/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.neo4j;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.grails.datastore.gorm.neo4j.DirtyCheckableAwareCollection;
import org.grails.datastore.gorm.neo4j.Neo4jSession;
import org.grails.datastore.mapping.engine.EntityAccess;
import org.grails.datastore.mapping.model.types.Association;

public class DirtyCheckableAwareList<T>
extends DirtyCheckableAwareCollection<T>
implements List<T> {
    private final List<T> delegate;

    public DirtyCheckableAwareList(EntityAccess owner, Association association, List<T> delegate, Neo4jSession session) {
        super(owner, association, delegate, session);
        this.delegate = delegate;
    }

    @Override
    public boolean addAll(int i, Collection<? extends T> ts) {
        boolean added = this.delegate.addAll(i, ts);
        if (added) {
            this.markDirty();
            for (T t : ts) {
                this.adoptGraphUponAdd(t);
            }
        }
        return added;
    }

    @Override
    public T get(int i) {
        return this.delegate.get(i);
    }

    @Override
    public T set(int i, T t) {
        T old = this.delegate.set(i, t);
        if (!t.equals(old)) {
            this.markDirty();
            this.adoptGraphUponRemove(old);
            this.adoptGraphUponAdd(t);
        }
        return old;
    }

    @Override
    public void add(int i, T t) {
        this.markDirty();
        this.delegate.add(i, t);
        this.adoptGraphUponAdd(t);
    }

    @Override
    public T remove(int i) {
        this.markDirty();
        T removed = this.delegate.remove(i);
        this.adoptGraphUponRemove(removed);
        return removed;
    }

    @Override
    public int indexOf(Object o) {
        return this.delegate.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.delegate.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.delegate.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int i) {
        return this.delegate.listIterator(i);
    }

    @Override
    public List<T> subList(int i, int i2) {
        return this.delegate.subList(i, i2);
    }
}

