/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.neo4j;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.grails.datastore.gorm.neo4j.GraphPersistentEntity;
import org.grails.datastore.gorm.neo4j.RelationshipUtils;
import org.grails.datastore.mapping.model.types.Association;

public class CypherBuilder {
    public static final String TYPE = "type";
    public static final String END = "end";
    public static final String START = "start";
    private String forLabels;
    private Set<String> matches = new HashSet<String>();
    private String conditions;
    private String orderAndLimits;
    private List<String> returnColumns = new ArrayList<String>();
    private List<Object> params = new ArrayList<Object>();

    public CypherBuilder(String forLabels) {
        this.forLabels = forLabels;
    }

    public void addMatch(String match) {
        this.matches.add(match);
    }

    public int getNextMatchNumber() {
        return this.matches.size();
    }

    public void setConditions(String conditions) {
        this.conditions = conditions;
    }

    public void setOrderAndLimits(String orderAndLimits) {
        this.orderAndLimits = orderAndLimits;
    }

    public int addParam(Object value) {
        this.params.add(value);
        return this.params.size();
    }

    public void replaceParamAt(int position, Object value) {
        this.params.set(position - 1, value);
    }

    public List<Object> getParams() {
        return this.params;
    }

    public void addReturnColumn(String returnColumn) {
        this.returnColumns.add(returnColumn);
    }

    public String build() {
        StringBuilder cypher = new StringBuilder();
        cypher.append("MATCH (n").append(this.forLabels).append(")");
        for (String m : this.matches) {
            cypher.append(", ").append(m);
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            cypher.append(" WHERE ").append(this.conditions);
        }
        if (this.returnColumns.isEmpty()) {
            cypher.append(" RETURN n.__id__ as id, labels(n) as labels, n as data \n");
            if (this.orderAndLimits != null) {
                cypher.append(this.orderAndLimits).append(" \n");
            }
        } else {
            cypher.append(" RETURN ");
            Iterator<String> iter = this.returnColumns.iterator();
            if (iter.hasNext()) {
                cypher.append(iter.next());
                while (iter.hasNext()) {
                    cypher.append(", ").append(iter.next());
                }
            }
            if (this.orderAndLimits != null) {
                cypher.append(" ");
                cypher.append(this.orderAndLimits);
            }
        }
        return cypher.toString();
    }

    public static String findRelationshipEndpointIdsFor(Association association) {
        String relType = RelationshipUtils.relationshipTypeUsedFor(association);
        boolean reversed = RelationshipUtils.useReversedMappingFor(association);
        StringBuilder sb = new StringBuilder();
        GraphPersistentEntity graphPersistentEntity = (GraphPersistentEntity)association.getOwner();
        String labels = graphPersistentEntity.getLabelsAsString();
        sb.append("MATCH (me").append(labels).append(" {__id__:{1}})");
        if (reversed) {
            sb.append("<");
        }
        sb.append("-[:").append(relType).append("]-");
        if (!reversed) {
            sb.append(">");
        }
        sb.append("(other) RETURN other.__id__ as id");
        return sb.toString();
    }
}

