/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.neo4j;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.persistence.FlushModeType;
import org.grails.datastore.gorm.neo4j.Neo4jDatastore;
import org.grails.datastore.gorm.neo4j.Neo4jEntityPersister;
import org.grails.datastore.gorm.neo4j.Neo4jTransaction;
import org.grails.datastore.gorm.neo4j.NodePendingInsert;
import org.grails.datastore.gorm.neo4j.RelationshipPendingDelete;
import org.grails.datastore.gorm.neo4j.RelationshipPendingInsert;
import org.grails.datastore.gorm.neo4j.SessionFlushedEvent;
import org.grails.datastore.gorm.neo4j.engine.CypherEngine;
import org.grails.datastore.mapping.core.AbstractSession;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.core.impl.PendingInsert;
import org.grails.datastore.mapping.core.impl.PendingOperation;
import org.grails.datastore.mapping.core.impl.PendingOperationExecution;
import org.grails.datastore.mapping.core.impl.PendingUpdate;
import org.grails.datastore.mapping.dirty.checking.DirtyCheckable;
import org.grails.datastore.mapping.engine.Persister;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.transactions.Transaction;
import org.neo4j.cypher.javacompat.ExecutionEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.dao.InvalidDataAccessResourceUsageException;

public class Neo4jSession
extends AbstractSession<ExecutionEngine> {
    private static Logger log = LoggerFactory.getLogger(Neo4jSession.class);
    private CypherEngine cypherEngine;
    private Collection<Object> persistingInstances = new HashSet<Object>();

    public Neo4jSession(Datastore datastore, MappingContext mappingContext, ApplicationEventPublisher publisher, boolean stateless, CypherEngine cypherEngine) {
        super(datastore, mappingContext, publisher, stateless);
        this.cypherEngine = cypherEngine;
        cypherEngine.beginTx();
    }

    public void disconnect() {
        this.cypherEngine.commit();
        super.disconnect();
    }

    protected Persister createPersister(Class cls, MappingContext mappingContext) {
        PersistentEntity entity = mappingContext.getPersistentEntity(cls.getName());
        return entity != null ? new Neo4jEntityPersister(mappingContext, entity, (Session)this, this.publisher) : null;
    }

    protected Transaction beginTransactionInternal() {
        return new Neo4jTransaction(this.cypherEngine);
    }

    public Neo4jDatastore getDatastore() {
        return (Neo4jDatastore)super.getDatastore();
    }

    public CypherEngine getNativeInterface() {
        return this.cypherEngine;
    }

    protected void flushPendingInserts(Map<PersistentEntity, Collection<PendingInsert>> inserts) {
        ArrayList<PendingInsert> nodes = new ArrayList<PendingInsert>();
        ArrayList<PendingInsert> relationships = new ArrayList<PendingInsert>();
        for (Collection<PendingInsert> coll : inserts.values()) {
            for (PendingInsert pendingInsert : coll) {
                if (pendingInsert instanceof NodePendingInsert) {
                    nodes.add(pendingInsert);
                }
                if (!(pendingInsert instanceof RelationshipPendingInsert) && !(pendingInsert instanceof RelationshipPendingDelete)) continue;
                relationships.add(pendingInsert);
            }
        }
        this.flushPendingOperations(nodes);
        this.flushPendingOperations(relationships);
    }

    private void flushPendingOperations(Collection operations) {
        for (Object o : operations) {
            PendingOperation pendingOperation = (PendingOperation)o;
            try {
                PendingOperationExecution.executePendingOperation((PendingOperation)pendingOperation);
            }
            catch (RuntimeException e) {
                this.setFlushMode(FlushModeType.COMMIT);
                throw new InvalidDataAccessResourceUsageException("Do not flush() the Session after an exception occurs", (Throwable)e);
            }
        }
    }

    public void flush() {
        this.persistDirtyButUnsavedInstances();
        super.flush();
    }

    protected void postFlush(boolean hasUpdates) {
        this.persistingInstances.clear();
        super.postFlush(hasUpdates);
        if (this.publisher != null) {
            this.publisher.publishEvent((ApplicationEvent)new SessionFlushedEvent((Session)this));
        }
        this.cypherEngine.commit();
    }

    private void persistDirtyButUnsavedInstances() {
        HashSet<Object> pendingObjects = new HashSet<Object>();
        for (Collection coll : this.getPendingInserts().values()) {
            for (PendingInsert pi : coll) {
                pendingObjects.add(pi.getEntityAccess().getEntity());
            }
        }
        for (Collection coll : this.getPendingUpdates().values()) {
            for (PendingUpdate pendingUpdate : coll) {
                pendingObjects.add(pendingUpdate.getEntityAccess().getEntity());
            }
        }
        for (Map cache : this.firstLevelCache.values()) {
            for (Object obj : cache.values()) {
                boolean isDirty;
                if (!(obj instanceof DirtyCheckable) || !(isDirty = ((DirtyCheckable)obj).hasChanged())) continue;
                this.persist(obj);
            }
        }
    }

    public void addPersistingInstance(Object obj) {
        this.persistingInstances.add(obj);
    }

    public boolean containsPersistingInstance(Object obj) {
        return this.persistingInstances.contains(obj);
    }
}

