/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.neo4j.engine;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;

public class NodeToMapConvertingIterator
implements ResourceIterator<Map<String, Object>> {
    private ResourceIterator<Map<String, Object>> delegatingIterator;

    NodeToMapConvertingIterator(ResourceIterator<Map<String, Object>> delegatingIterator) {
        this.delegatingIterator = delegatingIterator;
    }

    public void close() {
        this.delegatingIterator.close();
    }

    public boolean hasNext() {
        return this.delegatingIterator.hasNext();
    }

    public Map<String, Object> next() {
        Map row = (Map)this.delegatingIterator.next();
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry entry : row.entrySet()) {
            Object value;
            if (entry.getValue() instanceof Node) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                Node node = (Node)entry.getValue();
                for (String key : node.getPropertyKeys()) {
                    map.put(key, node.getProperty(key));
                }
                value = map;
            } else {
                value = entry.getValue();
            }
            result.put((String)entry.getKey(), value);
        }
        return result;
    }

    public void remove() {
        this.delegatingIterator.remove();
    }
}

