/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.neo4j;

import java.util.ArrayList;
import org.grails.datastore.gorm.neo4j.GraphPersistentEntity;
import org.grails.datastore.gorm.neo4j.engine.CypherEngine;
import org.grails.datastore.mapping.core.impl.PendingInsertAdapter;
import org.grails.datastore.mapping.engine.EntityAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RelationshipPendingInsert
extends PendingInsertAdapter<Object, Long> {
    private static Logger log = LoggerFactory.getLogger(RelationshipPendingInsert.class);
    private CypherEngine cypherEngine;
    private EntityAccess target;
    private String relType;

    RelationshipPendingInsert(EntityAccess source, String relType, EntityAccess target, CypherEngine cypherEngine) {
        super(source.getPersistentEntity(), (Object)-1L, source.getEntity(), source);
        this.relType = relType;
        this.target = target;
        this.cypherEngine = cypherEngine;
    }

    public void run() {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(this.getEntityAccess().getIdentifier());
        params.add(this.target.getIdentifier());
        String labelsFrom = ((GraphPersistentEntity)this.getEntity()).getLabelsAsString();
        String labelsTo = ((GraphPersistentEntity)this.target.getPersistentEntity()).getLabelsAsString();
        String cypher = String.format("MATCH (from%s {__id__:{1}}), (to%s {__id__:{2}}) MERGE (from)-[:%s]->(to)", labelsFrom, labelsTo, this.relType);
        this.cypherEngine.execute(cypher, params);
    }
}

