/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.neo4j;

import java.util.ArrayList;
import org.grails.datastore.gorm.neo4j.GraphPersistentEntity;
import org.grails.datastore.gorm.neo4j.engine.CypherEngine;
import org.grails.datastore.mapping.core.impl.PendingInsertAdapter;
import org.grails.datastore.mapping.engine.EntityAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RelationshipPendingDelete
extends PendingInsertAdapter<Object, Long> {
    private static Logger log = LoggerFactory.getLogger(RelationshipPendingDelete.class);
    private String relType;
    private CypherEngine cypherEngine;
    private EntityAccess target;

    RelationshipPendingDelete(EntityAccess source, String relType, EntityAccess target, CypherEngine cypherEngine) {
        super(source.getPersistentEntity(), (Object)-1L, source.getEntity(), source);
        this.target = target;
        this.cypherEngine = cypherEngine;
        this.relType = relType;
    }

    public void run() {
        String cypher;
        String labelsFrom = ((GraphPersistentEntity)this.getEntity()).getLabelsAsString();
        String labelsTo = null;
        ArrayList<Object> params = new ArrayList<Object>(2);
        params.add(this.getEntityAccess().getIdentifier());
        if (this.target != null) {
            params.add(this.target.getIdentifier());
            labelsTo = ((GraphPersistentEntity)this.target.getPersistentEntity()).getLabelsAsString();
            cypher = String.format("MATCH (from%s {__id__: {1}})-[r:%s]->(to%s {__id__: {2}}) DELETE r", labelsFrom, this.relType, labelsTo);
        } else {
            cypher = String.format("MATCH (from%s {__id__: {1}})-[r:%s]->() DELETE r", labelsFrom, this.relType);
        }
        this.cypherEngine.execute(cypher, params);
    }
}

