/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.neo4j;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.grails.datastore.gorm.neo4j.GraphPersistentEntity;
import org.grails.datastore.gorm.neo4j.Neo4jGormEnhancer;
import org.grails.datastore.gorm.neo4j.Neo4jUtils;
import org.grails.datastore.gorm.neo4j.engine.CypherEngine;
import org.grails.datastore.mapping.core.OptimisticLockingException;
import org.grails.datastore.mapping.core.impl.PendingUpdateAdapter;
import org.grails.datastore.mapping.engine.EntityAccess;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.types.Simple;
import org.neo4j.helpers.collection.IteratorUtil;

class NodePendingUpdate
extends PendingUpdateAdapter<Object, Long> {
    private CypherEngine cypherEngine;
    private MappingContext mappingContext;

    public NodePendingUpdate(EntityAccess ea, CypherEngine cypherEngine, MappingContext mappingContext) {
        super(ea.getPersistentEntity(), (Object)((Long)ea.getIdentifier()), ea.getEntity(), ea);
        this.cypherEngine = cypherEngine;
        this.mappingContext = mappingContext;
    }

    public void run() {
        HashMap<String, Object> simpleProps = new HashMap<String, Object>();
        Object id = this.getEntityAccess().getIdentifier();
        simpleProps.put("__id__", id);
        PersistentEntity persistentEntity = this.getEntityAccess().getPersistentEntity();
        for (PersistentProperty pp : persistentEntity.getPersistentProperties()) {
            boolean needsUpdate;
            if (!(pp instanceof Simple) || !(needsUpdate = true)) continue;
            String name = pp.getName();
            Object value = this.getEntityAccess().getProperty(name);
            if (value == null) continue;
            simpleProps.put(name, Neo4jUtils.mapToAllowedNeo4jType(value, this.mappingContext));
        }
        Neo4jGormEnhancer.amendMapWithUndeclaredProperties(simpleProps, this.getNativeEntry(), this.mappingContext);
        String labels = ((GraphPersistentEntity)this.entity).getLabelsWithInheritance(this.getEntityAccess().getEntity());
        ArrayList<Object> params = new ArrayList<Object>(2);
        params.add(id);
        StringBuilder cypherStringBuilder = new StringBuilder();
        cypherStringBuilder.append("MATCH (n%s) WHERE n.__id__={").append(params.size()).append("}");
        if (persistentEntity.hasProperty("version", Long.class) && persistentEntity.isVersioned()) {
            Long version = (Long)this.getEntityAccess().getProperty("version");
            if (version == null) {
                version = 0L;
            }
            params.add(version);
            cypherStringBuilder.append(" AND n.version={").append(params.size()).append("}");
            long newVersion = version + 1L;
            simpleProps.put("version", newVersion);
            this.getEntityAccess().setProperty("version", (Object)newVersion);
        }
        params.add(simpleProps);
        cypherStringBuilder.append(" SET n={").append(params.size()).append("} RETURN id(n) as id");
        String cypher = String.format(cypherStringBuilder.toString(), labels);
        Map result = (Map)IteratorUtil.singleOrNull((Iterable)((Object)this.cypherEngine.execute(cypher, params)));
        if (result == null) {
            throw new OptimisticLockingException(persistentEntity, id);
        }
    }
}

