/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.neo4j;

import java.util.HashSet;
import java.util.Map;
import org.grails.datastore.gorm.neo4j.GraphPersistentEntity;
import org.grails.datastore.gorm.neo4j.IdGenerator;
import org.grails.datastore.gorm.neo4j.Neo4jSession;
import org.grails.datastore.gorm.neo4j.SnowflakeIdGenerator;
import org.grails.datastore.gorm.neo4j.engine.CypherEngine;
import org.grails.datastore.mapping.config.Property;
import org.grails.datastore.mapping.core.AbstractDatastore;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.core.StatelessDatastore;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.types.Simple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;

public class Neo4jDatastore
extends AbstractDatastore
implements InitializingBean,
DisposableBean,
StatelessDatastore {
    private static Logger log = LoggerFactory.getLogger(Neo4jDatastore.class);
    protected MappingContext mappingContext;
    protected CypherEngine cypherEngine;
    protected boolean skipIndexSetup = false;
    protected IdGenerator idGenerator = new SnowflakeIdGenerator();

    public Neo4jDatastore(MappingContext mappingContext, ApplicationContext applicationContext, CypherEngine cypherEngine) {
        super(mappingContext);
        this.mappingContext = mappingContext;
        this.cypherEngine = cypherEngine;
        this.setApplicationContext(applicationContext);
    }

    public void setSkipIndexSetup(boolean skipIndexSetup) {
        this.skipIndexSetup = skipIndexSetup;
    }

    protected Session createSession(Map<String, String> connectionDetails) {
        return new Neo4jSession((Datastore)this, this.mappingContext, (ApplicationEventPublisher)this.getApplicationContext(), false, this.cypherEngine);
    }

    public void afterPropertiesSet() throws Exception {
        if (!this.skipIndexSetup) {
            this.setupIndexing();
        }
    }

    public long nextIdForType(PersistentEntity pe) {
        return this.idGenerator.nextId();
    }

    public void setupIndexing() {
        HashSet<String> schemaStrings = new HashSet<String>();
        for (PersistentEntity persistentEntity : this.mappingContext.getPersistentEntities()) {
            for (String label : ((GraphPersistentEntity)persistentEntity).getLabels()) {
                StringBuilder sb = new StringBuilder();
                sb.append("CREATE INDEX ON :").append(label).append("(__id__)");
                schemaStrings.add(sb.toString());
                for (PersistentProperty persistentProperty : persistentEntity.getPersistentProperties()) {
                    Property mappedForm = persistentProperty.getMapping().getMappedForm();
                    if (!(persistentProperty instanceof Simple) || mappedForm == null || !mappedForm.isIndex()) continue;
                    sb = new StringBuilder();
                    sb.append("CREATE INDEX ON :").append(label).append("(").append(persistentProperty.getName()).append(")");
                    schemaStrings.add(sb.toString());
                    log.debug("setting up indexing for " + label + " property " + persistentProperty.getName());
                }
            }
        }
        for (String cypher : schemaStrings) {
            this.cypherEngine.execute(cypher);
        }
        this.cypherEngine.commit();
    }
}

