/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.neo4j;

import java.util.Collection;
import java.util.Iterator;
import org.grails.datastore.gorm.neo4j.Neo4jSession;
import org.grails.datastore.gorm.neo4j.RelationshipPendingDelete;
import org.grails.datastore.gorm.neo4j.RelationshipPendingInsert;
import org.grails.datastore.gorm.neo4j.RelationshipUtils;
import org.grails.datastore.mapping.core.impl.PendingInsert;
import org.grails.datastore.mapping.dirty.checking.DirtyCheckable;
import org.grails.datastore.mapping.engine.EntityAccess;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.types.Association;
import org.grails.datastore.mapping.model.types.ManyToMany;

public abstract class DirtyCheckableAwareCollection<T>
implements Collection<T> {
    private final EntityAccess owner;
    private final Association association;
    private final Collection<T> delegate;
    private final Neo4jSession session;
    private final boolean reversed;
    private final String relType;

    protected DirtyCheckableAwareCollection(EntityAccess owner, Association association, Collection<T> delegate, Neo4jSession session) {
        this.owner = owner;
        this.association = association;
        this.delegate = delegate;
        this.session = session;
        this.reversed = RelationshipUtils.useReversedMappingFor(association);
        this.relType = RelationshipUtils.relationshipTypeUsedFor(association);
        for (T obj : delegate) {
            session.addPendingInsert((PendingInsert)new RelationshipPendingInsert(owner, this.relType, new EntityAccess(association.getAssociatedEntity(), obj), session.getNativeInterface()));
        }
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(0);
    }

    @Override
    public Iterator<T> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <T> T[] toArray(T[] ts) {
        return this.delegate.toArray(ts);
    }

    @Override
    public boolean add(T t) {
        boolean isAdded = this.delegate.add(t);
        if (isAdded) {
            this.markDirty();
            this.adoptGraphUponAdd(t);
        }
        return isAdded;
    }

    protected void adoptGraphUponAdd(T t) {
        if (this.session.getMappingContext().getProxyFactory().isProxy(t) && !this.isDomainInstance(t)) {
            return;
        }
        EntityAccess target = new EntityAccess(this.association.getAssociatedEntity(), t);
        if (this.association.isBidirectional()) {
            if (this.association instanceof ManyToMany) {
                Collection coll = (Collection)target.getProperty(this.association.getReferencedPropertyName());
                coll.add(this.owner.getEntity());
            } else {
                target.setProperty(this.association.getReferencedPropertyName(), this.owner.getEntity());
            }
        }
        if (target.getIdentifier() == null) {
            this.session.persist(t);
        }
        if (!this.reversed) {
            this.session.addPendingInsert((PendingInsert)new RelationshipPendingInsert(this.owner, this.relType, target, this.session.getNativeInterface()));
        }
    }

    private boolean isDomainInstance(T t) {
        boolean isDomainInstance = false;
        for (PersistentEntity pe : this.session.getMappingContext().getPersistentEntities()) {
            if (!pe.getJavaClass().equals(t.getClass())) continue;
            isDomainInstance = true;
        }
        return isDomainInstance;
    }

    @Override
    public boolean remove(Object o) {
        boolean isDeleted = this.delegate.remove(o);
        if (isDeleted) {
            this.markDirty();
            this.adoptGraphUponRemove(o);
        }
        return isDeleted;
    }

    protected void adoptGraphUponRemove(Object o) {
        if (this.session.getMappingContext().getProxyFactory().isProxy(o)) {
            return;
        }
        if (!this.reversed) {
            this.session.addPendingInsert((PendingInsert)new RelationshipPendingDelete(this.owner, this.relType, new EntityAccess(this.association.getAssociatedEntity(), o), this.session.getNativeInterface()));
        }
    }

    @Override
    public boolean containsAll(Collection<?> objects) {
        return this.delegate.containsAll(objects);
    }

    @Override
    public boolean addAll(Collection<? extends T> ts) {
        boolean changed = this.delegate.addAll(ts);
        if (changed) {
            this.markDirty();
        }
        return changed;
    }

    @Override
    public boolean addAll(Iterable<T> objects) {
        boolean result = false;
        for (T obj : objects) {
            result |= this.add(obj);
        }
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> objects) {
        this.markDirty();
        return this.delegate.removeAll(objects);
    }

    @Override
    public boolean retainAll(Collection<?> objects) {
        this.markDirty();
        return this.delegate.retainAll(objects);
    }

    @Override
    public void clear() {
        this.markDirty();
        this.delegate.clear();
    }

    protected void markDirty() {
        Object ownerEntity = this.owner.getEntity();
        if (ownerEntity instanceof DirtyCheckable) {
            ((DirtyCheckable)ownerEntity).markDirty(this.association.getName());
        }
    }
}

