/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.neo4j.engine;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;

public class ResultSetIterator
implements ResourceIterator<Map<String, Object>> {
    private final ResultSet resultSet;

    public ResultSetIterator(ResultSet resultSet) {
        this.resultSet = resultSet;
    }

    public void close() {
        try {
            this.resultSet.close();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasNext() {
        try {
            return !this.resultSet.isLast();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, Object> next() {
        try {
            this.resultSet.next();
            ResultSetMetaData metaData = this.resultSet.getMetaData();
            int cols = metaData.getColumnCount();
            HashMap<String, Object> map = new HashMap<String, Object>(cols);
            for (int i = 1; i <= cols; ++i) {
                Object value = this.resultSet.getObject(i);
                map.put(metaData.getColumnName(i), this.convertNodeToMap(value));
            }
            return map;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private Object convertNodeToMap(Object value) {
        if (value instanceof Node) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Node node = (Node)value;
            for (String key : node.getPropertyKeys()) {
                map.put(key, node.getProperty(key));
            }
            return map;
        }
        return value;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

