/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.mongo.engine;

import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReturnDocument;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.grails.datastore.mapping.core.IdentityGenerationException;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.core.SessionImplementor;
import org.grails.datastore.mapping.core.impl.PendingDelete;
import org.grails.datastore.mapping.core.impl.PendingDeleteAdapter;
import org.grails.datastore.mapping.engine.EntityAccess;
import org.grails.datastore.mapping.engine.internal.MappingUtils;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.types.EmbeddedCollection;
import org.grails.datastore.mapping.mongo.MongoSession;
import org.grails.datastore.mapping.mongo.config.MongoMappingContext;
import org.grails.datastore.mapping.mongo.engine.AbstractMongoObectEntityPersister;
import org.grails.datastore.mapping.mongo.query.MongoQuery;
import org.grails.datastore.mapping.query.Query;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;

public class MongoEntityPersister
extends AbstractMongoObectEntityPersister<Document> {
    public static final AbstractMongoObectEntityPersister.ValueRetrievalStrategy<Document> VALUE_RETRIEVAL_STRATEGY = new AbstractMongoObectEntityPersister.ValueRetrievalStrategy<Document>(){

        @Override
        public Object getValue(Document document, String name) {
            return document.get((Object)name);
        }

        @Override
        public void setValue(Document document, String name, Object value) {
            document.put(name, value);
        }
    };

    public MongoEntityPersister(MappingContext mappingContext, PersistentEntity entity, MongoSession mongoSession, ApplicationEventPublisher publisher) {
        super(mappingContext, entity, (Session)mongoSession, publisher);
    }

    protected void loadEmbeddedCollection(EmbeddedCollection embeddedCollection, EntityAccess ea, Object embeddedInstances, String propertyKey) {
        if (Map.class.isAssignableFrom(embeddedCollection.getType())) {
            if (embeddedInstances instanceof Document) {
                HashMap<String, Object> instances = new HashMap<String, Object>();
                Document embedded = (Document)embeddedInstances;
                for (String key : embedded.keySet()) {
                    Object o = embedded.get((Object)key);
                    if (!(o instanceof Document)) continue;
                    Document nativeEntry = (Document)o;
                    Object instance = this.createObjectFromEmbeddedNativeEntry(embeddedCollection.getAssociatedEntity(), nativeEntry);
                    SessionImplementor si = (SessionImplementor)this.getSession();
                    si.cacheEntry(embeddedCollection.getAssociatedEntity(), (Serializable)((Object)MongoEntityPersister.createEmbeddedCacheEntryKey((Object)instance)), (Object)nativeEntry);
                    instances.put(key, instance);
                }
                ea.setProperty(embeddedCollection.getName(), instances);
            }
        } else {
            Collection instances = MappingUtils.createConcreteCollection((Class)embeddedCollection.getType());
            if (embeddedInstances instanceof Collection) {
                Collection coll = (Collection)embeddedInstances;
                for (Object dbo : coll) {
                    if (!(dbo instanceof Document)) continue;
                    Document nativeEntry = (Document)dbo;
                    Object instance = this.createObjectFromEmbeddedNativeEntry(embeddedCollection.getAssociatedEntity(), nativeEntry);
                    SessionImplementor si = (SessionImplementor)this.getSession();
                    si.cacheEntry(embeddedCollection.getAssociatedEntity(), (Serializable)((Object)MongoEntityPersister.createEmbeddedCacheEntryKey((Object)instance)), (Object)nativeEntry);
                    instances.add(instance);
                }
            }
            ea.setProperty(embeddedCollection.getName(), (Object)instances);
        }
    }

    protected boolean isEmbeddedEntry(Object entry) {
        return entry instanceof Document;
    }

    public Query createQuery() {
        return new MongoQuery((MongoSession)this.getSession(), this.getPersistentEntity());
    }

    protected void deleteEntry(String family, Object key, final Object entry) {
        final MongoSession session = (MongoSession)this.getSession();
        session.addPendingDelete((PendingDelete)new PendingDeleteAdapter(this.getPersistentEntity(), key, entry){

            public void run() {
                session.clear(entry);
            }
        });
    }

    protected Object generateIdentifier(PersistentEntity persistentEntity, Document nativeEntry) {
        boolean hasNumericalIdentifier = this.hasNumericalIdentifier;
        if (hasNumericalIdentifier) {
            Document result;
            block3: {
                String collectionName = this.getCollectionName(persistentEntity, nativeEntry);
                MongoSession mongoSession = this.getMongoSession();
                MongoClient client = mongoSession.getNativeInterface();
                MongoCollection dbCollection = client.getDatabase(mongoSession.getDatabase(persistentEntity)).getCollection(collectionName + ".next_id");
                int attempts = 0;
                do {
                    FindOneAndUpdateOptions options = new FindOneAndUpdateOptions();
                    options.upsert(true).returnDocument(ReturnDocument.AFTER);
                    result = (Document)dbCollection.findOneAndUpdate((Bson)new Document("_id", (Object)collectionName), (Bson)new Document("$inc", (Object)new Document("next_id", (Object)1)), options);
                    if (result != null) break block3;
                } while (++attempts <= 3);
                throw new IdentityGenerationException("Unable to generate identity for [" + persistentEntity.getName() + "] using findAndModify after 3 attempts");
            }
            long nextId = (Long)this.getMappingContext().getConversionService().convert(result.get((Object)"next_id"), Long.class);
            nativeEntry.put("_id", (Object)nextId);
            return nativeEntry.get((Object)"_id");
        }
        ObjectId objectId = ObjectId.get();
        if (ObjectId.class.isAssignableFrom(persistentEntity.getIdentity().getType())) {
            nativeEntry.put("_id", (Object)objectId);
            return objectId;
        }
        String stringId = objectId.toString();
        nativeEntry.put("_id", (Object)stringId);
        return stringId;
    }

    protected Document createNewEntry(String family, Object instance) {
        SessionImplementor si = (SessionImplementor)this.getSession();
        Document dbo = (Document)si.getCachedEntry(this.getPersistentEntity(), (Serializable)((Object)MongoEntityPersister.createInstanceCacheEntryKey(instance)));
        if (dbo != null) {
            return dbo;
        }
        return (Document)super.createNewEntry(family, instance);
    }

    protected Document createNewEntry(String family) {
        Document dbo = new Document();
        PersistentEntity persistentEntity = this.getPersistentEntity();
        if (!persistentEntity.isRoot()) {
            dbo.put("_class", (Object)persistentEntity.getDiscriminator());
        }
        return dbo;
    }

    protected void setEntryValue(Document nativeEntry, String key, Object value) {
        MappingContext mappingContext = this.getMappingContext();
        MongoEntityPersister.setDBObjectValue(nativeEntry, key, value, mappingContext);
    }

    public static void setDBObjectValue(Document nativeEntry, String key, Object value, MappingContext mappingContext) {
        Object nativeValue = MongoEntityPersister.getSimpleNativePropertyValue(value, mappingContext);
        nativeEntry.put(key, nativeValue);
    }

    public static Object getSimpleNativePropertyValue(Object value, MappingContext mappingContext) {
        Cloneable nativeValue;
        if (value == null || mappingContext.isPersistentEntity((Object)value)) {
            nativeValue = null;
        } else if (MongoMappingContext.isMongoNativeType(value.getClass())) {
            nativeValue = value;
        } else if (value.getClass().isArray()) {
            Object[] array = (Object[])value;
            ArrayList<Object> nativeColl = new ArrayList<Object>(array.length);
            for (Object item : array) {
                nativeColl.add(MongoEntityPersister.getSimpleNativePropertyValue(item, mappingContext));
            }
            nativeValue = nativeColl;
        } else if (value instanceof Collection) {
            Collection existingColl = value;
            ArrayList<Object> nativeColl = new ArrayList<Object>(existingColl.size());
            for (Object item : existingColl) {
                nativeColl.add(MongoEntityPersister.getSimpleNativePropertyValue(item, mappingContext));
            }
            nativeValue = nativeColl;
        } else if (value instanceof Map) {
            Map existingMap = (Map)((Object)value);
            LinkedHashMap newMap = new LinkedHashMap();
            for (Map.Entry entry : existingMap.entrySet()) {
                newMap.put(entry.getKey(), MongoEntityPersister.getSimpleNativePropertyValue(entry.getValue(), mappingContext));
            }
            nativeValue = newMap;
        } else {
            nativeValue = MongoEntityPersister.convertPrimitiveToNative(value, mappingContext);
        }
        return nativeValue;
    }

    private static Object convertPrimitiveToNative(Object item, MappingContext mappingContext) {
        Object nativeValue;
        if (item != null) {
            ConversionService conversionService = mappingContext.getConversionService();
            TypeDescriptor itemTypeDescriptor = TypeDescriptor.forObject((Object)item);
            Class itemTypeClass = itemTypeDescriptor.getObjectType();
            nativeValue = (itemTypeClass.equals(Integer.class) || itemTypeClass.equals(Short.class)) && conversionService.canConvert(itemTypeDescriptor, TypeDescriptor.valueOf(Integer.class)) ? conversionService.convert(item, Integer.class) : (conversionService.canConvert(itemTypeDescriptor, TypeDescriptor.valueOf(String.class)) ? conversionService.convert(item, String.class) : item.toString());
        } else {
            nativeValue = null;
        }
        return nativeValue;
    }

    protected Document retrieveEntry(PersistentEntity persistentEntity, String family, Serializable key) {
        MongoSession mongoSession = this.getMongoSession();
        MongoCollection collection = mongoSession.getNativeInterface().getDatabase(mongoSession.getDatabase(persistentEntity)).getCollection(mongoSession.getCollectionName(persistentEntity));
        return (Document)collection.find((Bson)this.createDBObjectWithKey(key)).limit(1).first();
    }

    private Document removeNullEntries(Document nativeEntry) {
        for (String key : new HashSet(nativeEntry.keySet())) {
            Object o = nativeEntry.get((Object)key);
            if (o == null) {
                nativeEntry.remove((Object)key);
                continue;
            }
            if (o instanceof Object[]) {
                for (Object o2 : (Object[])o) {
                    if (!(o2 instanceof Document)) continue;
                    this.removeNullEntries((Document)o2);
                }
                continue;
            }
            if (o instanceof List) {
                for (Object o2 : (List)o) {
                    if (!(o2 instanceof Document)) continue;
                    this.removeNullEntries((Document)o2);
                }
                continue;
            }
            if (!(o instanceof Document)) continue;
            this.removeNullEntries((Document)o);
        }
        return nativeEntry;
    }

    protected Object storeEntry(PersistentEntity persistentEntity, EntityAccess entityAccess, Object storeId, Document nativeEntry) {
        nativeEntry.put("_id", storeId);
        return nativeEntry.get((Object)"_id");
    }

    @Override
    protected String getCollectionName(PersistentEntity persistentEntity, Document nativeEntry) {
        String collectionName;
        if (persistentEntity.isRoot()) {
            MongoSession mongoSession = (MongoSession)this.getSession();
            collectionName = mongoSession.getCollectionName(persistentEntity);
        } else {
            MongoSession mongoSession = (MongoSession)this.getSession();
            collectionName = mongoSession.getCollectionName(persistentEntity.getRootEntity());
        }
        return collectionName;
    }

    private Document modifyNullsToUnsets(Document nativeEntry) {
        Document unsets = new Document();
        Document sets = new Document();
        for (String key : nativeEntry.keySet()) {
            Object o = nativeEntry.get((Object)key);
            if (o == null) {
                unsets.put(key, (Object)1);
                continue;
            }
            if ("_id".equals(key)) continue;
            if (o instanceof Object[]) {
                sets.put(key, o);
                for (Object o2 : (Object[])o) {
                    if (!(o2 instanceof Document)) continue;
                    this.removeNullEntries((Document)o2);
                }
                continue;
            }
            if (o instanceof List) {
                sets.put(key, o);
                for (Object o2 : (List)o) {
                    if (!(o2 instanceof Document)) continue;
                    this.removeNullEntries((Document)o2);
                }
                continue;
            }
            if (o instanceof DBObject) {
                sets.put(key, (Object)this.removeNullEntries((Document)o));
                continue;
            }
            sets.put(key, o);
        }
        Document newEntry = new Document();
        newEntry.put("$set", (Object)sets);
        if (!unsets.keySet().isEmpty()) {
            newEntry.put("$unset", (Object)unsets);
        }
        return newEntry;
    }

    public void updateEntry(PersistentEntity persistentEntity, EntityAccess ea, Object key, Document entry) {
    }

    @Override
    AbstractMongoObectEntityPersister.ValueRetrievalStrategy<Document> getValueRetrievalStrategy() {
        return VALUE_RETRIEVAL_STRATEGY;
    }

    protected void deleteEntries(String family, List<Object> keys) {
        MongoCollection<Document> dbCollection = this.getMongoSession().getCollection(this.getPersistentEntity());
        MongoSession mongoSession = (MongoSession)this.getSession();
        MongoQuery query = (MongoQuery)mongoSession.createQuery(this.getPersistentEntity().getJavaClass());
        query.in(this.getPersistentEntity().getIdentity().getName(), keys);
        dbCollection.deleteMany((Bson)query.getMongoQuery());
    }

    protected Document createDBObjectWithKey(Object key) {
        Document dbo = new Document();
        if (this.hasNumericalIdentifier || this.hasStringIdentifier) {
            dbo.put("_id", key);
        } else if (key instanceof ObjectId) {
            dbo.put("_id", key);
        } else {
            dbo.put("_id", (Object)new ObjectId(key.toString()));
        }
        return dbo;
    }
}

