/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.mongo.config;

import com.mongodb.MongoClientURI;
import groovy.lang.Closure;
import java.beans.PropertyDescriptor;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.Binary;
import org.bson.types.Code;
import org.bson.types.ObjectId;
import org.bson.types.Symbol;
import org.grails.datastore.bson.codecs.CodecExtensions;
import org.grails.datastore.gorm.mongo.geo.BoxType;
import org.grails.datastore.gorm.mongo.geo.CircleType;
import org.grails.datastore.gorm.mongo.geo.GeometryCollectionType;
import org.grails.datastore.gorm.mongo.geo.LineStringType;
import org.grails.datastore.gorm.mongo.geo.MultiLineStringType;
import org.grails.datastore.gorm.mongo.geo.MultiPointType;
import org.grails.datastore.gorm.mongo.geo.MultiPolygonType;
import org.grails.datastore.gorm.mongo.geo.PointType;
import org.grails.datastore.gorm.mongo.geo.PolygonType;
import org.grails.datastore.gorm.mongo.geo.ShapeType;
import org.grails.datastore.gorm.mongo.simple.EnumType;
import org.grails.datastore.mapping.config.AbstractGormMappingFactory;
import org.grails.datastore.mapping.core.connections.ConnectionSourceSettings;
import org.grails.datastore.mapping.document.config.Collection;
import org.grails.datastore.mapping.document.config.DocumentMappingContext;
import org.grails.datastore.mapping.engine.types.CustomTypeMarshaller;
import org.grails.datastore.mapping.model.AbstractClassMapping;
import org.grails.datastore.mapping.model.ClassMapping;
import org.grails.datastore.mapping.model.EmbeddedPersistentEntity;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.MappingFactory;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.types.Identity;
import org.grails.datastore.mapping.mongo.config.MongoAttribute;
import org.grails.datastore.mapping.mongo.config.MongoCollection;
import org.grails.datastore.mapping.mongo.connections.AbstractMongoConnectionSourceSettings;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.env.PropertyResolver;

public class MongoMappingContext
extends DocumentMappingContext {
    private static final Set<String> MONGO_NATIVE_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(Double.class.getName(), String.class.getName(), Document.class.getName(), "com.mongodb.DBObject", Binary.class.getName(), ObjectId.class.getName(), "com.mongodb.DBRef", Boolean.class.getName(), Date.class.getName(), Pattern.class.getName(), Symbol.class.getName(), Integer.class.getName(), "org.bson.types.BSONTimestamp", Code.class.getName(), "org.bson.types.CodeWScope", Long.class.getName(), UUID.class.getName(), byte[].class.getName(), Byte.class.getName())));

    public MongoMappingContext(String defaultDatabaseName) {
        this(defaultDatabaseName, null);
    }

    public MongoMappingContext(String defaultDatabaseName, Closure defaultMapping) {
        this(defaultDatabaseName, defaultMapping, new Class[0]);
    }

    public MongoMappingContext(String defaultDatabaseName, Closure defaultMapping, Class ... classes) {
        super(defaultDatabaseName, defaultMapping);
        this.initialize(classes);
    }

    @Deprecated
    public MongoMappingContext(PropertyResolver configuration, Class ... classes) {
        this(MongoMappingContext.getDefaultDatabaseName(configuration), (Closure)configuration.getProperty("grails.mongodb.default.mapping", Closure.class, null), classes);
    }

    public MongoMappingContext(AbstractMongoConnectionSourceSettings settings, Class ... classes) {
        super(settings.getDatabase(), (ConnectionSourceSettings)settings);
        this.initialize(classes);
    }

    private void initialize(Class[] classes) {
        this.registerMongoTypes();
        ConverterRegistry converterRegistry = this.getConverterRegistry();
        converterRegistry.addConverter((Converter)new Converter<String, ObjectId>(){

            public ObjectId convert(String source) {
                if (ObjectId.isValid((String)source)) {
                    return new ObjectId(source);
                }
                return null;
            }
        });
        converterRegistry.addConverter((Converter)new Converter<ObjectId, String>(){

            public String convert(ObjectId source) {
                return source.toString();
            }
        });
        converterRegistry.addConverter((Converter)new Converter<byte[], Binary>(){

            public Binary convert(byte[] source) {
                return new Binary(source);
            }
        });
        converterRegistry.addConverter((Converter)new Converter<Binary, byte[]>(){

            public byte[] convert(Binary source) {
                return source.getData();
            }
        });
        for (Converter converter : CodecExtensions.getBsonConverters()) {
            converterRegistry.addConverter(converter);
        }
        this.addPersistentEntities(classes);
    }

    public static boolean isMongoNativeType(Class clazz) {
        return MONGO_NATIVE_TYPES.contains(clazz.getName()) || Bson.class.isAssignableFrom(clazz.getClass());
    }

    public static String getDefaultDatabaseName(PropertyResolver configuration) {
        MongoClientURI mongoClientURI;
        String database;
        String connectionString = (String)configuration.getProperty("grails.mongodb.connectionString", String.class, null);
        if (connectionString != null && (database = (mongoClientURI = new MongoClientURI(connectionString)).getDatabase()) != null) {
            return database;
        }
        return configuration.getProperty("grails.mongodb.databaseName", "test");
    }

    protected void registerMongoTypes() {
        MappingFactory mappingFactory = this.getMappingFactory();
        mappingFactory.registerCustomType((CustomTypeMarshaller)new GeometryCollectionType());
        mappingFactory.registerCustomType((CustomTypeMarshaller)new PointType());
        mappingFactory.registerCustomType((CustomTypeMarshaller)new PolygonType());
        mappingFactory.registerCustomType((CustomTypeMarshaller)new LineStringType());
        mappingFactory.registerCustomType((CustomTypeMarshaller)new MultiLineStringType());
        mappingFactory.registerCustomType((CustomTypeMarshaller)new MultiPointType());
        mappingFactory.registerCustomType((CustomTypeMarshaller)new MultiPolygonType());
        mappingFactory.registerCustomType((CustomTypeMarshaller)new ShapeType());
        mappingFactory.registerCustomType((CustomTypeMarshaller)new BoxType());
        mappingFactory.registerCustomType((CustomTypeMarshaller)new CircleType());
        mappingFactory.registerCustomType((CustomTypeMarshaller)new EnumType());
    }

    protected MappingFactory createDocumentMappingFactory(Closure defaultMapping) {
        MongoDocumentMappingFactory mongoDocumentMappingFactory = new MongoDocumentMappingFactory();
        mongoDocumentMappingFactory.setDefaultMapping(defaultMapping);
        return mongoDocumentMappingFactory;
    }

    public PersistentEntity createEmbeddedEntity(Class type) {
        return new DocumentEmbeddedPersistentEntity(type, (MappingContext)this);
    }

    class DocumentEmbeddedPersistentEntity
    extends EmbeddedPersistentEntity {
        private DocumentCollectionMapping classMapping;

        public DocumentEmbeddedPersistentEntity(Class type, MappingContext ctx) {
            super(type, ctx);
            this.classMapping = new DocumentCollectionMapping((PersistentEntity)this, ctx);
        }

        public ClassMapping getMapping() {
            return this.classMapping;
        }

        public class DocumentCollectionMapping
        extends AbstractClassMapping<Collection> {
            private Collection mappedForm;

            public DocumentCollectionMapping(PersistentEntity entity, MappingContext context) {
                super(entity, context);
                this.mappedForm = (Collection)context.getMappingFactory().createMappedForm((PersistentEntity)DocumentEmbeddedPersistentEntity.this);
            }

            public Collection getMappedForm() {
                return this.mappedForm;
            }
        }
    }

    private final class MongoDocumentMappingFactory
    extends AbstractGormMappingFactory<MongoCollection, MongoAttribute> {
        private MongoDocumentMappingFactory() {
        }

        protected Class<MongoAttribute> getPropertyMappedFormType() {
            return MongoAttribute.class;
        }

        protected Class<MongoCollection> getEntityMappedFormType() {
            return MongoCollection.class;
        }

        public Identity<MongoAttribute> createIdentity(PersistentEntity owner, MappingContext context, PropertyDescriptor pd) {
            Identity identity = super.createIdentity(owner, context, pd);
            ((MongoAttribute)identity.getMapping().getMappedForm()).setTargetName("_id");
            return identity;
        }

        public boolean isSimpleType(Class propType) {
            if (propType == null) {
                return false;
            }
            if (propType.isArray()) {
                return this.isSimpleType(propType.getComponentType()) || super.isSimpleType(propType);
            }
            return MongoMappingContext.isMongoNativeType(propType) || super.isSimpleType(propType);
        }
    }
}

