/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.mongo;

import com.mongodb.MongoClient;
import com.mongodb.WriteConcern;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.DeleteManyModel;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.FlushModeType;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.grails.datastore.mapping.core.OptimisticLockingException;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.core.impl.PendingDelete;
import org.grails.datastore.mapping.core.impl.PendingDeleteAdapter;
import org.grails.datastore.mapping.core.impl.PendingInsert;
import org.grails.datastore.mapping.core.impl.PendingUpdate;
import org.grails.datastore.mapping.engine.EntityAccess;
import org.grails.datastore.mapping.engine.EntityPersister;
import org.grails.datastore.mapping.engine.Persister;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.mongo.AbstractMongoSession;
import org.grails.datastore.mapping.mongo.MongoDatastore;
import org.grails.datastore.mapping.mongo.engine.MongoEntityPersister;
import org.grails.datastore.mapping.mongo.query.MongoQuery;
import org.grails.datastore.mapping.query.Query;
import org.grails.datastore.mapping.query.api.QueryableCriteria;
import org.grails.datastore.mapping.transactions.SessionOnlyTransaction;
import org.grails.datastore.mapping.transactions.Transaction;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.dao.DataIntegrityViolationException;

public class MongoSession
extends AbstractMongoSession {
    public MongoSession(MongoDatastore datastore, MappingContext mappingContext, ApplicationEventPublisher publisher) {
        this(datastore, mappingContext, publisher, false);
    }

    public MongoSession(MongoDatastore datastore, MappingContext mappingContext, ApplicationEventPublisher publisher, boolean stateless) {
        super(datastore, mappingContext, publisher, stateless);
    }

    public Query createQuery(Class type) {
        return super.createQuery(type);
    }

    protected void cacheEntry(Serializable key, Object entry, Map<Serializable, Object> entryCache, boolean forDirtyCheck) {
        entryCache.put(key, entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(WriteConcern writeConcern) {
        WriteConcern currentWriteConcern = this.getWriteConcern();
        try {
            this.writeConcern = writeConcern;
            Map pendingUpdates = this.getPendingUpdates();
            Map pendingInserts = this.getPendingInserts();
            Map pendingDeletes = this.getPendingDeletes();
            if (pendingUpdates.isEmpty() && pendingInserts.isEmpty() && pendingDeletes.isEmpty()) {
                return;
            }
            LinkedHashMap<String, Integer> numberOfOptimisticUpdates = new LinkedHashMap<String, Integer>();
            LinkedHashMap<String, Integer> numberOfPessimisticUpdates = new LinkedHashMap<String, Integer>();
            LinkedHashMap<PersistentEntity, List<WriteModel<Document>>> writeModels = new LinkedHashMap<PersistentEntity, List<WriteModel<Document>>>();
            for (PersistentEntity persistentEntity : pendingInserts.keySet()) {
                Collection inserts = (Collection)pendingInserts.get(persistentEntity);
                if (inserts == null || inserts.isEmpty()) continue;
                List<WriteModel<Document>> entityWrites = this.getWriteModelsForEntity(persistentEntity, writeModels);
                for (PendingInsert insert : inserts) {
                    insert.run();
                    if (insert.isVetoed()) continue;
                    entityWrites.add((WriteModel<Document>)new InsertOneModel((Object)((Document)insert.getNativeEntry())));
                    List cascadeOperations = insert.getCascadeOperations();
                    this.addPostFlushOperations(cascadeOperations);
                }
            }
            for (PersistentEntity persistentEntity : pendingUpdates.keySet()) {
                String name = persistentEntity.isRoot() ? persistentEntity.getName() : persistentEntity.getRootEntity().getName();
                int numberOfOptimistic = numberOfOptimisticUpdates.containsKey(name) ? (Integer)numberOfOptimisticUpdates.get(name) : 0;
                int numberOfPessimistic = numberOfPessimisticUpdates.containsKey(name) ? (Integer)numberOfPessimisticUpdates.get(name) : 0;
                Collection updates = (Collection)pendingUpdates.get(persistentEntity);
                if (updates != null && !updates.isEmpty()) {
                    List<WriteModel<Document>> entityWrites = this.getWriteModelsForEntity(persistentEntity, writeModels);
                    for (PendingUpdate update : updates) {
                        update.run();
                        if (update.isVetoed()) continue;
                        Document updateDoc = (Document)update.getNativeEntry();
                        updateDoc.remove((Object)"_id");
                        updateDoc = this.createSetAndUnsetDoc(updateDoc);
                        Object nativeKey = update.getNativeKey();
                        Document id = new Document("_id", nativeKey);
                        MongoEntityPersister documentEntityPersister = (MongoEntityPersister)this.getPersister(persistentEntity);
                        EntityAccess entityAccess = update.getEntityAccess();
                        if (documentEntityPersister.isVersioned(entityAccess)) {
                            Object currentVersion = documentEntityPersister.getCurrentVersion(entityAccess);
                            documentEntityPersister.incrementVersion(entityAccess);
                            id.put("version", currentVersion);
                            ++numberOfOptimistic;
                        } else {
                            ++numberOfPessimistic;
                        }
                        UpdateOptions options = new UpdateOptions();
                        entityWrites.add((WriteModel<Document>)new UpdateOneModel((Bson)id, (Bson)updateDoc, options.upsert(false)));
                        List cascadeOperations = update.getCascadeOperations();
                        this.addPostFlushOperations(cascadeOperations);
                    }
                }
                numberOfOptimisticUpdates.put(name, numberOfOptimistic);
                numberOfPessimisticUpdates.put(name, numberOfPessimistic);
            }
            for (PersistentEntity persistentEntity : pendingDeletes.keySet()) {
                Collection deletes = (Collection)pendingDeletes.get(persistentEntity);
                if (deletes == null || deletes.isEmpty()) continue;
                List<WriteModel<Document>> entityWrites = this.getWriteModelsForEntity(persistentEntity, writeModels);
                ArrayList<Object> nativeKeys = new ArrayList<Object>();
                for (PendingDelete delete : deletes) {
                    delete.run();
                    if (delete.isVetoed()) continue;
                    Object k = delete.getNativeKey();
                    if (k != null) {
                        if (k instanceof Document) {
                            entityWrites.add((WriteModel<Document>)new DeleteManyModel((Bson)((Document)k)));
                        } else {
                            nativeKeys.add(k);
                        }
                    }
                    List cascadeOperations = delete.getCascadeOperations();
                    this.addPostFlushOperations(cascadeOperations);
                }
                entityWrites.add((WriteModel<Document>)new DeleteManyModel((Bson)new Document("_id", (Object)new Document("$in", nativeKeys))));
            }
            for (PersistentEntity persistentEntity : writeModels.keySet()) {
                int no;
                List writes;
                MongoCollection collection = this.getCollection(persistentEntity);
                WriteConcern wc = this.getWriteConcern();
                if (wc != null) {
                    collection = collection.withWriteConcern(wc);
                }
                if ((writes = (List)writeModels.get(persistentEntity)).isEmpty()) continue;
                BulkWriteResult bulkWriteResult = collection.bulkWrite(writes);
                if (!bulkWriteResult.wasAcknowledged()) {
                    this.errorOccured = true;
                    throw new DataIntegrityViolationException("Write operation was not acknowledged");
                }
                int matchedCount = bulkWriteResult.getMatchedCount();
                String name = persistentEntity.getName();
                Integer numOptimistic = (Integer)numberOfOptimisticUpdates.get(name);
                Integer numPessimistic = (Integer)numberOfPessimisticUpdates.get(name);
                int pe = numPessimistic != null ? numPessimistic : 0;
                if (matchedCount - pe == (no = numOptimistic != null ? numOptimistic : 0)) continue;
                this.setFlushMode(FlushModeType.COMMIT);
                throw new OptimisticLockingException(persistentEntity, null);
            }
            for (Runnable postFlushOperation : this.postFlushOperations) {
                postFlushOperation.run();
            }
        }
        finally {
            this.clearPendingOperations();
            this.postFlushOperations.clear();
            this.firstLevelCollectionCache.clear();
            this.writeConcern = currentWriteConcern;
        }
    }

    protected Document createSetAndUnsetDoc(Document updateDoc) {
        Set keys = updateDoc.keySet();
        Document unsets = new Document();
        for (String key : keys) {
            Object v = updateDoc.get((Object)key);
            if (v != null) continue;
            unsets.put(key, (Object)"");
        }
        for (String key : unsets.keySet()) {
            updateDoc.remove((Object)key);
        }
        updateDoc = new Document("$set", (Object)updateDoc);
        if (!unsets.isEmpty()) {
            updateDoc.put("$unset", (Object)unsets);
        }
        return updateDoc;
    }

    protected List<WriteModel<Document>> getWriteModelsForEntity(PersistentEntity persistentEntity, Map<PersistentEntity, List<WriteModel<Document>>> writeModels) {
        PersistentEntity key = persistentEntity.isRoot() ? persistentEntity : persistentEntity.getRootEntity();
        List<WriteModel<Document>> entityWrites = writeModels.get(key);
        if (entityWrites == null) {
            entityWrites = new ArrayList<WriteModel<Document>>();
            writeModels.put(key, entityWrites);
        }
        return entityWrites;
    }

    protected void flushPendingUpdates(Map<PersistentEntity, Collection<PendingUpdate>> updates) {
    }

    public void disconnect() {
        super.disconnect();
    }

    protected Persister createPersister(Class cls, MappingContext mappingContext) {
        PersistentEntity entity = mappingContext.getPersistentEntity(cls.getName());
        return entity == null ? null : new MongoEntityPersister(mappingContext, entity, this, this.publisher);
    }

    protected Transaction<MongoClient> beginTransactionInternal() {
        return new SessionOnlyTransaction((Object)this.getNativeInterface(), (Session)this);
    }

    public void delete(Iterable objects) {
        final Map<PersistentEntity, List> toDelete = this.getDeleteMap(objects);
        for (final PersistentEntity persistentEntity : toDelete.keySet()) {
            MongoQuery query = new MongoQuery(this, persistentEntity);
            query.in("_id", toDelete.get(persistentEntity));
            Document mongoQuery = query.getMongoQuery();
            final EntityPersister persister = (EntityPersister)this.getPersister(persistentEntity);
            this.addPendingDelete((PendingDelete)new PendingDeleteAdapter<Object, Object>(persistentEntity, (Object)mongoQuery, null){

                public void run() {
                    for (Object o : (List)toDelete.get(persistentEntity)) {
                        if (persister.cancelDelete(persistentEntity, MongoSession.this.createEntityAccess(persistentEntity, o))) continue;
                        MongoSession.this.clear(o);
                    }
                }
            });
        }
    }

    protected Map<PersistentEntity, List> getDeleteMap(Iterable objects) {
        HashMap<PersistentEntity, List> toDelete = new HashMap<PersistentEntity, List>();
        for (Object object : objects) {
            Serializable id;
            PersistentEntity p;
            if (object == null || (p = this.getMappingContext().getPersistentEntity(object.getClass().getName())) == null) continue;
            ArrayList<Serializable> listForPersister = (ArrayList<Serializable>)toDelete.get(p);
            if (listForPersister == null) {
                listForPersister = new ArrayList<Serializable>();
                toDelete.put(p, listForPersister);
            }
            if ((id = this.getObjectIdentifier(object)) == null) continue;
            listForPersister.add(id);
        }
        return toDelete;
    }

    public long deleteAll(QueryableCriteria criteria) {
        PersistentEntity entity = criteria.getPersistentEntity();
        Document nativeQuery = this.buildNativeDocumentQueryFromCriteria(criteria, entity);
        MongoCollection<Document> collection = this.getCollection(entity);
        DeleteResult deleteResult = collection.deleteMany((Bson)nativeQuery);
        if (deleteResult.wasAcknowledged()) {
            return deleteResult.getDeletedCount();
        }
        return 0L;
    }

    public long updateAll(QueryableCriteria criteria, Map<String, Object> properties) {
        PersistentEntity entity = criteria.getPersistentEntity();
        Document nativeQuery = this.buildNativeDocumentQueryFromCriteria(criteria, entity);
        MongoCollection<Document> collection = this.getCollection(entity);
        UpdateOptions updateOptions = new UpdateOptions();
        updateOptions.upsert(false);
        UpdateResult updateResult = collection.updateMany((Bson)nativeQuery, (Bson)new Document("$set", properties), updateOptions);
        if (updateResult.wasAcknowledged()) {
            try {
                return updateResult.getModifiedCount();
            }
            catch (UnsupportedOperationException e) {
                return -1L;
            }
        }
        return 0L;
    }

    public Object decode(Class type, Object nativeObject) {
        if (nativeObject instanceof FindIterable) {
            return this.decode(type, ((FindIterable)nativeObject).first());
        }
        if (nativeObject instanceof Document) {
            Document dbo = (Document)nativeObject;
            Serializable key = (Serializable)dbo.get((Object)"_id");
            Persister persister = this.getPersister(type);
            MongoEntityPersister mongoEntityPersister = (MongoEntityPersister)persister;
            return mongoEntityPersister.createObjectFromNativeEntry(mongoEntityPersister.getPersistentEntity(), key, dbo);
        }
        return null;
    }

    private Document buildNativeDocumentQueryFromCriteria(QueryableCriteria criteria, PersistentEntity entity) {
        MongoQuery mongoQuery = new MongoQuery(this, entity);
        List criteriaList = criteria.getCriteria();
        for (Query.Criterion c : criteriaList) {
            mongoQuery.add(c);
        }
        return mongoQuery.getMongoQuery();
    }
}

