/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.mongo.query;

import com.mongodb.BasicDBObject;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCursor;
import grails.mongodb.geo.Box;
import grails.mongodb.geo.Circle;
import grails.mongodb.geo.Distance;
import grails.mongodb.geo.GeoJSON;
import grails.mongodb.geo.Point;
import grails.mongodb.geo.Polygon;
import grails.mongodb.geo.Shape;
import grails.mongodb.geo.Sphere;
import groovy.lang.Closure;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.grails.datastore.gorm.mongo.geo.GeoJSONType;
import org.grails.datastore.gorm.query.AbstractResultList;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.core.SessionImplementor;
import org.grails.datastore.mapping.engine.EntityAccess;
import org.grails.datastore.mapping.engine.EntityPersister;
import org.grails.datastore.mapping.engine.internal.MappingUtils;
import org.grails.datastore.mapping.engine.types.CustomTypeMarshaller;
import org.grails.datastore.mapping.model.EmbeddedPersistentEntity;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.types.Association;
import org.grails.datastore.mapping.model.types.Custom;
import org.grails.datastore.mapping.model.types.Embedded;
import org.grails.datastore.mapping.model.types.EmbeddedCollection;
import org.grails.datastore.mapping.model.types.ToOne;
import org.grails.datastore.mapping.mongo.AbstractMongoSession;
import org.grails.datastore.mapping.mongo.MongoCodecSession;
import org.grails.datastore.mapping.mongo.MongoDatastore;
import org.grails.datastore.mapping.mongo.config.MongoAttribute;
import org.grails.datastore.mapping.mongo.config.MongoCollection;
import org.grails.datastore.mapping.mongo.engine.MongoCodecEntityPersister;
import org.grails.datastore.mapping.mongo.engine.MongoEntityPersister;
import org.grails.datastore.mapping.mongo.engine.codecs.PersistentEntityCodec;
import org.grails.datastore.mapping.mongo.query.EmbeddedQueryEncoder;
import org.grails.datastore.mapping.query.AssociationQuery;
import org.grails.datastore.mapping.query.Query;
import org.grails.datastore.mapping.query.Restrictions;
import org.grails.datastore.mapping.query.api.QueryArgumentsAware;
import org.grails.datastore.mapping.query.projections.ManualProjections;
import org.grails.datastore.mapping.reflect.EntityReflector;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class MongoQuery
extends Query
implements QueryArgumentsAware {
    public static final String PROJECT_OPERATOR = "$project";
    public static final String SORT_OPERATOR = "$sort";
    private static Map<Class, QueryHandler> queryHandlers = new HashMap<Class, QueryHandler>();
    private static Map<Class, QueryHandler> negatedHandlers = new HashMap<Class, QueryHandler>();
    private static Map<Class, ProjectionHandler> groupByProjectionHandlers = new HashMap<Class, ProjectionHandler>();
    private static Map<Class, ProjectionHandler> projectProjectionHandlers = new HashMap<Class, ProjectionHandler>();
    public static final String MONGO_IN_OPERATOR = "$in";
    public static final String MONGO_OR_OPERATOR = "$or";
    public static final String MONGO_AND_OPERATOR = "$and";
    public static final String MONGO_GTE_OPERATOR = "$gte";
    public static final String MONGO_LTE_OPERATOR = "$lte";
    public static final String MONGO_GT_OPERATOR = "$gt";
    public static final String MONGO_LT_OPERATOR = "$lt";
    public static final String MONGO_NE_OPERATOR = "$ne";
    public static final String MONGO_NIN_OPERATOR = "$nin";
    public static final String MONGO_ID_REFERENCE_SUFFIX = ".$id";
    public static final String MONGO_WHERE_OPERATOR = "$where";
    private static final String MONGO_THIS_PREFIX = "this.";
    public static final String HINT_ARGUMENT = "hint";
    private Map queryArguments = Collections.emptyMap();
    public static final String NEAR_OPERATOR = "$near";
    public static final String BOX_OPERATOR = "$box";
    public static final String POLYGON_OPERATOR = "$polygon";
    public static final String WITHIN_OPERATOR = "$within";
    public static final String CENTER_OPERATOR = "$center";
    public static final String GEO_WITHIN_OPERATOR = "$geoWithin";
    public static final String GEOMETRY_OPERATOR = "$geometry";
    public static final String CENTER_SPHERE_OPERATOR = "$centerSphere";
    public static final String GEO_INTERSECTS_OPERATOR = "$geoIntersects";
    public static final String MAX_DISTANCE_OPERATOR = "$maxDistance";
    public static final String NEAR_SPHERE_OPERATOR = "$nearSphere";
    public static final String MONGO_REGEX_OPERATOR = "$regex";
    public static final String MATCH_OPERATOR = "$match";
    public static final String AVERAGE_OPERATOR = "$avg";
    public static final String GROUP_OPERATOR = "$group";
    public static final String SUM_OPERATOR = "$sum";
    public static final String MIN_OPERATOR = "$min";
    public static final String MAX_OPERATOR = "$max";
    public static final String SIZE_OPERATOR = "$size";
    public static final String NOT_OPERATOR = "$not";
    public static final String EXISTS_OPERATOR = "$exists";
    public static final EncoderContext ENCODER_CONTEXT = EncoderContext.builder().build();
    private final AbstractMongoSession mongoSession;
    private final EntityPersister mongoEntityPersister;
    private final ManualProjections manualProjections;
    private boolean isCodecPersister = false;

    private static Integer getNumber(Query.PropertyCriterion criterion) {
        Object value = criterion.getValue();
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        throw new IllegalArgumentException("Argument to size constraint must be a number");
    }

    private static Document getIdObjectForGroupBy(Document groupBy) {
        Document id;
        Object value = groupBy.get((Object)"_id");
        if (value instanceof Document) {
            id = (Document)value;
        } else {
            id = new Document();
            groupBy.put("_id", (Object)id);
        }
        return id;
    }

    private static String addProjectionToGroupBy(Document projectObject, Document groupBy, Query.PropertyProjection projection, String operator, String prefix) {
        projectObject.put(projection.getPropertyName(), (Object)1);
        String property = projection.getPropertyName();
        String projectionValueKey = prefix + property;
        Document averageProjection = new Document(operator, (Object)("$" + property));
        groupBy.put(projectionValueKey, (Object)averageProjection);
        return projectionValueKey;
    }

    private static Document getOrCreatePropertyQuery(Document query, String propertyName) {
        Document queryObject;
        Object existing = query.get((Object)propertyName);
        Document document = queryObject = existing instanceof Document ? (Document)existing : null;
        if (queryObject == null) {
            queryObject = new Document();
        }
        return queryObject;
    }

    private static void addWherePropertyComparison(Document query, String propertyName, String otherPropertyName, String operator) {
        query.put(MONGO_WHERE_OPERATOR, (Object)(MONGO_THIS_PREFIX + propertyName + operator + MONGO_THIS_PREFIX + otherPropertyName));
    }

    private static List<Object> getInListQueryValues(PersistentEntity entity, Query.In in) {
        ArrayList<Object> values = new ArrayList<Object>(in.getValues().size());
        MappingContext mappingContext = entity.getMappingContext();
        for (Object value : in.getValues()) {
            if (mappingContext.isPersistentEntity(value)) {
                PersistentEntity pe = mappingContext.getPersistentEntity(value.getClass().getName());
                EntityReflector reflector = mappingContext.getEntityReflector(pe);
                values.add(reflector.getIdentifier(value));
                continue;
            }
            value = MongoEntityPersister.getSimpleNativePropertyValue(value, mappingContext);
            values.add(value);
        }
        return values;
    }

    private static void handleLike(PersistentEntity entity, Query.Like like, Document query, boolean caseSensitive) {
        Object value = like.getValue();
        String expr = MongoQuery.patternToRegex((Object)value);
        Pattern regex = caseSensitive ? Pattern.compile(expr) : Pattern.compile(expr, 2);
        String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)like);
        query.put(propertyName, (Object)regex);
    }

    public MongoQuery(AbstractMongoSession session, PersistentEntity entity) {
        super((Session)session, entity);
        this.mongoSession = session;
        this.manualProjections = new ManualProjections(entity);
        if (session != null) {
            this.mongoEntityPersister = (EntityPersister)session.getPersister(entity);
            if (this.mongoEntityPersister instanceof MongoCodecEntityPersister) {
                this.isCodecPersister = true;
            }
        } else {
            this.mongoEntityPersister = null;
        }
    }

    protected void flushBeforeQuery() {
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            super.flushBeforeQuery();
        }
    }

    public Document getMongoQuery() {
        Document query = this.createQueryObject(this.entity);
        MongoQuery.populateMongoQuery((AbstractMongoSession)this.getSession(), query, this.criteria, this.entity);
        return query;
    }

    protected List executeQuery(PersistentEntity entity, Query.Junction criteria) {
        AbstractMongoSession mongoSession = this.mongoSession;
        com.mongodb.client.MongoCollection collection = mongoSession.getCollection(entity);
        if (this.uniqueResult) {
            if (this.isCodecPersister) {
                collection = collection.withDocumentClass(entity.getJavaClass()).withCodecRegistry(mongoSession.getDatastore().getCodecRegistry());
            }
            Object dbObject = criteria.isEmpty() ? (entity.isRoot() ? collection.find().limit(1).first() : collection.find((Bson)new Document("_class", (Object)entity.getDiscriminator())).limit(1).first()) : collection.find((Bson)this.getMongoQuery()).limit(1).first();
            if (this.isCodecPersister) {
                if (!mongoSession.contains(dbObject)) {
                    EntityAccess entityAccess = mongoSession.createEntityAccess(entity, dbObject);
                    mongoSession.cacheInstance(dbObject.getClass(), (Serializable)entityAccess.getIdentifier(), dbObject);
                }
                return this.wrapObjectResultInList(dbObject);
            }
            return this.wrapObjectResultInList(this.createObjectFromDBObject((Document)dbObject));
        }
        Document query = this.createQueryObject(entity);
        List projectionList = this.projections().getProjectionList();
        if (projectionList.isEmpty()) {
            if (this.isCodecPersister) {
                collection = collection.withDocumentClass(entity.getJavaClass()).withCodecRegistry(mongoSession.getDatastore().getCodecRegistry());
            }
            MongoCursor<Document> cursor = this.executeQuery(entity, criteria, (com.mongodb.client.MongoCollection<Document>)collection, query);
            return new MongoResultList(cursor, this.offset, this.mongoEntityPersister);
        }
        MongoQuery.populateMongoQuery((AbstractMongoSession)this.session, query, criteria, entity);
        AggregatePipeline aggregatePipeline = this.buildAggregatePipeline(entity, query, projectionList);
        List<Document> aggregationPipeline = aggregatePipeline.getAggregationPipeline();
        boolean singleResult = aggregatePipeline.isSingleResult();
        List<ProjectedProperty> projectedKeys = aggregatePipeline.getProjectedKeys();
        ArrayList<Object> projectedResults = new ArrayList<Object>();
        AggregateIterable aggregatedResults = collection.aggregate(aggregationPipeline);
        MongoCursor aggregateCursor = aggregatedResults.iterator();
        if (singleResult && aggregateCursor.hasNext()) {
            Document dbo = (Document)aggregateCursor.next();
            for (ProjectedProperty projectedProperty : projectedKeys) {
                Object value = dbo.get((Object)projectedProperty.projectionKey);
                PersistentProperty property = projectedProperty.property;
                if (value != null) {
                    if (property instanceof ToOne) {
                        projectedResults.add(this.session.retrieve(property.getType(), (Serializable)value));
                        continue;
                    }
                    projectedResults.add(value);
                    continue;
                }
                if (!(projectedProperty.projection instanceof Query.CountProjection)) continue;
                projectedResults.add(0);
            }
        } else {
            return new AggregatedResultList(this.getSession(), (MongoCursor<Document>)aggregateCursor, projectedKeys);
        }
        return projectedResults;
    }

    protected AggregatePipeline buildAggregatePipeline(PersistentEntity entity, Document query, List<Query.Projection> projectionList) {
        return new AggregatePipeline(this, entity, query, projectionList).build();
    }

    protected MongoCursor<Document> executeQuery(PersistentEntity entity, Query.Junction criteria, com.mongodb.client.MongoCollection<Document> collection, Document query) {
        FindIterable cursor;
        if (criteria.isEmpty()) {
            cursor = this.executeQueryAndApplyPagination(collection, query);
        } else {
            MongoQuery.populateMongoQuery((AbstractMongoSession)this.session, query, criteria, entity);
            cursor = this.executeQueryAndApplyPagination(collection, query);
        }
        if (this.queryArguments != null && this.queryArguments.containsKey(HINT_ARGUMENT)) {
            Object hint = this.queryArguments.get(HINT_ARGUMENT);
            cursor = cursor.modifiers((Bson)new Document("$hint", hint));
        }
        return cursor.iterator();
    }

    protected FindIterable<Document> executeQueryAndApplyPagination(com.mongodb.client.MongoCollection<Document> collection, Document query) {
        FindIterable iterable = collection.find((Bson)query);
        if (this.offset > 0) {
            iterable.skip(this.offset);
        }
        if (this.max > -1) {
            iterable.limit(this.max);
        }
        if (!this.orderBy.isEmpty()) {
            Document orderObject = new Document();
            for (Query.Order order : this.orderBy) {
                String property = order.getProperty();
                property = MongoQuery.getPropertyName(this.entity, property);
                orderObject.put(property, (Object)(order.getDirection() == Query.Order.Direction.DESC ? -1 : 1));
            }
            iterable.sort((Bson)orderObject);
        } else {
            MongoCollection coll = (MongoCollection)this.entity.getMapping().getMappedForm();
            if (coll != null && coll.getSort() != null) {
                Document orderObject = new Document();
                Query.Order order = coll.getSort();
                String property = order.getProperty();
                property = MongoQuery.getPropertyName(this.entity, property);
                orderObject.put(property, (Object)(order.getDirection() == Query.Order.Direction.DESC ? -1 : 1));
                iterable.sort((Bson)orderObject);
            }
        }
        return iterable;
    }

    protected Document createQueryObject(PersistentEntity persistentEntity) {
        Document query = persistentEntity.isRoot() ? new Document() : new Document("_class", (Object)persistentEntity.getDiscriminator());
        return query;
    }

    public static void populateMongoQuery(final AbstractMongoSession session, Document query, Query.Junction criteria, final PersistentEntity entity) {
        EmbeddedQueryEncoder queryEncoder;
        if (session instanceof MongoCodecSession) {
            MongoDatastore datastore = session.getDatastore();
            final CodecRegistry codecRegistry = datastore.getCodecRegistry();
            queryEncoder = new EmbeddedQueryEncoder(){

                @Override
                public Object encode(Embedded embedded, Object instance) {
                    PersistentEntityCodec codec = (PersistentEntityCodec)codecRegistry.get(embedded.getType());
                    BsonDocument doc = new BsonDocument();
                    codec.encode((BsonWriter)new BsonDocumentWriter(doc), instance, ENCODER_CONTEXT, false);
                    return doc;
                }
            };
        } else {
            queryEncoder = new EmbeddedQueryEncoder(){

                @Override
                public Object encode(Embedded embedded, Object instance) {
                    MongoEntityPersister persister = (MongoEntityPersister)session.getPersister(entity.getJavaClass());
                    return persister.createNativeObjectForEmbedded((Association)embedded, instance);
                }
            };
        }
        MongoQuery.populateMongoQuery(queryEncoder, query, criteria, entity);
    }

    public static void populateMongoQuery(EmbeddedQueryEncoder queryEncoder, Document query, Query.Junction criteria, PersistentEntity entity) {
        ArrayList<Document> subList = null;
        if (criteria.getCriteria().size() > 1) {
            if (criteria instanceof Query.Disjunction) {
                subList = new ArrayList<Document>();
                query.put(MONGO_OR_OPERATOR, subList);
            } else if (criteria instanceof Query.Conjunction) {
                subList = new ArrayList();
                query.put(MONGO_AND_OPERATOR, subList);
            }
        }
        for (Query.Criterion criterion : criteria.getCriteria()) {
            QueryHandler queryHandler = queryHandlers.get(criterion.getClass());
            if (queryHandler != null) {
                Query.PropertyCriterion pc;
                PersistentProperty property;
                Document dbo = query;
                if (subList != null) {
                    dbo = new Document();
                    subList.add(dbo);
                }
                if (criterion instanceof Query.PropertyCriterion && !(criterion instanceof GeoCriterion) && (property = entity.getPropertyByName((pc = (Query.PropertyCriterion)criterion).getProperty())) instanceof Custom) {
                    CustomTypeMarshaller customTypeMarshaller = ((Custom)property).getCustomTypeMarshaller();
                    customTypeMarshaller.query(property, pc, (Object)query);
                    continue;
                }
                queryHandler.handle(queryEncoder, criterion, dbo, entity);
                continue;
            }
            throw new InvalidDataAccessResourceUsageException("Queries of type " + criterion.getClass().getSimpleName() + " are not supported by this implementation");
        }
    }

    protected static String getPropertyName(PersistentEntity entity, Query.PropertyNameCriterion criterion) {
        String propertyName = criterion.getProperty();
        return MongoQuery.getPropertyName(entity, propertyName);
    }

    protected static String getPropertyName(PersistentEntity entity, String propertyName) {
        if (entity.isIdentityName(propertyName)) {
            propertyName = "_id";
        } else {
            PersistentProperty property = entity.getPropertyByName(propertyName);
            if (property != null) {
                propertyName = MappingUtils.getTargetKey((PersistentProperty)property);
                if (property instanceof ToOne && !(property instanceof Embedded)) {
                    boolean isReference;
                    ToOne association = (ToOne)property;
                    MongoAttribute attr = (MongoAttribute)association.getMapping().getMappedForm();
                    boolean bl = isReference = attr == null || attr.isReference();
                    if (isReference) {
                        propertyName = propertyName + MONGO_ID_REFERENCE_SUFFIX;
                    }
                }
            }
        }
        return propertyName;
    }

    private Object createObjectFromDBObject(Document dbObject) {
        Object id = dbObject.get((Object)"_id");
        Class type = this.mongoEntityPersister.getPersistentEntity().getJavaClass();
        Object instance = this.mongoSession.getCachedInstance(type, (Serializable)id);
        if (instance == null) {
            instance = ((MongoEntityPersister)this.mongoEntityPersister).createObjectFromNativeEntry(this.mongoEntityPersister.getPersistentEntity(), (Serializable)id, dbObject);
            this.mongoSession.cacheInstance(type, (Serializable)id, instance);
        }
        return instance;
    }

    private List wrapObjectResultInList(Object object) {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(object);
        return result;
    }

    public Query near(String property, List value) {
        this.add((Query.Criterion)new Near(property, value));
        return this;
    }

    public Query near(String property, Point value) {
        this.add((Query.Criterion)new Near(property, value));
        return this;
    }

    public Query near(String property, List value, Distance maxDistance) {
        this.add((Query.Criterion)new Near(property, (Object)value, maxDistance));
        return this;
    }

    public Query near(String property, Point value, Distance maxDistance) {
        this.add((Query.Criterion)new Near(property, (Object)value, maxDistance));
        return this;
    }

    public Query near(String property, List value, Number maxDistance) {
        this.add((Query.Criterion)new Near(property, (Object)value, maxDistance));
        return this;
    }

    public Query near(String property, Point value, Number maxDistance) {
        this.add((Query.Criterion)new Near(property, (Object)value, maxDistance));
        return this;
    }

    public Query nearSphere(String property, List value) {
        this.add((Query.Criterion)new NearSphere(property, value));
        return this;
    }

    public Query nearSphere(String property, Point value) {
        this.add((Query.Criterion)new NearSphere(property, value));
        return this;
    }

    public Query nearSphere(String property, List value, Distance maxDistance) {
        this.add((Query.Criterion)new NearSphere(property, (Object)value, maxDistance));
        return this;
    }

    public Query nearSphere(String property, Point value, Distance maxDistance) {
        this.add((Query.Criterion)new NearSphere(property, (Object)value, maxDistance));
        return this;
    }

    public Query nearSphere(String property, List value, Number maxDistance) {
        this.add((Query.Criterion)new NearSphere(property, (Object)value, maxDistance));
        return this;
    }

    public Query nearSphere(String property, Point value, Number maxDistance) {
        this.add((Query.Criterion)new NearSphere(property, (Object)value, maxDistance));
        return this;
    }

    public Query withinBox(String property, List value) {
        this.add((Query.Criterion)new WithinBox(property, value));
        return this;
    }

    public Query geoWithin(String property, Shape shape) {
        this.add((Query.Criterion)new GeoWithin(property, shape));
        return this;
    }

    public Query geoIntersects(String property, GeoJSON shape) {
        this.add((Query.Criterion)new GeoIntersects(property, shape));
        return this;
    }

    public Query withinPolygon(String property, List value) {
        this.add((Query.Criterion)new WithinPolygon(property, value));
        return this;
    }

    public Query withinCircle(String property, List value) {
        this.add((Query.Criterion)new WithinBox(property, value));
        return this;
    }

    public void setArguments(Map arguments) {
        this.queryArguments = arguments;
    }

    static {
        queryHandlers.put(Query.IdEquals.class, new QueryHandler<Query.IdEquals>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.IdEquals criterion, Document query, PersistentEntity entity) {
                query.put("_id", criterion.getValue());
            }
        });
        queryHandlers.put(AssociationQuery.class, new QueryHandler<AssociationQuery>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, AssociationQuery criterion, Document query, PersistentEntity entity) {
                Association association = criterion.getAssociation();
                PersistentEntity associatedEntity = association.getAssociatedEntity();
                if (association instanceof EmbeddedCollection) {
                    Document associationCollectionQuery = new Document();
                    MongoQuery.populateMongoQuery(queryEncoder, associationCollectionQuery, criterion.getCriteria(), associatedEntity);
                    Document collectionQuery = new Document("$elemMatch", (Object)associationCollectionQuery);
                    String propertyKey = MongoQuery.getPropertyName(entity, association.getName());
                    query.put(propertyKey, (Object)collectionQuery);
                } else if (associatedEntity instanceof EmbeddedPersistentEntity || association instanceof Embedded) {
                    Document associatedEntityQuery = new Document();
                    MongoQuery.populateMongoQuery(queryEncoder, associatedEntityQuery, criterion.getCriteria(), associatedEntity);
                    for (String property : associatedEntityQuery.keySet()) {
                        String propertyKey = MongoQuery.getPropertyName(entity, association.getName());
                        query.put(propertyKey + '.' + property, associatedEntityQuery.get((Object)property));
                    }
                } else {
                    throw new UnsupportedOperationException("Join queries are not supported by MongoDB");
                }
            }
        });
        queryHandlers.put(Query.Equals.class, new QueryHandler<Query.Equals>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.Equals criterion, Document query, PersistentEntity entity) {
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                PersistentProperty persistentProperty = entity.getPropertyByName(criterion.getProperty());
                Object value = persistentProperty instanceof Embedded && criterion.getValue() != null ? queryEncoder.encode((Embedded)persistentProperty, criterion.getValue()) : criterion.getValue();
                if (value instanceof Pattern) {
                    Pattern pattern = (Pattern)value;
                    query.put(propertyName, (Object)new Document(MongoQuery.MONGO_REGEX_OPERATOR, (Object)pattern.toString()));
                } else {
                    MongoEntityPersister.setDBObjectValue(query, propertyName, value, entity.getMappingContext());
                }
            }
        });
        queryHandlers.put(Query.IsNull.class, new QueryHandler<Query.IsNull>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.IsNull criterion, Document query, PersistentEntity entity) {
                ((QueryHandler)queryHandlers.get(Query.Equals.class)).handle(queryEncoder, new Query.Equals(criterion.getProperty(), null), query, entity);
            }
        });
        queryHandlers.put(Query.IsNotNull.class, new QueryHandler<Query.IsNotNull>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.IsNotNull criterion, Document query, PersistentEntity entity) {
                ((QueryHandler)queryHandlers.get(Query.NotEquals.class)).handle(queryEncoder, new Query.NotEquals(criterion.getProperty(), null), query, entity);
            }
        });
        queryHandlers.put(Query.EqualsProperty.class, new QueryHandler<Query.EqualsProperty>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.EqualsProperty criterion, Document query, PersistentEntity entity) {
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                String otherPropertyName = MongoQuery.getPropertyName(entity, criterion.getOtherProperty());
                MongoQuery.addWherePropertyComparison(query, propertyName, otherPropertyName, "==");
            }
        });
        queryHandlers.put(Query.NotEqualsProperty.class, new QueryHandler<Query.NotEqualsProperty>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.NotEqualsProperty criterion, Document query, PersistentEntity entity) {
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                String otherPropertyName = MongoQuery.getPropertyName(entity, criterion.getOtherProperty());
                MongoQuery.addWherePropertyComparison(query, propertyName, otherPropertyName, "!=");
            }
        });
        queryHandlers.put(Query.GreaterThanProperty.class, new QueryHandler<Query.GreaterThanProperty>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.GreaterThanProperty criterion, Document query, PersistentEntity entity) {
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                String otherPropertyName = MongoQuery.getPropertyName(entity, criterion.getOtherProperty());
                MongoQuery.addWherePropertyComparison(query, propertyName, otherPropertyName, ">");
            }
        });
        queryHandlers.put(Query.LessThanProperty.class, new QueryHandler<Query.LessThanProperty>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.LessThanProperty criterion, Document query, PersistentEntity entity) {
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                String otherPropertyName = MongoQuery.getPropertyName(entity, criterion.getOtherProperty());
                MongoQuery.addWherePropertyComparison(query, propertyName, otherPropertyName, "<");
            }
        });
        queryHandlers.put(Query.GreaterThanEqualsProperty.class, new QueryHandler<Query.GreaterThanEqualsProperty>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.GreaterThanEqualsProperty criterion, Document query, PersistentEntity entity) {
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                String otherPropertyName = MongoQuery.getPropertyName(entity, criterion.getOtherProperty());
                MongoQuery.addWherePropertyComparison(query, propertyName, otherPropertyName, ">=");
            }
        });
        queryHandlers.put(Query.LessThanEqualsProperty.class, new QueryHandler<Query.LessThanEqualsProperty>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.LessThanEqualsProperty criterion, Document query, PersistentEntity entity) {
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                String otherPropertyName = MongoQuery.getPropertyName(entity, criterion.getOtherProperty());
                MongoQuery.addWherePropertyComparison(query, propertyName, otherPropertyName, "<=");
            }
        });
        queryHandlers.put(Query.NotEquals.class, new QueryHandler<Query.NotEquals>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.NotEquals criterion, Document query, PersistentEntity entity) {
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                Document notEqualQuery = MongoQuery.getOrCreatePropertyQuery(query, propertyName);
                MongoEntityPersister.setDBObjectValue(notEqualQuery, MongoQuery.MONGO_NE_OPERATOR, criterion.getValue(), entity.getMappingContext());
                query.put(propertyName, (Object)notEqualQuery);
            }
        });
        queryHandlers.put(Query.Like.class, new QueryHandler<Query.Like>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.Like like, Document query, PersistentEntity entity) {
                MongoQuery.handleLike(entity, like, query, true);
            }
        });
        queryHandlers.put(Query.ILike.class, new QueryHandler<Query.ILike>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.ILike like, Document query, PersistentEntity entity) {
                MongoQuery.handleLike(entity, (Query.Like)like, query, false);
            }
        });
        queryHandlers.put(Query.RLike.class, new QueryHandler<Query.RLike>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.RLike like, Document query, PersistentEntity entity) {
                Object value = like.getValue();
                if (value == null) {
                    value = "null";
                }
                String expr = value.toString();
                Pattern regex = Pattern.compile(expr);
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)like);
                query.put(propertyName, (Object)regex);
            }
        });
        queryHandlers.put(Query.In.class, new QueryHandler<Query.In>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.In in, Document query, PersistentEntity entity) {
                Document inQuery = new Document();
                List values = MongoQuery.getInListQueryValues(entity, in);
                inQuery.put(MongoQuery.MONGO_IN_OPERATOR, (Object)values);
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)in);
                query.put(propertyName, (Object)inQuery);
            }
        });
        queryHandlers.put(WithinBox.class, new QueryHandler<WithinBox>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, WithinBox withinBox, Document query, PersistentEntity entity) {
                Document nearQuery = new Document();
                Document box = new Document();
                MongoEntityPersister.setDBObjectValue(box, MongoQuery.BOX_OPERATOR, withinBox.getValues(), entity.getMappingContext());
                nearQuery.put(MongoQuery.WITHIN_OPERATOR, (Object)box);
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)withinBox);
                query.put(propertyName, (Object)nearQuery);
            }
        });
        queryHandlers.put(WithinPolygon.class, new QueryHandler<WithinPolygon>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, WithinPolygon withinPolygon, Document query, PersistentEntity entity) {
                Document nearQuery = new Document();
                Document box = new Document();
                MongoEntityPersister.setDBObjectValue(box, MongoQuery.POLYGON_OPERATOR, withinPolygon.getValues(), entity.getMappingContext());
                nearQuery.put(MongoQuery.WITHIN_OPERATOR, (Object)box);
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)withinPolygon);
                query.put(propertyName, (Object)nearQuery);
            }
        });
        queryHandlers.put(WithinCircle.class, new QueryHandler<WithinCircle>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, WithinCircle withinCentre, Document query, PersistentEntity entity) {
                Document nearQuery = new Document();
                Document center = new Document();
                MongoEntityPersister.setDBObjectValue(center, MongoQuery.CENTER_OPERATOR, withinCentre.getValues(), entity.getMappingContext());
                nearQuery.put(MongoQuery.WITHIN_OPERATOR, (Object)center);
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)withinCentre);
                query.put(propertyName, (Object)nearQuery);
            }
        });
        QueryHandler<Near> nearHandler = new QueryHandler<Near>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Near near, Document query, PersistentEntity entity) {
                String nearOperator;
                Document nearQuery = new Document();
                Object value = near.getValue();
                String string = nearOperator = near instanceof NearSphere ? MongoQuery.NEAR_SPHERE_OPERATOR : MongoQuery.NEAR_OPERATOR;
                if (value instanceof List || value instanceof Map) {
                    MongoEntityPersister.setDBObjectValue(nearQuery, nearOperator, value, entity.getMappingContext());
                } else if (value instanceof Point) {
                    Document geoJson = GeoJSONType.convertToGeoDocument((Point)value);
                    Document geometry = new Document();
                    geometry.put(MongoQuery.GEOMETRY_OPERATOR, (Object)geoJson);
                    if (near.maxDistance != null) {
                        geometry.put(MongoQuery.MAX_DISTANCE_OPERATOR, (Object)near.maxDistance.getValue());
                    }
                    nearQuery.put(nearOperator, (Object)geometry);
                }
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)near);
                query.put(propertyName, (Object)nearQuery);
            }
        };
        queryHandlers.put(Near.class, nearHandler);
        queryHandlers.put(NearSphere.class, nearHandler);
        queryHandlers.put(GeoWithin.class, new QueryHandler<GeoWithin>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, GeoWithin geoWithin, Document query, PersistentEntity entity) {
                Document queryRoot = new Document();
                Document queryGeoWithin = new Document();
                queryRoot.put(MongoQuery.GEO_WITHIN_OPERATOR, (Object)queryGeoWithin);
                String targetProperty = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)geoWithin);
                Object value = geoWithin.getValue();
                if (value instanceof Shape) {
                    Shape shape = (Shape)value;
                    if (shape instanceof Polygon) {
                        Polygon p = (Polygon)shape;
                        Document geoJson = GeoJSONType.convertToGeoDocument(p);
                        queryGeoWithin.put(MongoQuery.GEOMETRY_OPERATOR, (Object)geoJson);
                    } else if (shape instanceof Box) {
                        queryGeoWithin.put(MongoQuery.BOX_OPERATOR, shape.asList());
                    } else if (shape instanceof Circle) {
                        queryGeoWithin.put(MongoQuery.CENTER_OPERATOR, shape.asList());
                    } else if (shape instanceof Sphere) {
                        queryGeoWithin.put(MongoQuery.CENTER_SPHERE_OPERATOR, shape.asList());
                    }
                } else if (value instanceof Map) {
                    queryGeoWithin.putAll((Map)value);
                }
                query.put(targetProperty, (Object)queryRoot);
            }
        });
        queryHandlers.put(GeoIntersects.class, new QueryHandler<GeoIntersects>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, GeoIntersects geoIntersects, Document query, PersistentEntity entity) {
                Document queryRoot = new Document();
                Document queryGeoWithin = new Document();
                queryRoot.put(MongoQuery.GEO_INTERSECTS_OPERATOR, (Object)queryGeoWithin);
                String targetProperty = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)geoIntersects);
                Object value = geoIntersects.getValue();
                if (value instanceof GeoJSON) {
                    Shape shape = (Shape)value;
                    Document geoJson = GeoJSONType.convertToGeoDocument(shape);
                    queryGeoWithin.put(MongoQuery.GEOMETRY_OPERATOR, (Object)geoJson);
                } else if (value instanceof Map) {
                    queryGeoWithin.putAll((Map)value);
                }
                query.put(targetProperty, (Object)queryRoot);
            }
        });
        queryHandlers.put(Query.Between.class, new QueryHandler<Query.Between>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.Between between, Document query, PersistentEntity entity) {
                Document betweenQuery = new Document();
                MongoEntityPersister.setDBObjectValue(betweenQuery, MongoQuery.MONGO_GTE_OPERATOR, between.getFrom(), entity.getMappingContext());
                MongoEntityPersister.setDBObjectValue(betweenQuery, MongoQuery.MONGO_LTE_OPERATOR, between.getTo(), entity.getMappingContext());
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)between);
                query.put(propertyName, (Object)betweenQuery);
            }
        });
        queryHandlers.put(Query.GreaterThan.class, new QueryHandler<Query.GreaterThan>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.GreaterThan criterion, Document query, PersistentEntity entity) {
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                Document greaterThanQuery = MongoQuery.getOrCreatePropertyQuery(query, propertyName);
                MongoEntityPersister.setDBObjectValue(greaterThanQuery, MongoQuery.MONGO_GT_OPERATOR, criterion.getValue(), entity.getMappingContext());
                query.put(propertyName, (Object)greaterThanQuery);
            }
        });
        queryHandlers.put(Query.GreaterThanEquals.class, new QueryHandler<Query.GreaterThanEquals>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.GreaterThanEquals criterion, Document query, PersistentEntity entity) {
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                Document greaterThanQuery = MongoQuery.getOrCreatePropertyQuery(query, propertyName);
                MongoEntityPersister.setDBObjectValue(greaterThanQuery, MongoQuery.MONGO_GTE_OPERATOR, criterion.getValue(), entity.getMappingContext());
                query.put(propertyName, (Object)greaterThanQuery);
            }
        });
        queryHandlers.put(Query.LessThan.class, new QueryHandler<Query.LessThan>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.LessThan criterion, Document query, PersistentEntity entity) {
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                Document lessThanQuery = MongoQuery.getOrCreatePropertyQuery(query, propertyName);
                MongoEntityPersister.setDBObjectValue(lessThanQuery, MongoQuery.MONGO_LT_OPERATOR, criterion.getValue(), entity.getMappingContext());
                query.put(propertyName, (Object)lessThanQuery);
            }
        });
        queryHandlers.put(Query.LessThanEquals.class, new QueryHandler<Query.LessThanEquals>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.LessThanEquals criterion, Document query, PersistentEntity entity) {
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                Document lessThanQuery = MongoQuery.getOrCreatePropertyQuery(query, propertyName);
                MongoEntityPersister.setDBObjectValue(lessThanQuery, MongoQuery.MONGO_LTE_OPERATOR, criterion.getValue(), entity.getMappingContext());
                query.put(propertyName, (Object)lessThanQuery);
            }
        });
        queryHandlers.put(Query.Conjunction.class, new QueryHandler<Query.Conjunction>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.Conjunction criterion, Document query, PersistentEntity entity) {
                MongoQuery.populateMongoQuery(queryEncoder, query, (Query.Junction)criterion, entity);
            }
        });
        queryHandlers.put(Query.Negation.class, new QueryHandler<Query.Negation>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.Negation criteria, Document query, PersistentEntity entity) {
                for (Query.Criterion criterion : criteria.getCriteria()) {
                    QueryHandler queryHandler = (QueryHandler)negatedHandlers.get(criterion.getClass());
                    if (queryHandler != null) {
                        queryHandler.handle(queryEncoder, criterion, query, entity);
                        continue;
                    }
                    throw new UnsupportedOperationException("Query of type " + criterion.getClass().getSimpleName() + " cannot be negated");
                }
            }
        });
        queryHandlers.put(Query.Disjunction.class, new QueryHandler<Query.Disjunction>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.Disjunction criterion, Document query, PersistentEntity entity) {
                MongoQuery.populateMongoQuery(queryEncoder, query, (Query.Junction)criterion, entity);
            }
        });
        queryHandlers.put(Query.SizeEquals.class, new QueryHandler<Query.SizeEquals>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.SizeEquals criterion, Document query, PersistentEntity entity) {
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                Document sizeEqualsQuery = MongoQuery.getOrCreatePropertyQuery(query, propertyName);
                MongoEntityPersister.setDBObjectValue(sizeEqualsQuery, MongoQuery.SIZE_OPERATOR, MongoQuery.getNumber((Query.PropertyCriterion)criterion), entity.getMappingContext());
                query.put(propertyName, (Object)sizeEqualsQuery);
            }
        });
        queryHandlers.put(Query.SizeNotEquals.class, new QueryHandler<Query.SizeNotEquals>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.SizeNotEquals criterion, Document query, PersistentEntity entity) {
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                Document sizeNotEqualsQuery = MongoQuery.getOrCreatePropertyQuery(query, propertyName);
                sizeNotEqualsQuery.put(MongoQuery.NOT_OPERATOR, (Object)new Document(MongoQuery.SIZE_OPERATOR, (Object)MongoQuery.getNumber((Query.PropertyCriterion)criterion)));
                query.put(propertyName, (Object)sizeNotEqualsQuery);
            }
        });
        queryHandlers.put(Query.SizeGreaterThan.class, new QueryHandler<Query.SizeGreaterThan>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.SizeGreaterThan criterion, Document query, PersistentEntity entity) {
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                Integer greaterThanValue = MongoQuery.getNumber((Query.PropertyCriterion)criterion);
                query.put(propertyName + '.' + greaterThanValue, (Object)new Document(MongoQuery.EXISTS_OPERATOR, (Object)true));
            }
        });
        queryHandlers.put(Query.SizeLessThan.class, new QueryHandler<Query.SizeLessThan>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.SizeLessThan criterion, Document query, PersistentEntity entity) {
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                Integer lessThanValue = MongoQuery.getNumber((Query.PropertyCriterion)criterion);
                query.put(propertyName + '.' + (lessThanValue - 1), (Object)new BasicDBObject(MongoQuery.EXISTS_OPERATOR, (Object)0));
            }
        });
        queryHandlers.put(Query.SizeLessThanEquals.class, new QueryHandler<Query.SizeLessThanEquals>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.SizeLessThanEquals criterion, Document query, PersistentEntity entity) {
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                Integer lessThanValue = MongoQuery.getNumber((Query.PropertyCriterion)criterion);
                query.put(propertyName + '.' + lessThanValue, (Object)new Document(MongoQuery.EXISTS_OPERATOR, (Object)0));
            }
        });
        queryHandlers.put(Query.SizeGreaterThanEquals.class, new QueryHandler<Query.SizeGreaterThanEquals>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.SizeGreaterThanEquals criterion, Document query, PersistentEntity entity) {
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                Integer greaterThanValue = MongoQuery.getNumber((Query.PropertyCriterion)criterion);
                query.put(propertyName + '.' + (greaterThanValue - 1), (Object)new Document(MongoQuery.EXISTS_OPERATOR, (Object)true));
            }
        });
        negatedHandlers.put(Query.SizeEquals.class, new QueryHandler<Query.SizeEquals>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.SizeEquals criterion, Document query, PersistentEntity entity) {
                ((QueryHandler)queryHandlers.get(Query.SizeNotEquals.class)).handle(queryEncoder, Restrictions.sizeNe((String)criterion.getProperty(), (int)MongoQuery.getNumber((Query.PropertyCriterion)criterion)), query, entity);
            }
        });
        negatedHandlers.put(Query.SizeNotEquals.class, new QueryHandler<Query.SizeNotEquals>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.SizeNotEquals criterion, Document query, PersistentEntity entity) {
                ((QueryHandler)queryHandlers.get(Query.SizeEquals.class)).handle(queryEncoder, Restrictions.sizeEq((String)criterion.getProperty(), (int)MongoQuery.getNumber((Query.PropertyCriterion)criterion)), query, entity);
            }
        });
        negatedHandlers.put(Query.SizeGreaterThan.class, new QueryHandler<Query.SizeGreaterThan>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.SizeGreaterThan criterion, Document query, PersistentEntity entity) {
                ((QueryHandler)queryHandlers.get(Query.SizeLessThan.class)).handle(queryEncoder, Restrictions.sizeLt((String)criterion.getProperty(), (int)MongoQuery.getNumber((Query.PropertyCriterion)criterion)), query, entity);
            }
        });
        negatedHandlers.put(Query.SizeLessThan.class, new QueryHandler<Query.SizeLessThan>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.SizeLessThan criterion, Document query, PersistentEntity entity) {
                ((QueryHandler)queryHandlers.get(Query.SizeGreaterThan.class)).handle(queryEncoder, Restrictions.sizeGt((String)criterion.getProperty(), (int)MongoQuery.getNumber((Query.PropertyCriterion)criterion)), query, entity);
            }
        });
        negatedHandlers.put(Query.Equals.class, new QueryHandler<Query.Equals>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.Equals criterion, Document query, PersistentEntity entity) {
                ((QueryHandler)queryHandlers.get(Query.NotEquals.class)).handle(queryEncoder, Restrictions.ne((String)criterion.getProperty(), (Object)criterion.getValue()), query, entity);
            }
        });
        negatedHandlers.put(Query.NotEquals.class, new QueryHandler<Query.NotEquals>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.NotEquals criterion, Document query, PersistentEntity entity) {
                ((QueryHandler)queryHandlers.get(Query.Equals.class)).handle(queryEncoder, Restrictions.eq((String)criterion.getProperty(), (Object)criterion.getValue()), query, entity);
            }
        });
        negatedHandlers.put(Query.In.class, new QueryHandler<Query.In>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.In in, Document query, PersistentEntity entity) {
                List nativePropertyValue = MongoQuery.getInListQueryValues(entity, in);
                String property = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)in);
                Document inQuery = MongoQuery.getOrCreatePropertyQuery(query, property);
                inQuery.put(MongoQuery.MONGO_NIN_OPERATOR, (Object)nativePropertyValue);
                query.put(property, (Object)inQuery);
            }
        });
        negatedHandlers.put(Query.Between.class, new QueryHandler<Query.Between>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.Between between, Document query, PersistentEntity entity) {
                String property = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)between);
                Document betweenQuery = MongoQuery.getOrCreatePropertyQuery(query, property);
                betweenQuery.put(MongoQuery.MONGO_LTE_OPERATOR, between.getFrom());
                betweenQuery.put(MongoQuery.MONGO_GTE_OPERATOR, between.getTo());
                query.put(property, (Object)betweenQuery);
            }
        });
        negatedHandlers.put(Query.GreaterThan.class, new QueryHandler<Query.GreaterThan>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.GreaterThan criterion, Document query, PersistentEntity entity) {
                ((QueryHandler)queryHandlers.get(Query.LessThan.class)).handle(queryEncoder, Restrictions.lt((String)criterion.getProperty(), (Object)criterion.getValue()), query, entity);
            }
        });
        negatedHandlers.put(Query.GreaterThanEquals.class, new QueryHandler<Query.GreaterThanEquals>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.GreaterThanEquals criterion, Document query, PersistentEntity entity) {
                ((QueryHandler)queryHandlers.get(Query.LessThanEquals.class)).handle(queryEncoder, Restrictions.lte((String)criterion.getProperty(), (Object)criterion.getValue()), query, entity);
            }
        });
        negatedHandlers.put(Query.LessThan.class, new QueryHandler<Query.LessThan>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.LessThan criterion, Document query, PersistentEntity entity) {
                ((QueryHandler)queryHandlers.get(Query.GreaterThan.class)).handle(queryEncoder, Restrictions.gt((String)criterion.getProperty(), (Object)criterion.getValue()), query, entity);
            }
        });
        negatedHandlers.put(Query.LessThanEquals.class, new QueryHandler<Query.LessThanEquals>(){

            @Override
            public void handle(EmbeddedQueryEncoder queryEncoder, Query.LessThanEquals criterion, Document query, PersistentEntity entity) {
                ((QueryHandler)queryHandlers.get(Query.GreaterThanEquals.class)).handle(queryEncoder, Restrictions.gte((String)criterion.getProperty(), (Object)criterion.getValue()), query, entity);
            }
        });
        groupByProjectionHandlers.put(Query.AvgProjection.class, new ProjectionHandler<Query.AvgProjection>(){

            @Override
            public String handle(PersistentEntity entity, Document projectObject, Document groupBy, Query.AvgProjection projection) {
                return MongoQuery.addProjectionToGroupBy(projectObject, groupBy, (Query.PropertyProjection)projection, MongoQuery.AVERAGE_OPERATOR, "avg_");
            }
        });
        groupByProjectionHandlers.put(Query.CountProjection.class, new ProjectionHandler<Query.CountProjection>(){

            @Override
            public String handle(PersistentEntity entity, Document projectObject, Document groupBy, Query.CountProjection projection) {
                projectObject.put("_id", (Object)1);
                String projectionKey = "count";
                groupBy.put(projectionKey, (Object)new Document(MongoQuery.SUM_OPERATOR, (Object)1));
                return projectionKey;
            }
        });
        groupByProjectionHandlers.put(Query.CountDistinctProjection.class, new ProjectionHandler<Query.CountDistinctProjection>(){

            @Override
            public String handle(PersistentEntity entity, Document projectObject, Document groupBy, Query.CountDistinctProjection projection) {
                projectObject.put(projection.getPropertyName(), (Object)1);
                String property = projection.getPropertyName();
                String projectionValueKey = "countDistinct_" + property;
                Document id = MongoQuery.getIdObjectForGroupBy(groupBy);
                id.put(property, (Object)("$" + property));
                return projectionValueKey;
            }
        });
        groupByProjectionHandlers.put(Query.MinProjection.class, new ProjectionHandler<Query.MinProjection>(){

            @Override
            public String handle(PersistentEntity entity, Document projectObject, Document groupBy, Query.MinProjection projection) {
                return MongoQuery.addProjectionToGroupBy(projectObject, groupBy, (Query.PropertyProjection)projection, MongoQuery.MIN_OPERATOR, "min_");
            }
        });
        groupByProjectionHandlers.put(Query.MaxProjection.class, new ProjectionHandler<Query.MaxProjection>(){

            @Override
            public String handle(PersistentEntity entity, Document projectObject, Document groupBy, Query.MaxProjection projection) {
                return MongoQuery.addProjectionToGroupBy(projectObject, groupBy, (Query.PropertyProjection)projection, MongoQuery.MAX_OPERATOR, "max_");
            }
        });
        groupByProjectionHandlers.put(Query.SumProjection.class, new ProjectionHandler<Query.SumProjection>(){

            @Override
            public String handle(PersistentEntity entity, Document projectObject, Document groupBy, Query.SumProjection projection) {
                return MongoQuery.addProjectionToGroupBy(projectObject, groupBy, (Query.PropertyProjection)projection, MongoQuery.SUM_OPERATOR, "sum_");
            }
        });
        projectProjectionHandlers.put(Query.DistinctPropertyProjection.class, new ProjectionHandler<Query.DistinctPropertyProjection>(){

            @Override
            public String handle(PersistentEntity entity, Document projectObject, Document groupBy, Query.DistinctPropertyProjection projection) {
                String property = projection.getPropertyName();
                projectObject.put(property, (Object)1);
                Document id = MongoQuery.getIdObjectForGroupBy(groupBy);
                id.put(property, (Object)("$" + property));
                return property;
            }
        });
        projectProjectionHandlers.put(Query.PropertyProjection.class, new ProjectionHandler<Query.PropertyProjection>(){

            @Override
            public String handle(PersistentEntity entity, Document projectObject, Document groupBy, Query.PropertyProjection projection) {
                String property = projection.getPropertyName();
                projectObject.put(property, (Object)1);
                Document id = MongoQuery.getIdObjectForGroupBy(groupBy);
                id.put(property, (Object)("$" + property));
                id.put("_id", (Object)"$_id");
                return property;
            }
        });
        projectProjectionHandlers.put(Query.IdProjection.class, new ProjectionHandler<Query.IdProjection>(){

            @Override
            public String handle(PersistentEntity entity, Document projectObject, Document groupBy, Query.IdProjection projection) {
                projectObject.put("_id", (Object)1);
                Document id = MongoQuery.getIdObjectForGroupBy(groupBy);
                id.put("_id", (Object)"$_id");
                return "_id";
            }
        });
    }

    protected static class AggregatePipeline {
        private PersistentEntity entity;
        private Document query;
        private List<Query.Projection> projectionList;
        private List<Document> aggregationPipeline;
        private List<ProjectedProperty> projectedKeys;
        private boolean singleResult;
        private final MongoQuery mongoQuery;

        public AggregatePipeline(MongoQuery mongoQuery, PersistentEntity entity, Document queryObject, List<Query.Projection> projectionList) {
            this.mongoQuery = mongoQuery;
            this.entity = entity;
            this.query = queryObject;
            this.projectionList = projectionList;
        }

        public List<Document> getAggregationPipeline() {
            return this.aggregationPipeline;
        }

        public List<ProjectedProperty> getProjectedKeys() {
            return this.projectedKeys;
        }

        public boolean isSingleResult() {
            return this.singleResult;
        }

        public AggregatePipeline build() {
            int offset;
            int max;
            List orderBy;
            this.aggregationPipeline = new ArrayList<Document>();
            if (!this.query.keySet().isEmpty()) {
                this.aggregationPipeline.add(new Document(MongoQuery.MATCH_OPERATOR, (Object)this.query));
            }
            if (!(orderBy = this.mongoQuery.getOrderBy()).isEmpty()) {
                Document sortBy = new Document();
                Document sort = new Document(MongoQuery.SORT_OPERATOR, (Object)sortBy);
                for (Query.Order order : orderBy) {
                    sortBy.put(order.getProperty(), (Object)(order.getDirection() == Query.Order.Direction.ASC ? 1 : -1));
                }
                this.aggregationPipeline.add(sort);
            }
            if ((max = this.mongoQuery.max) > 0) {
                this.aggregationPipeline.add(new Document("$limit", (Object)max));
            }
            if ((offset = this.mongoQuery.offset) > 0) {
                this.aggregationPipeline.add(new Document("$skip", (Object)offset));
            }
            this.projectedKeys = new ArrayList<ProjectedProperty>();
            this.singleResult = true;
            Document projectObject = new Document();
            Document groupByObject = new Document();
            groupByObject.put("_id", (Object)0);
            Document additionalGroupBy = null;
            for (Query.Projection projection : this.projectionList) {
                ProjectionHandler projectionHandler = (ProjectionHandler)projectProjectionHandlers.get(projection.getClass());
                ProjectedProperty projectedProperty = new ProjectedProperty();
                projectedProperty.projection = projection;
                if (projection instanceof Query.PropertyProjection) {
                    Query.PropertyProjection propertyProjection = (Query.PropertyProjection)projection;
                    String propertyName = propertyProjection.getPropertyName();
                    PersistentProperty property = this.entity.getPropertyByName(propertyName);
                    if (property != null) {
                        projectedProperty.property = property;
                    } else if (!propertyName.contains(".")) {
                        throw new InvalidDataAccessResourceUsageException("Attempt to project on a non-existent project [" + propertyName + "]");
                    }
                }
                if (projectionHandler != null) {
                    this.singleResult = false;
                    String aggregationKey = projectionHandler.handle(this.entity, projectObject, groupByObject, projection);
                    projectedProperty.projectionKey = aggregationKey = "id." + aggregationKey;
                    this.projectedKeys.add(projectedProperty);
                    continue;
                }
                projectionHandler = (ProjectionHandler)groupByProjectionHandlers.get(projection.getClass());
                if (projectionHandler == null) continue;
                projectedProperty.projectionKey = projectionHandler.handle(this.entity, projectObject, groupByObject, projection);
                this.projectedKeys.add(projectedProperty);
                if (!(projection instanceof Query.CountDistinctProjection)) continue;
                Document finalCount = new Document("_id", (Object)1);
                finalCount.put(projectedProperty.projectionKey, (Object)new Document(MongoQuery.SUM_OPERATOR, (Object)1));
                additionalGroupBy = new Document(MongoQuery.GROUP_OPERATOR, (Object)finalCount);
            }
            if (!projectObject.isEmpty()) {
                this.aggregationPipeline.add(new Document(MongoQuery.PROJECT_OPERATOR, (Object)projectObject));
            }
            this.aggregationPipeline.add(new Document(MongoQuery.GROUP_OPERATOR, (Object)groupByObject));
            if (additionalGroupBy != null) {
                this.aggregationPipeline.add(additionalGroupBy);
            }
            return this;
        }
    }

    protected static class ProjectedProperty {
        public Query.Projection projection;
        public String projectionKey;
        public PersistentProperty property;

        protected ProjectedProperty() {
        }
    }

    public static class MongoResultList
    extends AbstractResultList {
        private EntityPersister mongoEntityPersister;
        private MongoCursor cursor;
        private boolean isCodecPersister;

        public MongoResultList(MongoCursor cursor, int offset, EntityPersister mongoEntityPersister) {
            super(offset, (Iterator)cursor);
            this.cursor = cursor;
            this.mongoEntityPersister = mongoEntityPersister;
            this.isCodecPersister = mongoEntityPersister instanceof MongoCodecEntityPersister;
        }

        public void close() throws IOException {
            this.cursor.close();
        }

        public String toString() {
            this.initializeFully();
            return this.initializedObjects.toString();
        }

        public MongoCursor getCursor() {
            return this.cursor;
        }

        protected Object nextDecoded() {
            AbstractMongoSession session;
            Object o = this.cursor.next();
            if (this.isCodecPersister && !(session = (AbstractMongoSession)this.mongoEntityPersister.getSession()).contains(o)) {
                PersistentEntity entity = this.mongoEntityPersister.getPersistentEntity();
                EntityAccess entityAccess = session.createEntityAccess(entity, o);
                Object id = entityAccess.getIdentifier();
                if (id != null) {
                    session.cacheInstance(entity.getJavaClass(), (Serializable)id, o);
                }
                this.mongoEntityPersister.firePostLoadEvent(entity, entityAccess);
            }
            return o;
        }

        protected Object convertObject(Object object) {
            return this.isCodecPersister ? object : this.convertDBObject(object);
        }

        protected Object convertDBObject(Object object) {
            Class type;
            if (this.mongoEntityPersister instanceof MongoCodecEntityPersister) {
                return object;
            }
            Document dbObject = (Document)object;
            Object id = dbObject.get((Object)"_id");
            SessionImplementor session = (SessionImplementor)this.mongoEntityPersister.getSession();
            Object instance = session.getCachedInstance(type = this.mongoEntityPersister.getPersistentEntity().getJavaClass(), (Serializable)id);
            if (instance == null) {
                MongoEntityPersister mep = (MongoEntityPersister)this.mongoEntityPersister;
                instance = mep.createObjectFromNativeEntry(this.mongoEntityPersister.getPersistentEntity(), (Serializable)id, dbObject);
                session.cacheInstance(type, (Serializable)id, instance);
            }
            return instance;
        }
    }

    public static class AggregatedResultList
    extends AbstractList
    implements Closeable {
        private MongoCursor cursor;
        private List<ProjectedProperty> projectedProperties;
        private List initializedObjects = new ArrayList();
        private int internalIndex = 0;
        private boolean initialized = false;
        private boolean containsAssociations = false;
        private Session session;

        public AggregatedResultList(Session session, MongoCursor<Document> cursor, List<ProjectedProperty> projectedProperties) {
            this.cursor = cursor;
            this.projectedProperties = projectedProperties;
            this.session = session;
            for (ProjectedProperty projectedProperty : projectedProperties) {
                if (!(projectedProperty.property instanceof Association)) continue;
                this.containsAssociations = true;
                break;
            }
        }

        @Override
        public String toString() {
            return this.initializedObjects.toString();
        }

        @Override
        public Object get(int index) {
            if (this.containsAssociations) {
                this.initializeFully();
            }
            if (this.initializedObjects.size() > index) {
                return this.initializedObjects.get(index);
            }
            if (!this.initialized) {
                boolean hasResults = false;
                while (this.cursor.hasNext()) {
                    hasResults = true;
                    Document dbo = (Document)this.cursor.next();
                    Object projected = this.addInitializedObject(dbo);
                    if (index != this.internalIndex) continue;
                    return projected;
                }
                if (!hasResults) {
                    this.handleNoResults();
                }
                this.initialized = true;
            }
            throw new ArrayIndexOutOfBoundsException("Index value " + index + " exceeds size of aggregate list");
        }

        @Override
        public Object set(int index, Object element) {
            this.initializeFully();
            return this.initializedObjects.set(index, element);
        }

        @Override
        public ListIterator listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator listIterator(int index) {
            this.initializeFully();
            return this.initializedObjects.listIterator(index);
        }

        protected void initializeFully() {
            if (this.initialized) {
                return;
            }
            if (this.containsAssociations) {
                if (this.projectedProperties.size() == 1) {
                    ProjectedProperty projectedProperty = this.projectedProperties.get(0);
                    PersistentProperty property = projectedProperty.property;
                    ArrayList<Serializable> identifiers = new ArrayList<Serializable>();
                    boolean hasResults = false;
                    while (this.cursor.hasNext()) {
                        hasResults = true;
                        Document dbo = (Document)this.cursor.next();
                        Object id = this.getProjectedValue(dbo, projectedProperty.projectionKey);
                        identifiers.add((Serializable)id);
                    }
                    if (!hasResults) {
                        this.handleNoResults();
                    } else {
                        this.initializedObjects = this.session.retrieveAll(property.getType(), identifiers);
                    }
                } else {
                    Map<Integer, Map<Class, List<Serializable>>> associationMap = this.createAssociationMap();
                    boolean hasResults = false;
                    while (this.cursor.hasNext()) {
                        hasResults = true;
                        Document dbo = (Document)this.cursor.next();
                        ArrayList<Object> projectedResult = new ArrayList<Object>();
                        int index = 0;
                        for (ProjectedProperty projectedProperty : this.projectedProperties) {
                            PersistentProperty property = projectedProperty.property;
                            Object value = this.getProjectedValue(dbo, projectedProperty.projectionKey);
                            if (property instanceof Association) {
                                Map<Class, List<Serializable>> identifierMap = associationMap.get(index);
                                Class type = ((Association)property).getAssociatedEntity().getJavaClass();
                                identifierMap.get(type).add((Serializable)value);
                            }
                            projectedResult.add(value);
                            ++index;
                        }
                        this.initializedObjects.add(projectedResult);
                    }
                    if (!hasResults) {
                        this.handleNoResults();
                        return;
                    }
                    HashMap<Integer, List> finalResults = new HashMap<Integer, List>();
                    for (Integer index : associationMap.keySet()) {
                        Map<Class, List<Serializable>> associatedEntityIdentifiers = associationMap.get(index);
                        for (Class associationClass : associatedEntityIdentifiers.keySet()) {
                            List<Serializable> identifiers = associatedEntityIdentifiers.get(associationClass);
                            finalResults.put(index, this.session.retrieveAll(associationClass, identifiers));
                        }
                    }
                    for (Integer initializedObject : this.initializedObjects) {
                        List projected = (List)((Object)initializedObject);
                        for (Integer index : finalResults.keySet()) {
                            List resultsByIndex = (List)finalResults.get(index);
                            if (index < resultsByIndex.size()) {
                                projected.set(index, resultsByIndex.get(index));
                                continue;
                            }
                            projected.set(index, null);
                        }
                    }
                }
            } else {
                boolean hasResults = false;
                while (this.cursor.hasNext()) {
                    hasResults = true;
                    Document dbo = (Document)this.cursor.next();
                    this.addInitializedObject(dbo);
                }
                if (!hasResults) {
                    this.handleNoResults();
                }
            }
            this.initialized = true;
        }

        protected void handleNoResults() {
            ProjectedProperty projectedProperty = this.projectedProperties.get(0);
            if (projectedProperty.projection instanceof Query.CountProjection) {
                this.initializedObjects.add(0);
            }
        }

        private Map<Integer, Map<Class, List<Serializable>>> createAssociationMap() {
            HashMap<Integer, Map<Class, List<Serializable>>> associationMap = new HashMap();
            associationMap = DefaultGroovyMethods.withDefault(associationMap, (Closure)new Closure(this){

                public Object doCall(Object o) {
                    Map subMap = new HashMap();
                    subMap = DefaultGroovyMethods.withDefault(subMap, (Closure)new Closure((Object)this){

                        public Object doCall(Object o) {
                            return new ArrayList();
                        }
                    });
                    return subMap;
                }
            });
            return associationMap;
        }

        @Override
        public Iterator iterator() {
            if (this.initialized || this.containsAssociations || this.internalIndex > 0) {
                this.initializeFully();
                return this.initializedObjects.iterator();
            }
            if (!this.cursor.hasNext()) {
                this.handleNoResults();
                return this.initializedObjects.iterator();
            }
            return new Iterator(){

                @Override
                public boolean hasNext() {
                    boolean hasMore = AggregatedResultList.this.cursor.hasNext();
                    if (!hasMore) {
                        AggregatedResultList.this.initialized = true;
                    }
                    return hasMore;
                }

                public Object next() {
                    Document dbo = (Document)AggregatedResultList.this.cursor.next();
                    return AggregatedResultList.this.addInitializedObject(dbo);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Aggregate result list cannot be mutated.");
                }
            };
        }

        private Object addInitializedObject(Document dbo) {
            if (this.projectedProperties.size() > 1) {
                ArrayList<Object> projected = new ArrayList<Object>();
                for (ProjectedProperty projectedProperty : this.projectedProperties) {
                    Object value = this.getProjectedValue(dbo, projectedProperty.projectionKey);
                    projected.add(value);
                }
                this.initializedObjects.add(this.internalIndex, projected);
                ++this.internalIndex;
                return projected;
            }
            ProjectedProperty projectedProperty = this.projectedProperties.get(0);
            Object projected = this.getProjectedValue(dbo, projectedProperty.projectionKey);
            this.initializedObjects.add(this.internalIndex, projected);
            ++this.internalIndex;
            return projected;
        }

        private Object getProjectedValue(Document dbo, String projectionKey) {
            Object value;
            if (projectionKey.startsWith("id.")) {
                projectionKey = projectionKey.substring(3);
                Document id = (Document)dbo.get((Object)"_id");
                value = id.get((Object)projectionKey);
            } else {
                value = dbo.get((Object)projectionKey);
            }
            return value;
        }

        @Override
        public int size() {
            this.initializeFully();
            return this.initializedObjects.size();
        }

        @Override
        public void close() throws IOException {
            this.cursor.close();
        }
    }

    private static interface ProjectionHandler<T extends Query.Projection> {
        public String handle(PersistentEntity var1, Document var2, Document var3, T var4);
    }

    private static interface QueryHandler<T> {
        public void handle(EmbeddedQueryEncoder var1, T var2, Document var3, PersistentEntity var4);
    }

    public static class GeoIntersects
    extends GeoCriterion {
        public GeoIntersects(String name, Object value) {
            super(name, value);
        }
    }

    public static class GeoWithin
    extends GeoCriterion {
        public GeoWithin(String name, Object value) {
            super(name, value);
        }
    }

    public static class GeoCriterion
    extends Query.PropertyCriterion {
        public GeoCriterion(String name, Object value) {
            super(name, value);
        }
    }

    public static class WithinCircle
    extends Query.PropertyCriterion {
        public WithinCircle(String name, List value) {
            super(name, (Object)value);
        }

        public List getValues() {
            return (List)this.getValue();
        }

        public void setValue(List matrix) {
            this.value = matrix;
        }
    }

    public static class WithinPolygon
    extends Query.PropertyCriterion {
        public WithinPolygon(String name, List value) {
            super(name, (Object)value);
        }

        public List getValues() {
            return (List)this.getValue();
        }

        public void setValue(List value) {
            this.value = value;
        }
    }

    public static class WithinBox
    extends Query.PropertyCriterion {
        public WithinBox(String name, List value) {
            super(name, (Object)value);
        }

        public List getValues() {
            return (List)this.getValue();
        }

        public void setValue(List matrix) {
            this.value = matrix;
        }
    }

    public static class NearSphere
    extends Near {
        public NearSphere(String name, Object value) {
            super(name, value);
        }

        public NearSphere(String name, Object value, Distance maxDistance) {
            super(name, value, maxDistance);
        }

        public NearSphere(String name, Object value, Number maxDistance) {
            super(name, value, maxDistance);
        }
    }

    public static class Near
    extends GeoCriterion {
        Distance maxDistance = null;

        public Near(String name, Object value) {
            super(name, value);
        }

        public Near(String name, Object value, Distance maxDistance) {
            super(name, value);
            this.maxDistance = maxDistance;
        }

        public Near(String name, Object value, Number maxDistance) {
            super(name, value);
            this.maxDistance = Distance.valueOf(maxDistance.doubleValue());
        }

        public void setMaxDistance(Distance maxDistance) {
            this.maxDistance = maxDistance;
        }
    }
}

