/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bson.types.Binary;
import org.bson.types.ObjectId;
import org.grails.datastore.mapping.config.utils.ConfigUtils;
import org.grails.datastore.mapping.core.AbstractDatastore;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.core.StatelessDatastore;
import org.grails.datastore.mapping.document.config.DocumentMappingContext;
import org.grails.datastore.mapping.model.ClassMapping;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.PropertyMapping;
import org.grails.datastore.mapping.mongo.MongoSession;
import org.grails.datastore.mapping.mongo.config.MongoAttribute;
import org.grails.datastore.mapping.mongo.config.MongoCollection;
import org.grails.datastore.mapping.mongo.config.MongoMappingContext;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.convert.converter.Converter;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.authentication.UserCredentials;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.DbCallback;
import org.springframework.data.mongodb.core.MongoExceptionTranslator;
import org.springframework.data.mongodb.core.MongoTemplate;

public class MongoDatastore
extends AbstractDatastore
implements InitializingBean,
MappingContext.Listener,
DisposableBean,
StatelessDatastore {
    public static final String PASSWORD = "password";
    public static final String USERNAME = "username";
    public static final String MONGO_PORT = "port";
    public static final String MONGO_HOST = "host";
    public static final String MONGO_STATELESS = "stateless";
    public static final String INDEX_ATTRIBUTES = "indexAttributes";
    protected Mongo mongo;
    protected MongoClientOptions mongoOptions;
    protected Map<PersistentEntity, MongoTemplate> mongoTemplates = new ConcurrentHashMap<PersistentEntity, MongoTemplate>();
    protected Map<PersistentEntity, String> mongoCollections = new ConcurrentHashMap<PersistentEntity, String>();
    protected boolean stateless = false;
    protected UserCredentials userCrentials;

    public MongoDatastore() {
        this(new MongoMappingContext("test"), Collections.emptyMap(), null);
    }

    public MongoDatastore(MongoMappingContext mappingContext, Map<String, String> connectionDetails, MongoClientOptions mongoOptions, ConfigurableApplicationContext ctx) {
        this(mappingContext, connectionDetails, ctx);
        if (mongoOptions != null) {
            this.mongoOptions = mongoOptions;
        }
    }

    public MongoDatastore(MongoMappingContext mappingContext, Map<String, String> connectionDetails, ConfigurableApplicationContext ctx) {
        super((MappingContext)mappingContext, connectionDetails, ctx);
        if (mappingContext != null) {
            mappingContext.addMappingContextListener(this);
        }
        this.initializeConverters((MappingContext)mappingContext);
        mappingContext.getConverterRegistry().addConverter((Converter)new Converter<String, ObjectId>(){

            public ObjectId convert(String source) {
                return new ObjectId(source);
            }
        });
        mappingContext.getConverterRegistry().addConverter((Converter)new Converter<ObjectId, String>(){

            public String convert(ObjectId source) {
                return source.toString();
            }
        });
        mappingContext.getConverterRegistry().addConverter((Converter)new Converter<byte[], Binary>(){

            public Binary convert(byte[] source) {
                return new Binary(source);
            }
        });
        mappingContext.getConverterRegistry().addConverter((Converter)new Converter<Binary, byte[]>(){

            public byte[] convert(Binary source) {
                return source.getData();
            }
        });
    }

    public MongoDatastore(MongoMappingContext mappingContext) {
        this(mappingContext, Collections.emptyMap(), null);
    }

    public MongoDatastore(MongoMappingContext mappingContext, Mongo mongo, ConfigurableApplicationContext ctx) {
        this(mappingContext, Collections.emptyMap(), ctx);
        this.mongo = mongo;
    }

    public MongoDatastore(MongoMappingContext mappingContext, Mongo mongo, Map<String, String> connectionDetails, ConfigurableApplicationContext ctx) {
        this(mappingContext, connectionDetails, ctx);
        this.mongo = mongo;
    }

    public Mongo getMongo() {
        return this.mongo;
    }

    public MongoTemplate getMongoTemplate(PersistentEntity entity) {
        return this.mongoTemplates.get(entity);
    }

    public String getCollectionName(PersistentEntity entity) {
        return this.mongoCollections.get(entity);
    }

    public UserCredentials getUserCrentials() {
        return this.userCrentials;
    }

    protected Session createSession(Map<String, String> connDetails) {
        if (this.stateless) {
            return this.createStatelessSession(this.connectionDetails);
        }
        return new MongoSession(this, this.getMappingContext(), this.getApplicationEventPublisher(), false);
    }

    protected Session createStatelessSession(Map<String, String> connectionDetails) {
        return new MongoSession(this, this.getMappingContext(), this.getApplicationEventPublisher(), true);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.mongo == null) {
            ServerAddress defaults = new ServerAddress();
            String username = (String)ConfigUtils.read(String.class, (String)USERNAME, (Map)this.connectionDetails, null);
            String password = (String)ConfigUtils.read(String.class, (String)PASSWORD, (Map)this.connectionDetails, null);
            DocumentMappingContext dc = (DocumentMappingContext)this.getMappingContext();
            String databaseName = dc.getDefaultDatabaseName();
            ArrayList<MongoCredential> credentials = new ArrayList<MongoCredential>();
            if (username != null && password != null) {
                credentials.add(MongoCredential.createCredential((String)username, (String)databaseName, (char[])password.toCharArray()));
            }
            ServerAddress serverAddress = new ServerAddress((String)ConfigUtils.read(String.class, (String)MONGO_HOST, (Map)this.connectionDetails, (Object)defaults.getHost()), ((Integer)ConfigUtils.read(Integer.class, (String)MONGO_PORT, (Map)this.connectionDetails, (Object)defaults.getPort())).intValue());
            this.stateless = (Boolean)ConfigUtils.read(Boolean.class, (String)MONGO_STATELESS, (Map)this.connectionDetails, (Object)false);
            this.mongo = this.mongoOptions != null ? new MongoClient(serverAddress, credentials, this.mongoOptions) : new MongoClient(serverAddress, credentials);
        }
        for (PersistentEntity entity : this.mappingContext.getPersistentEntities()) {
            if (entity.isExternal()) continue;
            this.createMongoTemplate(entity, this.mongo);
        }
    }

    protected void createMongoTemplate(PersistentEntity entity, final Mongo mongoInstance) {
        WriteConcern writeConcern;
        MongoCollection mongoCollection;
        DocumentMappingContext dc = (DocumentMappingContext)this.getMappingContext();
        String collectionName = entity.getDecapitalizedName();
        String databaseName = dc.getDefaultDatabaseName();
        ClassMapping mapping = entity.getMapping();
        MongoCollection mongoCollection2 = mongoCollection = mapping.getMappedForm() != null ? (MongoCollection)mapping.getMappedForm() : null;
        if (mongoCollection != null) {
            if (mongoCollection.getCollection() != null) {
                collectionName = mongoCollection.getCollection();
            }
            if (mongoCollection.getDatabase() != null) {
                databaseName = mongoCollection.getDatabase();
            }
        }
        final String finalDatabaseName = databaseName;
        final MongoExceptionTranslator mongoExceptionTranslator = new MongoExceptionTranslator();
        MongoTemplate mt = new MongoTemplate(new MongoDbFactory(){

            public DB getDb() throws DataAccessException {
                return mongoInstance.getDB(finalDatabaseName);
            }

            public DB getDb(String dbName) throws DataAccessException {
                return mongoInstance.getDB(dbName);
            }

            public PersistenceExceptionTranslator getExceptionTranslator() {
                return mongoExceptionTranslator;
            }
        });
        if (mongoCollection != null && (writeConcern = mongoCollection.getWriteConcern()) != null) {
            final String collectionNameToUse = collectionName;
            mt.executeInSession((DbCallback)new DbCallback<Object>(){

                public Object doInDB(DB db) throws MongoException, DataAccessException {
                    DBCollection collection = db.getCollection(collectionNameToUse);
                    collection.setWriteConcern(writeConcern);
                    return null;
                }
            });
        }
        this.mongoTemplates.put(entity, mt);
        this.mongoCollections.put(entity, collectionName);
        this.initializeIndices(entity, mt);
    }

    protected void initializeIndices(final PersistentEntity entity, MongoTemplate template) {
        template.execute((DbCallback)new DbCallback<Object>(){

            public Object doInDB(DB db) throws MongoException, DataAccessException {
                MongoCollection mappedForm;
                DBCollection collection = db.getCollection(MongoDatastore.this.getCollectionName(entity));
                ClassMapping classMapping = entity.getMapping();
                if (classMapping != null && (mappedForm = (MongoCollection)classMapping.getMappedForm()) != null) {
                    List<MongoCollection.Index> indices = mappedForm.getIndices();
                    for (MongoCollection.Index index : indices) {
                        collection.createIndex((DBObject)new BasicDBObject(index.getDefinition()), (DBObject)new BasicDBObject(index.getOptions()));
                    }
                    for (Map compoundIndex : mappedForm.getCompoundIndices()) {
                        Object o;
                        Map indexAttributes = null;
                        if (compoundIndex.containsKey(MongoDatastore.INDEX_ATTRIBUTES) && (o = compoundIndex.remove(MongoDatastore.INDEX_ATTRIBUTES)) instanceof Map) {
                            indexAttributes = (Map)o;
                        }
                        BasicDBObject indexDef = new BasicDBObject(compoundIndex);
                        if (indexAttributes != null) {
                            collection.createIndex((DBObject)indexDef, (DBObject)new BasicDBObject(indexAttributes));
                            continue;
                        }
                        collection.createIndex((DBObject)indexDef);
                    }
                }
                for (PersistentProperty property : entity.getPersistentProperties()) {
                    HashMap attributes;
                    boolean indexed = MongoDatastore.this.isIndexed(property);
                    if (!indexed) continue;
                    MongoAttribute mongoAttributeMapping = (MongoAttribute)property.getMapping().getMappedForm();
                    BasicDBObject dbObject = new BasicDBObject();
                    String fieldName = this.getMongoFieldNameForProperty((PersistentProperty<MongoAttribute>)property);
                    dbObject.put(fieldName, (Object)1);
                    BasicDBObject options = new BasicDBObject();
                    if (mongoAttributeMapping != null && (attributes = mongoAttributeMapping.getIndexAttributes()) != null) {
                        if ((attributes = new HashMap(attributes)).containsKey("type")) {
                            dbObject.put(fieldName, attributes.remove("type"));
                        }
                        options.putAll(attributes);
                    }
                    if (options.toMap().isEmpty()) {
                        collection.createIndex((DBObject)dbObject);
                        continue;
                    }
                    collection.createIndex((DBObject)dbObject, (DBObject)options);
                }
                return null;
            }

            String getMongoFieldNameForProperty(PersistentProperty<MongoAttribute> property) {
                PropertyMapping pm = property.getMapping();
                String propKey = null;
                if (pm.getMappedForm() != null) {
                    propKey = ((MongoAttribute)pm.getMappedForm()).getField();
                }
                if (propKey == null) {
                    propKey = property.getName();
                }
                return propKey;
            }
        });
    }

    public void persistentEntityAdded(PersistentEntity entity) {
        this.createMongoTemplate(entity, this.mongo);
    }

    public void destroy() throws Exception {
        super.destroy();
        if (this.mongo != null) {
            this.mongo.close();
        }
    }

    public boolean isSchemaless() {
        return true;
    }
}

