/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.mongo.query;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import grails.mongodb.geo.Box;
import grails.mongodb.geo.Circle;
import grails.mongodb.geo.Distance;
import grails.mongodb.geo.GeoJSON;
import grails.mongodb.geo.Point;
import grails.mongodb.geo.Polygon;
import grails.mongodb.geo.Shape;
import grails.mongodb.geo.Sphere;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.bson.BasicBSONObject;
import org.grails.datastore.gorm.mongo.geo.GeoJSONType;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.core.SessionImplementor;
import org.grails.datastore.mapping.engine.EntityAccess;
import org.grails.datastore.mapping.engine.internal.MappingUtils;
import org.grails.datastore.mapping.engine.types.CustomTypeMarshaller;
import org.grails.datastore.mapping.model.EmbeddedPersistentEntity;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.types.Association;
import org.grails.datastore.mapping.model.types.Custom;
import org.grails.datastore.mapping.model.types.Embedded;
import org.grails.datastore.mapping.model.types.EmbeddedCollection;
import org.grails.datastore.mapping.model.types.ToOne;
import org.grails.datastore.mapping.mongo.MongoSession;
import org.grails.datastore.mapping.mongo.config.MongoAttribute;
import org.grails.datastore.mapping.mongo.config.MongoCollection;
import org.grails.datastore.mapping.mongo.engine.MongoEntityPersister;
import org.grails.datastore.mapping.query.AssociationQuery;
import org.grails.datastore.mapping.query.Query;
import org.grails.datastore.mapping.query.Restrictions;
import org.grails.datastore.mapping.query.api.QueryArgumentsAware;
import org.grails.datastore.mapping.query.projections.ManualProjections;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.data.mongodb.core.DbCallback;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.StringUtils;

public class MongoQuery
extends Query
implements QueryArgumentsAware {
    private static Map<Class, QueryHandler> queryHandlers = new HashMap<Class, QueryHandler>();
    private static Map<Class, QueryHandler> negatedHandlers = new HashMap<Class, QueryHandler>();
    public static final String MONGO_IN_OPERATOR = "$in";
    public static final String MONGO_OR_OPERATOR = "$or";
    public static final String MONGO_AND_OPERATOR = "$and";
    public static final String MONGO_GTE_OPERATOR = "$gte";
    public static final String MONGO_LTE_OPERATOR = "$lte";
    public static final String MONGO_GT_OPERATOR = "$gt";
    public static final String MONGO_LT_OPERATOR = "$lt";
    public static final String MONGO_NE_OPERATOR = "$ne";
    public static final String MONGO_NIN_OPERATOR = "$nin";
    public static final String MONGO_ID_REFERENCE_SUFFIX = ".$id";
    public static final String MONGO_WHERE_OPERATOR = "$where";
    private static final String MONGO_THIS_PREFIX = "this.";
    public static final String HINT_ARGUMENT = "hint";
    private Map queryArguments = Collections.emptyMap();
    public static final String NEAR_OPERATOR = "$near";
    public static final String BOX_OPERATOR = "$box";
    public static final String POLYGON_OPERATOR = "$polygon";
    public static final String WITHIN_OPERATOR = "$within";
    public static final String CENTER_OPERATOR = "$center";
    public static final String GEO_WITHIN_OPERATOR = "$geoWithin";
    public static final String GEOMETRY_OPERATOR = "$geometry";
    public static final String CENTER_SPHERE_OPERATOR = "$centerSphere";
    public static final String GEO_INTERSECTS_OPERATOR = "$geoIntersects";
    public static final String MAX_DISTANCE_OPERATOR = "$maxDistance";
    public static final String NEAR_SPHERE_OPERATOR = "$nearSphere";
    public static final String MONGO_REGEX_OPERATOR = "$regex";
    private MongoSession mongoSession;
    private MongoEntityPersister mongoEntityPersister;
    private ManualProjections manualProjections;

    private static DBObject getOrCreatePropertyQuery(DBObject query, String propertyName) {
        DBObject queryObject;
        Object existing = query.get(propertyName);
        DBObject dBObject = queryObject = existing instanceof DBObject ? (DBObject)existing : null;
        if (queryObject == null) {
            queryObject = new BasicDBObject();
        }
        return queryObject;
    }

    private static void addWherePropertyComparison(DBObject query, String propertyName, String otherPropertyName, String operator) {
        query.put(MONGO_WHERE_OPERATOR, (Object)(MONGO_THIS_PREFIX + propertyName + operator + MONGO_THIS_PREFIX + otherPropertyName));
    }

    private static List<Object> getInListQueryValues(PersistentEntity entity, Query.In in) {
        ArrayList<Object> values = new ArrayList<Object>(in.getValues().size());
        for (Object value : in.getValues()) {
            if (entity.getMappingContext().isPersistentEntity(value)) {
                PersistentEntity pe = entity.getMappingContext().getPersistentEntity(value.getClass().getName());
                values.add(new EntityAccess(pe, value).getIdentifier());
                continue;
            }
            value = MongoEntityPersister.getSimpleNativePropertyValue(value, entity.getMappingContext());
            values.add(value);
        }
        return values;
    }

    private static void handleLike(PersistentEntity entity, Query.Like like, DBObject query, boolean caseSensitive) {
        Object value = like.getValue();
        if (value == null) {
            value = "null";
        }
        Object[] array = value.toString().split("%", -1);
        for (int i = 0; i < array.length; ++i) {
            array[i] = Pattern.quote((String)array[i]);
        }
        String expr = StringUtils.arrayToDelimitedString((Object[])array, (String)".*");
        if (!expr.startsWith(".*")) {
            expr = '^' + expr;
        }
        if (!expr.endsWith(".*")) {
            expr = expr + '$';
        }
        Pattern regex = caseSensitive ? Pattern.compile(expr) : Pattern.compile(expr, 2);
        String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)like);
        query.put(propertyName, (Object)regex);
    }

    public MongoQuery(MongoSession session, PersistentEntity entity) {
        super((Session)session, entity);
        this.mongoSession = session;
        this.manualProjections = new ManualProjections(entity);
        this.mongoEntityPersister = (MongoEntityPersister)session.getPersister(entity);
    }

    protected void flushBeforeQuery() {
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            super.flushBeforeQuery();
        }
    }

    public DBObject getMongoQuery() {
        DBObject query = this.createQueryObject(this.entity);
        MongoQuery.populateMongoQuery(this.entity, query, this.criteria);
        return query;
    }

    protected List executeQuery(final PersistentEntity entity, final Query.Junction criteria) {
        MongoTemplate template = this.mongoSession.getMongoTemplate(entity);
        return (List)template.execute((DbCallback)new DbCallback<List>(){

            public List doInDB(DB db) throws MongoException, DataAccessException {
                DBCollection collection = db.getCollection(MongoQuery.this.mongoEntityPersister.getCollectionName(entity));
                if (MongoQuery.this.uniqueResult) {
                    DBObject dbObject = criteria.isEmpty() ? (entity.isRoot() ? collection.findOne() : collection.findOne((DBObject)new BasicDBObject("_class", (Object)entity.getDiscriminator()))) : collection.findOne(MongoQuery.this.getMongoQuery());
                    return MongoQuery.this.wrapObjectResultInList(MongoQuery.this.createObjectFromDBObject(dbObject));
                }
                DBCursor cursor = null;
                DBObject query = MongoQuery.this.createQueryObject(entity);
                List projectionList = MongoQuery.this.projections().getProjectionList();
                if (projectionList.isEmpty()) {
                    cursor = this.executeQuery(entity, criteria, collection, query);
                    return (List)new MongoResultList(cursor, MongoQuery.this.offset, MongoQuery.this.mongoEntityPersister).clone();
                }
                ArrayList<Object> projectedResults = new ArrayList<Object>();
                for (Query.Projection projection : projectionList) {
                    String propertyName;
                    PersistentProperty persistentProperty;
                    MongoResultList results;
                    if (projection instanceof Query.CountProjection) {
                        if (cursor == null) {
                            cursor = this.executeQuery(entity, criteria, collection, query);
                        }
                        projectedResults.add(cursor.size());
                        continue;
                    }
                    if (projection instanceof Query.MinProjection) {
                        if (cursor == null) {
                            cursor = this.executeQuery(entity, criteria, collection, query);
                        }
                        Query.MinProjection mp = (Query.MinProjection)projection;
                        results = new MongoResultList(cursor, MongoQuery.this.offset, MongoQuery.this.mongoEntityPersister);
                        projectedResults.add(MongoQuery.this.manualProjections.min((Collection)results.clone(), MongoQuery.getPropertyName(entity, mp.getPropertyName())));
                        continue;
                    }
                    if (projection instanceof Query.MaxProjection) {
                        if (cursor == null) {
                            cursor = this.executeQuery(entity, criteria, collection, query);
                        }
                        Query.MaxProjection mp = (Query.MaxProjection)projection;
                        results = new MongoResultList(cursor, MongoQuery.this.offset, MongoQuery.this.mongoEntityPersister);
                        projectedResults.add(MongoQuery.this.manualProjections.max((Collection)results.clone(), MongoQuery.getPropertyName(entity, mp.getPropertyName())));
                        continue;
                    }
                    if (projection instanceof Query.CountDistinctProjection) {
                        if (cursor == null) {
                            cursor = this.executeQuery(entity, criteria, collection, query);
                        }
                        Query.CountDistinctProjection mp = (Query.CountDistinctProjection)projection;
                        results = new MongoResultList(cursor, MongoQuery.this.offset, MongoQuery.this.mongoEntityPersister);
                        projectedResults.add(MongoQuery.this.manualProjections.countDistinct((Collection)results.clone(), MongoQuery.getPropertyName(entity, mp.getPropertyName())));
                        continue;
                    }
                    if (!(projection instanceof Query.DistinctPropertyProjection) && !(projection instanceof Query.PropertyProjection) && !(projection instanceof Query.IdProjection)) continue;
                    boolean distinct = projection instanceof Query.DistinctPropertyProjection;
                    if (projection instanceof Query.IdProjection) {
                        persistentProperty = entity.getIdentity();
                        propertyName = "_id";
                    } else {
                        Query.PropertyProjection pp = (Query.PropertyProjection)projection;
                        persistentProperty = entity.getPropertyByName(pp.getPropertyName());
                        propertyName = MongoQuery.getPropertyName(entity, persistentProperty.getName());
                    }
                    if (persistentProperty != null) {
                        MongoQuery.populateMongoQuery(entity, query, criteria);
                        List<Object> propertyResults = null;
                        if (MongoQuery.this.max > -1) {
                            cursor = this.executeQueryAndApplyPagination(collection, query);
                            propertyResults = distinct ? new ArrayList(MongoQuery.this.manualProjections.distinct((Collection)new MongoResultList(cursor, MongoQuery.this.offset, MongoQuery.this.mongoEntityPersister), propertyName)) : MongoQuery.this.manualProjections.property((Collection)new MongoResultList(cursor, MongoQuery.this.offset, MongoQuery.this.mongoEntityPersister), propertyName);
                        } else if (distinct || projection instanceof Query.IdProjection) {
                            propertyResults = collection.distinct(propertyName, query);
                        } else {
                            DBCursor propertyCursor = collection.find(query, (DBObject)new BasicDBObject(propertyName, (Object)1));
                            ArrayList<Object> projectedProperties = new ArrayList<Object>();
                            while (propertyCursor.hasNext()) {
                                DBObject dbo = propertyCursor.next();
                                projectedProperties.add(dbo.get(propertyName));
                            }
                            propertyResults = projectedProperties;
                        }
                        if (persistentProperty instanceof ToOne) {
                            Association a = (Association)persistentProperty;
                            propertyResults = MongoQuery.this.session.retrieveAll(a.getAssociatedEntity().getJavaClass(), (Iterable)propertyResults);
                        }
                        if (projectedResults.size() == 0 && projectionList.size() == 1) {
                            return propertyResults;
                        }
                        projectedResults.add(propertyResults);
                        continue;
                    }
                    throw new InvalidDataAccessResourceUsageException("Cannot use [" + projection.getClass().getSimpleName() + "] projection on non-existent property: " + propertyName);
                }
                return projectedResults;
            }

            protected DBCursor executeQuery(PersistentEntity entity2, Query.Junction criteria2, DBCollection collection, DBObject query) {
                DBCursor cursor;
                if (criteria2.isEmpty()) {
                    cursor = this.executeQueryAndApplyPagination(collection, query);
                } else {
                    MongoQuery.populateMongoQuery(entity2, query, criteria2);
                    cursor = this.executeQueryAndApplyPagination(collection, query);
                }
                if (MongoQuery.this.queryArguments != null && MongoQuery.this.queryArguments.containsKey(MongoQuery.HINT_ARGUMENT)) {
                    Object hint = MongoQuery.this.queryArguments.get(MongoQuery.HINT_ARGUMENT);
                    if (hint instanceof Map) {
                        cursor.hint((DBObject)new BasicDBObject((Map)hint));
                    } else if (hint != null) {
                        cursor.hint(hint.toString());
                    }
                }
                return cursor;
            }

            protected DBCursor executeQueryAndApplyPagination(DBCollection collection, DBObject query) {
                DBCursor cursor = collection.find(query);
                if (MongoQuery.this.offset > 0) {
                    cursor.skip(MongoQuery.this.offset);
                }
                if (MongoQuery.this.max > -1) {
                    cursor.limit(MongoQuery.this.max);
                }
                if (!MongoQuery.this.orderBy.isEmpty()) {
                    BasicDBObject orderObject = new BasicDBObject();
                    for (Query.Order order : MongoQuery.this.orderBy) {
                        String property = order.getProperty();
                        property = MongoQuery.getPropertyName(entity, property);
                        orderObject.put(property, (Object)(order.getDirection() == Query.Order.Direction.DESC ? -1 : 1));
                    }
                    cursor.sort((DBObject)orderObject);
                } else {
                    MongoCollection coll = (MongoCollection)entity.getMapping().getMappedForm();
                    if (coll != null && coll.getSort() != null) {
                        BasicDBObject orderObject = new BasicDBObject();
                        Query.Order order = coll.getSort();
                        String property = order.getProperty();
                        property = MongoQuery.getPropertyName(entity, property);
                        orderObject.put(property, (Object)(order.getDirection() == Query.Order.Direction.DESC ? -1 : 1));
                        cursor.sort((DBObject)orderObject);
                    }
                }
                return cursor;
            }
        });
    }

    private DBObject createQueryObject(PersistentEntity persistentEntity) {
        BasicDBObject query = persistentEntity.isRoot() ? new BasicDBObject() : new BasicDBObject("_class", (Object)persistentEntity.getDiscriminator());
        return query;
    }

    public static void populateMongoQuery(PersistentEntity entity, DBObject query, Query.Junction criteria) {
        ArrayList<DBObject> subList = null;
        if (criteria.getCriteria().size() > 1) {
            if (criteria instanceof Query.Disjunction) {
                subList = new ArrayList<DBObject>();
                query.put(MONGO_OR_OPERATOR, subList);
            } else if (criteria instanceof Query.Conjunction) {
                subList = new ArrayList();
                query.put(MONGO_AND_OPERATOR, subList);
            }
        }
        for (Query.Criterion criterion : criteria.getCriteria()) {
            QueryHandler queryHandler = queryHandlers.get(criterion.getClass());
            if (queryHandler != null) {
                Query.PropertyCriterion pc;
                PersistentProperty property;
                DBObject dbo = query;
                if (subList != null) {
                    dbo = new BasicDBObject();
                    subList.add(dbo);
                }
                if (criterion instanceof Query.PropertyCriterion && !(criterion instanceof GeoCriterion) && (property = entity.getPropertyByName((pc = (Query.PropertyCriterion)criterion).getProperty())) instanceof Custom) {
                    CustomTypeMarshaller customTypeMarshaller = ((Custom)property).getCustomTypeMarshaller();
                    customTypeMarshaller.query(property, pc, (Object)query);
                    continue;
                }
                queryHandler.handle(entity, criterion, dbo);
                continue;
            }
            throw new InvalidDataAccessResourceUsageException("Queries of type " + criterion.getClass().getSimpleName() + " are not supported by this implementation");
        }
    }

    protected static String getPropertyName(PersistentEntity entity, Query.PropertyNameCriterion criterion) {
        String propertyName = criterion.getProperty();
        return MongoQuery.getPropertyName(entity, propertyName);
    }

    private static String getPropertyName(PersistentEntity entity, String propertyName) {
        if (entity.isIdentityName(propertyName)) {
            propertyName = "_id";
        } else {
            PersistentProperty property = entity.getPropertyByName(propertyName);
            if (property != null) {
                propertyName = MappingUtils.getTargetKey((PersistentProperty)property);
                if (property instanceof ToOne && !(property instanceof Embedded)) {
                    boolean isReference;
                    ToOne association = (ToOne)property;
                    MongoAttribute attr = (MongoAttribute)association.getMapping().getMappedForm();
                    boolean bl = isReference = attr == null || attr.isReference();
                    if (isReference) {
                        propertyName = propertyName + MONGO_ID_REFERENCE_SUFFIX;
                    }
                }
            }
        }
        return propertyName;
    }

    private Object createObjectFromDBObject(DBObject dbObject) {
        Object id = dbObject.get("_id");
        Class type = this.mongoEntityPersister.getPersistentEntity().getJavaClass();
        Object instance = this.mongoSession.getCachedInstance(type, (Serializable)id);
        if (instance == null) {
            instance = this.mongoEntityPersister.createObjectFromNativeEntry(this.mongoEntityPersister.getPersistentEntity(), (Serializable)id, dbObject);
            this.mongoSession.cacheInstance(type, (Serializable)id, instance);
        }
        return instance;
    }

    private List wrapObjectResultInList(Object object) {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(object);
        return result;
    }

    public Query near(String property, List value) {
        this.add((Query.Criterion)new Near(property, value));
        return this;
    }

    public Query near(String property, Point value) {
        this.add((Query.Criterion)new Near(property, value));
        return this;
    }

    public Query near(String property, List value, Distance maxDistance) {
        this.add((Query.Criterion)new Near(property, (Object)value, maxDistance));
        return this;
    }

    public Query near(String property, Point value, Distance maxDistance) {
        this.add((Query.Criterion)new Near(property, (Object)value, maxDistance));
        return this;
    }

    public Query near(String property, List value, Number maxDistance) {
        this.add((Query.Criterion)new Near(property, (Object)value, maxDistance));
        return this;
    }

    public Query near(String property, Point value, Number maxDistance) {
        this.add((Query.Criterion)new Near(property, (Object)value, maxDistance));
        return this;
    }

    public Query nearSphere(String property, List value) {
        this.add((Query.Criterion)new NearSphere(property, value));
        return this;
    }

    public Query nearSphere(String property, Point value) {
        this.add((Query.Criterion)new NearSphere(property, value));
        return this;
    }

    public Query nearSphere(String property, List value, Distance maxDistance) {
        this.add((Query.Criterion)new NearSphere(property, (Object)value, maxDistance));
        return this;
    }

    public Query nearSphere(String property, Point value, Distance maxDistance) {
        this.add((Query.Criterion)new NearSphere(property, (Object)value, maxDistance));
        return this;
    }

    public Query nearSphere(String property, List value, Number maxDistance) {
        this.add((Query.Criterion)new NearSphere(property, (Object)value, maxDistance));
        return this;
    }

    public Query nearSphere(String property, Point value, Number maxDistance) {
        this.add((Query.Criterion)new NearSphere(property, (Object)value, maxDistance));
        return this;
    }

    public Query withinBox(String property, List value) {
        this.add((Query.Criterion)new WithinBox(property, value));
        return this;
    }

    public Query geoWithin(String property, Shape shape) {
        this.add((Query.Criterion)new GeoWithin(property, shape));
        return this;
    }

    public Query geoIntersects(String property, GeoJSON shape) {
        this.add((Query.Criterion)new GeoIntersects(property, shape));
        return this;
    }

    public Query withinPolygon(String property, List value) {
        this.add((Query.Criterion)new WithinPolygon(property, value));
        return this;
    }

    public Query withinCircle(String property, List value) {
        this.add((Query.Criterion)new WithinBox(property, value));
        return this;
    }

    public void setArguments(Map arguments) {
        this.queryArguments = arguments;
    }

    static {
        queryHandlers.put(Query.IdEquals.class, new QueryHandler<Query.IdEquals>(){

            @Override
            public void handle(PersistentEntity entity, Query.IdEquals criterion, DBObject query) {
                query.put("_id", criterion.getValue());
            }
        });
        queryHandlers.put(AssociationQuery.class, new QueryHandler<AssociationQuery>(){

            @Override
            public void handle(PersistentEntity entity, AssociationQuery criterion, DBObject query) {
                Association association = criterion.getAssociation();
                PersistentEntity associatedEntity = association.getAssociatedEntity();
                if (association instanceof EmbeddedCollection) {
                    BasicDBObject associationCollectionQuery = new BasicDBObject();
                    MongoQuery.populateMongoQuery(associatedEntity, (DBObject)associationCollectionQuery, criterion.getCriteria());
                    BasicDBObject collectionQuery = new BasicDBObject("$elemMatch", (Object)associationCollectionQuery);
                    String propertyKey = MongoQuery.getPropertyName(entity, association.getName());
                    query.put(propertyKey, (Object)collectionQuery);
                } else if (associatedEntity instanceof EmbeddedPersistentEntity || association instanceof Embedded) {
                    BasicDBObject associatedEntityQuery = new BasicDBObject();
                    MongoQuery.populateMongoQuery(associatedEntity, (DBObject)associatedEntityQuery, criterion.getCriteria());
                    for (String property : associatedEntityQuery.keySet()) {
                        String propertyKey = MongoQuery.getPropertyName(entity, association.getName());
                        query.put(propertyKey + '.' + property, associatedEntityQuery.get(property));
                    }
                } else {
                    throw new UnsupportedOperationException("Join queries are not supported by MongoDB");
                }
            }
        });
        queryHandlers.put(Query.Equals.class, new QueryHandler<Query.Equals>(){

            @Override
            public void handle(PersistentEntity entity, Query.Equals criterion, DBObject query) {
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                Object value = criterion.getValue();
                if (value instanceof Pattern) {
                    Pattern pattern = (Pattern)value;
                    query.put(propertyName, (Object)new BasicDBObject(MongoQuery.MONGO_REGEX_OPERATOR, (Object)pattern.toString()));
                } else {
                    MongoEntityPersister.setDBObjectValue(query, propertyName, value, entity.getMappingContext());
                }
            }
        });
        queryHandlers.put(Query.IsNull.class, new QueryHandler<Query.IsNull>(){

            @Override
            public void handle(PersistentEntity entity, Query.IsNull criterion, DBObject query) {
                ((QueryHandler)queryHandlers.get(Query.Equals.class)).handle(entity, new Query.Equals(criterion.getProperty(), null), query);
            }
        });
        queryHandlers.put(Query.IsNotNull.class, new QueryHandler<Query.IsNotNull>(){

            @Override
            public void handle(PersistentEntity entity, Query.IsNotNull criterion, DBObject query) {
                ((QueryHandler)queryHandlers.get(Query.NotEquals.class)).handle(entity, new Query.NotEquals(criterion.getProperty(), null), query);
            }
        });
        queryHandlers.put(Query.EqualsProperty.class, new QueryHandler<Query.EqualsProperty>(){

            @Override
            public void handle(PersistentEntity entity, Query.EqualsProperty criterion, DBObject query) {
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                String otherPropertyName = MongoQuery.getPropertyName(entity, criterion.getOtherProperty());
                MongoQuery.addWherePropertyComparison(query, propertyName, otherPropertyName, "==");
            }
        });
        queryHandlers.put(Query.NotEqualsProperty.class, new QueryHandler<Query.NotEqualsProperty>(){

            @Override
            public void handle(PersistentEntity entity, Query.NotEqualsProperty criterion, DBObject query) {
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                String otherPropertyName = MongoQuery.getPropertyName(entity, criterion.getOtherProperty());
                MongoQuery.addWherePropertyComparison(query, propertyName, otherPropertyName, "!=");
            }
        });
        queryHandlers.put(Query.GreaterThanProperty.class, new QueryHandler<Query.GreaterThanProperty>(){

            @Override
            public void handle(PersistentEntity entity, Query.GreaterThanProperty criterion, DBObject query) {
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                String otherPropertyName = MongoQuery.getPropertyName(entity, criterion.getOtherProperty());
                MongoQuery.addWherePropertyComparison(query, propertyName, otherPropertyName, ">");
            }
        });
        queryHandlers.put(Query.LessThanProperty.class, new QueryHandler<Query.LessThanProperty>(){

            @Override
            public void handle(PersistentEntity entity, Query.LessThanProperty criterion, DBObject query) {
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                String otherPropertyName = MongoQuery.getPropertyName(entity, criterion.getOtherProperty());
                MongoQuery.addWherePropertyComparison(query, propertyName, otherPropertyName, "<");
            }
        });
        queryHandlers.put(Query.GreaterThanEqualsProperty.class, new QueryHandler<Query.GreaterThanEqualsProperty>(){

            @Override
            public void handle(PersistentEntity entity, Query.GreaterThanEqualsProperty criterion, DBObject query) {
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                String otherPropertyName = MongoQuery.getPropertyName(entity, criterion.getOtherProperty());
                MongoQuery.addWherePropertyComparison(query, propertyName, otherPropertyName, ">=");
            }
        });
        queryHandlers.put(Query.LessThanEqualsProperty.class, new QueryHandler<Query.LessThanEqualsProperty>(){

            @Override
            public void handle(PersistentEntity entity, Query.LessThanEqualsProperty criterion, DBObject query) {
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                String otherPropertyName = MongoQuery.getPropertyName(entity, criterion.getOtherProperty());
                MongoQuery.addWherePropertyComparison(query, propertyName, otherPropertyName, "<=");
            }
        });
        queryHandlers.put(Query.NotEquals.class, new QueryHandler<Query.NotEquals>(){

            @Override
            public void handle(PersistentEntity entity, Query.NotEquals criterion, DBObject query) {
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                DBObject notEqualQuery = MongoQuery.getOrCreatePropertyQuery(query, propertyName);
                MongoEntityPersister.setDBObjectValue(notEqualQuery, MongoQuery.MONGO_NE_OPERATOR, criterion.getValue(), entity.getMappingContext());
                query.put(propertyName, (Object)notEqualQuery);
            }
        });
        queryHandlers.put(Query.Like.class, new QueryHandler<Query.Like>(){

            @Override
            public void handle(PersistentEntity entity, Query.Like like, DBObject query) {
                MongoQuery.handleLike(entity, like, query, true);
            }
        });
        queryHandlers.put(Query.ILike.class, new QueryHandler<Query.ILike>(){

            @Override
            public void handle(PersistentEntity entity, Query.ILike like, DBObject query) {
                MongoQuery.handleLike(entity, (Query.Like)like, query, false);
            }
        });
        queryHandlers.put(Query.RLike.class, new QueryHandler<Query.RLike>(){

            @Override
            public void handle(PersistentEntity entity, Query.RLike like, DBObject query) {
                Object value = like.getValue();
                if (value == null) {
                    value = "null";
                }
                String expr = value.toString();
                Pattern regex = Pattern.compile(expr);
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)like);
                query.put(propertyName, (Object)regex);
            }
        });
        queryHandlers.put(Query.In.class, new QueryHandler<Query.In>(){

            @Override
            public void handle(PersistentEntity entity, Query.In in, DBObject query) {
                BasicDBObject inQuery = new BasicDBObject();
                List values = MongoQuery.getInListQueryValues(entity, in);
                inQuery.put(MongoQuery.MONGO_IN_OPERATOR, (Object)values);
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)in);
                query.put(propertyName, (Object)inQuery);
            }
        });
        queryHandlers.put(WithinBox.class, new QueryHandler<WithinBox>(){

            @Override
            public void handle(PersistentEntity entity, WithinBox withinBox, DBObject query) {
                BasicDBObject nearQuery = new BasicDBObject();
                BasicDBObject box = new BasicDBObject();
                MongoEntityPersister.setDBObjectValue((DBObject)box, MongoQuery.BOX_OPERATOR, withinBox.getValues(), entity.getMappingContext());
                nearQuery.put(MongoQuery.WITHIN_OPERATOR, (Object)box);
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)withinBox);
                query.put(propertyName, (Object)nearQuery);
            }
        });
        queryHandlers.put(WithinPolygon.class, new QueryHandler<WithinPolygon>(){

            @Override
            public void handle(PersistentEntity entity, WithinPolygon withinPolygon, DBObject query) {
                BasicDBObject nearQuery = new BasicDBObject();
                BasicDBObject box = new BasicDBObject();
                MongoEntityPersister.setDBObjectValue((DBObject)box, MongoQuery.POLYGON_OPERATOR, withinPolygon.getValues(), entity.getMappingContext());
                nearQuery.put(MongoQuery.WITHIN_OPERATOR, (Object)box);
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)withinPolygon);
                query.put(propertyName, (Object)nearQuery);
            }
        });
        queryHandlers.put(WithinCircle.class, new QueryHandler<WithinCircle>(){

            @Override
            public void handle(PersistentEntity entity, WithinCircle withinCentre, DBObject query) {
                BasicDBObject nearQuery = new BasicDBObject();
                BasicDBObject center = new BasicDBObject();
                MongoEntityPersister.setDBObjectValue((DBObject)center, MongoQuery.CENTER_OPERATOR, withinCentre.getValues(), entity.getMappingContext());
                nearQuery.put(MongoQuery.WITHIN_OPERATOR, (Object)center);
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)withinCentre);
                query.put(propertyName, (Object)nearQuery);
            }
        });
        QueryHandler<Near> nearHandler = new QueryHandler<Near>(){

            @Override
            public void handle(PersistentEntity entity, Near near, DBObject query) {
                String nearOperator;
                BasicDBObject nearQuery = new BasicDBObject();
                Object value = near.getValue();
                String string = nearOperator = near instanceof NearSphere ? MongoQuery.NEAR_SPHERE_OPERATOR : MongoQuery.NEAR_OPERATOR;
                if (value instanceof List || value instanceof Map) {
                    MongoEntityPersister.setDBObjectValue((DBObject)nearQuery, nearOperator, value, entity.getMappingContext());
                } else if (value instanceof Point) {
                    BasicBSONObject geoJson = GeoJSONType.convertToGeoJSON((Point)value);
                    BasicDBObject geometry = new BasicDBObject();
                    geometry.put(MongoQuery.GEOMETRY_OPERATOR, (Object)geoJson);
                    nearQuery.put(nearOperator, (Object)geometry);
                }
                if (near.maxDistance != null) {
                    nearQuery.put(MongoQuery.MAX_DISTANCE_OPERATOR, (Object)near.maxDistance.getValue());
                }
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)near);
                query.put(propertyName, (Object)nearQuery);
            }
        };
        queryHandlers.put(Near.class, nearHandler);
        queryHandlers.put(NearSphere.class, nearHandler);
        queryHandlers.put(GeoWithin.class, new QueryHandler<GeoWithin>(){

            @Override
            public void handle(PersistentEntity entity, GeoWithin geoWithin, DBObject query) {
                BasicDBObject queryRoot = new BasicDBObject();
                BasicDBObject queryGeoWithin = new BasicDBObject();
                queryRoot.put(MongoQuery.GEO_WITHIN_OPERATOR, (Object)queryGeoWithin);
                String targetProperty = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)geoWithin);
                Object value = geoWithin.getValue();
                if (value instanceof Shape) {
                    Shape shape = (Shape)value;
                    if (shape instanceof Polygon) {
                        Polygon p = (Polygon)shape;
                        BasicBSONObject geoJson = GeoJSONType.convertToGeoJSON(p);
                        queryGeoWithin.put(MongoQuery.GEOMETRY_OPERATOR, (Object)geoJson);
                    } else if (shape instanceof Box) {
                        queryGeoWithin.put(MongoQuery.BOX_OPERATOR, shape.asList());
                    } else if (shape instanceof Circle) {
                        queryGeoWithin.put(MongoQuery.CENTER_OPERATOR, shape.asList());
                    } else if (shape instanceof Sphere) {
                        queryGeoWithin.put(MongoQuery.CENTER_SPHERE_OPERATOR, shape.asList());
                    }
                } else if (value instanceof Map) {
                    queryGeoWithin.putAll((Map)value);
                }
                query.put(targetProperty, (Object)queryRoot);
            }
        });
        queryHandlers.put(GeoIntersects.class, new QueryHandler<GeoIntersects>(){

            @Override
            public void handle(PersistentEntity entity, GeoIntersects geoIntersects, DBObject query) {
                BasicDBObject queryRoot = new BasicDBObject();
                BasicDBObject queryGeoWithin = new BasicDBObject();
                queryRoot.put(MongoQuery.GEO_INTERSECTS_OPERATOR, (Object)queryGeoWithin);
                String targetProperty = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)geoIntersects);
                Object value = geoIntersects.getValue();
                if (value instanceof GeoJSON) {
                    Shape shape = (Shape)value;
                    BasicBSONObject geoJson = GeoJSONType.convertToGeoJSON(shape);
                    queryGeoWithin.put(MongoQuery.GEOMETRY_OPERATOR, (Object)geoJson);
                } else if (value instanceof Map) {
                    queryGeoWithin.putAll((Map)value);
                }
                query.put(targetProperty, (Object)queryRoot);
            }
        });
        queryHandlers.put(Query.Between.class, new QueryHandler<Query.Between>(){

            @Override
            public void handle(PersistentEntity entity, Query.Between between, DBObject query) {
                BasicDBObject betweenQuery = new BasicDBObject();
                MongoEntityPersister.setDBObjectValue((DBObject)betweenQuery, MongoQuery.MONGO_GTE_OPERATOR, between.getFrom(), entity.getMappingContext());
                MongoEntityPersister.setDBObjectValue((DBObject)betweenQuery, MongoQuery.MONGO_LTE_OPERATOR, between.getTo(), entity.getMappingContext());
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)between);
                query.put(propertyName, (Object)betweenQuery);
            }
        });
        queryHandlers.put(Query.GreaterThan.class, new QueryHandler<Query.GreaterThan>(){

            @Override
            public void handle(PersistentEntity entity, Query.GreaterThan criterion, DBObject query) {
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                DBObject greaterThanQuery = MongoQuery.getOrCreatePropertyQuery(query, propertyName);
                MongoEntityPersister.setDBObjectValue(greaterThanQuery, MongoQuery.MONGO_GT_OPERATOR, criterion.getValue(), entity.getMappingContext());
                query.put(propertyName, (Object)greaterThanQuery);
            }
        });
        queryHandlers.put(Query.GreaterThanEquals.class, new QueryHandler<Query.GreaterThanEquals>(){

            @Override
            public void handle(PersistentEntity entity, Query.GreaterThanEquals criterion, DBObject query) {
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                DBObject greaterThanQuery = MongoQuery.getOrCreatePropertyQuery(query, propertyName);
                MongoEntityPersister.setDBObjectValue(greaterThanQuery, MongoQuery.MONGO_GTE_OPERATOR, criterion.getValue(), entity.getMappingContext());
                query.put(propertyName, (Object)greaterThanQuery);
            }
        });
        queryHandlers.put(Query.LessThan.class, new QueryHandler<Query.LessThan>(){

            @Override
            public void handle(PersistentEntity entity, Query.LessThan criterion, DBObject query) {
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                DBObject lessThanQuery = MongoQuery.getOrCreatePropertyQuery(query, propertyName);
                MongoEntityPersister.setDBObjectValue(lessThanQuery, MongoQuery.MONGO_LT_OPERATOR, criterion.getValue(), entity.getMappingContext());
                query.put(propertyName, (Object)lessThanQuery);
            }
        });
        queryHandlers.put(Query.LessThanEquals.class, new QueryHandler<Query.LessThanEquals>(){

            @Override
            public void handle(PersistentEntity entity, Query.LessThanEquals criterion, DBObject query) {
                String propertyName = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)criterion);
                DBObject lessThanQuery = MongoQuery.getOrCreatePropertyQuery(query, propertyName);
                MongoEntityPersister.setDBObjectValue(lessThanQuery, MongoQuery.MONGO_LTE_OPERATOR, criterion.getValue(), entity.getMappingContext());
                query.put(propertyName, (Object)lessThanQuery);
            }
        });
        queryHandlers.put(Query.Conjunction.class, new QueryHandler<Query.Conjunction>(){

            @Override
            public void handle(PersistentEntity entity, Query.Conjunction criterion, DBObject query) {
                MongoQuery.populateMongoQuery(entity, query, (Query.Junction)criterion);
            }
        });
        queryHandlers.put(Query.Negation.class, new QueryHandler<Query.Negation>(){

            @Override
            public void handle(PersistentEntity entity, Query.Negation criteria, DBObject query) {
                for (Query.Criterion criterion : criteria.getCriteria()) {
                    QueryHandler queryHandler = (QueryHandler)negatedHandlers.get(criterion.getClass());
                    if (queryHandler != null) {
                        queryHandler.handle(entity, criterion, query);
                        continue;
                    }
                    throw new UnsupportedOperationException("Query of type " + criterion.getClass().getSimpleName() + " cannot be negated");
                }
            }
        });
        queryHandlers.put(Query.Disjunction.class, new QueryHandler<Query.Disjunction>(){

            @Override
            public void handle(PersistentEntity entity, Query.Disjunction criterion, DBObject query) {
                MongoQuery.populateMongoQuery(entity, query, (Query.Junction)criterion);
            }
        });
        negatedHandlers.put(Query.Equals.class, new QueryHandler<Query.Equals>(){

            @Override
            public void handle(PersistentEntity entity, Query.Equals criterion, DBObject query) {
                ((QueryHandler)queryHandlers.get(Query.NotEquals.class)).handle(entity, Restrictions.ne((String)criterion.getProperty(), (Object)criterion.getValue()), query);
            }
        });
        negatedHandlers.put(Query.NotEquals.class, new QueryHandler<Query.NotEquals>(){

            @Override
            public void handle(PersistentEntity entity, Query.NotEquals criterion, DBObject query) {
                ((QueryHandler)queryHandlers.get(Query.Equals.class)).handle(entity, Restrictions.eq((String)criterion.getProperty(), (Object)criterion.getValue()), query);
            }
        });
        negatedHandlers.put(Query.In.class, new QueryHandler<Query.In>(){

            @Override
            public void handle(PersistentEntity entity, Query.In in, DBObject query) {
                List nativePropertyValue = MongoQuery.getInListQueryValues(entity, in);
                String property = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)in);
                DBObject inQuery = MongoQuery.getOrCreatePropertyQuery(query, property);
                inQuery.put(MongoQuery.MONGO_NIN_OPERATOR, (Object)nativePropertyValue);
                query.put(property, (Object)inQuery);
            }
        });
        negatedHandlers.put(Query.Between.class, new QueryHandler<Query.Between>(){

            @Override
            public void handle(PersistentEntity entity, Query.Between between, DBObject query) {
                String property = MongoQuery.getPropertyName(entity, (Query.PropertyNameCriterion)between);
                DBObject betweenQuery = MongoQuery.getOrCreatePropertyQuery(query, property);
                betweenQuery.put(MongoQuery.MONGO_LTE_OPERATOR, between.getFrom());
                betweenQuery.put(MongoQuery.MONGO_GTE_OPERATOR, between.getTo());
                query.put(property, (Object)betweenQuery);
            }
        });
        negatedHandlers.put(Query.GreaterThan.class, new QueryHandler<Query.GreaterThan>(){

            @Override
            public void handle(PersistentEntity entity, Query.GreaterThan criterion, DBObject query) {
                ((QueryHandler)queryHandlers.get(Query.LessThan.class)).handle(entity, Restrictions.lt((String)criterion.getProperty(), (Object)criterion.getValue()), query);
            }
        });
        negatedHandlers.put(Query.GreaterThanEquals.class, new QueryHandler<Query.GreaterThanEquals>(){

            @Override
            public void handle(PersistentEntity entity, Query.GreaterThanEquals criterion, DBObject query) {
                ((QueryHandler)queryHandlers.get(Query.LessThanEquals.class)).handle(entity, Restrictions.lte((String)criterion.getProperty(), (Object)criterion.getValue()), query);
            }
        });
        negatedHandlers.put(Query.LessThan.class, new QueryHandler<Query.LessThan>(){

            @Override
            public void handle(PersistentEntity entity, Query.LessThan criterion, DBObject query) {
                ((QueryHandler)queryHandlers.get(Query.GreaterThan.class)).handle(entity, Restrictions.gt((String)criterion.getProperty(), (Object)criterion.getValue()), query);
            }
        });
        negatedHandlers.put(Query.LessThanEquals.class, new QueryHandler<Query.LessThanEquals>(){

            @Override
            public void handle(PersistentEntity entity, Query.LessThanEquals criterion, DBObject query) {
                ((QueryHandler)queryHandlers.get(Query.GreaterThanEquals.class)).handle(entity, Restrictions.gte((String)criterion.getProperty(), (Object)criterion.getValue()), query);
            }
        });
    }

    public static class MongoResultList
    extends AbstractList {
        private MongoEntityPersister mongoEntityPersister;
        private DBCursor cursor;
        private int offset = 0;
        private int internalIndex;
        private List initializedObjects = new ArrayList();
        private Integer size;

        public MongoResultList(DBCursor cursor, int offset, MongoEntityPersister mongoEntityPersister) {
            this.cursor = cursor;
            this.mongoEntityPersister = mongoEntityPersister;
            this.offset = offset;
        }

        @Override
        public boolean isEmpty() {
            return this.initializedObjects.isEmpty() && !this.cursor.hasNext();
        }

        @Override
        public Object get(int index) {
            if (this.initializedObjects.size() > index) {
                return this.initializedObjects.get(index);
            }
            while (this.cursor.hasNext()) {
                if (this.internalIndex > index) {
                    throw new ArrayIndexOutOfBoundsException("Cannot retrieve element at index " + index + " for cursor size " + this.size());
                }
                Object o = this.convertDBObject(this.cursor.next());
                this.initializedObjects.add(this.internalIndex, o);
                if (index != this.internalIndex++) continue;
                return o;
            }
            throw new ArrayIndexOutOfBoundsException("Cannot retrieve element at index " + index + " for cursor size " + this.size());
        }

        @Override
        public Object set(int index, Object o) {
            if (index > this.size() - 1) {
                throw new ArrayIndexOutOfBoundsException("Cannot set element at index " + index + " for cursor size " + this.size());
            }
            this.get(index);
            return this.initializedObjects.set(index, o);
        }

        @Override
        public Iterator iterator() {
            final DBCursor cursor = this.cursor.copy();
            cursor.skip(this.offset);
            return new Iterator(){

                @Override
                public boolean hasNext() {
                    return cursor.hasNext();
                }

                public Object next() {
                    Object object = cursor.next();
                    if (object instanceof DBObject) {
                        object = MongoResultList.this.convertDBObject(object);
                    }
                    return object;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Method remove() not supported by MongoResultList iterator");
                }
            };
        }

        @Override
        public int size() {
            if (this.size == null) {
                this.size = this.cursor.size();
            }
            return this.size;
        }

        protected Object convertDBObject(Object object) {
            Class type;
            DBObject dbObject = (DBObject)object;
            Object id = dbObject.get("_id");
            SessionImplementor session = (SessionImplementor)this.mongoEntityPersister.getSession();
            Object instance = session.getCachedInstance(type = this.mongoEntityPersister.getPersistentEntity().getJavaClass(), (Serializable)id);
            if (instance == null) {
                instance = this.mongoEntityPersister.createObjectFromNativeEntry(this.mongoEntityPersister.getPersistentEntity(), (Serializable)id, dbObject);
                session.cacheInstance(type, (Serializable)id, instance);
            }
            return instance;
        }

        public Object clone() {
            return new MongoResultList(this.cursor, this.offset, this.mongoEntityPersister);
        }
    }

    private static interface QueryHandler<T> {
        public void handle(PersistentEntity var1, T var2, DBObject var3);
    }

    public static class GeoIntersects
    extends GeoCriterion {
        public GeoIntersects(String name, Object value) {
            super(name, value);
        }
    }

    public static class GeoWithin
    extends GeoCriterion {
        public GeoWithin(String name, Object value) {
            super(name, value);
        }
    }

    public static class GeoCriterion
    extends Query.PropertyCriterion {
        public GeoCriterion(String name, Object value) {
            super(name, value);
        }
    }

    public static class WithinCircle
    extends Query.PropertyCriterion {
        public WithinCircle(String name, List value) {
            super(name, (Object)value);
        }

        public List getValues() {
            return (List)this.getValue();
        }

        public void setValue(List matrix) {
            this.value = matrix;
        }
    }

    public static class WithinPolygon
    extends Query.PropertyCriterion {
        public WithinPolygon(String name, List value) {
            super(name, (Object)value);
        }

        public List getValues() {
            return (List)this.getValue();
        }

        public void setValue(List value) {
            this.value = value;
        }
    }

    public static class WithinBox
    extends Query.PropertyCriterion {
        public WithinBox(String name, List value) {
            super(name, (Object)value);
        }

        public List getValues() {
            return (List)this.getValue();
        }

        public void setValue(List matrix) {
            this.value = matrix;
        }
    }

    public static class NearSphere
    extends Near {
        public NearSphere(String name, Object value) {
            super(name, value);
        }

        public NearSphere(String name, Object value, Distance maxDistance) {
            super(name, value, maxDistance);
        }

        public NearSphere(String name, Object value, Number maxDistance) {
            super(name, value, maxDistance);
        }
    }

    public static class Near
    extends GeoCriterion {
        Distance maxDistance = null;

        public Near(String name, Object value) {
            super(name, value);
        }

        public Near(String name, Object value, Distance maxDistance) {
            super(name, value);
            this.maxDistance = maxDistance;
        }

        public Near(String name, Object value, Number maxDistance) {
            super(name, value);
            this.maxDistance = Distance.valueOf(maxDistance.doubleValue());
        }

        public void setMaxDistance(Distance maxDistance) {
            this.maxDistance = maxDistance;
        }
    }
}

