/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.MongoOptions;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bson.types.Binary;
import org.bson.types.ObjectId;
import org.grails.datastore.mapping.config.utils.ConfigUtils;
import org.grails.datastore.mapping.core.AbstractDatastore;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.core.StatelessDatastore;
import org.grails.datastore.mapping.document.config.DocumentMappingContext;
import org.grails.datastore.mapping.model.ClassMapping;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.PropertyMapping;
import org.grails.datastore.mapping.mongo.MongoSession;
import org.grails.datastore.mapping.mongo.config.MongoAttribute;
import org.grails.datastore.mapping.mongo.config.MongoCollection;
import org.grails.datastore.mapping.mongo.config.MongoMappingContext;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.convert.converter.Converter;
import org.springframework.dao.DataAccessException;
import org.springframework.data.authentication.UserCredentials;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.DbCallback;
import org.springframework.data.mongodb.core.MongoFactoryBean;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoDbFactory;

public class MongoDatastore
extends AbstractDatastore
implements InitializingBean,
MappingContext.Listener,
DisposableBean,
StatelessDatastore {
    public static final String PASSWORD = "password";
    public static final String USERNAME = "username";
    public static final String MONGO_PORT = "port";
    public static final String MONGO_HOST = "host";
    public static final String MONGO_STATELESS = "stateless";
    public static final String INDEX_ATTRIBUTES = "indexAttributes";
    protected Mongo mongo;
    protected MongoOptions mongoOptions = new MongoOptions();
    protected Map<PersistentEntity, MongoTemplate> mongoTemplates = new ConcurrentHashMap<PersistentEntity, MongoTemplate>();
    protected Map<PersistentEntity, String> mongoCollections = new ConcurrentHashMap<PersistentEntity, String>();
    protected boolean stateless = false;
    protected UserCredentials userCrentials;

    public MongoDatastore() {
        this(new MongoMappingContext("test"), Collections.emptyMap(), null);
    }

    public MongoDatastore(MongoMappingContext mappingContext, Map<String, String> connectionDetails, MongoOptions mongoOptions, ConfigurableApplicationContext ctx) {
        this(mappingContext, connectionDetails, ctx);
        if (mongoOptions != null) {
            this.mongoOptions = mongoOptions;
        }
    }

    public MongoDatastore(MongoMappingContext mappingContext, Map<String, String> connectionDetails, ConfigurableApplicationContext ctx) {
        super((MappingContext)mappingContext, connectionDetails, ctx);
        if (mappingContext != null) {
            mappingContext.addMappingContextListener(this);
        }
        this.initializeConverters((MappingContext)mappingContext);
        mappingContext.getConverterRegistry().addConverter((Converter)new Converter<String, ObjectId>(){

            public ObjectId convert(String source) {
                return new ObjectId(source);
            }
        });
        mappingContext.getConverterRegistry().addConverter((Converter)new Converter<ObjectId, String>(){

            public String convert(ObjectId source) {
                return source.toString();
            }
        });
        mappingContext.getConverterRegistry().addConverter((Converter)new Converter<byte[], Binary>(){

            public Binary convert(byte[] source) {
                return new Binary(source);
            }
        });
        mappingContext.getConverterRegistry().addConverter((Converter)new Converter<Binary, byte[]>(){

            public byte[] convert(Binary source) {
                return source.getData();
            }
        });
    }

    public MongoDatastore(MongoMappingContext mappingContext) {
        this(mappingContext, Collections.emptyMap(), null);
    }

    public MongoDatastore(MongoMappingContext mappingContext, Mongo mongo, ConfigurableApplicationContext ctx) {
        this(mappingContext, Collections.emptyMap(), ctx);
        this.mongo = mongo;
    }

    public MongoDatastore(MongoMappingContext mappingContext, Mongo mongo, Map<String, String> connectionDetails, ConfigurableApplicationContext ctx) {
        this(mappingContext, connectionDetails, ctx);
        this.mongo = mongo;
    }

    public Mongo getMongo() {
        return this.mongo;
    }

    public MongoTemplate getMongoTemplate(PersistentEntity entity) {
        return this.mongoTemplates.get(entity);
    }

    public String getCollectionName(PersistentEntity entity) {
        return this.mongoCollections.get(entity);
    }

    public UserCredentials getUserCrentials() {
        return this.userCrentials;
    }

    protected Session createSession(Map<String, String> connDetails) {
        if (this.stateless) {
            return this.createStatelessSession(this.connectionDetails);
        }
        return new MongoSession(this, this.getMappingContext(), this.getApplicationEventPublisher(), false);
    }

    protected Session createStatelessSession(Map<String, String> connectionDetails) {
        return new MongoSession(this, this.getMappingContext(), this.getApplicationEventPublisher(), true);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.mongo == null) {
            ServerAddress defaults = new ServerAddress();
            MongoFactoryBean dbFactory = new MongoFactoryBean();
            dbFactory.setHost((String)ConfigUtils.read(String.class, (String)MONGO_HOST, (Map)this.connectionDetails, (Object)defaults.getHost()));
            dbFactory.setPort(((Integer)ConfigUtils.read(Integer.class, (String)MONGO_PORT, (Map)this.connectionDetails, (Object)defaults.getPort())).intValue());
            this.stateless = (Boolean)ConfigUtils.read(Boolean.class, (String)MONGO_STATELESS, (Map)this.connectionDetails, (Object)false);
            if (this.mongoOptions != null) {
                dbFactory.setMongoOptions(this.mongoOptions);
            }
            dbFactory.afterPropertiesSet();
            this.mongo = dbFactory.getObject();
        }
        for (PersistentEntity entity : this.mappingContext.getPersistentEntities()) {
            if (entity.isExternal()) continue;
            this.createMongoTemplate(entity, this.mongo);
        }
    }

    protected void createMongoTemplate(PersistentEntity entity, Mongo mongoInstance) {
        WriteConcern writeConcern;
        SimpleMongoDbFactory dbf;
        MongoCollection mongoCollection;
        DocumentMappingContext dc = (DocumentMappingContext)this.getMappingContext();
        String collectionName = entity.getDecapitalizedName();
        String databaseName = dc.getDefaultDatabaseName();
        ClassMapping mapping = entity.getMapping();
        MongoCollection mongoCollection2 = mongoCollection = mapping.getMappedForm() != null ? (MongoCollection)mapping.getMappedForm() : null;
        if (mongoCollection != null) {
            if (mongoCollection.getCollection() != null) {
                collectionName = mongoCollection.getCollection();
            }
            if (mongoCollection.getDatabase() != null) {
                databaseName = mongoCollection.getDatabase();
            }
        }
        String username = (String)ConfigUtils.read(String.class, (String)USERNAME, (Map)this.connectionDetails, null);
        String password = (String)ConfigUtils.read(String.class, (String)PASSWORD, (Map)this.connectionDetails, null);
        if (username != null && password != null) {
            this.userCrentials = new UserCredentials(username, password);
            dbf = new SimpleMongoDbFactory(mongoInstance, databaseName, this.userCrentials);
        } else {
            dbf = new SimpleMongoDbFactory(mongoInstance, databaseName);
        }
        MongoTemplate mt = new MongoTemplate((MongoDbFactory)dbf);
        if (mongoCollection != null && (writeConcern = mongoCollection.getWriteConcern()) != null) {
            final String collectionNameToUse = collectionName;
            mt.executeInSession((DbCallback)new DbCallback<Object>(){

                public Object doInDB(DB db) throws MongoException, DataAccessException {
                    if (writeConcern != null) {
                        DBCollection collection = db.getCollection(collectionNameToUse);
                        collection.setWriteConcern(writeConcern);
                    }
                    return null;
                }
            });
        }
        this.mongoTemplates.put(entity, mt);
        this.mongoCollections.put(entity, collectionName);
        this.initializeIndices(entity, mt);
    }

    protected void initializeIndices(final PersistentEntity entity, MongoTemplate template) {
        template.execute((DbCallback)new DbCallback<Object>(){

            public Object doInDB(DB db) throws MongoException, DataAccessException {
                MongoCollection mappedForm;
                DBCollection collection = db.getCollection(MongoDatastore.this.getCollectionName(entity));
                ClassMapping classMapping = entity.getMapping();
                if (classMapping != null && (mappedForm = (MongoCollection)classMapping.getMappedForm()) != null) {
                    for (Map compoundIndex : mappedForm.getCompoundIndices()) {
                        Object o;
                        BasicDBObject indexDef = new BasicDBObject(compoundIndex);
                        Map indexAttributes = null;
                        if (compoundIndex.containsKey(MongoDatastore.INDEX_ATTRIBUTES) && (o = compoundIndex.get(MongoDatastore.INDEX_ATTRIBUTES)) instanceof Map) {
                            indexAttributes = (Map)o;
                        }
                        if (indexAttributes != null) {
                            collection.ensureIndex((DBObject)indexDef, (DBObject)new BasicDBObject(indexAttributes));
                            continue;
                        }
                        collection.ensureIndex((DBObject)indexDef);
                    }
                }
                for (PersistentProperty property : entity.getPersistentProperties()) {
                    HashMap attributes;
                    boolean indexed = MongoDatastore.this.isIndexed(property);
                    if (!indexed) continue;
                    MongoAttribute mongoAttributeMapping = (MongoAttribute)property.getMapping().getMappedForm();
                    BasicDBObject dbObject = new BasicDBObject();
                    String fieldName = this.getMongoFieldNameForProperty((PersistentProperty<MongoAttribute>)property);
                    dbObject.put(fieldName, (Object)1);
                    BasicDBObject options = new BasicDBObject();
                    if (mongoAttributeMapping != null && (attributes = mongoAttributeMapping.getIndexAttributes()) != null) {
                        if ((attributes = new HashMap(attributes)).containsKey("type")) {
                            dbObject.put(fieldName, attributes.remove("type"));
                        }
                        options.putAll(attributes);
                    }
                    if (options.toMap().isEmpty()) {
                        collection.ensureIndex((DBObject)dbObject);
                        continue;
                    }
                    collection.ensureIndex((DBObject)dbObject, (DBObject)options);
                }
                return null;
            }

            String getMongoFieldNameForProperty(PersistentProperty<MongoAttribute> property) {
                PropertyMapping pm = property.getMapping();
                String propKey = null;
                if (pm.getMappedForm() != null) {
                    propKey = ((MongoAttribute)pm.getMappedForm()).getField();
                }
                if (propKey == null) {
                    propKey = property.getName();
                }
                return propKey;
            }
        });
    }

    public void persistentEntityAdded(PersistentEntity entity) {
        this.createMongoTemplate(entity, this.mongo);
    }

    public void destroy() throws Exception {
        super.destroy();
        if (this.mongo != null) {
            this.mongo.close();
        }
    }

    public boolean isSchemaless() {
        return true;
    }
}

