/*
 * Decompiled with CFR 0.152.
 */
package org.grails.orm.hibernate.transaction;

import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class HibernateJtaTransactionManagerAdapter
implements TransactionManager {
    PlatformTransactionManager springTransactionManager;
    ThreadLocal<TransactionStatus> currentTransactionHolder = new ThreadLocal();

    public HibernateJtaTransactionManagerAdapter(PlatformTransactionManager springTransactionManager) {
        this.springTransactionManager = springTransactionManager;
    }

    public void begin() {
        DefaultTransactionDefinition definition = new DefaultTransactionDefinition(3);
        this.currentTransactionHolder.set(this.springTransactionManager.getTransaction((TransactionDefinition)definition));
    }

    public void commit() throws SecurityException, IllegalStateException {
        this.springTransactionManager.commit(this.getAndRemoveStatus());
    }

    public void rollback() throws IllegalStateException, SecurityException {
        this.springTransactionManager.rollback(this.getAndRemoveStatus());
    }

    public void setRollbackOnly() throws IllegalStateException {
        this.currentTransactionHolder.get().setRollbackOnly();
    }

    protected TransactionStatus getAndRemoveStatus() {
        TransactionStatus status = this.currentTransactionHolder.get();
        this.currentTransactionHolder.remove();
        return status;
    }

    public int getStatus() {
        TransactionStatus status = this.currentTransactionHolder.get();
        return HibernateJtaTransactionManagerAdapter.convertToJtaStatus(status);
    }

    protected static int convertToJtaStatus(TransactionStatus status) {
        if (status != null) {
            if (status.isCompleted()) {
                return 5;
            }
            if (status.isRollbackOnly()) {
                return 1;
            }
            return 0;
        }
        return 6;
    }

    public Transaction getTransaction() {
        return new TransactionAdapter(this.springTransactionManager, this.currentTransactionHolder);
    }

    public void resume(Transaction tobj) throws IllegalStateException {
        TransactionAdapter transaction = (TransactionAdapter)tobj;
        this.springTransactionManager.commit(transaction.transactionStatus);
    }

    public Transaction suspend() {
        this.currentTransactionHolder.set(this.springTransactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition(4)));
        return new TransactionAdapter(this.springTransactionManager, this.currentTransactionHolder);
    }

    public void setTransactionTimeout(int seconds) {
    }

    private static class TransactionAdapter
    implements Transaction {
        PlatformTransactionManager springTransactionManager;
        TransactionStatus transactionStatus;
        ThreadLocal<TransactionStatus> currentTransactionHolder;

        TransactionAdapter(PlatformTransactionManager springTransactionManager, ThreadLocal<TransactionStatus> currentTransactionHolder) {
            this.springTransactionManager = springTransactionManager;
            this.currentTransactionHolder = currentTransactionHolder;
            this.transactionStatus = currentTransactionHolder.get();
        }

        public void commit() throws SecurityException, IllegalStateException {
            this.springTransactionManager.commit(this.transactionStatus);
            this.currentTransactionHolder.remove();
        }

        public boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException {
            return false;
        }

        public boolean enlistResource(XAResource xaRes) throws RollbackException, IllegalStateException, SystemException {
            return false;
        }

        public int getStatus() throws SystemException {
            return HibernateJtaTransactionManagerAdapter.convertToJtaStatus(this.transactionStatus);
        }

        public void registerSynchronization(final Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                public void beforeCompletion() {
                    sync.beforeCompletion();
                }

                public void afterCompletion(int status) {
                    int jtaStatus = status == 0 ? 3 : (status == 1 ? 4 : 5);
                    sync.afterCompletion(jtaStatus);
                }

                public void suspend() {
                }

                public void resume() {
                }

                public void flush() {
                }

                public void beforeCommit(boolean readOnly) {
                }

                public void afterCommit() {
                }
            });
        }

        public void rollback() throws IllegalStateException, SystemException {
            this.springTransactionManager.rollback(this.transactionStatus);
            this.currentTransactionHolder.remove();
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            this.transactionStatus.setRollbackOnly();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj.getClass() == TransactionAdapter.class) {
                TransactionAdapter other = (TransactionAdapter)obj;
                if (other.transactionStatus == this.transactionStatus) {
                    return true;
                }
                if (other.transactionStatus != null) {
                    return other.transactionStatus.equals(this.transactionStatus);
                }
                return false;
            }
            return false;
        }

        public int hashCode() {
            return this.transactionStatus != null ? this.transactionStatus.hashCode() : System.identityHashCode(this);
        }
    }
}

