/*
 * Decompiled with CFR 0.152.
 */
package org.grails.orm.hibernate.support;

import java.io.Serializable;
import java.util.Map;
import org.grails.datastore.gorm.events.ConfigurableApplicationContextEventPublisher;
import org.grails.datastore.gorm.events.ConfigurableApplicationEventPublisher;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.dirty.checking.DirtyCheckable;
import org.grails.datastore.mapping.engine.EntityAccess;
import org.grails.datastore.mapping.engine.ModificationTrackingEntityAccess;
import org.grails.datastore.mapping.engine.event.AbstractPersistenceEvent;
import org.grails.datastore.mapping.engine.event.PostDeleteEvent;
import org.grails.datastore.mapping.engine.event.PostUpdateEvent;
import org.grails.datastore.mapping.engine.event.PreInsertEvent;
import org.grails.datastore.mapping.engine.event.SaveOrUpdateEvent;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.types.Embedded;
import org.grails.datastore.mapping.proxy.ProxyHandler;
import org.grails.orm.hibernate.AbstractHibernateDatastore;
import org.grails.orm.hibernate.support.AbstractClosureEventTriggeringInterceptor;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.event.spi.AbstractEvent;
import org.hibernate.event.spi.PostInsertEvent;
import org.hibernate.event.spi.PostLoadEvent;
import org.hibernate.event.spi.PreDeleteEvent;
import org.hibernate.event.spi.PreLoadEvent;
import org.hibernate.event.spi.PreUpdateEvent;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;

public class ClosureEventTriggeringInterceptor
extends AbstractClosureEventTriggeringInterceptor {
    private static final long serialVersionUID = 1L;
    public static final String ONLOAD_EVENT = "onLoad";
    public static final String ONLOAD_SAVE = "onSave";
    public static final String BEFORE_LOAD_EVENT = "beforeLoad";
    public static final String BEFORE_INSERT_EVENT = "beforeInsert";
    public static final String AFTER_INSERT_EVENT = "afterInsert";
    public static final String BEFORE_UPDATE_EVENT = "beforeUpdate";
    public static final String AFTER_UPDATE_EVENT = "afterUpdate";
    public static final String BEFORE_DELETE_EVENT = "beforeDelete";
    public static final String AFTER_DELETE_EVENT = "afterDelete";
    public static final String AFTER_LOAD_EVENT = "afterLoad";
    protected AbstractHibernateDatastore datastore;
    protected ConfigurableApplicationEventPublisher eventPublisher;
    private MappingContext mappingContext;
    private ProxyHandler proxyHandler;

    public void setDatastore(AbstractHibernateDatastore datastore) {
        this.datastore = datastore;
        this.mappingContext = datastore.getMappingContext();
        this.proxyHandler = this.mappingContext.getProxyHandler();
    }

    public void setEventPublisher(ConfigurableApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void onSaveOrUpdate(org.hibernate.event.spi.SaveOrUpdateEvent hibernateEvent) throws HibernateException {
        Object entity = this.getEntity(hibernateEvent);
        if (entity != null && this.proxyHandler.isInitialized(entity)) {
            this.activateDirtyChecking(entity);
            SaveOrUpdateEvent grailsEvent = new SaveOrUpdateEvent((Datastore)this.datastore, entity);
            this.publishEvent((AbstractEvent)hibernateEvent, (AbstractPersistenceEvent)grailsEvent);
        }
        super.onSaveOrUpdate(hibernateEvent);
    }

    protected Object getEntity(org.hibernate.event.spi.SaveOrUpdateEvent hibernateEvent) {
        Object object = hibernateEvent.getObject();
        if (object != null) {
            return object;
        }
        return hibernateEvent.getEntity();
    }

    public void onPreLoad(PreLoadEvent hibernateEvent) {
        org.grails.datastore.mapping.engine.event.PreLoadEvent grailsEvent = new org.grails.datastore.mapping.engine.event.PreLoadEvent((Datastore)this.datastore, hibernateEvent.getEntity());
        this.publishEvent((AbstractEvent)hibernateEvent, (AbstractPersistenceEvent)grailsEvent);
    }

    public void onPostLoad(PostLoadEvent hibernateEvent) {
        Object entity = hibernateEvent.getEntity();
        this.activateDirtyChecking(entity);
        this.publishEvent((AbstractEvent)hibernateEvent, (AbstractPersistenceEvent)new org.grails.datastore.mapping.engine.event.PostLoadEvent((Datastore)this.datastore, entity));
    }

    public boolean onPreInsert(org.hibernate.event.spi.PreInsertEvent hibernateEvent) {
        PreInsertEvent grailsEvent;
        Object entity = hibernateEvent.getEntity();
        Class type = Hibernate.getClass((Object)entity);
        PersistentEntity persistentEntity = this.mappingContext.getPersistentEntity(type.getName());
        ModificationTrackingEntityAccess entityAccess = null;
        if (persistentEntity != null) {
            entityAccess = new ModificationTrackingEntityAccess(this.mappingContext.createEntityAccess(persistentEntity, entity));
            grailsEvent = new PreInsertEvent((Datastore)this.datastore, persistentEntity, (EntityAccess)entityAccess);
        } else {
            grailsEvent = new PreInsertEvent((Datastore)this.datastore, entity);
        }
        this.publishEvent((AbstractEvent)hibernateEvent, (AbstractPersistenceEvent)grailsEvent);
        boolean cancelled = grailsEvent.isCancelled();
        if (!cancelled && entityAccess != null) {
            this.synchronizeHibernateState(hibernateEvent, entityAccess);
        }
        return cancelled;
    }

    private void synchronizeHibernateState(org.hibernate.event.spi.PreInsertEvent hibernateEvent, ModificationTrackingEntityAccess entityAccess) {
        Map modifiedProperties = entityAccess.getModifiedProperties();
        if (!modifiedProperties.isEmpty()) {
            Object[] state = hibernateEvent.getState();
            EntityPersister persister = hibernateEvent.getPersister();
            this.synchronizeHibernateState(persister, state, modifiedProperties);
        }
    }

    private void synchronizeHibernateState(PreUpdateEvent hibernateEvent, ModificationTrackingEntityAccess entityAccess, boolean autoTimestamp) {
        Map modifiedProperties = entityAccess.getModifiedProperties();
        if (autoTimestamp) {
            this.updateModifiedPropertiesWithAutoTimestamp(modifiedProperties, hibernateEvent);
        }
        if (!modifiedProperties.isEmpty()) {
            Object[] state = hibernateEvent.getState();
            EntityPersister persister = hibernateEvent.getPersister();
            this.synchronizeHibernateState(persister, state, modifiedProperties);
        }
    }

    private void updateModifiedPropertiesWithAutoTimestamp(Map<String, Object> modifiedProperties, PreUpdateEvent hibernateEvent) {
        EntityMetamodel entityMetamodel = hibernateEvent.getPersister().getEntityMetamodel();
        Integer dateCreatedIdx = entityMetamodel.getPropertyIndexOrNull("dateCreated");
        Object[] oldState = hibernateEvent.getOldState();
        Object[] state = hibernateEvent.getState();
        if (dateCreatedIdx != null && oldState != null && oldState[dateCreatedIdx] != null && !oldState[dateCreatedIdx].equals(state[dateCreatedIdx])) {
            modifiedProperties.put("dateCreated", oldState[dateCreatedIdx]);
        }
    }

    private void synchronizeHibernateState(EntityPersister persister, Object[] state, Map<String, Object> modifiedProperties) {
        EntityMetamodel entityMetamodel = persister.getEntityMetamodel();
        for (Map.Entry<String, Object> entry : modifiedProperties.entrySet()) {
            Integer index = entityMetamodel.getPropertyIndexOrNull(entry.getKey());
            if (index == null) continue;
            state[index.intValue()] = entry.getValue();
        }
    }

    public void onPostInsert(PostInsertEvent hibernateEvent) {
        Object entity = hibernateEvent.getEntity();
        org.grails.datastore.mapping.engine.event.PostInsertEvent grailsEvent = new org.grails.datastore.mapping.engine.event.PostInsertEvent((Datastore)this.datastore, entity);
        this.activateDirtyChecking(entity);
        this.publishEvent((AbstractEvent)hibernateEvent, (AbstractPersistenceEvent)grailsEvent);
    }

    public boolean onPreUpdate(PreUpdateEvent hibernateEvent) {
        org.grails.datastore.mapping.engine.event.PreUpdateEvent grailsEvent;
        Object entity = hibernateEvent.getEntity();
        Class type = Hibernate.getClass((Object)entity);
        MappingContext mappingContext = this.datastore.getMappingContext();
        PersistentEntity persistentEntity = mappingContext.getPersistentEntity(type.getName());
        ModificationTrackingEntityAccess entityAccess = null;
        if (persistentEntity != null) {
            entityAccess = new ModificationTrackingEntityAccess(mappingContext.createEntityAccess(persistentEntity, entity));
            grailsEvent = new org.grails.datastore.mapping.engine.event.PreUpdateEvent((Datastore)this.datastore, persistentEntity, (EntityAccess)entityAccess);
        } else {
            grailsEvent = new org.grails.datastore.mapping.engine.event.PreUpdateEvent((Datastore)this.datastore, entity);
        }
        this.publishEvent((AbstractEvent)hibernateEvent, (AbstractPersistenceEvent)grailsEvent);
        boolean cancelled = grailsEvent.isCancelled();
        if (!cancelled && entityAccess != null) {
            boolean autoTimestamp = persistentEntity.getMapping().getMappedForm().isAutoTimestamp();
            this.synchronizeHibernateState(hibernateEvent, entityAccess, autoTimestamp);
        }
        return cancelled;
    }

    public void onPostUpdate(org.hibernate.event.spi.PostUpdateEvent hibernateEvent) {
        Object entity = hibernateEvent.getEntity();
        this.activateDirtyChecking(entity);
        this.publishEvent((AbstractEvent)hibernateEvent, (AbstractPersistenceEvent)new PostUpdateEvent((Datastore)this.datastore, entity));
    }

    public boolean onPreDelete(PreDeleteEvent hibernateEvent) {
        org.grails.datastore.mapping.engine.event.PreDeleteEvent event = new org.grails.datastore.mapping.engine.event.PreDeleteEvent((Datastore)this.datastore, hibernateEvent.getEntity());
        this.publishEvent((AbstractEvent)hibernateEvent, (AbstractPersistenceEvent)event);
        return event.isCancelled();
    }

    public void onPostDelete(org.hibernate.event.spi.PostDeleteEvent hibernateEvent) {
        PostDeleteEvent grailsEvent = new PostDeleteEvent((Datastore)this.datastore, hibernateEvent.getEntity());
        this.publishEvent((AbstractEvent)hibernateEvent, (AbstractPersistenceEvent)grailsEvent);
    }

    private void publishEvent(AbstractEvent hibernateEvent, AbstractPersistenceEvent mappingEvent) {
        mappingEvent.setNativeEvent((Serializable)hibernateEvent);
        if (this.eventPublisher != null) {
            this.eventPublisher.publishEvent((ApplicationEvent)mappingEvent);
        }
    }

    public boolean requiresPostCommitHanding(EntityPersister persister) {
        return false;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (applicationContext instanceof ConfigurableApplicationContext) {
            this.eventPublisher = new ConfigurableApplicationContextEventPublisher((ConfigurableApplicationContext)applicationContext);
        }
    }

    private void activateDirtyChecking(Object entity) {
        if (entity instanceof DirtyCheckable && this.proxyHandler.isInitialized(entity)) {
            PersistentEntity persistentEntity = this.mappingContext.getPersistentEntity(Hibernate.getClass((Object)entity).getName());
            entity = this.proxyHandler.unwrap(entity);
            DirtyCheckable dirtyCheckable = (DirtyCheckable)entity;
            Map dirtyCheckingState = persistentEntity.getReflector().getDirtyCheckingState(entity);
            if (dirtyCheckingState == null) {
                dirtyCheckable.trackChanges();
                for (Embedded association : persistentEntity.getEmbedded()) {
                    DirtyCheckable embeddedCheck;
                    Object embedded;
                    if (!DirtyCheckable.class.isAssignableFrom(association.getType()) || (embedded = association.getReader().read(entity)) == null || !(embeddedCheck = (DirtyCheckable)embedded).listDirtyPropertyNames().isEmpty()) continue;
                    embeddedCheck.trackChanges();
                }
            }
        }
    }
}

