/*
 * Decompiled with CFR 0.152.
 */
package org.grails.orm.hibernate.cfg;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import javax.sql.DataSource;
import org.grails.datastore.gorm.GormEntity;
import org.grails.datastore.gorm.jdbc.connections.DataSourceSettings;
import org.grails.datastore.mapping.core.connections.ConnectionSource;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.orm.hibernate.EventListenerIntegrator;
import org.grails.orm.hibernate.GrailsSessionContext;
import org.grails.orm.hibernate.HibernateEventListeners;
import org.grails.orm.hibernate.MetadataIntegrator;
import org.grails.orm.hibernate.access.TraitPropertyAccessStrategy;
import org.grails.orm.hibernate.cfg.GrailsDomainBinder;
import org.grails.orm.hibernate.cfg.GrailsIdentifierGeneratorFactory;
import org.grails.orm.hibernate.cfg.HibernateMappingContext;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.registry.classloading.internal.ClassLoaderServiceImpl;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.boot.spi.MetadataContributor;
import org.hibernate.cfg.Configuration;
import org.hibernate.context.spi.CurrentSessionContext;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.property.access.spi.PropertyAccessStrategy;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;

public class HibernateMappingContextConfiguration
extends Configuration
implements ApplicationContextAware {
    private static final long serialVersionUID = -7115087342689305517L;
    private static final String RESOURCE_PATTERN = "/**/*.class";
    private static final TypeFilter[] ENTITY_TYPE_FILTERS = new TypeFilter[]{new AnnotationTypeFilter(Entity.class, false), new AnnotationTypeFilter(Embeddable.class, false), new AnnotationTypeFilter(MappedSuperclass.class, false)};
    protected String sessionFactoryBeanName = "sessionFactory";
    protected String dataSourceName = "DEFAULT";
    protected HibernateMappingContext hibernateMappingContext;
    private Class<? extends CurrentSessionContext> currentSessionContext = GrailsSessionContext.class;
    private HibernateEventListeners hibernateEventListeners;
    private Map<String, Object> eventListeners;
    private ServiceRegistry serviceRegistry;
    private ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
    private MetadataContributor metadataContributor;
    private Set<Class> additionalClasses = new HashSet<Class>();

    public void setHibernateMappingContext(HibernateMappingContext hibernateMappingContext) {
        this.hibernateMappingContext = hibernateMappingContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.resourcePatternResolver = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)applicationContext);
        String dsName = "DEFAULT".equals(this.dataSourceName) ? "dataSource" : "dataSource_" + this.dataSourceName;
        Properties properties = this.getProperties();
        if (applicationContext.containsBean(dsName)) {
            properties.put("hibernate.connection.datasource", applicationContext.getBean(dsName));
        }
        properties.put("hibernate.current_session_context_class", this.currentSessionContext.getName());
        properties.put("hibernate.classLoaders", applicationContext.getClassLoader());
    }

    public void setDataSourceConnectionSource(ConnectionSource<DataSource, DataSourceSettings> connectionSource) {
        this.dataSourceName = connectionSource.getName();
        DataSource source = (DataSource)connectionSource.getSource();
        this.getProperties().put("hibernate.connection.datasource", source);
        this.getProperties().put("hibernate.current_session_context_class", GrailsSessionContext.class.getName());
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null && contextClassLoader.getClass().getSimpleName().equalsIgnoreCase("RestartClassLoader")) {
            this.getProperties().put("hibernate.classLoaders", contextClassLoader);
        } else {
            this.getProperties().put("hibernate.classLoaders", connectionSource.getClass().getClassLoader());
        }
    }

    public void addAnnotatedClasses(Class<?> ... annotatedClasses) {
        for (Class<?> annotatedClass : annotatedClasses) {
            this.addAnnotatedClass(annotatedClass);
        }
    }

    public Configuration addAnnotatedClass(Class annotatedClass) {
        this.additionalClasses.add(annotatedClass);
        return super.addAnnotatedClass(annotatedClass);
    }

    public void addPackages(String ... annotatedPackages) {
        for (String annotatedPackage : annotatedPackages) {
            this.addPackage(annotatedPackage);
        }
    }

    public void scanPackages(String ... packagesToScan) throws HibernateException {
        try {
            for (String pkg : packagesToScan) {
                String pattern = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)pkg) + RESOURCE_PATTERN;
                Resource[] resources = this.resourcePatternResolver.getResources(pattern);
                CachingMetadataReaderFactory readerFactory = new CachingMetadataReaderFactory((ResourceLoader)this.resourcePatternResolver);
                for (Resource resource : resources) {
                    if (!resource.isReadable()) continue;
                    MetadataReader reader = readerFactory.getMetadataReader(resource);
                    String className = reader.getClassMetadata().getClassName();
                    if (!this.matchesFilter(reader, (MetadataReaderFactory)readerFactory)) continue;
                    Class<?> loadedClass = this.resourcePatternResolver.getClassLoader().loadClass(className);
                    this.addAnnotatedClasses(loadedClass);
                }
            }
        }
        catch (IOException ex) {
            throw new MappingException("Failed to scan classpath for unlisted classes", (Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            throw new MappingException("Failed to load annotated classes from classpath", (Throwable)ex);
        }
    }

    protected boolean matchesFilter(MetadataReader reader, MetadataReaderFactory readerFactory) throws IOException {
        for (TypeFilter filter : ENTITY_TYPE_FILTERS) {
            if (!filter.match(reader, readerFactory)) continue;
            return true;
        }
        return false;
    }

    public void setSessionFactoryBeanName(String name) {
        this.sessionFactoryBeanName = name;
    }

    public void setDataSourceName(String name) {
        this.dataSourceName = name;
    }

    public SessionFactory buildSessionFactory() throws HibernateException {
        Object classLoaderObject = this.getProperties().get("hibernate.classLoaders");
        ClassLoader appClassLoader = classLoaderObject instanceof ClassLoader ? (ClassLoader)classLoaderObject : ((Object)((Object)this)).getClass().getClassLoader();
        ConfigurationHelper.resolvePlaceHolders((Map)this.getProperties());
        final GrailsDomainBinder domainBinder = new GrailsDomainBinder(this.dataSourceName, this.sessionFactoryBeanName, this.hibernateMappingContext);
        ArrayList<Class> annotatedClasses = new ArrayList<Class>();
        for (PersistentEntity persistentEntity : this.hibernateMappingContext.getPersistentEntities()) {
            Class javaClass = persistentEntity.getJavaClass();
            if (!javaClass.isAnnotationPresent(Entity.class)) continue;
            annotatedClasses.add(javaClass);
        }
        if (!this.additionalClasses.isEmpty()) {
            for (Class additionalClass : this.additionalClasses) {
                if (!GormEntity.class.isAssignableFrom(additionalClass)) continue;
                this.hibernateMappingContext.addPersistentEntity(additionalClass);
            }
        }
        this.addAnnotatedClasses(annotatedClasses.toArray(new Class[annotatedClasses.size()]));
        ClassLoaderServiceImpl classLoaderService = new ClassLoaderServiceImpl(appClassLoader){

            public <S> Collection<S> loadJavaServices(Class<S> serviceContract) {
                if (MetadataContributor.class.isAssignableFrom(serviceContract)) {
                    if (HibernateMappingContextConfiguration.this.metadataContributor != null) {
                        return Arrays.asList(domainBinder, HibernateMappingContextConfiguration.this.metadataContributor);
                    }
                    return Collections.singletonList(domainBinder);
                }
                return super.loadJavaServices(serviceContract);
            }
        };
        EventListenerIntegrator eventListenerIntegrator = new EventListenerIntegrator(this.hibernateEventListeners, this.eventListeners);
        BootstrapServiceRegistry bootstrapServiceRegistry = this.createBootstrapServiceRegistryBuilder().applyIntegrator((Integrator)eventListenerIntegrator).applyIntegrator((Integrator)new MetadataIntegrator()).applyClassLoaderService((ClassLoaderService)classLoaderService).build();
        StrategySelector strategySelector = (StrategySelector)bootstrapServiceRegistry.getService(StrategySelector.class);
        strategySelector.registerStrategyImplementor(PropertyAccessStrategy.class, "traitProperty", TraitPropertyAccessStrategy.class);
        this.setSessionFactoryObserver(new SessionFactoryObserver(){
            private static final long serialVersionUID = 1L;

            public void sessionFactoryCreated(SessionFactory factory) {
            }

            public void sessionFactoryClosed(SessionFactory factory) {
                if (HibernateMappingContextConfiguration.this.serviceRegistry != null) {
                    ((ServiceRegistryImplementor)HibernateMappingContextConfiguration.this.serviceRegistry).destroy();
                }
            }
        });
        StandardServiceRegistryBuilder standardServiceRegistryBuilder = this.createStandardServiceRegistryBuilder(bootstrapServiceRegistry).applySettings((Map)this.getProperties());
        StandardServiceRegistry serviceRegistry = standardServiceRegistryBuilder.build();
        SessionFactory sessionFactory = super.buildSessionFactory((ServiceRegistry)serviceRegistry);
        this.serviceRegistry = serviceRegistry;
        return sessionFactory;
    }

    protected BootstrapServiceRegistryBuilder createBootstrapServiceRegistryBuilder() {
        return new BootstrapServiceRegistryBuilder();
    }

    protected StandardServiceRegistryBuilder createStandardServiceRegistryBuilder(BootstrapServiceRegistry bootstrapServiceRegistry) {
        return new StandardServiceRegistryBuilder(bootstrapServiceRegistry);
    }

    public void setEventListeners(Map<String, Object> listeners) {
        this.eventListeners = listeners;
    }

    public void setHibernateEventListeners(HibernateEventListeners listeners) {
        this.hibernateEventListeners = listeners;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    protected void reset() {
        super.reset();
        try {
            GrailsIdentifierGeneratorFactory.applyNewInstance(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setMetadataContributor(MetadataContributor metadataContributor) {
        this.metadataContributor = metadataContributor;
    }
}

