/*
 * Decompiled with CFR 0.152.
 */
package org.grails.orm.hibernate.query;

import java.util.Map;
import javax.persistence.LockModeType;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.types.Association;
import org.grails.datastore.mapping.model.types.Embedded;
import org.grails.datastore.mapping.reflect.ClassUtils;
import org.grails.orm.hibernate.cfg.AbstractGrailsDomainBinder;
import org.grails.orm.hibernate.cfg.Mapping;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.query.Query;
import org.springframework.core.convert.ConversionService;

public class GrailsHibernateQueryUtils {
    @Deprecated
    public static void populateArgumentsForCriteria(PersistentEntity entity, Criteria c, Map argMap, ConversionService conversionService, boolean useDefaultMapping) {
        block20: {
            Mapping m;
            block19: {
                int offset;
                Integer maxParam = null;
                Integer offsetParam = null;
                if (argMap.containsKey("max")) {
                    maxParam = (Integer)conversionService.convert(argMap.get("max"), Integer.class);
                }
                if (argMap.containsKey("offset")) {
                    offsetParam = (Integer)conversionService.convert(argMap.get("offset"), Integer.class);
                }
                if (argMap.containsKey("fetchSize")) {
                    c.setFetchSize(((Integer)conversionService.convert(argMap.get("fetchSize"), Integer.class)).intValue());
                }
                if (argMap.containsKey("timeout")) {
                    c.setTimeout(((Integer)conversionService.convert(argMap.get("timeout"), Integer.class)).intValue());
                }
                if (argMap.containsKey("flushMode")) {
                    c.setFlushMode(GrailsHibernateQueryUtils.convertFlushMode(argMap.get("flushMode")));
                }
                if (argMap.containsKey("readOnly")) {
                    c.setReadOnly(ClassUtils.getBooleanFromMap((String)"readOnly", (Map)argMap));
                }
                String orderParam = (String)argMap.get("order");
                Object fetchObj = argMap.get("fetch");
                if (fetchObj instanceof Map) {
                    Map fetch = (Map)fetchObj;
                    for (Object o : fetch.keySet()) {
                        String associationName = (String)o;
                        c.setFetchMode(associationName, GrailsHibernateQueryUtils.getFetchMode(fetch.get(associationName)));
                    }
                }
                int max = maxParam == null ? -1 : maxParam;
                int n = offset = offsetParam == null ? -1 : offsetParam;
                if (max > -1) {
                    c.setMaxResults(max);
                }
                if (offset > -1) {
                    c.setFirstResult(offset);
                }
                if (ClassUtils.getBooleanFromMap((String)"lock", (Map)argMap)) {
                    c.setLockMode(LockMode.PESSIMISTIC_WRITE);
                    c.setCacheable(false);
                } else if (argMap.containsKey("cache")) {
                    c.setCacheable(ClassUtils.getBooleanFromMap((String)"cache", (Map)argMap));
                } else {
                    GrailsHibernateQueryUtils.cacheCriteriaByMapping(entity.getJavaClass(), c);
                }
                Object sortObj = argMap.get("sort");
                if (sortObj == null) break block19;
                boolean ignoreCase = true;
                Object caseArg = argMap.get("ignoreCase");
                if (caseArg instanceof Boolean) {
                    ignoreCase = (Boolean)caseArg;
                }
                if (sortObj instanceof Map) {
                    Map sortMap = (Map)sortObj;
                    for (Object sort : sortMap.keySet()) {
                        String order = "desc".equalsIgnoreCase((String)sortMap.get(sort)) ? "desc" : "asc";
                        GrailsHibernateQueryUtils.addOrderPossiblyNested(c, entity, (String)sort, order, ignoreCase);
                    }
                } else {
                    String sort = (String)sortObj;
                    String order = "desc".equalsIgnoreCase(orderParam) ? "desc" : "asc";
                    GrailsHibernateQueryUtils.addOrderPossiblyNested(c, entity, sort, order, ignoreCase);
                }
                break block20;
            }
            if (!useDefaultMapping || (m = AbstractGrailsDomainBinder.getMapping(entity.getJavaClass())) == null) break block20;
            Map sortMap = m.getSort().getNamesAndDirections();
            for (Object sort : sortMap.keySet()) {
                String order = "desc".equalsIgnoreCase((String)sortMap.get(sort)) ? "desc" : "asc";
                GrailsHibernateQueryUtils.addOrderPossiblyNested(c, entity, (String)sort, order, true);
            }
        }
    }

    public static void populateArgumentsForCriteria(PersistentEntity entity, CriteriaQuery query, Root queryRoot, CriteriaBuilder criteriaBuilder, Map argMap, ConversionService conversionService, boolean useDefaultMapping) {
        block8: {
            Mapping m;
            block7: {
                Object sortObj;
                String orderParam = (String)argMap.get("order");
                Object fetchObj = argMap.get("fetch");
                if (fetchObj instanceof Map) {
                    Map fetch = (Map)fetchObj;
                    for (Object o : fetch.keySet()) {
                        String associationName = (String)o;
                        FetchMode fetchMode = GrailsHibernateQueryUtils.getFetchMode(fetch.get(associationName));
                        if (fetchMode != FetchMode.JOIN) continue;
                        queryRoot.join(associationName);
                    }
                }
                if ((sortObj = argMap.get("sort")) == null) break block7;
                boolean ignoreCase = true;
                Object caseArg = argMap.get("ignoreCase");
                if (caseArg instanceof Boolean) {
                    ignoreCase = (Boolean)caseArg;
                }
                if (sortObj instanceof Map) {
                    Map sortMap = (Map)sortObj;
                    for (Object sort : sortMap.keySet()) {
                        String order = "desc".equalsIgnoreCase((String)sortMap.get(sort)) ? "desc" : "asc";
                        GrailsHibernateQueryUtils.addOrderPossiblyNested(query, (From)queryRoot, criteriaBuilder, entity, (String)sort, order, ignoreCase);
                    }
                } else {
                    String sort = (String)sortObj;
                    String order = "desc".equalsIgnoreCase(orderParam) ? "desc" : "asc";
                    GrailsHibernateQueryUtils.addOrderPossiblyNested(query, (From)queryRoot, criteriaBuilder, entity, sort, order, ignoreCase);
                }
                break block8;
            }
            if (!useDefaultMapping || (m = AbstractGrailsDomainBinder.getMapping(entity.getJavaClass())) == null) break block8;
            Map sortMap = m.getSort().getNamesAndDirections();
            for (Object sort : sortMap.keySet()) {
                String order = "desc".equalsIgnoreCase((String)sortMap.get(sort)) ? "desc" : "asc";
                GrailsHibernateQueryUtils.addOrderPossiblyNested(query, (From)queryRoot, criteriaBuilder, entity, (String)sort, order, true);
            }
        }
    }

    public static void populateArgumentsForCriteria(PersistentEntity entity, Query query, Map argMap, ConversionService conversionService, boolean useDefaultMapping) {
        int offset;
        Integer maxParam = null;
        Integer offsetParam = null;
        if (argMap.containsKey("max")) {
            maxParam = (Integer)conversionService.convert(argMap.get("max"), Integer.class);
        }
        if (argMap.containsKey("offset")) {
            offsetParam = (Integer)conversionService.convert(argMap.get("offset"), Integer.class);
        }
        if (argMap.containsKey("fetchSize")) {
            query.setFetchSize(((Integer)conversionService.convert(argMap.get("fetchSize"), Integer.class)).intValue());
        }
        if (argMap.containsKey("timeout")) {
            query.setTimeout(((Integer)conversionService.convert(argMap.get("timeout"), Integer.class)).intValue());
        }
        if (argMap.containsKey("flushMode")) {
            query.setHibernateFlushMode(GrailsHibernateQueryUtils.convertFlushMode(argMap.get("flushMode")));
        }
        if (argMap.containsKey("readOnly")) {
            query.setReadOnly(ClassUtils.getBooleanFromMap((String)"readOnly", (Map)argMap));
        }
        int max = maxParam == null ? -1 : maxParam;
        int n = offset = offsetParam == null ? -1 : offsetParam;
        if (max > -1) {
            query.setMaxResults(max);
        }
        if (offset > -1) {
            query.setFirstResult(offset);
        }
        if (ClassUtils.getBooleanFromMap((String)"lock", (Map)argMap)) {
            query.setLockMode(LockModeType.PESSIMISTIC_WRITE);
            query.setCacheable(false);
        } else if (argMap.containsKey("cache")) {
            query.setCacheable(ClassUtils.getBooleanFromMap((String)"cache", (Map)argMap));
        } else {
            GrailsHibernateQueryUtils.cacheCriteriaByMapping(entity.getJavaClass(), query);
        }
    }

    private static void addOrderPossiblyNested(Criteria c, PersistentEntity entity, String sort, String order, boolean ignoreCase) {
        int firstDotPos = sort.indexOf(".");
        if (firstDotPos == -1) {
            GrailsHibernateQueryUtils.addOrder(c, sort, order, ignoreCase);
        } else {
            String sortHead = sort.substring(0, firstDotPos);
            String sortTail = sort.substring(firstDotPos + 1);
            PersistentProperty property = entity.getPropertyByName(sortHead);
            if (property instanceof Embedded) {
                GrailsHibernateQueryUtils.addOrder(c, sort, order, ignoreCase);
            } else if (property instanceof Association) {
                Association a = (Association)property;
                Criteria subCriteria = c.createCriteria(sortHead);
                PersistentEntity associatedEntity = a.getAssociatedEntity();
                Class propertyTargetClass = associatedEntity.getJavaClass();
                GrailsHibernateQueryUtils.cacheCriteriaByMapping(propertyTargetClass, subCriteria);
                GrailsHibernateQueryUtils.addOrderPossiblyNested(subCriteria, associatedEntity, sortTail, order, ignoreCase);
            }
        }
    }

    private static void addOrderPossiblyNested(CriteriaQuery query, From queryRoot, CriteriaBuilder criteriaBuilder, PersistentEntity entity, String sort, String order, boolean ignoreCase) {
        int firstDotPos;
        if (ignoreCase && entity.getPropertyByName(sort).getType() != String.class) {
            ignoreCase = false;
        }
        if ((firstDotPos = sort.indexOf(".")) == -1) {
            GrailsHibernateQueryUtils.addOrder(entity, query, queryRoot, criteriaBuilder, sort, order, ignoreCase);
        } else {
            String sortHead = sort.substring(0, firstDotPos);
            String sortTail = sort.substring(firstDotPos + 1);
            PersistentProperty property = entity.getPropertyByName(sortHead);
            if (property instanceof Embedded) {
                GrailsHibernateQueryUtils.addOrder(entity, query, queryRoot, criteriaBuilder, sort, order, ignoreCase);
            } else if (property instanceof Association) {
                Association a = (Association)property;
                Join join = queryRoot.join(sortHead);
                PersistentEntity associatedEntity = a.getAssociatedEntity();
                Class propertyTargetClass = associatedEntity.getJavaClass();
                GrailsHibernateQueryUtils.addOrderPossiblyNested(query, (From)join, criteriaBuilder, associatedEntity, sortTail, order, ignoreCase);
            }
        }
    }

    private static void addOrder(PersistentEntity entity, CriteriaQuery query, From queryRoot, CriteriaBuilder criteriaBuilder, String sort, String order, boolean ignoreCase) {
        if (sort.equalsIgnoreCase(entity.getIdentity().getName())) {
            From path = queryRoot;
            if (ignoreCase) {
                path = criteriaBuilder.upper((Expression)path);
            }
            if ("desc".equals(order)) {
                query.orderBy(new Order[]{criteriaBuilder.desc((Expression)path)});
            } else {
                query.orderBy(new Order[]{criteriaBuilder.asc((Expression)path)});
            }
        } else {
            Path path = queryRoot.get(sort);
            if (ignoreCase) {
                path = criteriaBuilder.upper((Expression)path);
            }
            if ("desc".equals(order)) {
                query.orderBy(new Order[]{criteriaBuilder.desc((Expression)path)});
            } else {
                query.orderBy(new Order[]{criteriaBuilder.asc((Expression)path)});
            }
        }
    }

    private static void cacheCriteriaByMapping(Class<?> targetClass, Criteria criteria) {
        Mapping m = AbstractGrailsDomainBinder.getMapping(targetClass);
        if (m != null && m.getCache() != null && m.getCache().getEnabled()) {
            criteria.setCacheable(true);
        }
    }

    private static void cacheCriteriaByMapping(Class<?> targetClass, Query criteria) {
        Mapping m = AbstractGrailsDomainBinder.getMapping(targetClass);
        if (m != null && m.getCache() != null && m.getCache().getEnabled()) {
            criteria.setCacheable(true);
        }
    }

    private static FlushMode convertFlushMode(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof FlushMode) {
            return (FlushMode)object;
        }
        try {
            return FlushMode.valueOf((String)object.toString());
        }
        catch (IllegalArgumentException e) {
            return FlushMode.COMMIT;
        }
    }

    private static void addOrder(Criteria c, String sort, String order, boolean ignoreCase) {
        if ("desc".equals(order)) {
            c.addOrder(ignoreCase ? org.hibernate.criterion.Order.desc((String)sort).ignoreCase() : org.hibernate.criterion.Order.desc((String)sort));
        } else {
            c.addOrder(ignoreCase ? org.hibernate.criterion.Order.asc((String)sort).ignoreCase() : org.hibernate.criterion.Order.asc((String)sort));
        }
    }

    public static FetchMode getFetchMode(Object object) {
        String name;
        String string = name = object != null ? object.toString() : "default";
        if (name.equalsIgnoreCase(FetchMode.JOIN.toString()) || name.equalsIgnoreCase("eager")) {
            return FetchMode.JOIN;
        }
        if (name.equalsIgnoreCase(FetchMode.SELECT.toString()) || name.equalsIgnoreCase("lazy")) {
            return FetchMode.SELECT;
        }
        return FetchMode.DEFAULT;
    }
}

