/*
 * Decompiled with CFR 0.152.
 */
package org.grails.orm.hibernate;

import groovy.lang.Closure;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.PersistenceException;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import javax.sql.DataSource;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.grails.orm.hibernate.HibernateDatastore;
import org.grails.orm.hibernate.IHibernateTemplate;
import org.hibernate.Criteria;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.engine.jdbc.connections.internal.DatasourceConnectionProviderImpl;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.exception.GenericJDBCException;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.orm.hibernate5.SessionFactoryUtils;
import org.springframework.orm.hibernate5.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public class GrailsHibernateTemplate
implements IHibernateTemplate {
    private static final Logger LOG = LoggerFactory.getLogger(GrailsHibernateTemplate.class);
    private boolean osivReadOnly;
    private boolean passReadOnlyToHibernate = false;
    protected boolean exposeNativeSession = true;
    protected boolean cacheQueries = false;
    protected SessionFactory sessionFactory;
    protected DataSource dataSource = null;
    protected SQLExceptionTranslator jdbcExceptionTranslator;
    protected int flushMode = 1;
    private boolean applyFlushModeOnlyToNonExistingTransactions = false;
    public static final int FLUSH_NEVER = 0;
    public static final int FLUSH_AUTO = 1;
    public static final int FLUSH_EAGER = 2;
    public static final int FLUSH_COMMIT = 3;
    public static final int FLUSH_ALWAYS = 4;

    protected GrailsHibernateTemplate() {
    }

    public GrailsHibernateTemplate(SessionFactory sessionFactory) {
        Assert.notNull((Object)sessionFactory, (String)"Property 'sessionFactory' is required");
        this.sessionFactory = sessionFactory;
        ConnectionProvider connectionProvider = (ConnectionProvider)((SessionFactoryImplementor)sessionFactory).getServiceRegistry().getService(ConnectionProvider.class);
        if (connectionProvider instanceof DatasourceConnectionProviderImpl) {
            this.dataSource = ((DatasourceConnectionProviderImpl)connectionProvider).getDataSource();
            if (this.dataSource instanceof TransactionAwareDataSourceProxy) {
                this.dataSource = ((TransactionAwareDataSourceProxy)this.dataSource).getTargetDataSource();
            }
            this.jdbcExceptionTranslator = new SQLErrorCodeSQLExceptionTranslator(this.dataSource);
        } else {
            SQLErrorCodeSQLExceptionTranslator sqlErrorCodeSQLExceptionTranslator = new SQLErrorCodeSQLExceptionTranslator();
            sqlErrorCodeSQLExceptionTranslator.setDatabaseProductName("H2");
            this.jdbcExceptionTranslator = sqlErrorCodeSQLExceptionTranslator;
        }
    }

    public GrailsHibernateTemplate(SessionFactory sessionFactory, HibernateDatastore datastore) {
        this(sessionFactory, datastore, datastore.getDefaultFlushMode());
    }

    public GrailsHibernateTemplate(SessionFactory sessionFactory, HibernateDatastore datastore, int defaultFlushMode) {
        this(sessionFactory);
        if (datastore != null) {
            this.cacheQueries = datastore.isCacheQueries();
            this.osivReadOnly = datastore.isOsivReadOnly();
            this.passReadOnlyToHibernate = datastore.isPassReadOnlyToHibernate();
        }
        this.flushMode = defaultFlushMode;
    }

    @Override
    public <T> T execute(Closure<T> callable) {
        HibernateCallback hibernateCallback = (HibernateCallback)DefaultGroovyMethods.asType(callable, HibernateCallback.class);
        return this.execute(hibernateCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T executeWithNewSession(Closure<T> callable) {
        SessionHolder sessionHolder;
        SessionHolder previousHolder = sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource((Object)this.sessionFactory);
        ConnectionHolder previousConnectionHolder = (ConnectionHolder)TransactionSynchronizationManager.getResource((Object)this.dataSource);
        Session newSession = null;
        boolean previousActiveSynchronization = TransactionSynchronizationManager.isSynchronizationActive();
        List transactionSynchronizations = previousActiveSynchronization ? TransactionSynchronizationManager.getSynchronizations() : null;
        try {
            if (previousActiveSynchronization) {
                TransactionSynchronizationManager.clearSynchronization();
                TransactionSynchronizationManager.initSynchronization();
            }
            if (sessionHolder != null) {
                TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
                if (previousConnectionHolder != null) {
                    TransactionSynchronizationManager.unbindResource((Object)this.dataSource);
                }
            }
            newSession = this.sessionFactory.openSession();
            this.applyFlushMode(newSession, false);
            sessionHolder = new SessionHolder(newSession);
            TransactionSynchronizationManager.bindResource((Object)this.sessionFactory, (Object)sessionHolder);
            Object object = this.execute(arg_0 -> callable.call(arg_0));
            return (T)object;
        }
        finally {
            try {
                if (TransactionSynchronizationManager.isSynchronizationActive()) {
                    TransactionSynchronizationManager.clearSynchronization();
                }
                if (newSession != null) {
                    SessionFactoryUtils.closeSession((Session)newSession);
                }
                TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
                ConnectionHolder connectionHolder = (ConnectionHolder)TransactionSynchronizationManager.unbindResourceIfPossible((Object)this.dataSource);
                try {
                    if (connectionHolder != null && !connectionHolder.getConnection().isClosed()) {
                        Connection conn = connectionHolder.getConnection();
                        DataSourceUtils.releaseConnection((Connection)conn, (DataSource)this.dataSource);
                    }
                }
                catch (SQLException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Could not close opened JDBC connection. Did the application close the connection manually?: " + e.getMessage());
                    }
                }
            }
            finally {
                if (previousActiveSynchronization) {
                    TransactionSynchronizationManager.initSynchronization();
                    for (TransactionSynchronization transactionSynchronization : transactionSynchronizations) {
                        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)transactionSynchronization);
                    }
                }
                if (previousHolder != null) {
                    TransactionSynchronizationManager.bindResource((Object)this.sessionFactory, (Object)previousHolder);
                    if (previousConnectionHolder != null) {
                        TransactionSynchronizationManager.bindResource((Object)this.dataSource, (Object)previousConnectionHolder);
                    }
                }
            }
        }
    }

    @Override
    public <T1> T1 executeWithExistingOrCreateNewSession(SessionFactory sessionFactory, Closure<T1> callable) {
        SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource((Object)sessionFactory);
        if (sessionHolder == null) {
            return this.executeWithNewSession(callable);
        }
        return (T1)callable.call((Object)sessionHolder.getSession());
    }

    @Override
    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public void applySettings(Query query) {
        if (this.exposeNativeSession) {
            this.prepareQuery(query);
        }
    }

    @Override
    public void applySettings(Criteria criteria) {
        if (this.exposeNativeSession) {
            this.prepareCriteria(criteria);
        }
    }

    public void setCacheQueries(boolean cacheQueries) {
        this.cacheQueries = cacheQueries;
    }

    public boolean isCacheQueries() {
        return this.cacheQueries;
    }

    public <T> T execute(HibernateCallback<T> action) throws DataAccessException {
        return this.doExecute(action, false);
    }

    public List<?> executeFind(HibernateCallback<?> action) throws DataAccessException {
        Object result = this.doExecute(action, false);
        if (result != null && !(result instanceof List)) {
            throw new InvalidDataAccessApiUsageException("Result object returned from HibernateCallback isn't a List: [" + result + "]");
        }
        return (List)result;
    }

    protected boolean shouldPassReadOnlyToHibernate() {
        if ((this.passReadOnlyToHibernate || this.osivReadOnly) && TransactionSynchronizationManager.hasResource((Object)this.getSessionFactory())) {
            if (TransactionSynchronizationManager.isActualTransactionActive()) {
                return this.passReadOnlyToHibernate && TransactionSynchronizationManager.isCurrentTransactionReadOnly();
            }
            return this.osivReadOnly;
        }
        return false;
    }

    public boolean isOsivReadOnly() {
        return this.osivReadOnly;
    }

    public void setOsivReadOnly(boolean osivReadOnly) {
        this.osivReadOnly = osivReadOnly;
    }

    protected <T> T doExecute(HibernateCallback<T> action, boolean enforceNativeSession) throws DataAccessException {
        Assert.notNull(action, (String)"Callback object must not be null");
        Session session = this.getSession();
        boolean existingTransaction = this.isSessionTransactional(session);
        if (existingTransaction) {
            LOG.debug("Found thread-bound Session for HibernateTemplate");
        }
        FlushMode previousFlushMode = null;
        try {
            previousFlushMode = this.applyFlushMode(session, existingTransaction);
            if (this.shouldPassReadOnlyToHibernate()) {
                session.setDefaultReadOnly(true);
            }
            Session sessionToExpose = enforceNativeSession || this.exposeNativeSession ? session : this.createSessionProxy(session);
            T result = action.doInHibernate(sessionToExpose);
            this.flushIfNecessary(session, existingTransaction);
            T t = result;
            return t;
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
        catch (PersistenceException ex) {
            if (ex.getCause() instanceof HibernateException) {
                throw SessionFactoryUtils.convertHibernateAccessException((HibernateException)((HibernateException)ex.getCause()));
            }
            throw ex;
        }
        catch (SQLException ex) {
            throw this.jdbcExceptionTranslator.translate("Hibernate-related JDBC operation", null, ex);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            if (existingTransaction) {
                LOG.debug("Not closing pre-bound Hibernate Session after HibernateTemplate");
                if (previousFlushMode != null) {
                    session.setHibernateFlushMode(previousFlushMode);
                }
            } else {
                SessionFactoryUtils.closeSession((Session)session);
            }
        }
    }

    protected boolean isSessionTransactional(Session session) {
        SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource((Object)this.sessionFactory);
        return sessionHolder != null && sessionHolder.getSession() == session;
    }

    protected Session getSession() {
        try {
            return this.sessionFactory.getCurrentSession();
        }
        catch (HibernateException ex) {
            throw new DataAccessResourceFailureException("Could not obtain current Hibernate Session", (Throwable)ex);
        }
    }

    protected Session createSessionProxy(Session session) {
        Class<Session> mainIfc = Session.class;
        Class[] sessionIfcs = session instanceof EventSource ? new Class[]{mainIfc, EventSource.class} : (session instanceof SessionImplementor ? new Class[]{mainIfc, SessionImplementor.class} : new Class[]{mainIfc});
        return (Session)Proxy.newProxyInstance(session.getClass().getClassLoader(), sessionIfcs, (InvocationHandler)new CloseSuppressingInvocationHandler(session));
    }

    @Override
    public <T> T get(Class<T> entityClass, Serializable id) throws DataAccessException {
        return (T)this.doExecute(session -> session.get(entityClass, id), true);
    }

    @Override
    public <T> T get(Class<T> entityClass, Serializable id, LockMode mode) {
        return this.lock(entityClass, id, mode);
    }

    @Override
    public void delete(Object entity) throws DataAccessException {
        this.doExecute(session -> {
            session.delete(entity);
            return null;
        }, true);
    }

    public void flush(Object entity) throws DataAccessException {
        this.doExecute(session -> {
            session.flush();
            return null;
        }, true);
    }

    @Override
    public <T> T load(Class<T> entityClass, Serializable id) throws DataAccessException {
        return (T)this.doExecute(session -> session.load(entityClass, id), true);
    }

    public <T> T lock(Class<T> entityClass, Serializable id, LockMode lockMode) throws DataAccessException {
        return (T)this.doExecute(session -> session.get(entityClass, id, new LockOptions(lockMode)), true);
    }

    public <T> List<T> loadAll(Class<T> entityClass) throws DataAccessException {
        return this.doExecute(session -> {
            CriteriaBuilder criteriaBuilder = session.getCriteriaBuilder();
            CriteriaQuery query = criteriaBuilder.createQuery(entityClass);
            Root root = query.from(entityClass);
            Query jpaQuery = session.createQuery(query);
            this.prepareCriteria(jpaQuery);
            return jpaQuery.getResultList();
        }, true);
    }

    @Override
    public boolean contains(Object entity) throws DataAccessException {
        return this.doExecute(session -> session.contains(entity), true);
    }

    @Override
    public void evict(Object entity) throws DataAccessException {
        this.doExecute(session -> {
            session.evict(entity);
            return null;
        }, true);
    }

    @Override
    public void lock(Object entity, LockMode lockMode) throws DataAccessException {
        this.doExecute(session -> {
            session.buildLockRequest(new LockOptions(lockMode)).lock(entity);
            return null;
        }, true);
    }

    @Override
    public void refresh(Object entity) throws DataAccessException {
        this.refresh(entity, null);
    }

    public void refresh(Object entity, LockMode lockMode) throws DataAccessException {
        this.doExecute(session -> {
            if (lockMode == null) {
                session.refresh(entity);
            } else {
                session.refresh(entity, new LockOptions(lockMode));
            }
            return null;
        }, true);
    }

    public void setExposeNativeSession(boolean exposeNativeSession) {
        this.exposeNativeSession = exposeNativeSession;
    }

    public boolean isExposeNativeSession() {
        return this.exposeNativeSession;
    }

    protected void prepareQuery(Query query) {
        SessionHolder sessionHolder;
        if (this.cacheQueries) {
            query.setCacheable(true);
        }
        if (this.shouldPassReadOnlyToHibernate()) {
            query.setReadOnly(true);
        }
        if ((sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource((Object)this.sessionFactory)) != null && sessionHolder.hasTimeout()) {
            query.setTimeout(sessionHolder.getTimeToLiveInSeconds());
        }
    }

    @Deprecated
    protected void prepareCriteria(Criteria criteria) {
        SessionHolder sessionHolder;
        if (this.cacheQueries) {
            criteria.setCacheable(true);
        }
        if (this.shouldPassReadOnlyToHibernate()) {
            criteria.setReadOnly(true);
        }
        if ((sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource((Object)this.sessionFactory)) != null && sessionHolder.hasTimeout()) {
            criteria.setTimeout(sessionHolder.getTimeToLiveInSeconds());
        }
    }

    protected <T> void prepareCriteria(Query<T> jpaQuery) {
        SessionHolder sessionHolder;
        if (this.cacheQueries) {
            jpaQuery.setCacheable(true);
        }
        if (this.shouldPassReadOnlyToHibernate()) {
            jpaQuery.setReadOnly(true);
        }
        if ((sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource((Object)this.sessionFactory)) != null && sessionHolder.hasTimeout()) {
            jpaQuery.setTimeout(sessionHolder.getTimeToLiveInSeconds());
        }
    }

    @Override
    public void setFlushMode(int flushMode) {
        this.flushMode = flushMode;
    }

    @Override
    public int getFlushMode() {
        return this.flushMode;
    }

    protected FlushMode applyFlushMode(Session session, boolean existingTransaction) {
        if (this.isApplyFlushModeOnlyToNonExistingTransactions() && existingTransaction) {
            return null;
        }
        if (this.getFlushMode() == 0) {
            if (existingTransaction) {
                FlushMode previousFlushMode = session.getHibernateFlushMode();
                if (!previousFlushMode.lessThan(FlushMode.COMMIT)) {
                    session.setHibernateFlushMode(FlushMode.MANUAL);
                    return previousFlushMode;
                }
            } else {
                session.setHibernateFlushMode(FlushMode.MANUAL);
            }
        } else if (this.getFlushMode() == 2) {
            FlushMode previousFlushMode;
            if (existingTransaction && !(previousFlushMode = session.getHibernateFlushMode()).equals((Object)FlushMode.AUTO)) {
                session.setHibernateFlushMode(FlushMode.AUTO);
                return previousFlushMode;
            }
        } else if (this.getFlushMode() == 3) {
            if (existingTransaction) {
                FlushMode previousFlushMode = session.getHibernateFlushMode();
                if (previousFlushMode.equals((Object)FlushMode.AUTO) || previousFlushMode.equals((Object)FlushMode.ALWAYS)) {
                    session.setHibernateFlushMode(FlushMode.COMMIT);
                    return previousFlushMode;
                }
            } else {
                session.setHibernateFlushMode(FlushMode.COMMIT);
            }
        } else if (this.getFlushMode() == 4) {
            if (existingTransaction) {
                FlushMode previousFlushMode = session.getHibernateFlushMode();
                if (!previousFlushMode.equals((Object)FlushMode.ALWAYS)) {
                    session.setHibernateFlushMode(FlushMode.ALWAYS);
                    return previousFlushMode;
                }
            } else {
                session.setHibernateFlushMode(FlushMode.ALWAYS);
            }
        }
        return null;
    }

    protected void flushIfNecessary(Session session, boolean existingTransaction) throws HibernateException {
        if (this.getFlushMode() == 2 || !existingTransaction && this.getFlushMode() != 0) {
            LOG.debug("Eagerly flushing Hibernate session");
            session.flush();
        }
    }

    protected DataAccessException convertHibernateAccessException(HibernateException ex) {
        if (ex instanceof JDBCException) {
            return this.convertJdbcAccessException((JDBCException)ex, this.jdbcExceptionTranslator);
        }
        if (GenericJDBCException.class.equals(((Object)((Object)ex)).getClass())) {
            return this.convertJdbcAccessException((JDBCException)((GenericJDBCException)ex), this.jdbcExceptionTranslator);
        }
        return SessionFactoryUtils.convertHibernateAccessException((HibernateException)ex);
    }

    protected DataAccessException convertJdbcAccessException(JDBCException ex, SQLExceptionTranslator translator) {
        String msg = ex.getMessage();
        String sql = ex.getSQL();
        SQLException sqlException = ex.getSQLException();
        return translator.translate("Hibernate operation: " + msg, sql, sqlException);
    }

    @Override
    public Serializable save(Object o) {
        return this.sessionFactory.getCurrentSession().save(o);
    }

    @Override
    public void flush() {
        this.sessionFactory.getCurrentSession().flush();
    }

    @Override
    public void clear() {
        this.sessionFactory.getCurrentSession().clear();
    }

    @Override
    public void deleteAll(Collection<?> objects) {
        this.execute((Session session) -> {
            for (Object entity : this.getIterableAsCollection(objects)) {
                session.delete(entity);
            }
            return null;
        });
    }

    protected Collection getIterableAsCollection(Iterable objects) {
        ArrayList list;
        if (objects instanceof Collection) {
            list = (ArrayList)objects;
        } else {
            list = new ArrayList();
            for (Object object : objects) {
                list.add(object);
            }
        }
        return list;
    }

    public boolean isApplyFlushModeOnlyToNonExistingTransactions() {
        return this.applyFlushModeOnlyToNonExistingTransactions;
    }

    public void setApplyFlushModeOnlyToNonExistingTransactions(boolean applyFlushModeOnlyToNonExistingTransactions) {
        this.applyFlushModeOnlyToNonExistingTransactions = applyFlushModeOnlyToNonExistingTransactions;
    }

    protected class CloseSuppressingInvocationHandler
    implements InvocationHandler {
        protected final Session target;

        protected CloseSuppressingInvocationHandler(Session target) {
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0];
            }
            if (method.getName().equals("hashCode")) {
                return System.identityHashCode(proxy);
            }
            if (method.getName().equals("close")) {
                return null;
            }
            try {
                Object retVal = method.invoke((Object)this.target, args);
                if (retVal instanceof Query) {
                    GrailsHibernateTemplate.this.prepareQuery((Query)retVal);
                }
                if (retVal instanceof Criteria) {
                    GrailsHibernateTemplate.this.prepareCriteria((Criteria)retVal);
                } else if (retVal instanceof Query) {
                    GrailsHibernateTemplate.this.prepareCriteria((Query)retVal);
                }
                return retVal;
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }

    public static interface HibernateCallback<T> {
        public T doInHibernate(Session var1) throws HibernateException, SQLException;
    }
}

