/*
 * Decompiled with CFR 0.152.
 */
package org.grails.orm.hibernate.proxy;

import grails.util.CollectionUtils;
import groovy.lang.GroovyObject;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import org.apache.commons.logging.LogFactory;
import org.grails.datastore.mapping.proxy.EntityProxy;
import org.grails.datastore.mapping.proxy.EntityProxyMethodHandler;
import org.grails.orm.hibernate.cfg.HibernateUtils;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.proxy.pojo.BasicLazyInitializer;
import org.hibernate.proxy.pojo.javassist.SerializableProxy;
import org.hibernate.type.CompositeType;

public class GroovyAwareJavassistLazyInitializer
extends BasicLazyInitializer
implements MethodHandler {
    private static final String WRITE_CLASSES_DIRECTORY = System.getProperty("javassist.writeDirectory");
    private static final Set<String> GROOVY_METHODS = CollectionUtils.newSet((Object[])new String[]{"$getStaticMetaClass"});
    private static final MethodFilter METHOD_FILTERS = new MethodFilter(){

        public boolean isHandled(Method m) {
            return m.getName().indexOf("super$") == -1 && !GROOVY_METHODS.contains(m.getName()) && (m.getParameterTypes().length != 0 || !m.getName().equals("finalize"));
        }
    };
    private Class<?>[] interfaces;
    private boolean constructed = false;
    HibernateGroovyObjectMethodHandler groovyObjectMethodHandler;

    protected GroovyAwareJavassistLazyInitializer(String entityName, Class<?> persistentClass, Class<?>[] interfaces, Serializable id, Method getIdentifierMethod, Method setIdentifierMethod, CompositeType componentIdType, SessionImplementor session, boolean overridesEquals) {
        super(entityName, persistentClass, id, getIdentifierMethod, setIdentifierMethod, componentIdType, session, overridesEquals);
        this.interfaces = interfaces;
    }

    public static HibernateProxy getProxy(String entityName, Class<?> persistentClass, Class<?>[] interfaces, Method getIdentifierMethod, Method setIdentifierMethod, CompositeType componentIdType, Serializable id, SessionImplementor session) throws HibernateException {
        GroovyAwareJavassistLazyInitializer instance = new GroovyAwareJavassistLazyInitializer(entityName, persistentClass, interfaces, id, getIdentifierMethod, setIdentifierMethod, componentIdType, session, ReflectHelper.overridesEquals(persistentClass));
        return GroovyAwareJavassistLazyInitializer.createProxyInstance(GroovyAwareJavassistLazyInitializer.getProxyFactory(persistentClass, interfaces), instance);
    }

    protected static HibernateProxy createProxyInstance(Class<?> proxyClass, GroovyAwareJavassistLazyInitializer instance) {
        HibernateProxy proxy;
        try {
            proxy = (HibernateProxy)proxyClass.newInstance();
        }
        catch (Exception e) {
            throw new HibernateException("Javassist Enhancement failed: " + proxyClass.getName(), (Throwable)e);
        }
        ((ProxyObject)proxy).setHandler((MethodHandler)instance);
        instance.groovyObjectMethodHandler = new HibernateGroovyObjectMethodHandler(proxyClass, proxy, (LazyInitializer)instance);
        instance.constructed = true;
        return proxy;
    }

    public static HibernateProxy getProxy(Class<?> factory, String entityName, Class<?> persistentClass, Class<?>[] interfaces, Method getIdentifierMethod, Method setIdentifierMethod, CompositeType componentIdType, Serializable id, SessionImplementor session) throws HibernateException {
        GroovyAwareJavassistLazyInitializer instance = new GroovyAwareJavassistLazyInitializer(entityName, persistentClass, interfaces, id, getIdentifierMethod, setIdentifierMethod, componentIdType, session, ReflectHelper.overridesEquals(persistentClass));
        return GroovyAwareJavassistLazyInitializer.createProxyInstance(factory, instance);
    }

    public static Class<?> getProxyFactory(Class<?> persistentClass, Class<?>[] interfaces) throws HibernateException {
        try {
            HashSet allInterfaces = new HashSet();
            if (interfaces != null) {
                allInterfaces.addAll(Arrays.asList(interfaces));
            }
            allInterfaces.add(GroovyObject.class);
            allInterfaces.add(EntityProxy.class);
            ProxyFactory factory = GroovyAwareJavassistLazyInitializer.createProxyFactory(persistentClass, allInterfaces.toArray(new Class[allInterfaces.size()]));
            Class proxyClass = factory.createClass();
            HibernateUtils.enhanceProxyClass(proxyClass);
            return proxyClass;
        }
        catch (Throwable t) {
            LogFactory.getLog(BasicLazyInitializer.class).error((Object)("Javassist Enhancement failed: " + persistentClass.getName()), t);
            throw new HibernateException("Javassist Enhancement failed: " + persistentClass.getName(), t);
        }
    }

    private static ProxyFactory createProxyFactory(Class<?> persistentClass, Class<?>[] interfaces) {
        ProxyFactory factory = new ProxyFactory();
        factory.setSuperclass(persistentClass);
        factory.setInterfaces((Class[])interfaces);
        factory.setFilter(METHOD_FILTERS);
        factory.setUseCache(true);
        if (WRITE_CLASSES_DIRECTORY != null) {
            factory.writeDirectory = WRITE_CLASSES_DIRECTORY;
        }
        return factory;
    }

    public Object invoke(Object proxy, Method thisMethod, Method proceed, Object[] args) throws Throwable {
        if (thisMethod.getName().equals("getHibernateLazyInitializer")) {
            return this;
        }
        Object result = this.groovyObjectMethodHandler.handleInvocation(proxy, thisMethod, args);
        if (this.groovyObjectMethodHandler.wasHandled(result)) {
            return result;
        }
        if (this.constructed) {
            try {
                result = this.invoke(thisMethod, args, proxy);
            }
            catch (Throwable t) {
                throw new Exception(t.getCause());
            }
            if (result == INVOKE_IMPLEMENTATION) {
                Object target = this.getImplementation();
                try {
                    Object returnValue;
                    if (ReflectHelper.isPublic((Class)this.persistentClass, (Member)thisMethod)) {
                        if (!thisMethod.getDeclaringClass().isInstance(target)) {
                            throw new ClassCastException(target.getClass().getName());
                        }
                        returnValue = thisMethod.invoke(target, args);
                    } else {
                        if (!thisMethod.isAccessible()) {
                            thisMethod.setAccessible(true);
                        }
                        returnValue = thisMethod.invoke(target, args);
                    }
                    return returnValue == target ? proxy : returnValue;
                }
                catch (InvocationTargetException ite) {
                    throw ite.getTargetException();
                }
            }
            return result;
        }
        return proceed.invoke(proxy, args);
    }

    protected Object serializableProxy() {
        return new SerializableProxy(this.getEntityName(), this.persistentClass, (Class[])this.interfaces, this.getIdentifier(), Boolean.valueOf(false), this.getIdentifierMethod, this.setIdentifierMethod, this.componentIdType);
    }

    private static class HibernateGroovyObjectMethodHandler
    extends EntityProxyMethodHandler {
        private Object target;
        private final Object originalSelf;
        private final LazyInitializer lazyInitializer;

        public HibernateGroovyObjectMethodHandler(Class<?> proxyClass, Object originalSelf, LazyInitializer lazyInitializer) {
            super(proxyClass);
            this.originalSelf = originalSelf;
            this.lazyInitializer = lazyInitializer;
        }

        protected Object resolveDelegate(Object self) {
            if (self != this.originalSelf) {
                throw new IllegalStateException("self instance has changed.");
            }
            if (this.target == null) {
                this.target = this.lazyInitializer.getImplementation();
            }
            return this.target;
        }

        protected Object isProxyInitiated(Object self) {
            return this.target != null;
        }

        protected Object getProxyKey(Object self) {
            return this.lazyInitializer.getIdentifier();
        }
    }
}

