/*
 * Decompiled with CFR 0.152.
 */
package org.grails.orm.hibernate.cfg;

import groovy.lang.Closure;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.grails.datastore.mapping.config.Property;
import org.grails.datastore.mapping.model.DatastoreConfigurationException;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.types.Association;
import org.grails.datastore.mapping.model.types.Basic;
import org.grails.datastore.mapping.model.types.Embedded;
import org.grails.datastore.mapping.model.types.ManyToMany;
import org.grails.datastore.mapping.model.types.OneToMany;
import org.grails.datastore.mapping.model.types.OneToOne;
import org.grails.datastore.mapping.model.types.ToMany;
import org.grails.datastore.mapping.model.types.ToOne;
import org.grails.datastore.mapping.reflect.NameUtils;
import org.grails.orm.hibernate.cfg.CacheConfig;
import org.grails.orm.hibernate.cfg.CollectionType;
import org.grails.orm.hibernate.cfg.ColumnConfig;
import org.grails.orm.hibernate.cfg.CompositeIdentity;
import org.grails.orm.hibernate.cfg.GrailsHibernateUtil;
import org.grails.orm.hibernate.cfg.HibernateMappingContext;
import org.grails.orm.hibernate.cfg.HibernatePersistentEntity;
import org.grails.orm.hibernate.cfg.HibernateUtils;
import org.grails.orm.hibernate.cfg.Identity;
import org.grails.orm.hibernate.cfg.IdentityEnumType;
import org.grails.orm.hibernate.cfg.JoinTable;
import org.grails.orm.hibernate.cfg.Mapping;
import org.grails.orm.hibernate.cfg.NaturalId;
import org.grails.orm.hibernate.cfg.PersistentEntityNamingStrategy;
import org.grails.orm.hibernate.cfg.PropertyConfig;
import org.grails.orm.hibernate.persister.entity.GroovyAwareJoinedSubclassEntityPersister;
import org.grails.orm.hibernate.persister.entity.GroovyAwareSingleTableEntityPersister;
import org.hibernate.FetchMode;
import org.hibernate.MappingException;
import org.hibernate.boot.internal.ClassLoaderAccessImpl;
import org.hibernate.boot.internal.MetadataBuildingContextRootImpl;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.ClassLoaderAccess;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.MetadataBuildingOptions;
import org.hibernate.boot.spi.MetadataContributor;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.ImprovedNamingStrategy;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.cfg.SecondPass;
import org.hibernate.mapping.Backref;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.IndexBackref;
import org.hibernate.mapping.IndexedCollection;
import org.hibernate.mapping.JoinedSubclass;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.List;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Set;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.SingleTableSubclass;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UnionSubclass;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.mapping.Value;
import org.hibernate.persister.entity.UnionSubclassEntityPersister;
import org.hibernate.type.BasicType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.IntegerType;
import org.hibernate.type.LongType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.TimestampType;
import org.jboss.jandex.IndexView;
import org.springframework.util.StringUtils;

public class GrailsDomainBinder
implements MetadataContributor {
    protected static final String CASCADE_ALL_DELETE_ORPHAN = "all-delete-orphan";
    protected static final String FOREIGN_KEY_SUFFIX = "_id";
    protected static final String STRING_TYPE = "string";
    protected static final String EMPTY_PATH = "";
    protected static final char UNDERSCORE = '_';
    protected static final String CASCADE_ALL = "all";
    protected static final String CASCADE_SAVE_UPDATE = "save-update";
    protected static final String CASCADE_NONE = "none";
    protected static final String BACKTICK = "`";
    protected static final java.util.Map<Class<?>, Mapping> MAPPING_CACHE = new HashMap();
    protected static final String ENUM_TYPE_CLASS = "org.hibernate.type.EnumType";
    protected static final String ENUM_CLASS_PROP = "enumClass";
    protected static final String ENUM_TYPE_PROP = "type";
    protected static final String DEFAULT_ENUM_TYPE = "default";
    protected static final Log LOG = LogFactory.getLog(GrailsDomainBinder.class);
    public static java.util.Map<String, NamingStrategy> NAMING_STRATEGIES = new HashMap<String, NamingStrategy>();
    protected final CollectionType CT = new CollectionType(null, this){

        @Override
        public org.hibernate.mapping.Collection create(ToMany property, PersistentClass owner, String path, InFlightMetadataCollector mappings, String sessionFactoryBeanName) {
            return null;
        }
    };
    protected final String sessionFactoryName;
    protected final HibernateMappingContext hibernateMappingContext;
    protected Closure defaultMapping;
    protected PersistentEntityNamingStrategy namingStrategy;
    protected MetadataBuildingContext metadataBuildingContext;

    public GrailsDomainBinder(String sessionFactoryName, HibernateMappingContext hibernateMappingContext) {
        this.sessionFactoryName = sessionFactoryName;
        this.hibernateMappingContext = hibernateMappingContext;
        for (PersistentEntity persistentEntity : hibernateMappingContext.getPersistentEntities()) {
            this.evaluateMapping(persistentEntity);
        }
    }

    public void setDefaultMapping(Closure defaultMapping) {
        this.defaultMapping = defaultMapping;
    }

    public void setNamingStrategy(PersistentEntityNamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    public void contribute(InFlightMetadataCollector metadataCollector, IndexView jandexIndex) {
        MetadataBuildingOptions options = metadataCollector.getMetadataBuildingOptions();
        ClassLoaderService classLoaderService = (ClassLoaderService)options.getServiceRegistry().getService(ClassLoaderService.class);
        ClassLoaderAccessImpl classLoaderAccess = new ClassLoaderAccessImpl(options.getTempClassLoader(), classLoaderService);
        this.metadataBuildingContext = new MetadataBuildingContextRootImpl(options, (ClassLoaderAccess)classLoaderAccess, metadataCollector);
        Collection persistentEntities = this.hibernateMappingContext.getPersistentEntities();
        for (PersistentEntity persistentEntity : persistentEntities) {
            if (!persistentEntity.isRoot()) continue;
            this.bindRoot((HibernatePersistentEntity)persistentEntity, metadataCollector, this.sessionFactoryName);
        }
    }

    public static void configureNamingStrategy(Object strategy) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        GrailsDomainBinder.configureNamingStrategy("DEFAULT", strategy);
    }

    public static void configureNamingStrategy(String datasourceName, Object strategy) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> namingStrategyClass = null;
        if (strategy instanceof Class) {
            namingStrategyClass = (Class<?>)strategy;
        } else if (strategy instanceof CharSequence) {
            namingStrategyClass = Thread.currentThread().getContextClassLoader().loadClass(strategy.toString());
        }
        NamingStrategy namingStrategy = namingStrategyClass == null ? (NamingStrategy)strategy : (NamingStrategy)namingStrategyClass.newInstance();
        NAMING_STRATEGIES.put(datasourceName, namingStrategy);
    }

    protected void bindMapSecondPass(ToMany property, InFlightMetadataCollector mappings, java.util.Map<?, ?> persistentClasses, Map map, String sessionFactoryBeanName) {
        this.bindCollectionSecondPass(property, mappings, persistentClasses, (org.hibernate.mapping.Collection)map, sessionFactoryBeanName);
        SimpleValue value = new SimpleValue((MetadataImplementor)mappings, map.getCollectionTable());
        this.bindSimpleValue(this.getIndexColumnType((PersistentProperty)property, STRING_TYPE), value, true, this.getIndexColumnName((PersistentProperty)property, sessionFactoryBeanName), mappings);
        PropertyConfig pc = this.getPropertyConfig((PersistentProperty)property);
        if (pc != null && pc.getIndexColumn() != null) {
            this.bindColumnConfigToColumn(this.getColumnForSimpleValue(value), this.getSingleColumnConfig(pc.getIndexColumn()));
        }
        if (!value.isTypeSpecified()) {
            throw new MappingException("map index element must specify a type: " + map.getRole());
        }
        map.setIndex((Value)value);
        if (!(property instanceof OneToMany) && !(property instanceof ManyToMany)) {
            SimpleValue elt = new SimpleValue((MetadataImplementor)mappings, map.getCollectionTable());
            map.setElement((Value)elt);
            String typeName = this.getTypeName((PersistentProperty)property, this.getPropertyConfig((PersistentProperty)property), GrailsDomainBinder.getMapping(property.getOwner()));
            if (typeName == null && property instanceof Basic) {
                Basic basic = (Basic)property;
                typeName = basic.getComponentType().getName();
            }
            if (typeName == null || typeName.equals(Object.class.getName())) {
                typeName = StandardBasicTypes.STRING.getName();
            }
            this.bindSimpleValue(typeName, elt, false, this.getMapElementName((PersistentProperty)property, sessionFactoryBeanName), mappings);
            elt.setTypeName(typeName);
        }
        map.setInverse(false);
    }

    protected ColumnConfig getSingleColumnConfig(PropertyConfig propertyConfig) {
        java.util.List columns;
        if (propertyConfig != null && (columns = propertyConfig.getColumns()) != null && !columns.isEmpty()) {
            return (ColumnConfig)columns.get(0);
        }
        return null;
    }

    protected void bindListSecondPass(ToMany property, InFlightMetadataCollector mappings, java.util.Map<?, ?> persistentClasses, List list, String sessionFactoryBeanName) {
        this.bindCollectionSecondPass(property, mappings, persistentClasses, (org.hibernate.mapping.Collection)list, sessionFactoryBeanName);
        String columnName = this.getIndexColumnName((PersistentProperty)property, sessionFactoryBeanName);
        boolean isManyToMany = property instanceof ManyToMany;
        if (isManyToMany && !property.isOwningSide()) {
            throw new MappingException("Invalid association [" + property + "]. List collection types only supported on the owning side of a many-to-many relationship.");
        }
        Table collectionTable = list.getCollectionTable();
        SimpleValue iv = new SimpleValue((MetadataImplementor)mappings, collectionTable);
        this.bindSimpleValue("integer", iv, true, columnName, mappings);
        iv.setTypeName("integer");
        list.setIndex((Value)iv);
        list.setBaseIndex(0);
        list.setInverse(false);
        Value v = list.getElement();
        v.createForeignKey();
        if (property.isBidirectional()) {
            String entityName;
            Value element = list.getElement();
            if (element instanceof ManyToOne) {
                ManyToOne manyToOne = (ManyToOne)element;
                entityName = manyToOne.getReferencedEntityName();
            } else {
                entityName = ((org.hibernate.mapping.OneToMany)element).getReferencedEntityName();
            }
            PersistentClass referenced = mappings.getEntityBinding(entityName);
            Class mappedClass = referenced.getMappedClass();
            Mapping m = GrailsDomainBinder.getMapping(mappedClass);
            boolean compositeIdProperty = this.isCompositeIdProperty(m, (PersistentProperty)property.getInverseSide());
            if (!compositeIdProperty) {
                Backref prop = new Backref();
                PersistentEntity owner = property.getOwner();
                prop.setEntityName(owner.getName());
                prop.setName('_' + this.addUnderscore(owner.getJavaClass().getSimpleName(), property.getName()) + "Backref");
                prop.setSelectable(false);
                prop.setUpdateable(false);
                if (isManyToMany) {
                    prop.setInsertable(false);
                }
                prop.setCollectionRole(list.getRole());
                prop.setValue((Value)list.getKey());
                DependantValue value = (DependantValue)prop.getValue();
                if (!property.isCircular()) {
                    value.setNullable(false);
                }
                value.setUpdateable(true);
                prop.setOptional(false);
                referenced.addProperty((org.hibernate.mapping.Property)prop);
            }
            if (!list.getKey().isNullable() && !list.isInverse() || compositeIdProperty) {
                IndexBackref ib = new IndexBackref();
                ib.setName('_' + property.getName() + "IndexBackref");
                ib.setUpdateable(false);
                ib.setSelectable(false);
                if (isManyToMany) {
                    ib.setInsertable(false);
                }
                ib.setCollectionRole(list.getRole());
                ib.setEntityName(list.getOwner().getEntityName());
                ib.setValue(list.getIndex());
                referenced.addProperty((org.hibernate.mapping.Property)ib);
            }
        }
    }

    protected void bindCollectionSecondPass(ToMany property, InFlightMetadataCollector mappings, java.util.Map<?, ?> persistentClasses, org.hibernate.mapping.Collection collection, String sessionFactoryBeanName) {
        boolean isManyToMany;
        CacheConfig cacheConfig;
        PersistentEntity referenced;
        PropertyConfig propConfig;
        PersistentClass associatedClass = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Mapping collection: " + collection.getRole() + " -> " + collection.getCollectionTable().getName()));
        }
        if ((propConfig = this.getPropertyConfig((PersistentProperty)property)) != null && StringUtils.hasText((String)propConfig.getSort())) {
            if (!property.isBidirectional() && property instanceof OneToMany) {
                throw new DatastoreConfigurationException("Default sort for associations [" + property.getOwner().getName() + "->" + property.getName() + "] are not supported with unidirectional one to many relationships.");
            }
            referenced = property.getAssociatedEntity();
            if (referenced != null) {
                PersistentProperty propertyToSortBy = referenced.getPropertyByName(propConfig.getSort());
                String associatedClassName = property.getAssociatedEntity().getName();
                associatedClass = (PersistentClass)persistentClasses.get(associatedClassName);
                if (associatedClass != null) {
                    collection.setOrderBy(this.buildOrderByClause(propertyToSortBy.getName(), associatedClass, collection.getRole(), propConfig.getOrder() != null ? propConfig.getOrder() : "asc"));
                }
            }
        }
        if (collection.isOneToMany()) {
            org.hibernate.mapping.OneToMany oneToMany;
            String associatedClassName;
            boolean tablePerSubclass;
            referenced = property.getAssociatedEntity();
            Mapping m = this.getRootMapping(referenced);
            boolean bl = tablePerSubclass = m != null && !m.getTablePerHierarchy();
            if (referenced != null && !referenced.isRoot() && !tablePerSubclass) {
                Mapping rootMapping = this.getRootMapping(referenced);
                String discriminatorColumnName = "class";
                if (rootMapping != null) {
                    ColumnConfig discriminatorColumn = rootMapping.getDiscriminatorColumn();
                    if (discriminatorColumn != null) {
                        discriminatorColumnName = discriminatorColumn.getName();
                    }
                    if (rootMapping.getDiscriminatorMap().get("formula") != null) {
                        discriminatorColumnName = (String)m.getDiscriminatorMap().get("formula");
                    }
                }
                java.util.Set<String> discSet = this.buildDiscriminatorSet((HibernatePersistentEntity)referenced);
                String inclause = DefaultGroovyMethods.join(discSet, (String)",");
                collection.setWhere(discriminatorColumnName + " in (" + inclause + ")");
            }
            if ((associatedClass = (PersistentClass)persistentClasses.get(associatedClassName = (oneToMany = (org.hibernate.mapping.OneToMany)collection.getElement()).getReferencedEntityName())) == null) {
                throw new MappingException("Association references unmapped class: " + oneToMany.getReferencedEntityName());
            }
            oneToMany.setAssociatedClass(associatedClass);
            if (this.shouldBindCollectionWithForeignKey(property)) {
                collection.setCollectionTable(associatedClass.getTable());
            }
            this.bindCollectionForPropertyConfig(collection, propConfig);
        }
        if (this.isSorted((PersistentProperty)property)) {
            collection.setSorted(true);
        }
        DependantValue key = this.createPrimaryKeyValue(mappings, (PersistentProperty)property, collection, persistentClasses);
        if (property.isBidirectional()) {
            Association otherSide = property.getInverseSide();
            if (otherSide instanceof ToOne && this.shouldBindCollectionWithForeignKey(property)) {
                this.linkBidirectionalOneToMany(collection, associatedClass, key, (PersistentProperty)otherSide);
            } else if (otherSide instanceof ManyToMany || java.util.Map.class.isAssignableFrom(property.getType())) {
                this.bindDependentKeyValue((PersistentProperty)property, key, mappings, sessionFactoryBeanName);
            }
        } else if (this.hasJoinKeyMapping(propConfig)) {
            this.bindSimpleValue("long", (SimpleValue)key, false, propConfig.getJoinTable().getKey().getName(), mappings);
        } else {
            this.bindDependentKeyValue((PersistentProperty)property, key, mappings, sessionFactoryBeanName);
        }
        collection.setKey((KeyValue)key);
        if (propConfig != null && (cacheConfig = propConfig.getCache()) != null) {
            collection.setCacheConcurrencyStrategy(cacheConfig.getUsage());
        }
        if ((isManyToMany = property instanceof ManyToMany) || this.isBidirectionalOneToManyMap((Association)property)) {
            Association otherSide = property.getInverseSide();
            if (property.isBidirectional()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("[GrailsDomainBinder] Mapping other side " + otherSide.getOwner().getName() + "." + otherSide.getName() + " -> " + collection.getCollectionTable().getName() + " as ManyToOne"));
                }
                ManyToOne element = new ManyToOne((MetadataImplementor)mappings, collection.getCollectionTable());
                this.bindManyToMany(otherSide, element, mappings, sessionFactoryBeanName);
                collection.setElement((Value)element);
                this.bindCollectionForPropertyConfig(collection, propConfig);
                if (property.isCircular()) {
                    collection.setInverse(false);
                }
            }
        } else if (this.shouldCollectionBindWithJoinColumn(property)) {
            this.bindCollectionWithJoinTable(property, mappings, collection, propConfig, sessionFactoryBeanName);
        } else if (this.isUnidirectionalOneToMany((PersistentProperty)property)) {
            this.bindUnidirectionalOneToMany((OneToMany)property, mappings, collection);
        }
    }

    protected String buildOrderByClause(String hqlOrderBy, PersistentClass associatedClass, String role, String defaultOrder) {
        String orderByString = null;
        if (hqlOrderBy != null) {
            ArrayList<String> properties = new ArrayList<String>();
            ArrayList<String> ordering = new ArrayList<String>();
            StringBuilder orderByBuffer = new StringBuilder();
            if (hqlOrderBy.length() == 0) {
                Iterator it = associatedClass.getIdentifier().getColumnIterator();
                while (it.hasNext()) {
                    Selectable col = (Selectable)it.next();
                    orderByBuffer.append(col.getText()).append(" asc").append(", ");
                }
            } else {
                StringTokenizer st = new StringTokenizer(hqlOrderBy, " ,", false);
                String currentOrdering = defaultOrder;
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (this.isNonPropertyToken(token)) {
                        if (currentOrdering != null) {
                            throw new DatastoreConfigurationException("Error while parsing sort clause: " + hqlOrderBy + " (" + role + ")");
                        }
                        currentOrdering = token;
                        continue;
                    }
                    if (currentOrdering == null) {
                        ordering.add("asc");
                    } else {
                        ordering.add(currentOrdering);
                        currentOrdering = null;
                    }
                    properties.add(token);
                }
                ordering.remove(0);
                if (currentOrdering == null) {
                    ordering.add(defaultOrder);
                } else {
                    ordering.add(currentOrdering);
                    currentOrdering = null;
                }
                int index = 0;
                for (String property : properties) {
                    org.hibernate.mapping.Property p = BinderHelper.findPropertyByName((PersistentClass)associatedClass, (String)property);
                    if (p == null) {
                        throw new DatastoreConfigurationException("property from sort clause not found: " + associatedClass.getEntityName() + "." + property);
                    }
                    PersistentClass pc = p.getPersistentClass();
                    String table = pc == null ? EMPTY_PATH : (pc == associatedClass || associatedClass instanceof SingleTableSubclass && pc.getMappedClass().isAssignableFrom(associatedClass.getMappedClass()) ? EMPTY_PATH : pc.getTable().getQuotedName() + ".");
                    Iterator propertyColumns = p.getColumnIterator();
                    while (propertyColumns.hasNext()) {
                        Selectable column = (Selectable)propertyColumns.next();
                        orderByBuffer.append(table).append(column.getText()).append(" ").append((String)ordering.get(index)).append(", ");
                    }
                    ++index;
                }
            }
            orderByString = orderByBuffer.substring(0, orderByBuffer.length() - 2);
        }
        return orderByString;
    }

    protected boolean isNonPropertyToken(String token) {
        if (" ".equals(token)) {
            return true;
        }
        if (",".equals(token)) {
            return true;
        }
        if (token.equalsIgnoreCase("desc")) {
            return true;
        }
        return token.equalsIgnoreCase("asc");
    }

    protected java.util.Set<String> buildDiscriminatorSet(HibernatePersistentEntity domainClass) {
        HashSet<String> theSet = new HashSet<String>();
        Mapping mapping = (Mapping)domainClass.getMapping().getMappedForm();
        String discriminator = domainClass.getName();
        if (mapping != null && mapping.getDiscriminator() != null) {
            discriminator = mapping.getDiscriminator();
        }
        Mapping rootMapping = this.getRootMapping((PersistentEntity)domainClass);
        String quote = "'";
        if (rootMapping != null && rootMapping.getDiscriminatorMap() != null && rootMapping.getDiscriminatorMap().get(ENUM_TYPE_PROP) != null && rootMapping.getDiscriminatorMap().get(ENUM_TYPE_PROP) != STRING_TYPE) {
            quote = EMPTY_PATH;
        }
        theSet.add(quote + discriminator + quote);
        Collection childEntities = domainClass.getMappingContext().getDirectChildEntities((PersistentEntity)domainClass);
        for (PersistentEntity subClass : childEntities) {
            theSet.addAll(this.buildDiscriminatorSet((HibernatePersistentEntity)subClass));
        }
        return theSet;
    }

    protected Mapping getRootMapping(PersistentEntity referenced) {
        Class superClass;
        if (referenced == null) {
            return null;
        }
        Class current = referenced.getJavaClass();
        while (!Object.class.equals(superClass = current.getSuperclass())) {
            current = superClass;
        }
        return GrailsDomainBinder.getMapping(current);
    }

    protected boolean isBidirectionalOneToManyMap(Association property) {
        return java.util.Map.class.isAssignableFrom(property.getType()) && property.isBidirectional();
    }

    protected void bindCollectionWithJoinTable(ToMany property, InFlightMetadataCollector mappings, org.hibernate.mapping.Collection collection, PropertyConfig config, String sessionFactoryBeanName) {
        SimpleValue element;
        NamingStrategy namingStrategy = this.getNamingStrategy(sessionFactoryBeanName);
        boolean isBasicCollectionType = property instanceof Basic;
        if (isBasicCollectionType) {
            element = new SimpleValue((MetadataImplementor)mappings, collection.getCollectionTable());
        } else {
            element = new ManyToOne((MetadataImplementor)mappings, collection.getCollectionTable());
            this.bindUnidirectionalOneToManyInverseValues(property, (ManyToOne)element);
        }
        collection.setInverse(false);
        boolean hasJoinColumnMapping = this.hasJoinColumnMapping(config);
        if (isBasicCollectionType) {
            String columnName;
            Class referencedType = ((Basic)property).getComponentType();
            String className = referencedType.getName();
            boolean isEnum = referencedType.isEnum();
            if (hasJoinColumnMapping) {
                columnName = config.getJoinTable().getColumn().getName();
            } else {
                String string = columnName = isEnum ? namingStrategy.propertyToColumnName(className) : this.addUnderscore(namingStrategy.propertyToColumnName(property.getName()), namingStrategy.propertyToColumnName(className));
            }
            if (isEnum) {
                this.bindEnumType((PersistentProperty)property, referencedType, element, columnName);
            } else {
                BasicType type;
                String typeName = this.getTypeName((PersistentProperty)property, config, GrailsDomainBinder.getMapping(property.getOwner()));
                if (typeName == null && (type = mappings.getTypeResolver().basic(className)) != null) {
                    typeName = type.getName();
                }
                if (typeName == null) {
                    String domainName = property.getOwner().getName();
                    throw new MappingException("Missing type or column for column[" + columnName + "] on domain[" + domainName + "] referencing[" + className + "]");
                }
                this.bindSimpleValue(typeName, element, true, columnName, mappings);
                if (hasJoinColumnMapping) {
                    this.bindColumnConfigToColumn(this.getColumnForSimpleValue(element), config.getJoinTable().getColumn());
                }
            }
        } else {
            PersistentEntity domainClass = property.getAssociatedEntity();
            Mapping m = GrailsDomainBinder.getMapping(domainClass);
            if (this.hasCompositeIdentifier(m)) {
                CompositeIdentity ci = (CompositeIdentity)m.getIdentity();
                this.bindCompositeIdentifierToManyToOne((Association)property, element, ci, domainClass, EMPTY_PATH, sessionFactoryBeanName);
            } else {
                String columnName = hasJoinColumnMapping ? config.getJoinTable().getColumn().getName() : namingStrategy.propertyToColumnName(NameUtils.decapitalize((String)domainClass.getName())) + FOREIGN_KEY_SUFFIX;
                this.bindSimpleValue("long", element, true, columnName, mappings);
            }
        }
        collection.setElement((Value)element);
        this.bindCollectionForPropertyConfig(collection, config);
    }

    protected String addUnderscore(String s1, String s2) {
        return this.removeBackticks(s1) + '_' + this.removeBackticks(s2);
    }

    protected String removeBackticks(String s) {
        return s.startsWith(BACKTICK) && s.endsWith(BACKTICK) ? s.substring(1, s.length() - 1) : s;
    }

    protected Column getColumnForSimpleValue(SimpleValue element) {
        return (Column)element.getColumnIterator().next();
    }

    protected String getTypeName(PersistentProperty property, PropertyConfig config, Mapping mapping) {
        if (config != null && config.getType() != null) {
            Object typeObj = config.getType();
            if (typeObj instanceof Class) {
                return ((Class)typeObj).getName();
            }
            return typeObj.toString();
        }
        if (mapping != null) {
            return mapping.getTypeName(property.getType());
        }
        return null;
    }

    protected void bindColumnConfigToColumn(Column column, ColumnConfig columnConfig) {
        if (columnConfig == null) {
            return;
        }
        if (columnConfig.getLength() != -1) {
            column.setLength(columnConfig.getLength());
        }
        if (columnConfig.getPrecision() != -1) {
            column.setPrecision(columnConfig.getPrecision());
        }
        if (columnConfig.getScale() != -1) {
            column.setScale(columnConfig.getScale());
        }
        if (columnConfig.getSqlType() != null && !columnConfig.getSqlType().isEmpty()) {
            column.setSqlType(columnConfig.getSqlType());
        }
        column.setUnique(columnConfig.getUnique());
    }

    protected boolean hasJoinColumnMapping(PropertyConfig config) {
        return config != null && config.getJoinTable() != null && config.getJoinTable().getColumn() != null;
    }

    protected boolean shouldCollectionBindWithJoinColumn(ToMany property) {
        PropertyConfig config = this.getPropertyConfig((PersistentProperty)property);
        JoinTable jt = config != null ? config.getJoinTable() : new JoinTable();
        return (this.isUnidirectionalOneToMany((PersistentProperty)property) || property instanceof Basic) && jt != null;
    }

    protected void bindUnidirectionalOneToManyInverseValues(ToMany property, ManyToOne manyToOne) {
        PropertyConfig config = this.getPropertyConfig((PersistentProperty)property);
        if (config == null) {
            manyToOne.setLazy(true);
        } else {
            Boolean lazy;
            manyToOne.setIgnoreNotFound(config.getIgnoreNotFound());
            FetchMode fetch = config.getFetch();
            if (!fetch.equals((Object)FetchMode.JOIN) && !fetch.equals((Object)FetchMode.EAGER)) {
                manyToOne.setLazy(true);
            }
            if ((lazy = config.getLazy()) != null) {
                manyToOne.setLazy(lazy.booleanValue());
            }
        }
        manyToOne.setReferencedEntityName(property.getAssociatedEntity().getName());
    }

    protected void bindCollectionForPropertyConfig(org.hibernate.mapping.Collection collection, PropertyConfig config) {
        if (config == null) {
            collection.setLazy(true);
            collection.setExtraLazy(false);
        } else {
            Boolean lazy;
            FetchMode fetch = config.getFetch();
            if (!fetch.equals((Object)FetchMode.JOIN) && !fetch.equals((Object)FetchMode.EAGER)) {
                collection.setLazy(true);
            }
            if ((lazy = config.getLazy()) != null) {
                collection.setExtraLazy(lazy.booleanValue());
            }
        }
    }

    public PropertyConfig getPropertyConfig(PersistentProperty property) {
        return (PropertyConfig)property.getMapping().getMappedForm();
    }

    protected boolean isUnidirectionalOneToMany(PersistentProperty property) {
        return property instanceof OneToMany && !((Association)property).isBidirectional();
    }

    protected void bindDependentKeyValue(PersistentProperty property, DependantValue key, InFlightMetadataCollector mappings, String sessionFactoryBeanName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("[GrailsDomainBinder] binding  [" + property.getName() + "] with dependant key"));
        }
        PersistentEntity refDomainClass = property.getOwner();
        Mapping mapping = GrailsDomainBinder.getMapping(refDomainClass.getJavaClass());
        boolean hasCompositeIdentifier = this.hasCompositeIdentifier(mapping);
        if (this.shouldCollectionBindWithJoinColumn((ToMany)property) && hasCompositeIdentifier || hasCompositeIdentifier && property instanceof ManyToMany) {
            CompositeIdentity ci = (CompositeIdentity)mapping.getIdentity();
            this.bindCompositeIdentifierToManyToOne((Association)property, (SimpleValue)key, ci, refDomainClass, EMPTY_PATH, sessionFactoryBeanName);
        } else {
            this.bindSimpleValue(property, null, (SimpleValue)key, EMPTY_PATH, mappings, sessionFactoryBeanName);
        }
    }

    protected DependantValue createPrimaryKeyValue(InFlightMetadataCollector mappings, PersistentProperty property, org.hibernate.mapping.Collection collection, java.util.Map<?, ?> persistentClasses) {
        String propertyRef = collection.getReferencedPropertyName();
        KeyValue keyValue = propertyRef == null ? collection.getOwner().getIdentifier() : (KeyValue)collection.getOwner().getProperty(propertyRef).getValue();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("[GrailsDomainBinder] creating dependant key value  to table [" + keyValue.getTable().getName() + "]"));
        }
        DependantValue key = new DependantValue((MetadataImplementor)mappings, collection.getCollectionTable(), keyValue);
        key.setTypeName(null);
        key.setNullable(true);
        key.setUpdateable(false);
        return key;
    }

    protected void bindUnidirectionalOneToMany(OneToMany property, InFlightMetadataCollector mappings, org.hibernate.mapping.Collection collection) {
        String entityName;
        Value v = collection.getElement();
        v.createForeignKey();
        if (v instanceof ManyToOne) {
            ManyToOne manyToOne = (ManyToOne)v;
            entityName = manyToOne.getReferencedEntityName();
        } else {
            entityName = ((org.hibernate.mapping.OneToMany)v).getReferencedEntityName();
        }
        collection.setInverse(false);
        PersistentClass referenced = mappings.getEntityBinding(entityName);
        Backref prop = new Backref();
        PersistentEntity owner = property.getOwner();
        prop.setEntityName(owner.getName());
        prop.setName('_' + this.addUnderscore(owner.getJavaClass().getSimpleName(), property.getName()) + "Backref");
        prop.setUpdateable(false);
        prop.setInsertable(true);
        prop.setCollectionRole(collection.getRole());
        prop.setValue((Value)collection.getKey());
        prop.setOptional(true);
        referenced.addProperty((org.hibernate.mapping.Property)prop);
    }

    protected org.hibernate.mapping.Property getProperty(PersistentClass associatedClass, String propertyName) throws MappingException {
        try {
            return associatedClass.getProperty(propertyName);
        }
        catch (MappingException e) {
            if (associatedClass.getKey() instanceof Component) {
                return ((Component)associatedClass.getKey()).getProperty(propertyName);
            }
            throw e;
        }
    }

    protected void linkBidirectionalOneToMany(org.hibernate.mapping.Collection collection, PersistentClass associatedClass, DependantValue key, PersistentProperty otherSide) {
        collection.setInverse(true);
        Iterator mappedByColumns = this.getProperty(associatedClass, otherSide.getName()).getValue().getColumnIterator();
        while (mappedByColumns.hasNext()) {
            Column column = (Column)mappedByColumns.next();
            this.linkValueUsingAColumnCopy(otherSide, column, key);
        }
    }

    protected boolean isSorted(PersistentProperty property) {
        return SortedSet.class.isAssignableFrom(property.getType());
    }

    protected void bindManyToMany(Association property, ManyToOne element, InFlightMetadataCollector mappings, String sessionFactoryBeanName) {
        this.bindManyToOne(property, element, EMPTY_PATH, mappings, sessionFactoryBeanName);
        element.setReferencedEntityName(property.getOwner().getName());
    }

    protected void linkValueUsingAColumnCopy(PersistentProperty prop, Column column, DependantValue key) {
        Column mappingColumn = new Column();
        mappingColumn.setName(column.getName());
        mappingColumn.setLength(column.getLength());
        mappingColumn.setNullable(prop.isNullable());
        mappingColumn.setSqlType(column.getSqlType());
        mappingColumn.setValue((Value)key);
        key.addColumn(mappingColumn);
        key.getTable().addColumn(mappingColumn);
    }

    protected void bindCollection(ToMany property, org.hibernate.mapping.Collection collection, PersistentClass owner, InFlightMetadataCollector mappings, String path, String sessionFactoryBeanName) {
        String propertyName = this.getNameForPropertyAndPath((PersistentProperty)property, path);
        collection.setRole(this.qualify(property.getOwner().getName(), propertyName));
        PropertyConfig pc = this.getPropertyConfig((PersistentProperty)property);
        FetchMode fetchMode = pc.getFetch();
        if (fetchMode == FetchMode.JOIN) {
            collection.setFetchMode(FetchMode.JOIN);
        } else if (pc.getFetch() != null) {
            collection.setFetchMode(pc.getFetch());
        } else {
            collection.setFetchMode(FetchMode.DEFAULT);
        }
        if (pc.getCascade() != null) {
            collection.setOrphanDelete(pc.getCascade().equals(CASCADE_ALL_DELETE_ORPHAN));
        }
        if (this.shouldBindCollectionWithForeignKey(property)) {
            org.hibernate.mapping.OneToMany oneToMany = new org.hibernate.mapping.OneToMany((MetadataImplementor)mappings, collection.getOwner());
            collection.setElement((Value)oneToMany);
            this.bindOneToMany((OneToMany)property, oneToMany, mappings);
        } else {
            this.bindCollectionTable(property, mappings, collection, owner.getTable(), sessionFactoryBeanName);
            if (!property.isOwningSide()) {
                collection.setInverse(true);
            }
        }
        if (pc.getBatchSize() != null) {
            collection.setBatchSize(pc.getBatchSize().intValue());
        }
        if (collection instanceof Set) {
            mappings.addSecondPass((SecondPass)new GrailsCollectionSecondPass(property, mappings, collection, sessionFactoryBeanName));
        } else if (collection instanceof List) {
            mappings.addSecondPass((SecondPass)new ListSecondPass(property, mappings, collection, sessionFactoryBeanName));
        } else if (collection instanceof Map) {
            mappings.addSecondPass((SecondPass)new MapSecondPass(property, mappings, collection, sessionFactoryBeanName));
        } else {
            mappings.addSecondPass((SecondPass)new GrailsCollectionSecondPass(property, mappings, collection, sessionFactoryBeanName));
        }
    }

    protected boolean shouldBindCollectionWithForeignKey(ToMany property) {
        return (property instanceof OneToMany && property.isBidirectional() || !this.shouldCollectionBindWithJoinColumn(property)) && !java.util.Map.class.isAssignableFrom(property.getType()) && !(property instanceof ManyToMany) && !(property instanceof Basic);
    }

    protected String getNameForPropertyAndPath(PersistentProperty property, String path) {
        if (this.isNotEmpty(path)) {
            return this.qualify(path, property.getName());
        }
        return property.getName();
    }

    protected void bindCollectionTable(ToMany property, InFlightMetadataCollector mappings, org.hibernate.mapping.Collection collection, Table ownerTable, String sessionFactoryBeanName) {
        String owningTableSchema = ownerTable.getSchema();
        PropertyConfig config = this.getPropertyConfig((PersistentProperty)property);
        JoinTable jt = config != null ? config.getJoinTable() : null;
        NamingStrategy namingStrategy = this.getNamingStrategy(sessionFactoryBeanName);
        String tableName = jt != null && jt.getName() != null ? jt.getName() : namingStrategy.tableName(this.calculateTableForMany(property, sessionFactoryBeanName));
        String schemaName = this.getSchemaName(mappings);
        String catalogName = this.getCatalogName(mappings);
        if (jt != null) {
            if (jt.getSchema() != null) {
                schemaName = jt.getSchema();
            }
            if (jt.getCatalog() != null) {
                catalogName = jt.getCatalog();
            }
        }
        if (schemaName == null && owningTableSchema != null) {
            schemaName = owningTableSchema;
        }
        collection.setCollectionTable(mappings.addTable(schemaName, catalogName, tableName, null, false));
    }

    protected String calculateTableForMany(ToMany property, String sessionFactoryBeanName) {
        NamingStrategy namingStrategy = this.getNamingStrategy(sessionFactoryBeanName);
        String propertyColumnName = namingStrategy.propertyToColumnName(property.getName());
        PropertyConfig config = this.getPropertyConfig((PersistentProperty)property);
        JoinTable jt = config != null ? config.getJoinTable() : null;
        boolean hasJoinTableMapping = jt != null && jt.getName() != null;
        String left = this.getTableName(property.getOwner(), sessionFactoryBeanName);
        if (java.util.Map.class.isAssignableFrom(property.getType())) {
            if (hasJoinTableMapping) {
                return jt.getName();
            }
            return this.addUnderscore(left, propertyColumnName);
        }
        if (property instanceof Basic) {
            if (hasJoinTableMapping) {
                return jt.getName();
            }
            return this.addUnderscore(left, propertyColumnName);
        }
        String right = this.getTableName(property.getAssociatedEntity(), sessionFactoryBeanName);
        if (property instanceof ManyToMany) {
            if (hasJoinTableMapping) {
                return jt.getName();
            }
            if (property.isOwningSide()) {
                return this.addUnderscore(left, propertyColumnName);
            }
            return this.addUnderscore(right, namingStrategy.propertyToColumnName(((ManyToMany)property).getInversePropertyName()));
        }
        if (this.shouldCollectionBindWithJoinColumn(property)) {
            if (hasJoinTableMapping) {
                return jt.getName();
            }
            left = this.trimBackTigs(left);
            right = this.trimBackTigs(right);
            return this.addUnderscore(left, right);
        }
        if (property.isOwningSide()) {
            return this.addUnderscore(left, right);
        }
        return this.addUnderscore(right, left);
    }

    protected String trimBackTigs(String tableName) {
        if (tableName.startsWith(BACKTICK)) {
            return tableName.substring(1, tableName.length() - 1);
        }
        return tableName;
    }

    protected String getTableName(PersistentEntity domainClass, String sessionFactoryBeanName) {
        Mapping m = GrailsDomainBinder.getMapping(domainClass);
        String tableName = null;
        if (m != null && m.getTableName() != null) {
            tableName = m.getTableName();
        }
        if (tableName == null) {
            String shortName = domainClass.getJavaClass().getSimpleName();
            PersistentEntityNamingStrategy namingStrategy = this.namingStrategy;
            if (namingStrategy != null) {
                tableName = namingStrategy.resolveTableName(domainClass);
            }
            if (tableName == null) {
                tableName = this.getNamingStrategy(sessionFactoryBeanName).classToTableName(shortName);
            }
        }
        return tableName;
    }

    protected NamingStrategy getNamingStrategy(String sessionFactoryBeanName) {
        String key = "sessionFactory".equals(sessionFactoryBeanName) ? "DEFAULT" : sessionFactoryBeanName.substring("sessionFactory_".length());
        NamingStrategy namingStrategy = NAMING_STRATEGIES.get(key);
        return namingStrategy != null ? namingStrategy : new ImprovedNamingStrategy();
    }

    public void bindClass(PersistentEntity entity, InFlightMetadataCollector mappings, String sessionFactoryBeanName) throws MappingException {
        if (entity.isRoot()) {
            this.bindRoot((HibernatePersistentEntity)entity, mappings, sessionFactoryBeanName);
        }
    }

    public Mapping evaluateMapping(PersistentEntity domainClass) {
        return this.evaluateMapping(domainClass, null);
    }

    public Mapping evaluateMapping(PersistentEntity domainClass, Closure<?> defaultMapping) {
        return this.evaluateMapping(domainClass, defaultMapping, true);
    }

    public Mapping evaluateMapping(PersistentEntity domainClass, Closure<?> defaultMapping, boolean cache) {
        try {
            Mapping m = (Mapping)domainClass.getMapping().getMappedForm();
            this.trackCustomCascadingSaves(m, domainClass.getPersistentProperties());
            if (cache) {
                MAPPING_CACHE.put(domainClass.getJavaClass(), m);
            }
            return m;
        }
        catch (Exception e) {
            throw new DatastoreConfigurationException("Error evaluating ORM mappings block for domain [" + domainClass.getName() + "]:  " + e.getMessage(), (Throwable)e);
        }
    }

    protected void trackCustomCascadingSaves(Mapping mapping, Iterable<PersistentProperty> persistentProperties) {
        for (PersistentProperty property : persistentProperties) {
            PropertyConfig propConf = mapping.getPropertyConfig(property.getName());
            if (propConf == null || propConf.getCascade() == null) continue;
            propConf.setExplicitSaveUpdateCascade(this.isSaveUpdateCascade(propConf.getCascade()));
        }
    }

    protected boolean isSaveUpdateCascade(String cascade) {
        String[] cascades;
        for (String cascadeProp : cascades = cascade.split(",")) {
            String trimmedProp = cascadeProp.trim();
            if (!CASCADE_SAVE_UPDATE.equals(trimmedProp) && !CASCADE_ALL.equals(trimmedProp) && !CASCADE_ALL_DELETE_ORPHAN.equals(trimmedProp)) continue;
            return true;
        }
        return false;
    }

    public static Mapping getMapping(Class<?> theClass) {
        return theClass == null ? null : MAPPING_CACHE.get(theClass);
    }

    public static Mapping getMapping(PersistentEntity domainClass) {
        return domainClass == null ? null : MAPPING_CACHE.get(domainClass.getJavaClass());
    }

    public static void clearMappingCache() {
        MAPPING_CACHE.clear();
    }

    public static void clearMappingCache(Class<?> theClass) {
        String className = theClass.getName();
        Iterator<Map.Entry<Class<?>, Mapping>> it = MAPPING_CACHE.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Class<?>, Mapping> entry = it.next();
            if (!className.equals(entry.getKey().getName())) continue;
            it.remove();
        }
    }

    protected void bindClass(PersistentEntity domainClass, PersistentClass persistentClass, InFlightMetadataCollector mappings) {
        persistentClass.setLazy(true);
        String entityName = domainClass.getName();
        persistentClass.setEntityName(entityName);
        persistentClass.setJpaEntityName(this.unqualify(entityName));
        persistentClass.setProxyInterfaceName(entityName);
        persistentClass.setClassName(entityName);
        persistentClass.setDynamicInsert(false);
        persistentClass.setDynamicUpdate(false);
        persistentClass.setSelectBeforeUpdate(false);
        String en = persistentClass.getEntityName();
        if (mappings.getMetadataBuildingOptions().getMappingDefaults().isAutoImportEnabled() && en.indexOf(46) > 0) {
            String unqualified = this.unqualify(en);
            mappings.addImport(unqualified, en);
        }
    }

    public void bindRoot(HibernatePersistentEntity entity, InFlightMetadataCollector mappings, String sessionFactoryBeanName) {
        if (mappings.getEntityBinding(entity.getName()) != null) {
            LOG.info((Object)("[GrailsDomainBinder] Class [" + entity.getName() + "] is already mapped, skipping.. "));
            return;
        }
        RootClass root = new RootClass(this.metadataBuildingContext);
        root.setAbstract(Boolean.valueOf(entity.isAbstract()));
        MappingContext mappingContext = entity.getMappingContext();
        Collection children = mappingContext.getDirectChildEntities((PersistentEntity)entity);
        if (children.isEmpty()) {
            root.setPolymorphic(false);
        }
        this.bindClass((PersistentEntity)entity, (PersistentClass)root, mappings);
        Mapping m = GrailsDomainBinder.getMapping((PersistentEntity)entity);
        this.bindRootPersistentClassCommonValues(entity, root, mappings, sessionFactoryBeanName);
        if (!children.isEmpty()) {
            boolean tablePerSubclass;
            boolean bl = tablePerSubclass = m != null && !m.getTablePerHierarchy();
            if (!tablePerSubclass) {
                this.bindDiscriminatorProperty(root.getTable(), root, mappings);
            }
            this.bindSubClasses(entity, (PersistentClass)root, mappings, sessionFactoryBeanName);
        }
        if (root.getEntityPersisterClass() == null) {
            root.setEntityPersisterClass(this.getGroovyAwareSingleTableEntityPersisterClass());
        }
        mappings.addEntityBinding((PersistentClass)root);
    }

    protected void bindSubClasses(HibernatePersistentEntity domainClass, PersistentClass parent, InFlightMetadataCollector mappings, String sessionFactoryBeanName) {
        Collection subClasses = domainClass.getMappingContext().getDirectChildEntities((PersistentEntity)domainClass);
        for (PersistentEntity sub : subClasses) {
            Class javaClass = sub.getJavaClass();
            if (!javaClass.getSuperclass().equals(domainClass.getJavaClass())) continue;
            this.bindSubClass((HibernatePersistentEntity)sub, parent, mappings, sessionFactoryBeanName);
        }
    }

    protected void bindSubClass(HibernatePersistentEntity sub, PersistentClass parent, InFlightMetadataCollector mappings, String sessionFactoryBeanName) {
        JoinedSubclass subClass;
        this.evaluateMapping((PersistentEntity)sub, this.defaultMapping);
        Mapping m = GrailsDomainBinder.getMapping(parent.getMappedClass());
        boolean tablePerSubclass = m != null && !m.getTablePerHierarchy() && !m.isTablePerConcreteClass();
        boolean tablePerConcreteClass = m != null && m.isTablePerConcreteClass();
        String fullName = sub.getName();
        if (tablePerSubclass) {
            subClass = new JoinedSubclass(parent, this.metadataBuildingContext);
        } else if (tablePerConcreteClass) {
            subClass = new UnionSubclass(parent, this.metadataBuildingContext);
        } else {
            subClass = new SingleTableSubclass(parent, this.metadataBuildingContext);
            Mapping subMapping = GrailsDomainBinder.getMapping((PersistentEntity)sub);
            subClass.setDiscriminatorValue(subMapping != null && subMapping.getDiscriminator() != null ? subMapping.getDiscriminator() : fullName);
            if (subMapping != null) {
                this.configureDerivedProperties((PersistentEntity)sub, subMapping);
            }
        }
        subClass.setEntityName(fullName);
        subClass.setJpaEntityName(this.unqualify(fullName));
        parent.addSubclass((Subclass)subClass);
        mappings.addEntityBinding((PersistentClass)subClass);
        if (tablePerSubclass) {
            this.bindJoinedSubClass(sub, subClass, mappings, m, sessionFactoryBeanName);
        } else if (tablePerConcreteClass) {
            this.bindUnionSubclass(sub, (UnionSubclass)subClass, mappings, sessionFactoryBeanName);
        } else {
            this.bindSubClass(sub, (Subclass)subClass, mappings, sessionFactoryBeanName);
        }
        Collection childEntities = sub.getMappingContext().getDirectChildEntities((PersistentEntity)sub);
        if (!childEntities.isEmpty()) {
            this.bindSubClasses(sub, (PersistentClass)subClass, mappings, sessionFactoryBeanName);
        }
    }

    public void bindUnionSubclass(HibernatePersistentEntity subClass, UnionSubclass unionSubclass, InFlightMetadataCollector mappings, String sessionFactoryBeanName) throws MappingException {
        Mapping subMapping = GrailsDomainBinder.getMapping(subClass.getJavaClass());
        if (unionSubclass.getEntityPersisterClass() == null) {
            unionSubclass.getRootClass().setEntityPersisterClass(UnionSubclassEntityPersister.class);
        }
        String schema = subMapping != null && subMapping.getTable().getSchema() != null ? subMapping.getTable().getSchema() : null;
        String catalog = subMapping != null && subMapping.getTable().getCatalog() != null ? subMapping.getTable().getCatalog() : null;
        Table denormalizedSuperTable = unionSubclass.getSuperclass().getTable();
        Table mytable = mappings.addDenormalizedTable(schema, catalog, this.getTableName((PersistentEntity)subClass, sessionFactoryBeanName), unionSubclass.isAbstract() != null && unionSubclass.isAbstract() != false, null, denormalizedSuperTable);
        unionSubclass.setTable(mytable);
        unionSubclass.setClassName(subClass.getName());
        LOG.info((Object)("Mapping union-subclass: " + unionSubclass.getEntityName() + " -> " + unionSubclass.getTable().getName()));
        this.createClassProperties(subClass, (PersistentClass)unionSubclass, mappings, sessionFactoryBeanName);
    }

    protected void bindJoinedSubClass(HibernatePersistentEntity sub, JoinedSubclass joinedSubclass, InFlightMetadataCollector mappings, Mapping gormMapping, String sessionFactoryBeanName) {
        this.bindClass((PersistentEntity)sub, (PersistentClass)joinedSubclass, mappings);
        if (joinedSubclass.getEntityPersisterClass() == null) {
            joinedSubclass.getRootClass().setEntityPersisterClass(this.getGroovyAwareJoinedSubclassEntityPersisterClass());
        }
        String schemaName = this.getSchemaName(mappings);
        String catalogName = this.getCatalogName(mappings);
        Table mytable = mappings.addTable(schemaName, catalogName, this.getJoinedSubClassTableName(sub, (PersistentClass)joinedSubclass, null, mappings, sessionFactoryBeanName), null, false);
        joinedSubclass.setTable(mytable);
        LOG.info((Object)("Mapping joined-subclass: " + joinedSubclass.getEntityName() + " -> " + joinedSubclass.getTable().getName()));
        DependantValue key = new DependantValue((MetadataImplementor)mappings, mytable, joinedSubclass.getIdentifier());
        joinedSubclass.setKey((KeyValue)key);
        PersistentProperty identifier = sub.getIdentity();
        String columnName = this.getColumnNameForPropertyAndPath(identifier, EMPTY_PATH, null, sessionFactoryBeanName);
        this.bindSimpleValue(identifier.getType().getName(), (SimpleValue)key, false, columnName, mappings);
        joinedSubclass.createPrimaryKey();
        this.createClassProperties(sub, (PersistentClass)joinedSubclass, mappings, sessionFactoryBeanName);
    }

    protected String getJoinedSubClassTableName(HibernatePersistentEntity sub, PersistentClass model, Table denormalizedSuperTable, InFlightMetadataCollector mappings, String sessionFactoryBeanName) {
        String logicalTableName = this.unqualify(model.getEntityName());
        String physicalTableName = this.getTableName((PersistentEntity)sub, sessionFactoryBeanName);
        String schemaName = this.getSchemaName(mappings);
        String catalogName = this.getCatalogName(mappings);
        mappings.addTableNameBinding(schemaName, catalogName, logicalTableName, physicalTableName, denormalizedSuperTable);
        return physicalTableName;
    }

    protected void bindSubClass(HibernatePersistentEntity sub, Subclass subClass, InFlightMetadataCollector mappings, String sessionFactoryBeanName) {
        this.bindClass((PersistentEntity)sub, (PersistentClass)subClass, mappings);
        if (subClass.getEntityPersisterClass() == null) {
            subClass.getRootClass().setEntityPersisterClass(this.getGroovyAwareSingleTableEntityPersisterClass());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Mapping subclass: " + subClass.getEntityName() + " -> " + subClass.getTable().getName()));
        }
        this.createClassProperties(sub, (PersistentClass)subClass, mappings, sessionFactoryBeanName);
    }

    protected void bindDiscriminatorProperty(Table table, RootClass entity, InFlightMetadataCollector mappings) {
        Mapping m = GrailsDomainBinder.getMapping(entity.getMappedClass());
        SimpleValue d = new SimpleValue((MetadataImplementor)mappings, table);
        entity.setDiscriminator((Value)d);
        entity.setDiscriminatorValue(m != null && m.getDiscriminator() != null ? m.getDiscriminator() : entity.getClassName());
        if (m != null && m.getDiscriminatorMap().get("insert") != null) {
            entity.setDiscriminatorInsertable(((Boolean)m.getDiscriminatorMap().get("insert")).booleanValue());
        }
        if (m != null && m.getDiscriminatorMap().get(ENUM_TYPE_PROP) != null) {
            d.setTypeName((String)m.getDiscriminatorMap().get(ENUM_TYPE_PROP));
        }
        if (m != null && m.getDiscriminatorMap().get("formula") != null) {
            Formula formula = new Formula();
            formula.setFormula((String)m.getDiscriminatorMap().get("formula"));
            d.addFormula(formula);
        } else {
            ColumnConfig cc;
            this.bindSimpleValue(STRING_TYPE, d, false, "class", mappings);
            ColumnConfig columnConfig = cc = m == null ? null : m.getDiscriminatorColumn();
            if (cc != null) {
                Column c = (Column)d.getColumnIterator().next();
                if (cc.getName() != null) {
                    c.setName(cc.getName());
                }
                this.bindColumnConfigToColumn(c, cc);
            }
        }
        entity.setPolymorphic(true);
    }

    protected void configureDerivedProperties(PersistentEntity domainClass, Mapping m) {
        for (PersistentProperty prop : domainClass.getPersistentProperties()) {
            PropertyConfig propertyConfig = m.getPropertyConfig(prop.getName());
            if (propertyConfig == null || propertyConfig.getFormula() == null) continue;
            propertyConfig.setDerived(true);
        }
    }

    protected void bindRootPersistentClassCommonValues(HibernatePersistentEntity domainClass, RootClass root, InFlightMetadataCollector mappings, String sessionFactoryBeanName) {
        boolean hasTableDefinition;
        Mapping m = GrailsDomainBinder.getMapping(domainClass.getJavaClass());
        String schema = this.getSchemaName(mappings);
        String catalog = this.getCatalogName(mappings);
        if (m != null) {
            Integer bs;
            this.configureDerivedProperties((PersistentEntity)domainClass, m);
            CacheConfig cc = m.getCache();
            if (cc != null && cc.getEnabled()) {
                root.setCacheConcurrencyStrategy(cc.getUsage());
                if ("read-only".equals(cc.getUsage())) {
                    root.setMutable(false);
                }
                root.setLazyPropertiesCacheable(!"non-lazy".equals(cc.getInclude()));
            }
            if ((bs = m.getBatchSize()) != null) {
                root.setBatchSize(bs.intValue());
            }
            if (m.getDynamicUpdate()) {
                root.setDynamicUpdate(true);
            }
            if (m.getDynamicInsert()) {
                root.setDynamicInsert(true);
            }
        }
        boolean bl = hasTableDefinition = m != null && m.getTable() != null;
        if (hasTableDefinition && m.getTable().getSchema() != null) {
            schema = m.getTable().getSchema();
        }
        if (hasTableDefinition && m.getTable().getCatalog() != null) {
            catalog = m.getTable().getCatalog();
        }
        boolean isAbstract = m != null && !m.getTablePerHierarchy() && m.isTablePerConcreteClass() && root.isAbstract() != false;
        Table table = mappings.addTable(schema, catalog, this.getTableName((PersistentEntity)domainClass, sessionFactoryBeanName), null, isAbstract);
        root.setTable(table);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("[GrailsDomainBinder] Mapping Grails domain class: " + domainClass.getName() + " -> " + root.getTable().getName()));
        }
        this.bindIdentity(domainClass, root, mappings, m, sessionFactoryBeanName);
        if (m == null) {
            this.bindVersion(domainClass.getVersion(), root, mappings, sessionFactoryBeanName);
        } else if (m.getVersioned()) {
            this.bindVersion(domainClass.getVersion(), root, mappings, sessionFactoryBeanName);
        }
        root.createPrimaryKey();
        this.createClassProperties(domainClass, (PersistentClass)root, mappings, sessionFactoryBeanName);
    }

    protected void bindIdentity(HibernatePersistentEntity domainClass, RootClass root, InFlightMetadataCollector mappings, Mapping gormMapping, String sessionFactoryBeanName) {
        PersistentProperty identifierProp = domainClass.getIdentity();
        if (gormMapping == null) {
            if (identifierProp != null) {
                this.bindSimpleId(identifierProp, root, mappings, null, sessionFactoryBeanName);
            }
            return;
        }
        Object id = gormMapping.getIdentity();
        if (id instanceof CompositeIdentity) {
            this.bindCompositeId((PersistentEntity)domainClass, root, (CompositeIdentity)id, mappings, sessionFactoryBeanName);
        } else {
            Identity identity = (Identity)id;
            String propertyName = identity.getName();
            if (propertyName != null) {
                PersistentProperty namedIdentityProp = domainClass.getPropertyByName(propertyName);
                if (namedIdentityProp == null) {
                    throw new MappingException("Mapping specifies an identifier property name that doesn't exist [" + propertyName + "]");
                }
                if (!namedIdentityProp.equals(identifierProp)) {
                    identifierProp = namedIdentityProp;
                }
            }
            this.bindSimpleId(identifierProp, root, mappings, identity, sessionFactoryBeanName);
        }
    }

    protected void bindCompositeId(PersistentEntity domainClass, RootClass root, CompositeIdentity compositeIdentity, InFlightMetadataCollector mappings, String sessionFactoryBeanName) {
        PersistentProperty[] composite;
        HibernatePersistentEntity hibernatePersistentEntity = (HibernatePersistentEntity)domainClass;
        Component id = new Component((MetadataImplementor)mappings, (PersistentClass)root);
        id.setNullValue("undefined");
        root.setIdentifier((KeyValue)id);
        root.setEmbeddedIdentifier(true);
        id.setComponentClassName(domainClass.getName());
        id.setKey(true);
        id.setEmbedded(true);
        String path = this.qualify(root.getEntityName(), "id");
        id.setRoleName(path);
        for (PersistentProperty property : composite = hibernatePersistentEntity.getCompositeIdentity()) {
            if (property == null) {
                throw new MappingException("Property referenced in composite-id mapping of class [" + domainClass.getName() + "] is not a valid property!");
            }
            this.bindComponentProperty(id, null, property, (PersistentClass)root, EMPTY_PATH, root.getTable(), mappings, sessionFactoryBeanName);
        }
    }

    protected void createClassProperties(HibernatePersistentEntity domainClass, PersistentClass persistentClass, InFlightMetadataCollector mappings, String sessionFactoryBeanName) {
        java.util.List persistentProperties = domainClass.getPersistentProperties();
        Table table = persistentClass.getTable();
        Mapping gormMapping = (Mapping)domainClass.getMapping().getMappedForm();
        if (gormMapping != null) {
            table.setComment(gormMapping.getComment());
        }
        for (PersistentProperty currentGrailsProp : persistentProperties) {
            if (currentGrailsProp.isInherited() || currentGrailsProp.getName().equals("version") || this.isCompositeIdProperty(gormMapping, currentGrailsProp) || this.isIdentityProperty(gormMapping, currentGrailsProp)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("[GrailsDomainBinder] Binding persistent property [" + currentGrailsProp.getName() + "]"));
            }
            SimpleValue value = null;
            CollectionType collectionType = this.CT.collectionTypeForClass(currentGrailsProp.getType());
            Class<?> userType = this.getUserType(currentGrailsProp);
            if (userType != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("[GrailsDomainBinder] Binding property [" + currentGrailsProp.getName() + "] as SimpleValue"));
                }
                value = new SimpleValue((MetadataImplementor)mappings, table);
                this.bindSimpleValue(currentGrailsProp, null, value, EMPTY_PATH, mappings, sessionFactoryBeanName);
            } else if (collectionType != null) {
                String typeName = this.getTypeName(currentGrailsProp, this.getPropertyConfig(currentGrailsProp), gormMapping);
                if ("serializable".equals(typeName)) {
                    value = new SimpleValue((MetadataImplementor)mappings, table);
                    this.bindSimpleValue(typeName, value, currentGrailsProp.isNullable(), this.getColumnNameForPropertyAndPath(currentGrailsProp, EMPTY_PATH, null, sessionFactoryBeanName), mappings);
                } else {
                    org.hibernate.mapping.Collection collection = collectionType.create((ToMany)currentGrailsProp, persistentClass, EMPTY_PATH, mappings, sessionFactoryBeanName);
                    mappings.addCollectionBinding(collection);
                    value = collection;
                }
            } else if (currentGrailsProp.getType().isEnum()) {
                value = new SimpleValue((MetadataImplementor)mappings, table);
                this.bindEnumType(currentGrailsProp, value, EMPTY_PATH, sessionFactoryBeanName);
            } else if (currentGrailsProp instanceof Association) {
                Association association = (Association)currentGrailsProp;
                if (currentGrailsProp instanceof org.grails.datastore.mapping.model.types.ManyToOne) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("[GrailsDomainBinder] Binding property [" + currentGrailsProp.getName() + "] as ManyToOne"));
                    }
                    value = new ManyToOne((MetadataImplementor)mappings, table);
                    this.bindManyToOne((Association)currentGrailsProp, (ManyToOne)value, EMPTY_PATH, mappings, sessionFactoryBeanName);
                } else if (currentGrailsProp instanceof OneToOne && userType == null) {
                    boolean isHasOne;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("[GrailsDomainBinder] Binding property [" + currentGrailsProp.getName() + "] as OneToOne"));
                    }
                    if ((isHasOne = this.isHasOne(association)) && !association.isBidirectional()) {
                        throw new MappingException("hasOne property [" + currentGrailsProp.getOwner().getName() + "." + currentGrailsProp.getName() + "] is not bidirectional. Specify the other side of the relationship!");
                    }
                    if (this.canBindOneToOneWithSingleColumnAndForeignKey((Association)currentGrailsProp)) {
                        value = new org.hibernate.mapping.OneToOne((MetadataImplementor)mappings, table, persistentClass);
                        this.bindOneToOne((OneToOne)currentGrailsProp, (org.hibernate.mapping.OneToOne)value, EMPTY_PATH, sessionFactoryBeanName);
                    } else if (isHasOne && association.isBidirectional()) {
                        value = new org.hibernate.mapping.OneToOne((MetadataImplementor)mappings, table, persistentClass);
                        this.bindOneToOne((OneToOne)currentGrailsProp, (org.hibernate.mapping.OneToOne)value, EMPTY_PATH, sessionFactoryBeanName);
                    } else {
                        value = new ManyToOne((MetadataImplementor)mappings, table);
                        this.bindManyToOne((Association)currentGrailsProp, (ManyToOne)value, EMPTY_PATH, mappings, sessionFactoryBeanName);
                    }
                } else if (currentGrailsProp instanceof Embedded) {
                    value = new Component((MetadataImplementor)mappings, persistentClass);
                    this.bindComponent((Component)value, (Embedded)currentGrailsProp, true, mappings, sessionFactoryBeanName);
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("[GrailsDomainBinder] Binding property [" + currentGrailsProp.getName() + "] as SimpleValue"));
                }
                value = new SimpleValue((MetadataImplementor)mappings, table);
                this.bindSimpleValue(currentGrailsProp, null, value, EMPTY_PATH, mappings, sessionFactoryBeanName);
            }
            if (value == null) continue;
            org.hibernate.mapping.Property property = this.createProperty((Value)value, persistentClass, currentGrailsProp, mappings);
            persistentClass.addProperty(property);
        }
        this.bindNaturalIdentifier(table, gormMapping, persistentClass);
    }

    private boolean isHasOne(Association association) {
        return association instanceof OneToOne && ((OneToOne)association).isForeignKeyInChild();
    }

    protected void bindNaturalIdentifier(Table table, Mapping mapping, PersistentClass persistentClass) {
        Object o;
        Object object = o = mapping != null ? mapping.getIdentity() : null;
        if (!(o instanceof Identity)) {
            return;
        }
        Identity identity = (Identity)o;
        NaturalId naturalId = identity.getNatural();
        if (naturalId == null || naturalId.getPropertyNames().isEmpty()) {
            return;
        }
        UniqueKey uk = new UniqueKey();
        uk.setTable(table);
        boolean mutable = naturalId.isMutable();
        for (String propertyName : naturalId.getPropertyNames()) {
            org.hibernate.mapping.Property property = persistentClass.getProperty(propertyName);
            property.setNaturalIdentifier(true);
            if (!mutable) {
                property.setUpdateable(false);
            }
            uk.addColumns(property.getColumnIterator());
        }
        this.setUniqueName(uk);
        table.addUniqueKey(uk);
    }

    protected void setUniqueName(UniqueKey uk) {
        MessageDigest md;
        StringBuilder sb = new StringBuilder(uk.getTable().getName()).append('_');
        for (Object col : uk.getColumns()) {
            sb.append(((Column)col).getName()).append('_');
        }
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        try {
            md.update(sb.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        String name = "UK" + new BigInteger(1, md.digest()).toString(16);
        if (name.length() > 30) {
            name = name.substring(0, 30);
        }
        uk.setName(name);
    }

    protected boolean canBindOneToOneWithSingleColumnAndForeignKey(Association currentGrailsProp) {
        if (currentGrailsProp.isBidirectional()) {
            Association otherSide = currentGrailsProp.getInverseSide();
            if (this.isHasOne(otherSide)) {
                return false;
            }
            if (!currentGrailsProp.isOwningSide() && otherSide.isOwningSide()) {
                return true;
            }
        }
        return false;
    }

    protected boolean isIdentityProperty(Mapping gormMapping, PersistentProperty currentGrailsProp) {
        if (gormMapping == null) {
            return false;
        }
        Object identityMapping = gormMapping.getIdentity();
        if (!(identityMapping instanceof Identity)) {
            return false;
        }
        String identityName = ((Identity)identityMapping).getName();
        return identityName != null && identityName.equals(currentGrailsProp.getName());
    }

    protected void bindEnumType(PersistentProperty property, SimpleValue simpleValue, String path, String sessionFactoryBeanName) {
        this.bindEnumType(property, property.getType(), simpleValue, this.getColumnNameForPropertyAndPath(property, path, null, sessionFactoryBeanName));
    }

    protected void bindEnumType(PersistentProperty property, Class<?> propertyType, SimpleValue simpleValue, String columnName) {
        PropertyConfig pc = this.getPropertyConfig(property);
        PersistentEntity owner = property.getOwner();
        String typeName = this.getTypeName(property, this.getPropertyConfig(property), GrailsDomainBinder.getMapping(owner));
        if (typeName == null) {
            String enumType;
            Properties enumProperties = new Properties();
            enumProperties.put(ENUM_CLASS_PROP, propertyType.getName());
            String string = enumType = pc == null ? DEFAULT_ENUM_TYPE : pc.getEnumType();
            if (enumType.equals(DEFAULT_ENUM_TYPE) && this.identityEnumTypeSupports(propertyType)) {
                simpleValue.setTypeName("org.grails.orm.hibernate.cfg.IdentityEnumType");
            } else {
                simpleValue.setTypeName(ENUM_TYPE_CLASS);
                if (enumType.equals(DEFAULT_ENUM_TYPE) || STRING_TYPE.equalsIgnoreCase(enumType)) {
                    enumProperties.put(ENUM_TYPE_PROP, String.valueOf(12));
                } else if (!"ordinal".equalsIgnoreCase(enumType)) {
                    LOG.warn((Object)("Invalid enumType specified when mapping property [" + property.getName() + "] of class [" + owner.getName() + "]. Using defaults instead."));
                }
            }
            simpleValue.setTypeParameters(enumProperties);
        } else {
            simpleValue.setTypeName(typeName);
        }
        Table t = simpleValue.getTable();
        Column column = new Column();
        if (owner.isRoot()) {
            column.setNullable(property.isNullable());
        } else {
            Mapping mapping = GrailsDomainBinder.getMapping(owner);
            if (mapping == null || mapping.getTablePerHierarchy()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("[GrailsDomainBinder] Sub class property [" + property.getName() + "] for column name [" + column.getName() + "] set to nullable"));
                }
                column.setNullable(true);
            } else {
                column.setNullable(property.isNullable());
            }
        }
        column.setValue((Value)simpleValue);
        column.setName(columnName);
        if (t != null) {
            t.addColumn(column);
        }
        simpleValue.addColumn(column);
        PropertyConfig propertyConfig = this.getPropertyConfig(property);
        if (propertyConfig != null && !propertyConfig.getColumns().isEmpty()) {
            this.bindIndex(columnName, column, (ColumnConfig)propertyConfig.getColumns().get(0), t);
            this.bindColumnConfigToColumn(column, (ColumnConfig)propertyConfig.getColumns().get(0));
        }
    }

    protected Class<?> getUserType(PersistentProperty currentGrailsProp) {
        Class<?> userType;
        block5: {
            Object typeObj;
            userType = null;
            PropertyConfig config = this.getPropertyConfig(currentGrailsProp);
            Object object = typeObj = config == null ? null : config.getType();
            if (typeObj instanceof Class) {
                userType = (Class<?>)typeObj;
            } else if (typeObj != null) {
                String typeName = typeObj.toString();
                try {
                    userType = Class.forName(typeName, true, Thread.currentThread().getContextClassLoader());
                }
                catch (ClassNotFoundException e) {
                    if (typeName.indexOf(".") <= -1 || !LOG.isWarnEnabled()) break block5;
                    LOG.warn((Object)"UserType not found ", (Throwable)e);
                }
            }
        }
        return userType;
    }

    protected boolean isCompositeIdProperty(Mapping gormMapping, PersistentProperty currentGrailsProp) {
        Object id;
        if (gormMapping != null && gormMapping.getIdentity() != null && (id = gormMapping.getIdentity()) instanceof CompositeIdentity) {
            String[] propertyNames = ((CompositeIdentity)id).getPropertyNames();
            String property = currentGrailsProp.getName();
            for (String currentName : propertyNames) {
                if (currentName == null || !currentName.equals(property)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isBidirectionalManyToOne(PersistentProperty currentGrailsProp) {
        return currentGrailsProp instanceof org.grails.datastore.mapping.model.types.ManyToOne && ((Association)currentGrailsProp).isBidirectional();
    }

    protected void bindComponent(Component component, Embedded property, boolean isNullable, InFlightMetadataCollector mappings, String sessionFactoryBeanName) {
        component.setEmbedded(true);
        Class type = property.getType();
        String role = this.qualify(type.getName(), property.getName());
        component.setRoleName(role);
        component.setComponentClassName(type.getName());
        PersistentEntity domainClass = property.getAssociatedEntity();
        this.evaluateMapping(domainClass, this.defaultMapping);
        java.util.List properties = domainClass.getPersistentProperties();
        Table table = component.getOwner().getTable();
        PersistentClass persistentClass = component.getOwner();
        String path = property.getName();
        Class propertyType = property.getOwner().getJavaClass();
        for (PersistentProperty currentGrailsProp : properties) {
            if (currentGrailsProp.equals(domainClass.getIdentity()) || currentGrailsProp.getName().equals("version")) continue;
            if (currentGrailsProp.getType().equals(propertyType)) {
                component.setParentProperty(currentGrailsProp.getName());
                continue;
            }
            this.bindComponentProperty(component, (PersistentProperty)property, currentGrailsProp, persistentClass, path, table, mappings, sessionFactoryBeanName);
        }
    }

    protected void bindComponentProperty(Component component, PersistentProperty componentProperty, PersistentProperty currentGrailsProp, PersistentClass persistentClass, String path, Table table, InFlightMetadataCollector mappings, String sessionFactoryBeanName) {
        ManyToOne value;
        CollectionType collectionType = this.CT.collectionTypeForClass(currentGrailsProp.getType());
        if (collectionType != null) {
            org.hibernate.mapping.Collection collection = collectionType.create((ToMany)currentGrailsProp, persistentClass, path, mappings, sessionFactoryBeanName);
            mappings.addCollectionBinding(collection);
            value = collection;
        } else if (currentGrailsProp instanceof org.grails.datastore.mapping.model.types.ManyToOne) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("[GrailsDomainBinder] Binding property [" + currentGrailsProp.getName() + "] as ManyToOne"));
            }
            value = new ManyToOne((MetadataImplementor)mappings, table);
            this.bindManyToOne((Association)currentGrailsProp, value, path, mappings, sessionFactoryBeanName);
        } else if (currentGrailsProp instanceof OneToOne) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("[GrailsDomainBinder] Binding property [" + currentGrailsProp.getName() + "] as OneToOne"));
            }
            if (this.canBindOneToOneWithSingleColumnAndForeignKey((Association)currentGrailsProp)) {
                value = new org.hibernate.mapping.OneToOne((MetadataImplementor)mappings, table, persistentClass);
                this.bindOneToOne((OneToOne)currentGrailsProp, (org.hibernate.mapping.OneToOne)value, path, sessionFactoryBeanName);
            } else {
                value = new ManyToOne((MetadataImplementor)mappings, table);
                this.bindManyToOne((Association)currentGrailsProp, value, path, mappings, sessionFactoryBeanName);
            }
        } else if (currentGrailsProp instanceof Embedded) {
            value = new Component((MetadataImplementor)mappings, persistentClass);
            this.bindComponent((Component)value, (Embedded)currentGrailsProp, true, mappings, sessionFactoryBeanName);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("[GrailsDomainBinder] Binding property [" + currentGrailsProp.getName() + "] as SimpleValue"));
            }
            value = new SimpleValue((MetadataImplementor)mappings, table);
            if (currentGrailsProp.getType().isEnum()) {
                this.bindEnumType(currentGrailsProp, (SimpleValue)value, path, sessionFactoryBeanName);
            } else {
                this.bindSimpleValue(currentGrailsProp, componentProperty, (SimpleValue)value, path, mappings, sessionFactoryBeanName);
            }
        }
        if (value != null) {
            org.hibernate.mapping.Property persistentProperty = this.createProperty((Value)value, persistentClass, currentGrailsProp, mappings);
            component.addProperty(persistentProperty);
            if (this.isComponentPropertyNullable(componentProperty)) {
                Iterator columnIterator = value.getColumnIterator();
                while (columnIterator.hasNext()) {
                    Column c = (Column)columnIterator.next();
                    c.setNullable(true);
                }
            }
        }
    }

    protected boolean isComponentPropertyNullable(PersistentProperty componentProperty) {
        if (componentProperty == null) {
            return false;
        }
        PersistentEntity domainClass = componentProperty.getOwner();
        Mapping mapping = GrailsDomainBinder.getMapping(domainClass.getJavaClass());
        return !domainClass.isRoot() && (mapping == null || mapping.isTablePerHierarchy()) || componentProperty.isNullable();
    }

    protected org.hibernate.mapping.Property createProperty(Value value, PersistentClass persistentClass, PersistentProperty grailsProperty, InFlightMetadataCollector mappings) {
        value.setTypeUsingReflection(persistentClass.getClassName(), grailsProperty.getName());
        if (value.getTable() != null) {
            value.createForeignKey();
        }
        org.hibernate.mapping.Property prop = new org.hibernate.mapping.Property();
        prop.setValue(value);
        this.bindProperty(grailsProperty, prop, mappings);
        return prop;
    }

    protected void bindOneToMany(OneToMany currentGrailsProp, org.hibernate.mapping.OneToMany one, InFlightMetadataCollector mappings) {
        one.setReferencedEntityName(currentGrailsProp.getAssociatedEntity().getName());
        one.setIgnoreNotFound(true);
    }

    protected void bindManyToOne(Association property, ManyToOne manyToOne, String path, InFlightMetadataCollector mappings, String sessionFactoryBeanName) {
        NamingStrategy namingStrategy = this.getNamingStrategy(sessionFactoryBeanName);
        this.bindManyToOneValues(property, manyToOne);
        PersistentEntity refDomainClass = property instanceof ManyToMany ? property.getOwner() : property.getAssociatedEntity();
        Mapping mapping = GrailsDomainBinder.getMapping(refDomainClass);
        boolean isComposite = this.hasCompositeIdentifier(mapping);
        if (isComposite) {
            CompositeIdentity ci = (CompositeIdentity)mapping.getIdentity();
            this.bindCompositeIdentifierToManyToOne(property, (SimpleValue)manyToOne, ci, refDomainClass, path, sessionFactoryBeanName);
        } else if (property.isCircular() && property instanceof ManyToMany) {
            PropertyConfig pc = this.getPropertyConfig((PersistentProperty)property);
            if (pc.getColumns().isEmpty()) {
                mapping.getColumns().put(property.getName(), pc);
            }
            if (!this.hasJoinKeyMapping(pc)) {
                JoinTable jt = new JoinTable();
                ColumnConfig columnConfig = new ColumnConfig();
                columnConfig.setName(namingStrategy.propertyToColumnName(property.getName()) + '_' + FOREIGN_KEY_SUFFIX);
                jt.setKey(columnConfig);
                pc.setJoinTable(jt);
            }
            this.bindSimpleValue((PersistentProperty)property, (SimpleValue)manyToOne, path, pc, sessionFactoryBeanName);
        } else {
            this.bindSimpleValue((PersistentProperty)property, null, (SimpleValue)manyToOne, path, mappings, sessionFactoryBeanName);
        }
        PropertyConfig config = this.getPropertyConfig((PersistentProperty)property);
        if (property instanceof OneToOne && !isComposite) {
            manyToOne.setAlternateUniqueKey(true);
            Column c = this.getColumnForSimpleValue((SimpleValue)manyToOne);
            if (config != null) {
                c.setUnique(config.isUnique());
            } else if (property.isBidirectional() && this.isHasOne(property.getInverseSide())) {
                c.setUnique(true);
            }
        }
    }

    protected void bindCompositeIdentifierToManyToOne(Association property, SimpleValue value, CompositeIdentity compositeId, PersistentEntity refDomainClass, String path, String sessionFactoryBeanName) {
        NamingStrategy namingStrategy = this.getNamingStrategy(sessionFactoryBeanName);
        String[] propertyNames = compositeId.getPropertyNames();
        PropertyConfig config = this.getPropertyConfig((PersistentProperty)property);
        if (config.getColumns().size() != propertyNames.length) {
            for (String propertyName : propertyNames) {
                ColumnConfig cc = new ColumnConfig();
                cc.setName(this.addUnderscore(namingStrategy.classToTableName(refDomainClass.getJavaClass().getSimpleName()), this.getDefaultColumnName(refDomainClass.getPropertyByName(propertyName), sessionFactoryBeanName)));
                config.getColumns().add(cc);
            }
        }
        this.bindSimpleValue((PersistentProperty)property, value, path, config, sessionFactoryBeanName);
    }

    protected boolean hasCompositeIdentifier(Mapping mapping) {
        return mapping != null && mapping.getIdentity() instanceof CompositeIdentity;
    }

    protected void bindOneToOne(OneToOne property, org.hibernate.mapping.OneToOne oneToOne, String path, String sessionFactoryBeanName) {
        PropertyConfig config = this.getPropertyConfig((PersistentProperty)property);
        Association otherSide = property.getInverseSide();
        boolean hasOne = this.isHasOne(otherSide);
        oneToOne.setConstrained(hasOne);
        oneToOne.setForeignKeyType(oneToOne.isConstrained() ? ForeignKeyDirection.FROM_PARENT : ForeignKeyDirection.TO_PARENT);
        oneToOne.setAlternateUniqueKey(true);
        if (config != null && config.getFetch() != null) {
            oneToOne.setFetchMode(config.getFetch());
        } else {
            oneToOne.setFetchMode(FetchMode.DEFAULT);
        }
        oneToOne.setReferencedEntityName(otherSide.getOwner().getName());
        oneToOne.setPropertyName(property.getName());
        this.bindOneToOneInternal(property, oneToOne, path);
        if (hasOne) {
            PropertyConfig pc = this.getPropertyConfig((PersistentProperty)property);
            this.bindSimpleValue((PersistentProperty)property, (SimpleValue)oneToOne, path, pc, sessionFactoryBeanName);
        } else {
            oneToOne.setReferencedPropertyName(otherSide.getName());
        }
    }

    protected void bindOneToOneInternal(OneToOne property, org.hibernate.mapping.OneToOne oneToOne, String path) {
    }

    protected void bindManyToOneValues(Association property, ManyToOne manyToOne) {
        PropertyConfig config = this.getPropertyConfig((PersistentProperty)property);
        if (config != null && config.getFetch() != null) {
            manyToOne.setFetchMode(config.getFetch());
        } else {
            manyToOne.setFetchMode(FetchMode.DEFAULT);
        }
        manyToOne.setLazy(this.getLaziness((PersistentProperty)property));
        if (config != null) {
            manyToOne.setIgnoreNotFound(config.getIgnoreNotFound());
        }
        manyToOne.setReferencedEntityName(property.getAssociatedEntity().getName());
    }

    protected void bindVersion(PersistentProperty version, RootClass entity, InFlightMetadataCollector mappings, String sessionFactoryBeanName) {
        if (version != null) {
            SimpleValue val = new SimpleValue((MetadataImplementor)mappings, entity.getTable());
            this.bindSimpleValue(version, null, val, EMPTY_PATH, mappings, sessionFactoryBeanName);
            if (val.isTypeSpecified()) {
                if (!(val.getType() instanceof IntegerType || val.getType() instanceof LongType || val.getType() instanceof TimestampType)) {
                    LOG.warn((Object)("Invalid version class specified in " + version.getOwner().getName() + "; must be one of [int, Integer, long, Long, Timestamp, Date]. Not mapping the version."));
                    return;
                }
            } else {
                val.setTypeName("version".equals(version.getName()) ? "integer" : "timestamp");
            }
            org.hibernate.mapping.Property prop = new org.hibernate.mapping.Property();
            prop.setValue((Value)val);
            this.bindProperty(version, prop, mappings);
            val.setNullValue("undefined");
            entity.setVersion(prop);
            entity.setOptimisticLockMode(0);
            entity.addProperty(prop);
        }
    }

    protected void bindSimpleId(PersistentProperty identifier, RootClass entity, InFlightMetadataCollector mappings, Identity mappedId, String sessionFactoryBeanName) {
        Mapping mapping = GrailsDomainBinder.getMapping(identifier.getOwner());
        boolean useSequence = mapping != null && mapping.isTablePerConcreteClass();
        SimpleValue id = new SimpleValue((MetadataImplementor)mappings, entity.getTable());
        Properties params = new Properties();
        entity.setIdentifier((KeyValue)id);
        if (mappedId == null) {
            id.setIdentifierGeneratorStrategy(useSequence ? "sequence-identity" : "native");
        } else {
            String generator = mappedId.getGenerator();
            if ("native".equals(generator) && useSequence) {
                generator = "sequence-identity";
            }
            id.setIdentifierGeneratorStrategy(generator);
            params.putAll((java.util.Map<?, ?>)mappedId.getParams());
            if ("assigned".equals(generator)) {
                id.setNullValue("undefined");
            }
        }
        String schemaName = this.getSchemaName(mappings);
        String catalogName = this.getCatalogName(mappings);
        params.put("identifier_normalizer", this.metadataBuildingContext.getObjectNameNormalizer());
        if (schemaName != null) {
            params.setProperty("schema", schemaName);
        }
        if (catalogName != null) {
            params.setProperty("catalog", catalogName);
        }
        id.setIdentifierGeneratorProperties(params);
        this.bindSimpleValue(identifier, null, id, EMPTY_PATH, mappings, sessionFactoryBeanName);
        org.hibernate.mapping.Property prop = new org.hibernate.mapping.Property();
        prop.setValue((Value)id);
        this.bindProperty(identifier, prop, mappings);
        entity.setIdentifierProperty(prop);
        id.getTable().setIdentifierValue((KeyValue)id);
    }

    private String getSchemaName(InFlightMetadataCollector mappings) {
        Identifier schema = mappings.getDatabase().getDefaultNamespace().getName().getSchema();
        if (schema != null) {
            return schema.getCanonicalName();
        }
        return null;
    }

    private String getCatalogName(InFlightMetadataCollector mappings) {
        Identifier catalog = mappings.getDatabase().getDefaultNamespace().getName().getCatalog();
        if (catalog != null) {
            return catalog.getCanonicalName();
        }
        return null;
    }

    protected void bindProperty(PersistentProperty grailsProperty, org.hibernate.mapping.Property prop, InFlightMetadataCollector mappings) {
        boolean isLazyable;
        prop.setName(grailsProperty.getName());
        if (this.isBidirectionalManyToOneWithListMapping(grailsProperty, prop)) {
            prop.setInsertable(false);
            prop.setUpdateable(false);
        } else {
            prop.setInsertable(this.getInsertableness(grailsProperty));
            prop.setUpdateable(this.getUpdateableness(grailsProperty));
        }
        prop.setPropertyAccessorName(mappings.getMetadataBuildingOptions().getMappingDefaults().getImplicitPropertyAccessorName());
        prop.setOptional(grailsProperty.isNullable());
        this.setCascadeBehaviour(grailsProperty, prop);
        boolean isToOne = grailsProperty instanceof ToOne;
        boolean bl = isLazyable = isToOne || !(grailsProperty instanceof Association) && !grailsProperty.equals(grailsProperty.getOwner().getIdentity());
        if (isLazyable) {
            boolean isLazy = this.getLaziness(grailsProperty);
            prop.setLazy(isLazy);
            if (isLazy && isToOne) {
                this.handleLazyProxy(grailsProperty.getOwner(), grailsProperty);
            }
        }
    }

    protected boolean getLaziness(PersistentProperty grailsProperty) {
        PropertyConfig config = this.getPropertyConfig(grailsProperty);
        Boolean lazy = config.getLazy();
        return lazy == null || lazy != false;
    }

    protected boolean getInsertableness(PersistentProperty grailsProperty) {
        PropertyConfig config = this.getPropertyConfig(grailsProperty);
        return config == null || config.getInsertable();
    }

    protected boolean getUpdateableness(PersistentProperty grailsProperty) {
        PropertyConfig config = this.getPropertyConfig(grailsProperty);
        return config == null || config.getUpdateable();
    }

    protected boolean isBidirectionalManyToOneWithListMapping(PersistentProperty grailsProperty, org.hibernate.mapping.Property prop) {
        if (grailsProperty instanceof Association) {
            Association association = (Association)grailsProperty;
            Association otherSide = association.getInverseSide();
            return association.isBidirectional() && otherSide != null && prop.getValue() instanceof ManyToOne && java.util.List.class.isAssignableFrom(otherSide.getType());
        }
        return false;
    }

    protected void setCascadeBehaviour(PersistentProperty grailsProperty, org.hibernate.mapping.Property prop) {
        String cascadeStrategy = CASCADE_NONE;
        PersistentEntity domainClass = grailsProperty.getOwner();
        PropertyConfig config = this.getPropertyConfig(grailsProperty);
        if (config != null && config.getCascade() != null) {
            cascadeStrategy = config.getCascade();
        } else if (grailsProperty instanceof Association) {
            Association association = (Association)grailsProperty;
            PersistentEntity referenced = association.getAssociatedEntity();
            if (this.isHasOne(association)) {
                cascadeStrategy = CASCADE_ALL;
            } else if (association instanceof OneToOne) {
                cascadeStrategy = referenced != null && association.isOwningSide() ? CASCADE_ALL : CASCADE_SAVE_UPDATE;
            } else if (association instanceof OneToMany) {
                cascadeStrategy = referenced != null && association.isOwningSide() ? CASCADE_ALL : CASCADE_SAVE_UPDATE;
            } else if (grailsProperty instanceof ManyToMany) {
                if (referenced != null && referenced.isOwningEntity(domainClass) || association.isCircular()) {
                    cascadeStrategy = CASCADE_SAVE_UPDATE;
                }
            } else if (grailsProperty instanceof org.grails.datastore.mapping.model.types.ManyToOne) {
                cascadeStrategy = referenced != null && referenced.isOwningEntity(domainClass) && !this.isCircularAssociation(grailsProperty) ? CASCADE_ALL : (this.isCompositeIdProperty((Mapping)domainClass.getMapping().getMappedForm(), grailsProperty) ? CASCADE_ALL : CASCADE_NONE);
            } else if (grailsProperty instanceof Basic) {
                cascadeStrategy = CASCADE_ALL;
            } else if (java.util.Map.class.isAssignableFrom(grailsProperty.getType())) {
                referenced = association.getAssociatedEntity();
                cascadeStrategy = referenced != null && referenced.isOwningEntity(domainClass) ? CASCADE_ALL : CASCADE_SAVE_UPDATE;
            }
            this.logCascadeMapping(association, cascadeStrategy, referenced);
        }
        prop.setCascade(cascadeStrategy);
    }

    protected boolean isCircularAssociation(PersistentProperty grailsProperty) {
        return grailsProperty.getType().equals(grailsProperty.getOwner().getJavaClass());
    }

    protected void logCascadeMapping(Association grailsProperty, String cascadeStrategy, PersistentEntity referenced) {
        if (LOG.isDebugEnabled() & referenced != null) {
            String assType = this.getAssociationDescription(grailsProperty);
            LOG.debug((Object)("Mapping cascade strategy for " + assType + " property " + grailsProperty.getOwner().getName() + "." + grailsProperty.getName() + " referencing type [" + referenced.getJavaClass().getName() + "] -> [CASCADE: " + cascadeStrategy + "]"));
        }
    }

    protected String getAssociationDescription(Association grailsProperty) {
        String assType = "unknown";
        if (grailsProperty instanceof ManyToMany) {
            assType = "many-to-many";
        } else if (grailsProperty instanceof OneToMany) {
            assType = "one-to-many";
        } else if (grailsProperty instanceof OneToOne) {
            assType = "one-to-one";
        } else if (grailsProperty instanceof org.grails.datastore.mapping.model.types.ManyToOne) {
            assType = "many-to-one";
        } else if (grailsProperty.isEmbedded()) {
            assType = "embedded";
        }
        return assType;
    }

    protected void bindSimpleValue(PersistentProperty property, PersistentProperty parentProperty, SimpleValue simpleValue, String path, InFlightMetadataCollector mappings, String sessionFactoryBeanName) {
        this.bindSimpleValue(property, parentProperty, simpleValue, path, this.getPropertyConfig(property), sessionFactoryBeanName);
    }

    protected void bindSimpleValue(PersistentProperty grailsProp, SimpleValue simpleValue, String path, PropertyConfig propertyConfig, String sessionFactoryBeanName) {
        this.bindSimpleValue(grailsProp, null, simpleValue, path, propertyConfig, sessionFactoryBeanName);
    }

    protected void bindSimpleValue(PersistentProperty grailsProp, PersistentProperty parentProperty, SimpleValue simpleValue, String path, PropertyConfig propertyConfig, String sessionFactoryBeanName) {
        this.setTypeForPropertyConfig(grailsProp, simpleValue, propertyConfig);
        PropertyConfig mappedForm = (PropertyConfig)grailsProp.getMapping().getMappedForm();
        if (mappedForm.isDerived()) {
            Formula formula = new Formula();
            formula.setFormula(propertyConfig.getFormula());
            simpleValue.addFormula(formula);
        } else {
            java.util.List<Object> columnDefinitions;
            Table table = simpleValue.getTable();
            java.util.List<Object> list = columnDefinitions = propertyConfig != null ? propertyConfig.getColumns() : Arrays.asList(new Object[]{null});
            if (columnDefinitions.isEmpty()) {
                columnDefinitions = Arrays.asList(new Object[]{null});
            }
            for (Object columnDefinition : columnDefinitions) {
                ColumnConfig cc = (ColumnConfig)columnDefinition;
                Column column = new Column();
                if (cc != null) {
                    if (cc.getName() != null) {
                        column.setName(cc.getName());
                    }
                    if (cc.getSqlType() != null) {
                        column.setSqlType(cc.getSqlType());
                    }
                }
                column.setValue((Value)simpleValue);
                if (cc != null) {
                    if (cc.getLength() != -1) {
                        column.setLength(cc.getLength());
                    }
                    if (cc.getPrecision() != -1) {
                        column.setPrecision(cc.getPrecision());
                    }
                    if (cc.getScale() != -1) {
                        column.setScale(cc.getScale());
                    }
                    if (!mappedForm.isUniqueWithinGroup()) {
                        column.setUnique(cc.isUnique());
                    }
                }
                this.bindColumn(grailsProp, parentProperty, column, cc, path, table, sessionFactoryBeanName);
                if (table != null) {
                    table.addColumn(column);
                }
                simpleValue.addColumn(column);
            }
        }
    }

    protected void setTypeForPropertyConfig(PersistentProperty grailsProp, SimpleValue simpleValue, PropertyConfig config) {
        String typeName = this.getTypeName(grailsProp, this.getPropertyConfig(grailsProp), GrailsDomainBinder.getMapping(grailsProp.getOwner()));
        if (typeName == null) {
            simpleValue.setTypeName(grailsProp.getType().getName());
        } else {
            simpleValue.setTypeName(typeName);
            if (config != null) {
                simpleValue.setTypeParameters(config.getTypeParams());
            }
        }
    }

    protected void bindSimpleValue(String type, SimpleValue simpleValue, boolean nullable, String columnName, InFlightMetadataCollector mappings) {
        simpleValue.setTypeName(type);
        Table t = simpleValue.getTable();
        Column column = new Column();
        column.setNullable(nullable);
        column.setValue((Value)simpleValue);
        column.setName(columnName);
        if (t != null) {
            t.addColumn(column);
        }
        simpleValue.addColumn(column);
    }

    protected void bindColumn(PersistentProperty property, PersistentProperty parentProperty, Column column, ColumnConfig cc, String path, Table table, String sessionFactoryBeanName) {
        if (cc != null) {
            column.setComment(cc.getComment());
            column.setDefaultValue(cc.getDefaultValue());
            column.setCustomRead(cc.getRead());
            column.setCustomWrite(cc.getWrite());
        }
        Class<?> userType = this.getUserType(property);
        String columnName = this.getColumnNameForPropertyAndPath(property, path, cc, sessionFactoryBeanName);
        if (property instanceof Association && userType == null) {
            Association association = (Association)property;
            if (column.getName() == null) {
                column.setName(columnName);
            }
            if (property instanceof ManyToMany) {
                column.setNullable(false);
            } else if (property instanceof OneToOne && association.isBidirectional() && !association.isOwningSide()) {
                if (this.isHasOne(((Association)property).getInverseSide())) {
                    column.setNullable(false);
                } else {
                    column.setNullable(true);
                }
            } else if (property instanceof ToOne && association.isCircular()) {
                column.setNullable(true);
            } else {
                column.setNullable(property.isNullable());
            }
        } else {
            column.setName(columnName);
            column.setNullable(property.isNullable() || parentProperty != null && parentProperty.isNullable());
            if (String.class.isAssignableFrom(property.getType()) || byte[].class.isAssignableFrom(property.getType())) {
                this.bindStringColumnConstraints(column, property);
            }
            if (Number.class.isAssignableFrom(property.getType())) {
                this.bindNumericColumnConstraints(column, property, cc);
            }
        }
        this.handleUniqueConstraint(property, column, path, table, columnName, sessionFactoryBeanName);
        this.bindIndex(columnName, column, cc, table);
        PersistentEntity owner = property.getOwner();
        if (!owner.isRoot()) {
            Mapping mapping = GrailsDomainBinder.getMapping(owner);
            if (mapping == null || mapping.getTablePerHierarchy()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("[GrailsDomainBinder] Sub class property [" + property.getName() + "] for column name [" + column.getName() + "] set to nullable"));
                }
                column.setNullable(true);
            } else {
                column.setNullable(property.isNullable());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("[GrailsDomainBinder] bound property [" + property.getName() + "] to column name [" + column.getName() + "] in table [" + table.getName() + "]"));
        }
    }

    protected void createKeyForProps(PersistentProperty grailsProp, String path, Table table, String columnName, java.util.List<?> propertyNames, String sessionFactoryBeanName) {
        ArrayList<Column> keyList = new ArrayList<Column>();
        keyList.add(new Column(columnName));
        for (String propertyName : propertyNames) {
            PersistentProperty otherProp = grailsProp.getOwner().getPropertyByName(propertyName);
            String otherColumnName = this.getColumnNameForPropertyAndPath(otherProp, path, null, sessionFactoryBeanName);
            keyList.add(new Column(otherColumnName));
        }
        this.createUniqueKeyForColumns(table, columnName, keyList);
    }

    protected void createUniqueKeyForColumns(Table table, String columnName, java.util.List<Column> keyList) {
        Collections.reverse(keyList);
        UniqueKey key = table.getOrCreateUniqueKey("unique_" + table.getName() + '_' + columnName);
        java.util.List columns = key.getColumns();
        if (columns.isEmpty()) {
            LOG.debug((Object)("create unique key for " + table.getName() + " columns = " + keyList));
            key.addColumns(keyList.iterator());
        }
    }

    protected void bindIndex(String columnName, Column column, ColumnConfig cc, Table table) {
        if (cc == null) {
            return;
        }
        Object indexObj = cc.getIndex();
        String indexDefinition = null;
        if (indexObj instanceof Boolean) {
            Boolean b = (Boolean)indexObj;
            if (b.booleanValue()) {
                indexDefinition = table.getName() + '_' + columnName + "_idx";
            }
        } else if (indexObj != null) {
            indexDefinition = indexObj.toString();
        }
        if (indexDefinition == null) {
            return;
        }
        String[] tokens = indexDefinition.split(",");
        for (int i = 0; i < tokens.length; ++i) {
            String index = tokens[i];
            table.getOrCreateIndex(index).addColumn(column);
        }
    }

    protected String getColumnNameForPropertyAndPath(PersistentProperty grailsProp, String path, ColumnConfig cc, String sessionFactoryBeanName) {
        NamingStrategy namingStrategy = this.getNamingStrategy(sessionFactoryBeanName);
        String columnName = null;
        if (cc == null) {
            PersistentEntity domainClass = grailsProp.getOwner();
            Mapping m = GrailsDomainBinder.getMapping(domainClass);
            if (m != null) {
                PropertyConfig c = m.getPropertyConfig(grailsProp.getName());
                if (this.supportsJoinColumnMapping(grailsProp) && this.hasJoinKeyMapping(c)) {
                    columnName = c.getJoinTable().getKey().getName();
                } else if (c != null && c.getColumn() != null) {
                    columnName = c.getColumn();
                }
            }
        } else {
            PropertyConfig pc;
            columnName = this.supportsJoinColumnMapping(grailsProp) ? (this.hasJoinKeyMapping(pc = this.getPropertyConfig(grailsProp)) ? pc.getJoinTable().getKey().getName() : cc.getName()) : cc.getName();
        }
        if (columnName == null) {
            columnName = this.isNotEmpty(path) ? this.addUnderscore(namingStrategy.propertyToColumnName(path), this.getDefaultColumnName(grailsProp, sessionFactoryBeanName)) : this.getDefaultColumnName(grailsProp, sessionFactoryBeanName);
        }
        return columnName;
    }

    protected boolean hasJoinKeyMapping(PropertyConfig c) {
        return c != null && c.getJoinTable() != null && c.getJoinTable().getKey() != null;
    }

    protected boolean supportsJoinColumnMapping(PersistentProperty grailsProp) {
        return grailsProp instanceof ManyToMany || this.isUnidirectionalOneToMany(grailsProp) || grailsProp instanceof Basic;
    }

    protected String getDefaultColumnName(PersistentProperty property, String sessionFactoryBeanName) {
        NamingStrategy namingStrategy = this.getNamingStrategy(sessionFactoryBeanName);
        String columnName = namingStrategy.propertyToColumnName(property.getName());
        if (property instanceof Association) {
            Association association = (Association)property;
            boolean isBasic = property instanceof Basic;
            if (isBasic && ((PropertyConfig)property.getMapping().getMappedForm()).getType() != null) {
                return columnName;
            }
            if (isBasic) {
                return this.getForeignKeyForPropertyDomainClass(property, sessionFactoryBeanName);
            }
            if (property instanceof ManyToMany) {
                return this.getForeignKeyForPropertyDomainClass(property, sessionFactoryBeanName);
            }
            if (!association.isBidirectional() && association instanceof OneToMany) {
                String prefix = namingStrategy.classToTableName(property.getOwner().getName());
                return this.addUnderscore(prefix, columnName) + FOREIGN_KEY_SUFFIX;
            }
            if (property.isInherited() && this.isBidirectionalManyToOne(property)) {
                return namingStrategy.propertyToColumnName(property.getOwner().getName()) + '_' + columnName + FOREIGN_KEY_SUFFIX;
            }
            return columnName + FOREIGN_KEY_SUFFIX;
        }
        return columnName;
    }

    protected String getForeignKeyForPropertyDomainClass(PersistentProperty property, String sessionFactoryBeanName) {
        String propertyName = NameUtils.decapitalize((String)property.getOwner().getName());
        NamingStrategy namingStrategy = this.getNamingStrategy(sessionFactoryBeanName);
        return namingStrategy.propertyToColumnName(propertyName) + FOREIGN_KEY_SUFFIX;
    }

    protected String getIndexColumnName(PersistentProperty property, String sessionFactoryBeanName) {
        PropertyConfig pc = this.getPropertyConfig(property);
        if (pc != null && pc.getIndexColumn() != null && pc.getIndexColumn().getColumn() != null) {
            return pc.getIndexColumn().getColumn();
        }
        NamingStrategy namingStrategy = this.getNamingStrategy(sessionFactoryBeanName);
        return namingStrategy.propertyToColumnName(property.getName()) + '_' + "idx";
    }

    protected String getIndexColumnType(PersistentProperty property, String defaultType) {
        PropertyConfig pc = this.getPropertyConfig(property);
        if (pc != null && pc.getIndexColumn() != null && pc.getIndexColumn().getType() != null) {
            return this.getTypeName(property, pc.getIndexColumn(), GrailsDomainBinder.getMapping(property.getOwner()));
        }
        return defaultType;
    }

    protected String getMapElementName(PersistentProperty property, String sessionFactoryBeanName) {
        PropertyConfig pc = this.getPropertyConfig(property);
        if (this.hasJoinTableColumnNameMapping(pc)) {
            return pc.getJoinTable().getColumn().getName();
        }
        NamingStrategy namingStrategy = this.getNamingStrategy(sessionFactoryBeanName);
        return namingStrategy.propertyToColumnName(property.getName()) + '_' + "elt";
    }

    protected boolean hasJoinTableColumnNameMapping(PropertyConfig pc) {
        return pc != null && pc.getJoinTable() != null && pc.getJoinTable().getColumn() != null && pc.getJoinTable().getColumn().getName() != null;
    }

    protected void bindStringColumnConstraints(Column column, PersistentProperty constrainedProperty) {
        Property mappedForm = constrainedProperty.getMapping().getMappedForm();
        Number columnLength = mappedForm.getMaxSize();
        java.util.List inListValues = mappedForm.getInList();
        if (columnLength != null) {
            column.setLength(columnLength.intValue());
        } else if (inListValues != null) {
            column.setLength(this.getMaxSize(inListValues));
        }
    }

    protected void bindNumericColumnConstraints(Column column, PersistentProperty constrainedProperty) {
        this.bindNumericColumnConstraints(column, constrainedProperty, null);
    }

    protected void bindNumericColumnConstraints(Column column, PersistentProperty property, ColumnConfig cc) {
        int scale = 2;
        int precision = 19;
        PropertyConfig constrainedProperty = (PropertyConfig)property.getMapping().getMappedForm();
        if (cc != null && cc.getScale() > -1) {
            column.setScale(cc.getScale());
        } else if (constrainedProperty.getScale() > -1) {
            scale = constrainedProperty.getScale();
            column.setScale(scale);
        }
        if (cc != null && cc.getPrecision() > -1) {
            column.setPrecision(cc.getPrecision());
        } else {
            Comparable minConstraintValue = constrainedProperty.getMin();
            Comparable maxConstraintValue = constrainedProperty.getMax();
            int minConstraintValueLength = 0;
            if (minConstraintValue != null && minConstraintValue instanceof Number) {
                minConstraintValueLength = Math.max(this.countDigits((Number)((Object)minConstraintValue)), this.countDigits(((Number)((Object)minConstraintValue)).longValue()) + scale);
            }
            int maxConstraintValueLength = 0;
            if (maxConstraintValue != null && maxConstraintValue instanceof Number) {
                maxConstraintValueLength = Math.max(this.countDigits((Number)((Object)maxConstraintValue)), this.countDigits(((Number)((Object)maxConstraintValue)).longValue()) + scale);
            }
            precision = minConstraintValueLength > 0 && maxConstraintValueLength > 0 ? Math.max(minConstraintValueLength, maxConstraintValueLength) : (Integer)DefaultGroovyMethods.max((Object[])new Integer[]{precision, minConstraintValueLength, maxConstraintValueLength});
            column.setPrecision(precision);
        }
    }

    protected int countDigits(Number number) {
        int numDigits = 0;
        if (number != null) {
            String digitsOnly = number.toString().replaceAll("\\D", EMPTY_PATH);
            numDigits = digitsOnly.length();
        }
        return numDigits;
    }

    protected int getMaxSize(java.util.List<?> inListValues) {
        int maxSize = 0;
        for (Object inListValue : inListValues) {
            String value = (String)inListValue;
            maxSize = Math.max(value.length(), maxSize);
        }
        return maxSize;
    }

    protected Class<?> getGroovyAwareJoinedSubclassEntityPersisterClass() {
        return GroovyAwareJoinedSubclassEntityPersister.class;
    }

    protected void handleLazyProxy(PersistentEntity domainClass, PersistentProperty grailsProperty) {
        HibernateUtils.handleLazyProxy(domainClass, grailsProperty);
    }

    protected Class<?> getGroovyAwareSingleTableEntityPersisterClass() {
        return GroovyAwareSingleTableEntityPersister.class;
    }

    protected void handleUniqueConstraint(PersistentProperty property, Column column, String path, Table table, String columnName, String sessionFactoryBeanName) {
        PropertyConfig mappedForm = (PropertyConfig)property.getMapping().getMappedForm();
        if (mappedForm.isUnique()) {
            if (!mappedForm.isUniqueWithinGroup()) {
                column.setUnique(true);
            } else {
                this.createKeyForProps(property, path, table, columnName, mappedForm.getUniquenessGroup(), sessionFactoryBeanName);
            }
        }
    }

    protected boolean identityEnumTypeSupports(Class<?> propertyType) {
        return IdentityEnumType.supports(propertyType);
    }

    protected boolean isNotEmpty(String s) {
        return GrailsHibernateUtil.isNotEmpty(s);
    }

    protected String qualify(String prefix, String name) {
        return GrailsHibernateUtil.qualify(prefix, name);
    }

    protected String unqualify(String qualifiedName) {
        return GrailsHibernateUtil.unqualify(qualifiedName);
    }

    public MetadataBuildingContext getMetadataBuildingContext() {
        return this.metadataBuildingContext;
    }

    static {
        NAMING_STRATEGIES.put("DEFAULT", ImprovedNamingStrategy.INSTANCE);
    }

    class MapSecondPass
    extends GrailsCollectionSecondPass {
        private static final long serialVersionUID = -3244991685626409031L;

        public MapSecondPass(ToMany property, InFlightMetadataCollector mappings, org.hibernate.mapping.Collection coll, String sessionFactoryBeanName) {
            super(property, mappings, coll, sessionFactoryBeanName);
        }

        @Override
        public void doSecondPass(java.util.Map<?, ?> persistentClasses, java.util.Map<?, ?> inheritedMetas) throws MappingException {
            GrailsDomainBinder.this.bindMapSecondPass(this.property, this.mappings, persistentClasses, (Map)this.collection, this.sessionFactoryBeanName);
        }

        @Override
        public void doSecondPass(java.util.Map persistentClasses) throws MappingException {
            GrailsDomainBinder.this.bindMapSecondPass(this.property, this.mappings, persistentClasses, (Map)this.collection, this.sessionFactoryBeanName);
        }
    }

    class ListSecondPass
    extends GrailsCollectionSecondPass {
        private static final long serialVersionUID = -3024674993774205193L;

        public ListSecondPass(ToMany property, InFlightMetadataCollector mappings, org.hibernate.mapping.Collection coll, String sessionFactoryBeanName) {
            super(property, mappings, coll, sessionFactoryBeanName);
        }

        @Override
        public void doSecondPass(java.util.Map<?, ?> persistentClasses, java.util.Map<?, ?> inheritedMetas) throws MappingException {
            GrailsDomainBinder.this.bindListSecondPass(this.property, this.mappings, persistentClasses, (List)this.collection, this.sessionFactoryBeanName);
        }

        @Override
        public void doSecondPass(java.util.Map persistentClasses) throws MappingException {
            GrailsDomainBinder.this.bindListSecondPass(this.property, this.mappings, persistentClasses, (List)this.collection, this.sessionFactoryBeanName);
        }
    }

    class GrailsCollectionSecondPass
    implements SecondPass {
        private static final long serialVersionUID = -5540526942092611348L;
        protected ToMany property;
        protected InFlightMetadataCollector mappings;
        protected org.hibernate.mapping.Collection collection;
        protected String sessionFactoryBeanName;

        public GrailsCollectionSecondPass(ToMany property, InFlightMetadataCollector mappings, org.hibernate.mapping.Collection coll, String sessionFactoryBeanName) {
            this.property = property;
            this.mappings = mappings;
            this.collection = coll;
            this.sessionFactoryBeanName = sessionFactoryBeanName;
        }

        public void doSecondPass(java.util.Map<?, ?> persistentClasses, java.util.Map<?, ?> inheritedMetas) throws MappingException {
            GrailsDomainBinder.this.bindCollectionSecondPass(this.property, this.mappings, persistentClasses, this.collection, this.sessionFactoryBeanName);
            this.createCollectionKeys();
        }

        protected void createCollectionKeys() {
            this.collection.createAllKeys();
            if (LOG.isDebugEnabled()) {
                String msg = "Mapped collection key: " + this.columns((Value)this.collection.getKey());
                if (this.collection.isIndexed()) {
                    msg = msg + ", index: " + this.columns(((IndexedCollection)this.collection).getIndex());
                }
                msg = this.collection.isOneToMany() ? msg + ", one-to-many: " + ((org.hibernate.mapping.OneToMany)this.collection.getElement()).getReferencedEntityName() : msg + ", element: " + this.columns(this.collection.getElement());
                LOG.debug((Object)msg);
            }
        }

        protected String columns(Value val) {
            StringBuilder columns = new StringBuilder();
            Iterator iter = val.getColumnIterator();
            while (iter.hasNext()) {
                columns.append(((Selectable)iter.next()).getText());
                if (!iter.hasNext()) continue;
                columns.append(", ");
            }
            return columns.toString();
        }

        public void doSecondPass(java.util.Map persistentClasses) throws MappingException {
            GrailsDomainBinder.this.bindCollectionSecondPass(this.property, this.mappings, persistentClasses, this.collection, this.sessionFactoryBeanName);
            this.createCollectionKeys();
        }
    }
}

