/*
 * Decompiled with CFR 0.152.
 */
package org.grails.orm.hibernate;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.persistence.FlushModeType;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.proxy.ProxyHandler;
import org.grails.datastore.mapping.query.Query;
import org.grails.datastore.mapping.query.api.QueryableCriteria;
import org.grails.datastore.mapping.query.jpa.JpaQueryBuilder;
import org.grails.datastore.mapping.query.jpa.JpaQueryInfo;
import org.grails.datastore.mapping.reflect.ClassPropertyFetcher;
import org.grails.orm.hibernate.AbstractHibernateDatastore;
import org.grails.orm.hibernate.AbstractHibernateSession;
import org.grails.orm.hibernate.GrailsHibernateTemplate;
import org.grails.orm.hibernate.HibernateDatastore;
import org.grails.orm.hibernate.proxy.HibernateProxyHandler;
import org.grails.orm.hibernate.query.HibernateQuery;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Restrictions;
import org.hibernate.proxy.HibernateProxy;

public class HibernateSession
extends AbstractHibernateSession {
    ProxyHandler proxyHandler = new HibernateProxyHandler();

    public HibernateSession(HibernateDatastore hibernateDatastore, SessionFactory sessionFactory, int defaultFlushMode) {
        super((AbstractHibernateDatastore)hibernateDatastore, sessionFactory);
        this.hibernateTemplate = new GrailsHibernateTemplate(sessionFactory, (HibernateDatastore)this.getDatastore());
    }

    public HibernateSession(HibernateDatastore hibernateDatastore, SessionFactory sessionFactory) {
        this(hibernateDatastore, sessionFactory, hibernateDatastore.getDefaultFlushMode());
    }

    public Serializable getObjectIdentifier(Object instance) {
        if (instance == null) {
            return null;
        }
        if (this.proxyHandler.isProxy(instance)) {
            return ((HibernateProxy)instance).getHibernateLazyInitializer().getIdentifier();
        }
        Class<?> type = instance.getClass();
        ClassPropertyFetcher cpf = ClassPropertyFetcher.forClass(type);
        PersistentEntity persistentEntity = this.getMappingContext().getPersistentEntity(type.getName());
        if (persistentEntity != null) {
            return (Serializable)cpf.getPropertyValue(instance, persistentEntity.getIdentity().getName());
        }
        return null;
    }

    public long deleteAll(final QueryableCriteria criteria) {
        return this.getHibernateTemplate().execute(new GrailsHibernateTemplate.HibernateCallback<Integer>(){

            @Override
            public Integer doInHibernate(Session session) throws HibernateException, SQLException {
                JpaQueryBuilder builder = new JpaQueryBuilder(criteria);
                builder.setHibernateCompatible(true);
                JpaQueryInfo jpaQueryInfo = builder.buildDelete();
                org.hibernate.Query query = session.createQuery(jpaQueryInfo.getQuery());
                HibernateSession.this.getHibernateTemplate().applySettings(query);
                List parameters = jpaQueryInfo.getParameters();
                if (parameters != null) {
                    int count = parameters.size();
                    for (int i = 0; i < count; ++i) {
                        query.setParameter(i, parameters.get(i));
                    }
                }
                return query.executeUpdate();
            }
        }).intValue();
    }

    public long updateAll(final QueryableCriteria criteria, final Map<String, Object> properties) {
        return this.getHibernateTemplate().execute(new GrailsHibernateTemplate.HibernateCallback<Integer>(){

            @Override
            public Integer doInHibernate(Session session) throws HibernateException, SQLException {
                JpaQueryBuilder builder = new JpaQueryBuilder(criteria);
                builder.setHibernateCompatible(true);
                JpaQueryInfo jpaQueryInfo = builder.buildUpdate(properties);
                org.hibernate.Query query = session.createQuery(jpaQueryInfo.getQuery());
                HibernateSession.this.getHibernateTemplate().applySettings(query);
                List parameters = jpaQueryInfo.getParameters();
                if (parameters != null) {
                    int count = parameters.size();
                    for (int i = 0; i < count; ++i) {
                        query.setParameter(i, parameters.get(i));
                    }
                }
                return query.executeUpdate();
            }
        }).intValue();
    }

    public List retrieveAll(final Class type, final Iterable keys) {
        final PersistentEntity persistentEntity = this.getMappingContext().getPersistentEntity(type.getName());
        return this.getHibernateTemplate().execute(new GrailsHibernateTemplate.HibernateCallback<List>(){

            @Override
            public List doInHibernate(Session session) throws HibernateException, SQLException {
                Criteria criteria = session.createCriteria(type);
                HibernateSession.this.getHibernateTemplate().applySettings(criteria);
                return criteria.add(Restrictions.in((String)persistentEntity.getIdentity().getName(), (Collection)HibernateSession.this.getIterableAsCollection(keys))).list();
            }
        });
    }

    public Query createQuery(Class type) {
        return this.createQuery(type, null);
    }

    public Query createQuery(Class type, String alias) {
        PersistentEntity persistentEntity = this.getMappingContext().getPersistentEntity(type.getName());
        Session currentSession = this.getHibernateTemplate().getSessionFactory().getCurrentSession();
        Criteria criteria = alias != null ? currentSession.createCriteria(type, alias) : currentSession.createCriteria(type);
        this.getHibernateTemplate().applySettings(criteria);
        return new HibernateQuery(criteria, this, persistentEntity);
    }

    protected GrailsHibernateTemplate getHibernateTemplate() {
        return (GrailsHibernateTemplate)this.getNativeInterface();
    }

    public void setFlushMode(FlushModeType flushMode) {
        if (flushMode == FlushModeType.AUTO) {
            this.hibernateTemplate.setFlushMode(1);
        } else if (flushMode == FlushModeType.COMMIT) {
            this.hibernateTemplate.setFlushMode(3);
        }
    }

    public FlushModeType getFlushMode() {
        switch (this.hibernateTemplate.getFlushMode()) {
            case 1: {
                return FlushModeType.AUTO;
            }
            case 3: {
                return FlushModeType.COMMIT;
            }
            case 4: {
                return FlushModeType.AUTO;
            }
        }
        return FlushModeType.AUTO;
    }
}

