/*
 * Decompiled with CFR 0.152.
 */
package org.grails.orm.hibernate;

import java.util.concurrent.Callable;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.orm.hibernate.AbstractHibernateDatastore;
import org.grails.orm.hibernate.EventTriggeringInterceptor;
import org.grails.orm.hibernate.GrailsHibernateTemplate;
import org.grails.orm.hibernate.HibernateSession;
import org.grails.orm.hibernate.IHibernateTemplate;
import org.hibernate.FlushMode;
import org.hibernate.SessionFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.PropertyResolver;

public class HibernateDatastore
extends AbstractHibernateDatastore {
    public HibernateDatastore(MappingContext mappingContext, SessionFactory sessionFactory, PropertyResolver config) {
        super(mappingContext, sessionFactory, config, null, "DEFAULT");
    }

    public HibernateDatastore(MappingContext mappingContext, SessionFactory sessionFactory, PropertyResolver config, ApplicationContext applicationContext) {
        super(mappingContext, sessionFactory, config, applicationContext, "DEFAULT");
    }

    public HibernateDatastore(MappingContext mappingContext, SessionFactory sessionFactory, PropertyResolver config, String dataSourceName) {
        super(mappingContext, sessionFactory, config, null, dataSourceName);
    }

    protected Session createSession(PropertyResolver connectionDetails) {
        return new HibernateSession(this, this.sessionFactory);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        super.setApplicationContext(applicationContext);
        if (applicationContext != null && this.eventTriggeringInterceptor == null) {
            this.eventTriggeringInterceptor = new EventTriggeringInterceptor(this, this.connectionDetails);
            ((ConfigurableApplicationContext)applicationContext).addApplicationListener((ApplicationListener)this.eventTriggeringInterceptor);
        }
    }

    public IHibernateTemplate getHibernateTemplate(int flushMode) {
        return new GrailsHibernateTemplate(this.getSessionFactory(), this, flushMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withFlushMode(AbstractHibernateDatastore.FlushMode flushMode, Callable<Boolean> callable) {
        org.hibernate.Session session = this.sessionFactory.getCurrentSession();
        FlushMode previousMode = null;
        Boolean reset = true;
        try {
            if (session != null) {
                previousMode = session.getFlushMode();
                session.setFlushMode(FlushMode.valueOf((String)flushMode.name()));
            }
            try {
                reset = callable.call();
            }
            catch (Exception e) {
                reset = false;
            }
        }
        finally {
            if (session != null && previousMode != null && reset.booleanValue()) {
                session.setFlushMode(previousMode);
            }
        }
    }

    public org.hibernate.Session openSession() {
        return this.sessionFactory.openSession();
    }
}

