/*
 * Decompiled with CFR 0.152.
 */
package org.grails.orm.hibernate.cfg;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.grails.datastore.mapping.model.types.ToMany;
import org.grails.orm.hibernate.cfg.GrailsDomainBinder;
import org.hibernate.MappingException;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.mapping.Bag;
import org.hibernate.mapping.List;
import org.hibernate.mapping.PersistentClass;

abstract class CollectionType {
    protected final Class<?> clazz;
    protected final GrailsDomainBinder binder;
    protected final MetadataBuildingContext buildingContext;
    protected static CollectionType SET;
    protected static CollectionType LIST;
    protected static CollectionType BAG;
    protected static CollectionType MAP;
    protected static boolean initialized;
    protected static final Map<Class<?>, CollectionType> INSTANCES;

    public abstract org.hibernate.mapping.Collection create(ToMany var1, PersistentClass var2, String var3, InFlightMetadataCollector var4, String var5) throws MappingException;

    protected CollectionType(Class<?> clazz, GrailsDomainBinder binder) {
        this.clazz = clazz;
        this.binder = binder;
        this.buildingContext = binder.getMetadataBuildingContext();
    }

    public String toString() {
        return this.clazz.getName();
    }

    protected void createInstances() {
        if (initialized) {
            return;
        }
        initialized = true;
        SET = new CollectionType(Set.class, this.binder){

            @Override
            public org.hibernate.mapping.Collection create(ToMany property, PersistentClass owner, String path, InFlightMetadataCollector mappings, String sessionFactoryBeanName) throws MappingException {
                org.hibernate.mapping.Set coll = new org.hibernate.mapping.Set((MetadataImplementor)mappings, owner);
                coll.setCollectionTable(owner.getTable());
                this.binder.bindCollection(property, (org.hibernate.mapping.Collection)coll, owner, mappings, path, sessionFactoryBeanName);
                return coll;
            }
        };
        INSTANCES.put(Set.class, SET);
        INSTANCES.put(SortedSet.class, SET);
        LIST = new CollectionType(java.util.List.class, this.binder){

            @Override
            public org.hibernate.mapping.Collection create(ToMany property, PersistentClass owner, String path, InFlightMetadataCollector mappings, String sessionFactoryBeanName) throws MappingException {
                List coll = new List((MetadataImplementor)mappings, owner);
                coll.setCollectionTable(owner.getTable());
                this.binder.bindCollection(property, (org.hibernate.mapping.Collection)coll, owner, mappings, path, sessionFactoryBeanName);
                return coll;
            }
        };
        INSTANCES.put(java.util.List.class, LIST);
        BAG = new CollectionType(Collection.class, this.binder){

            @Override
            public org.hibernate.mapping.Collection create(ToMany property, PersistentClass owner, String path, InFlightMetadataCollector mappings, String sessionFactoryBeanName) throws MappingException {
                Bag coll = new Bag((MetadataImplementor)mappings, owner);
                coll.setCollectionTable(owner.getTable());
                this.binder.bindCollection(property, (org.hibernate.mapping.Collection)coll, owner, mappings, path, sessionFactoryBeanName);
                return coll;
            }
        };
        INSTANCES.put(Collection.class, BAG);
        MAP = new CollectionType(Map.class, this.binder){

            @Override
            public org.hibernate.mapping.Collection create(ToMany property, PersistentClass owner, String path, InFlightMetadataCollector mappings, String sessionFactoryBeanName) throws MappingException {
                org.hibernate.mapping.Map map = new org.hibernate.mapping.Map((MetadataImplementor)mappings, owner);
                this.binder.bindCollection(property, (org.hibernate.mapping.Collection)map, owner, mappings, path, sessionFactoryBeanName);
                return map;
            }
        };
        INSTANCES.put(Map.class, MAP);
    }

    public CollectionType collectionTypeForClass(Class<?> clazz) {
        this.createInstances();
        return INSTANCES.get(clazz);
    }

    static {
        INSTANCES = new HashMap();
    }
}

