/*
 * Decompiled with CFR 0.152.
 */
package org.grails.orm.hibernate.cfg;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.grails.orm.hibernate.EventListenerIntegrator;
import org.grails.orm.hibernate.GrailsSessionContext;
import org.grails.orm.hibernate.HibernateEventListeners;
import org.grails.orm.hibernate.cfg.GrailsDomainBinder;
import org.grails.orm.hibernate.cfg.GrailsIdentifierGeneratorFactory;
import org.grails.orm.hibernate.cfg.HibernateMappingContext;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.registry.classloading.internal.ClassLoaderServiceImpl;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.MetadataContributor;
import org.hibernate.cfg.Configuration;
import org.hibernate.context.spi.CurrentSessionContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;

public class HibernateMappingContextConfiguration
extends Configuration
implements ApplicationContextAware {
    private static final long serialVersionUID = -7115087342689305517L;
    protected static final Log LOG = LogFactory.getLog(HibernateMappingContextConfiguration.class);
    private static final String RESOURCE_PATTERN = "/**/*.class";
    private static final TypeFilter[] ENTITY_TYPE_FILTERS = new TypeFilter[]{new AnnotationTypeFilter(Entity.class, false), new AnnotationTypeFilter(Embeddable.class, false), new AnnotationTypeFilter(MappedSuperclass.class, false)};
    protected String sessionFactoryBeanName = "sessionFactory";
    protected String dataSourceName = "DEFAULT";
    protected HibernateMappingContext hibernateMappingContext;
    private Class<? extends CurrentSessionContext> currentSessionContext = GrailsSessionContext.class;
    private HibernateEventListeners hibernateEventListeners;
    private Map<String, Object> eventListeners;
    private ServiceRegistry serviceRegistry;
    private ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();

    public void setHibernateMappingContext(HibernateMappingContext hibernateMappingContext) {
        this.hibernateMappingContext = hibernateMappingContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.resourcePatternResolver = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)applicationContext);
        String dsName = "DEFAULT".equals(this.dataSourceName) ? "dataSource" : "dataSource_" + this.dataSourceName;
        this.getProperties().put("hibernate.connection.datasource", applicationContext.getBean(dsName));
        this.getProperties().put("hibernate.current_session_context_class", this.currentSessionContext.getName());
        this.getProperties().put("hibernate.classLoaders", applicationContext.getClassLoader());
    }

    public void addAnnotatedClasses(Class<?> ... annotatedClasses) {
        for (Class<?> annotatedClass : annotatedClasses) {
            this.addAnnotatedClass(annotatedClass);
        }
    }

    public void addPackages(String ... annotatedPackages) {
        for (String annotatedPackage : annotatedPackages) {
            this.addPackage(annotatedPackage);
        }
    }

    public void scanPackages(String ... packagesToScan) throws HibernateException {
        try {
            for (String pkg : packagesToScan) {
                String pattern = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)pkg) + RESOURCE_PATTERN;
                Resource[] resources = this.resourcePatternResolver.getResources(pattern);
                CachingMetadataReaderFactory readerFactory = new CachingMetadataReaderFactory((ResourceLoader)this.resourcePatternResolver);
                for (Resource resource : resources) {
                    if (!resource.isReadable()) continue;
                    MetadataReader reader = readerFactory.getMetadataReader(resource);
                    String className = reader.getClassMetadata().getClassName();
                    if (!this.matchesFilter(reader, (MetadataReaderFactory)readerFactory)) continue;
                    this.addAnnotatedClasses(this.resourcePatternResolver.getClassLoader().loadClass(className));
                }
            }
        }
        catch (IOException ex) {
            throw new MappingException("Failed to scan classpath for unlisted classes", (Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            throw new MappingException("Failed to load annotated classes from classpath", (Throwable)ex);
        }
    }

    protected boolean matchesFilter(MetadataReader reader, MetadataReaderFactory readerFactory) throws IOException {
        for (TypeFilter filter : ENTITY_TYPE_FILTERS) {
            if (!filter.match(reader, readerFactory)) continue;
            return true;
        }
        return false;
    }

    public void setSessionFactoryBeanName(String name) {
        this.sessionFactoryBeanName = name;
    }

    public void setDataSourceName(String name) {
        this.dataSourceName = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionFactory buildSessionFactory() throws HibernateException {
        SessionFactory sessionFactory = null;
        Object classLoaderObject = this.getProperties().get("hibernate.classLoaders");
        List<Object> appClassLoaders = classLoaderObject instanceof Collection ? (List)classLoaderObject : (classLoaderObject instanceof ClassLoader ? Collections.singletonList((ClassLoader)classLoaderObject) : Collections.emptyList());
        Thread currentThread = Thread.currentThread();
        ClassLoader threadContextClassLoader = currentThread.getContextClassLoader();
        boolean overrideClassLoader = false;
        ClassLoader appClassLoader = null;
        if (!appClassLoaders.isEmpty()) {
            for (ClassLoader classLoader : appClassLoaders) {
                if (classLoader.equals(threadContextClassLoader)) continue;
                overrideClassLoader = true;
                appClassLoader = classLoader;
                break;
            }
        } else {
            appClassLoaders = Arrays.asList(threadContextClassLoader, ((Object)((Object)this)).getClass().getClassLoader());
        }
        if (overrideClassLoader) {
            currentThread.setContextClassLoader(appClassLoader);
        }
        try {
            ConfigurationHelper.resolvePlaceHolders((Map)this.getProperties());
            final GrailsDomainBinder domainBinder = new GrailsDomainBinder(this.sessionFactoryBeanName, this.hibernateMappingContext);
            ClassLoaderServiceImpl classLoaderServiceImpl = new ClassLoaderServiceImpl(appClassLoaders){

                public <S> Collection<S> loadJavaServices(Class<S> serviceContract) {
                    if (MetadataContributor.class.isAssignableFrom(serviceContract)) {
                        return Collections.singletonList(domainBinder);
                    }
                    return super.loadJavaServices(serviceContract);
                }
            };
            EventListenerIntegrator eventListenerIntegrator = new EventListenerIntegrator(this.hibernateEventListeners, this.eventListeners);
            BootstrapServiceRegistry bootstrapServiceRegistry = new BootstrapServiceRegistryBuilder().applyIntegrator((Integrator)eventListenerIntegrator).applyClassLoaderService((ClassLoaderService)classLoaderServiceImpl).build();
            this.setSessionFactoryObserver(new SessionFactoryObserver(){
                private static final long serialVersionUID = 1L;

                public void sessionFactoryCreated(SessionFactory factory) {
                }

                public void sessionFactoryClosed(SessionFactory factory) {
                    ((ServiceRegistryImplementor)HibernateMappingContextConfiguration.this.serviceRegistry).destroy();
                }
            });
            StandardServiceRegistryBuilder standardServiceRegistryBuilder = new StandardServiceRegistryBuilder(bootstrapServiceRegistry).applySettings((Map)this.getProperties());
            sessionFactory = super.buildSessionFactory((ServiceRegistry)standardServiceRegistryBuilder.build());
            this.serviceRegistry = ((SessionFactoryImplementor)sessionFactory).getServiceRegistry();
        }
        finally {
            if (overrideClassLoader) {
                currentThread.setContextClassLoader(threadContextClassLoader);
            }
        }
        return sessionFactory;
    }

    public void setEventListeners(Map<String, Object> listeners) {
        this.eventListeners = listeners;
    }

    public void setHibernateEventListeners(HibernateEventListeners listeners) {
        this.hibernateEventListeners = listeners;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    protected void reset() {
        super.reset();
        try {
            GrailsIdentifierGeneratorFactory.applyNewInstance(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

