/*
 * Decompiled with CFR 0.152.
 */
package org.grails.orm.hibernate.transaction;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import javax.sql.DataSource;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.engine.jdbc.connections.internal.DatasourceConnectionProviderImpl;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.spi.JdbcConnectionAccess;
import org.hibernate.engine.transaction.internal.jdbc.JdbcIsolationDelegate;
import org.hibernate.engine.transaction.internal.jdbc.JdbcTransaction;
import org.hibernate.engine.transaction.spi.IsolationDelegate;
import org.hibernate.engine.transaction.spi.TransactionCoordinator;
import org.hibernate.engine.transaction.spi.TransactionFactory;
import org.hibernate.service.spi.Wrapped;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.util.ReflectionUtils;

public class GrailsJdbcTransactionFactory
implements TransactionFactory<GrailsJdbcTransaction> {
    private static final long serialVersionUID = 1L;

    public GrailsJdbcTransaction createTransaction(TransactionCoordinator transactionCoordinator) {
        return new GrailsJdbcTransaction(transactionCoordinator);
    }

    public boolean canBeDriver() {
        return true;
    }

    public ConnectionReleaseMode getDefaultReleaseMode() {
        return ConnectionReleaseMode.ON_CLOSE;
    }

    public boolean compatibleWithJtaSynchronization() {
        return false;
    }

    public boolean isJoinableJtaTransaction(TransactionCoordinator transactionCoordinator, GrailsJdbcTransaction transaction) {
        return false;
    }

    private static class ConnectionProviderJdbcConnectionAccess
    implements JdbcConnectionAccess {
        private static final long serialVersionUID = 1L;
        private final ConnectionProvider connectionProvider;

        public ConnectionProviderJdbcConnectionAccess(ConnectionProvider connectionProvider) {
            this.connectionProvider = connectionProvider;
        }

        public Connection obtainConnection() throws SQLException {
            return this.connectionProvider.getConnection();
        }

        public void releaseConnection(Connection connection) throws SQLException {
            this.connectionProvider.closeConnection(connection);
        }

        public boolean supportsAggressiveRelease() {
            return this.connectionProvider.supportsAggressiveRelease();
        }
    }

    public static class GrailsJdbcIsolationDelegate
    extends JdbcIsolationDelegate {
        public GrailsJdbcIsolationDelegate(TransactionCoordinator transactionCoordinator) {
            super(transactionCoordinator);
        }

        protected JdbcConnectionAccess jdbcConnectionAccess() {
            JdbcConnectionAccess connectionAccess = super.jdbcConnectionAccess();
            Field connectionProviderField = ReflectionUtils.findField(connectionAccess.getClass(), (String)"connectionProvider");
            if (connectionProviderField != null) {
                DataSource dataSource;
                ReflectionUtils.makeAccessible((Field)connectionProviderField);
                Object connectionProvider = ReflectionUtils.getField((Field)connectionProviderField, (Object)connectionAccess);
                if (connectionProvider instanceof Wrapped && (dataSource = (DataSource)((Wrapped)connectionProvider).unwrap(DataSource.class)) instanceof TransactionAwareDataSourceProxy) {
                    DataSource unwrapped = ((TransactionAwareDataSourceProxy)dataSource).getTargetDataSource();
                    DatasourceConnectionProviderImpl dsProvider = new DatasourceConnectionProviderImpl();
                    HashMap<String, DataSource> configValues = new HashMap<String, DataSource>();
                    configValues.put("hibernate.connection.datasource", unwrapped);
                    dsProvider.configure(configValues);
                    return new ConnectionProviderJdbcConnectionAccess((ConnectionProvider)dsProvider);
                }
            }
            return connectionAccess;
        }
    }

    public static class GrailsJdbcTransaction
    extends JdbcTransaction {
        protected GrailsJdbcTransaction(TransactionCoordinator transactionCoordinator) {
            super(transactionCoordinator);
        }

        public IsolationDelegate createIsolationDelegate() {
            return new GrailsJdbcIsolationDelegate(this.transactionCoordinator());
        }
    }
}

