/*
 * Decompiled with CFR 0.152.
 */
package org.grails.orm.hibernate.cfg;

import grails.core.ArtefactHandler;
import grails.core.GrailsApplication;
import grails.core.GrailsClass;
import grails.core.GrailsDomainClass;
import groovy.lang.Closure;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.grails.core.artefact.AnnotationDomainClassArtefactHandler;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.orm.hibernate.EventListenerIntegrator;
import org.grails.orm.hibernate.GrailsSessionContext;
import org.grails.orm.hibernate.HibernateEventListeners;
import org.grails.orm.hibernate.cfg.GrailsDomainBinder;
import org.grails.orm.hibernate.cfg.GrailsDomainConfiguration;
import org.grails.orm.hibernate.cfg.GrailsHibernateUtil;
import org.grails.orm.hibernate.cfg.GrailsIdentifierGeneratorFactory;
import org.grails.orm.hibernate.cfg.HibernateMappingContext;
import org.grails.orm.hibernate.cfg.Mapping;
import org.grails.orm.hibernate.proxy.GroovyAwarePojoEntityTuplizer;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.ImprovedNamingStrategy;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.cfg.Settings;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.mapping.JoinedSubclass;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.RootClass;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;

public class GrailsAnnotationConfiguration
extends Configuration
implements GrailsDomainConfiguration,
InitializingBean,
ApplicationContextAware {
    private static final long serialVersionUID = -7115087342689305517L;
    private static final Log LOG = LogFactory.getLog(GrailsAnnotationConfiguration.class);
    private GrailsApplication grailsApplication;
    private Set<GrailsDomainClass> domainClasses = new HashSet<GrailsDomainClass>();
    private boolean configLocked;
    private String sessionFactoryBeanName = "sessionFactory";
    private String dataSourceName = Mapping.DEFAULT_DATA_SOURCE;
    private static final String RESOURCE_PATTERN = "/**/*.class";
    private static final TypeFilter[] ENTITY_TYPE_FILTERS = new TypeFilter[]{new AnnotationTypeFilter(Entity.class, false), new AnnotationTypeFilter(Embeddable.class, false), new AnnotationTypeFilter(MappedSuperclass.class, false)};
    private ResourcePatternResolver resourcePatternResolver;
    private ServiceRegistry serviceRegistry;
    private HibernateEventListeners hibernateEventListeners;
    private Map<String, Object> eventListeners;
    protected GrailsDomainBinder binder = new GrailsDomainBinder();
    protected ApplicationContext applicationContext;
    private boolean subclassForeignKeysCreated = false;

    public GrailsDomainConfiguration addDomainClass(GrailsDomainClass domainClass) {
        if (this.shouldMapWithGorm(domainClass)) {
            this.domainClasses.add(domainClass);
        } else {
            this.addAnnotatedClass(domainClass.getClazz());
        }
        return this;
    }

    private boolean shouldMapWithGorm(GrailsDomainClass domainClass) {
        return !AnnotationDomainClassArtefactHandler.isJPADomainClass((Class)domainClass.getClazz()) && domainClass.getMappingStrategy().equalsIgnoreCase("GORM");
    }

    public void setGrailsApplication(GrailsApplication application) {
        GrailsClass[] existingDomainClasses;
        this.grailsApplication = application;
        if (this.grailsApplication == null) {
            return;
        }
        for (GrailsClass existingDomainClass : existingDomainClasses = this.grailsApplication.getArtefacts("Domain")) {
            this.addDomainClass((GrailsDomainClass)existingDomainClass);
        }
    }

    public void setSessionFactoryBeanName(String name) {
        this.sessionFactoryBeanName = name;
    }

    public void setDataSourceName(String name) {
        this.dataSourceName = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void secondPassCompile() throws MappingException {
        Thread currentThread = Thread.currentThread();
        ClassLoader originalContextLoader = currentThread.getContextClassLoader();
        try {
            if (this.grailsApplication != null) {
                currentThread.setContextClassLoader(this.grailsApplication.getClassLoader());
            }
            Mappings mappings = super.createMappings();
            if (!this.configLocked) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("[GrailsAnnotationConfiguration] [" + this.domainClasses.size() + "] Grails domain classes to bind to persistence runtime"));
                }
                Closure defaultMapping = (Closure)this.grailsApplication.getConfig().getProperty("grails.gorm.default.mapping", Closure.class);
                HibernateMappingContext mappingContext = new HibernateMappingContext(defaultMapping);
                for (GrailsDomainClass domainClass : this.domainClasses) {
                    PersistentEntity entity = mappingContext.addPersistentEntity(domainClass.getClazz());
                    mappingContext.addEntityValidator(entity, domainClass.getValidator());
                    this.binder.evaluateMapping(entity);
                }
                Iterator<Object> i$ = mappingContext.getPersistentEntities().iterator();
                while (i$.hasNext()) {
                    GrailsDomainClass domainClass;
                    ClassLoader loader = originalContextLoader;
                    domainClass = (PersistentEntity)i$.next();
                    String fullClassName = domainClass.getName();
                    String hibernateConfig = fullClassName.replace('.', '/') + ".hbm.xml";
                    if (loader.getResource(hibernateConfig) != null || !GrailsHibernateUtil.usesDatasource((PersistentEntity)domainClass, this.dataSourceName)) continue;
                    LOG.debug((Object)("[GrailsAnnotationConfiguration] Binding persistent class [" + fullClassName + "]"));
                    Mapping m = GrailsDomainBinder.getMapping((PersistentEntity)domainClass);
                    mappings.setAutoImport(m == null || m.getAutoImport());
                    this.binder.bindClass((PersistentEntity)domainClass, mappings, this.sessionFactoryBeanName);
                }
            }
            super.secondPassCompile();
            this.createSubclassForeignKeys();
        }
        finally {
            currentThread.setContextClassLoader(originalContextLoader);
        }
        this.configLocked = true;
    }

    private void createSubclassForeignKeys() {
        if (this.subclassForeignKeysCreated) {
            return;
        }
        for (PersistentClass persistentClass : this.classes.values()) {
            RootClass rootClass;
            if (!(persistentClass instanceof RootClass) || !(rootClass = (RootClass)persistentClass).hasSubclasses()) continue;
            Iterator subclasses = rootClass.getSubclassIterator();
            while (subclasses.hasNext()) {
                Object subclass = subclasses.next();
                if (!(subclass instanceof JoinedSubclass)) continue;
                JoinedSubclass joinedSubclass = (JoinedSubclass)subclass;
                joinedSubclass.createForeignKey();
            }
        }
        this.subclassForeignKeysCreated = true;
    }

    private void configureNamingStrategy() {
        NamingStrategy strategy = null;
        Object customStrategy = this.grailsApplication.getConfig().getProperty("hibernate.naming_strategy", Object.class, null);
        if (customStrategy != null) {
            Class<?> namingStrategyClass = null;
            if (customStrategy instanceof Class) {
                namingStrategyClass = (Class<?>)customStrategy;
            } else {
                try {
                    namingStrategyClass = this.grailsApplication.getClassLoader().loadClass(customStrategy.toString());
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            if (namingStrategyClass != null) {
                try {
                    strategy = (NamingStrategy)namingStrategyClass.newInstance();
                }
                catch (InstantiationException e) {
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
            }
        }
        if (strategy == null) {
            strategy = ImprovedNamingStrategy.INSTANCE;
        }
        this.setNamingStrategy(strategy);
    }

    public void addAnnotatedClasses(Class<?> ... annotatedClasses) {
        for (Class<?> annotatedClass : annotatedClasses) {
            this.addAnnotatedClass(annotatedClass);
        }
    }

    public void addPackages(String ... annotatedPackages) {
        for (String annotatedPackage : annotatedPackages) {
            this.addPackage(annotatedPackage);
        }
    }

    public void setEventListeners(Map<String, Object> listeners) {
        this.eventListeners = listeners;
    }

    public void setHibernateEventListeners(HibernateEventListeners listeners) {
        this.hibernateEventListeners = listeners;
    }

    public void scanPackages(String ... packagesToScan) throws HibernateException {
        try {
            for (String pkg : packagesToScan) {
                String pattern = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)pkg) + RESOURCE_PATTERN;
                Resource[] resources = this.resourcePatternResolver.getResources(pattern);
                CachingMetadataReaderFactory readerFactory = new CachingMetadataReaderFactory((ResourceLoader)this.resourcePatternResolver);
                for (Resource resource : resources) {
                    if (!resource.isReadable()) continue;
                    MetadataReader reader = readerFactory.getMetadataReader(resource);
                    String className = reader.getClassMetadata().getClassName();
                    if (!this.matchesFilter(reader, (MetadataReaderFactory)readerFactory)) continue;
                    this.addAnnotatedClasses(this.resourcePatternResolver.getClassLoader().loadClass(className));
                }
            }
        }
        catch (IOException ex) {
            throw new MappingException("Failed to scan classpath for unlisted classes", (Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            throw new MappingException("Failed to load annotated classes from classpath", (Throwable)ex);
        }
    }

    protected boolean matchesFilter(MetadataReader reader, MetadataReaderFactory readerFactory) throws IOException {
        for (TypeFilter filter : ENTITY_TYPE_FILTERS) {
            if (!filter.match(reader, readerFactory)) continue;
            return true;
        }
        return false;
    }

    public Settings buildSettings(ServiceRegistry serviceRegistry) {
        Settings settings = super.buildSettings(serviceRegistry);
        settings.getEntityTuplizerFactory().registerDefaultTuplizerClass(EntityMode.POJO, GroovyAwarePojoEntityTuplizer.class);
        return settings;
    }

    public Settings buildSettings(Properties props, ServiceRegistry serviceRegistry) throws HibernateException {
        Settings settings = super.buildSettings(props, serviceRegistry);
        settings.getEntityTuplizerFactory().registerDefaultTuplizerClass(EntityMode.POJO, GroovyAwarePojoEntityTuplizer.class);
        return settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionFactory buildSessionFactory() throws HibernateException {
        boolean overrideClassLoader;
        HashMap empty = new HashMap();
        this.addFilterDefinition(new FilterDefinition("dynamicFilterEnabler", "1=1", empty));
        SessionFactory sessionFactory = null;
        ClassLoader appClassLoader = (ClassLoader)this.getProperties().get("hibernate.classLoader.application");
        Thread currentThread = Thread.currentThread();
        ClassLoader threadContextClassLoader = currentThread.getContextClassLoader();
        boolean bl = overrideClassLoader = appClassLoader != null && !appClassLoader.equals(threadContextClassLoader);
        if (overrideClassLoader) {
            currentThread.setContextClassLoader(appClassLoader);
        }
        try {
            ConfigurationHelper.resolvePlaceHolders((Map)this.getProperties());
            EventListenerIntegrator eventListenerIntegrator = new EventListenerIntegrator(this.hibernateEventListeners, this.eventListeners);
            BootstrapServiceRegistry bootstrapServiceRegistry = new BootstrapServiceRegistryBuilder().with((Integrator)eventListenerIntegrator).build();
            this.setSessionFactoryObserver(new SessionFactoryObserver(){
                private static final long serialVersionUID = 1L;

                public void sessionFactoryCreated(SessionFactory factory) {
                }

                public void sessionFactoryClosed(SessionFactory factory) {
                    ((ServiceRegistryImplementor)GrailsAnnotationConfiguration.this.serviceRegistry).destroy();
                }
            });
            StandardServiceRegistryBuilder standardServiceRegistryBuilder = new StandardServiceRegistryBuilder(bootstrapServiceRegistry).applySettings((Map)this.getProperties());
            sessionFactory = super.buildSessionFactory((ServiceRegistry)standardServiceRegistryBuilder.build());
            this.serviceRegistry = ((SessionFactoryImplementor)sessionFactory).getServiceRegistry();
        }
        finally {
            if (overrideClassLoader) {
                currentThread.setContextClassLoader(threadContextClassLoader);
            }
        }
        return sessionFactory;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    public void afterPropertiesSet() throws Exception {
        GrailsClass[] existingDomainClasses;
        if (this.grailsApplication == null) {
            return;
        }
        String dsName = Mapping.DEFAULT_DATA_SOURCE.equals(this.dataSourceName) ? "dataSource" : "dataSource_" + this.dataSourceName;
        this.getProperties().put("hibernate.connection.datasource", this.applicationContext.getBean(dsName));
        this.getProperties().put("hibernate.current_session_context_class", GrailsSessionContext.class.getName());
        this.getProperties().put("hibernate.classLoaders", this.grailsApplication.getClassLoader());
        this.resourcePatternResolver = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)this.applicationContext);
        this.configureNamingStrategy();
        for (GrailsClass existingDomainClass : existingDomainClasses = this.grailsApplication.getArtefacts("Domain")) {
            this.addDomainClass((GrailsDomainClass)existingDomainClass);
        }
        ArtefactHandler handler = this.grailsApplication.getArtefactHandler("Domain");
        if (!(handler instanceof AnnotationDomainClassArtefactHandler)) {
            return;
        }
        Set jpaDomainNames = ((AnnotationDomainClassArtefactHandler)handler).getJpaClassNames();
        if (jpaDomainNames == null) {
            return;
        }
        ClassLoader loader = this.grailsApplication.getClassLoader();
        for (String jpaDomainName : jpaDomainNames) {
            try {
                this.addAnnotatedClass(loader.loadClass(jpaDomainName));
            }
            catch (ClassNotFoundException e) {}
        }
    }

    protected void reset() {
        super.reset();
        try {
            GrailsIdentifierGeneratorFactory.applyNewInstance(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

