/*
 * Decompiled with CFR 0.152.
 */
package org.grails.orm.hibernate.cfg;

import grails.core.GrailsApplication;
import grails.core.GrailsClass;
import grails.core.GrailsDomainClass;
import groovy.lang.Closure;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.orm.hibernate.cfg.GrailsDomainBinder;
import org.grails.orm.hibernate.cfg.GrailsDomainConfiguration;
import org.grails.orm.hibernate.cfg.GrailsHibernateUtil;
import org.grails.orm.hibernate.cfg.GrailsIdentifierGeneratorFactory;
import org.grails.orm.hibernate.cfg.HibernateMappingContext;
import org.grails.orm.hibernate.cfg.Mapping;
import org.grails.orm.hibernate.proxy.GroovyAwarePojoEntityTuplizer;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.Settings;
import org.hibernate.service.ServiceRegistry;

public class DefaultGrailsDomainConfiguration
extends Configuration
implements GrailsDomainConfiguration {
    private static final long serialVersionUID = -7115087342689305517L;
    private GrailsApplication grailsApplication;
    private Set<GrailsDomainClass> domainClasses = new HashSet<GrailsDomainClass>();
    private boolean configLocked;
    private String sessionFactoryBeanName = "sessionFactory";
    private String dataSourceName = Mapping.DEFAULT_DATA_SOURCE;
    protected GrailsDomainBinder binder = new GrailsDomainBinder();

    public GrailsDomainConfiguration addDomainClass(GrailsDomainClass domainClass) {
        if (domainClass.getMappingStrategy().equalsIgnoreCase("GORM")) {
            this.domainClasses.add(domainClass);
        }
        return this;
    }

    public void setGrailsApplication(GrailsApplication application) {
        GrailsClass[] existingDomainClasses;
        this.grailsApplication = application;
        if (this.grailsApplication == null) {
            return;
        }
        for (GrailsClass existingDomainClass : existingDomainClasses = this.grailsApplication.getArtefacts("Domain")) {
            this.addDomainClass((GrailsDomainClass)existingDomainClass);
        }
    }

    public void setSessionFactoryBeanName(String name) {
        this.sessionFactoryBeanName = name;
    }

    public void setDataSourceName(String name) {
        this.dataSourceName = name;
    }

    public Settings buildSettings(ServiceRegistry serviceRegistry) {
        Settings settings = super.buildSettings(serviceRegistry);
        settings.getEntityTuplizerFactory().registerDefaultTuplizerClass(EntityMode.POJO, GroovyAwarePojoEntityTuplizer.class);
        return settings;
    }

    public Settings buildSettings(Properties props, ServiceRegistry serviceRegistry) throws HibernateException {
        Settings settings = super.buildSettings(props, serviceRegistry);
        settings.getEntityTuplizerFactory().registerDefaultTuplizerClass(EntityMode.POJO, GroovyAwarePojoEntityTuplizer.class);
        return settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void secondPassCompile() throws MappingException {
        if (this.configLocked) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader originalClassLoader = thread.getContextClassLoader();
        try {
            if (this.grailsApplication != null) {
                thread.setContextClassLoader(this.grailsApplication.getClassLoader());
            }
            Closure defaultMapping = (Closure)this.grailsApplication.getConfig().getProperty("grails.gorm.default.mapping", Closure.class);
            HibernateMappingContext mappingContext = new HibernateMappingContext(defaultMapping);
            Mappings mappings = super.createMappings();
            for (GrailsDomainClass domainClass : this.domainClasses) {
                PersistentEntity entity = mappingContext.addPersistentEntity(domainClass.getClazz());
                if (entity == null) continue;
                mappingContext.addEntityValidator(entity, domainClass.getValidator());
                this.binder.evaluateMapping(entity);
            }
            for (PersistentEntity entity : mappingContext.getPersistentEntities()) {
                if (!GrailsHibernateUtil.usesDatasource(entity, this.dataSourceName)) continue;
                Mapping m = GrailsDomainBinder.getMapping((PersistentEntity)entity);
                mappings.setAutoImport(m == null || m.getAutoImport());
                this.binder.bindClass(entity, mappings, this.sessionFactoryBeanName);
            }
            super.secondPassCompile();
            this.configLocked = true;
        }
        finally {
            thread.setContextClassLoader(originalClassLoader);
        }
    }

    protected void reset() {
        super.reset();
        try {
            GrailsIdentifierGeneratorFactory.applyNewInstance(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

