/*
 * Decompiled with CFR 0.152.
 */
package org.grails.orm.hibernate;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.grails.orm.hibernate.HibernateEventListeners;
import org.grails.orm.hibernate.support.ClosureEventTriggeringInterceptor;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.internal.DefaultSaveOrUpdateEventListener;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;

public class EventListenerIntegrator
implements Integrator {
    protected HibernateEventListeners hibernateEventListeners;
    protected Map<String, Object> eventListeners;
    protected static final List<EventType<? extends Serializable>> TYPES = Arrays.asList(EventType.AUTO_FLUSH, EventType.MERGE, EventType.PERSIST, EventType.PERSIST_ONFLUSH, EventType.DELETE, EventType.DIRTY_CHECK, EventType.EVICT, EventType.FLUSH, EventType.FLUSH_ENTITY, EventType.LOAD, EventType.INIT_COLLECTION, EventType.LOCK, EventType.REFRESH, EventType.REPLICATE, EventType.SAVE_UPDATE, EventType.SAVE, EventType.UPDATE, EventType.PRE_LOAD, EventType.PRE_UPDATE, EventType.PRE_DELETE, EventType.PRE_INSERT, EventType.PRE_COLLECTION_RECREATE, EventType.PRE_COLLECTION_REMOVE, EventType.PRE_COLLECTION_UPDATE, EventType.POST_LOAD, EventType.POST_UPDATE, EventType.POST_DELETE, EventType.POST_INSERT, EventType.POST_COMMIT_UPDATE, EventType.POST_COMMIT_DELETE, EventType.POST_COMMIT_INSERT, EventType.POST_COLLECTION_RECREATE, EventType.POST_COLLECTION_REMOVE, EventType.POST_COLLECTION_UPDATE);

    public EventListenerIntegrator(HibernateEventListeners hibernateEventListeners, Map<String, Object> eventListeners) {
        this.hibernateEventListeners = hibernateEventListeners;
        this.eventListeners = eventListeners;
    }

    public void integrate(Configuration config, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        EventListenerRegistry listenerRegistry = (EventListenerRegistry)serviceRegistry.getService(EventListenerRegistry.class);
        if (this.eventListeners != null) {
            for (Map.Entry<String, Object> entry : this.eventListeners.entrySet()) {
                EventType<? extends Serializable> type = EventType.resolveEventTypeByName((String)entry.getKey());
                Object listenerObject = entry.getValue();
                if (listenerObject instanceof Collection) {
                    this.appendListeners(listenerRegistry, type, (Collection)listenerObject);
                    continue;
                }
                if (listenerObject == null) continue;
                this.appendListeners(listenerRegistry, type, Collections.singleton(listenerObject));
            }
        }
        if (this.hibernateEventListeners != null && this.hibernateEventListeners.getListenerMap() != null) {
            Map listenerMap = this.hibernateEventListeners.getListenerMap();
            for (EventType<? extends Serializable> type : TYPES) {
                this.appendListeners(listenerRegistry, type, listenerMap);
            }
        }
        ClosureEventTriggeringInterceptor.addNullabilityCheckerPreInsertEventListener((EventListenerRegistry)listenerRegistry);
    }

    protected <T> void appendListeners(EventListenerRegistry listenerRegistry, EventType<T> eventType, Collection<T> listeners) {
        EventListenerGroup group = listenerRegistry.getEventListenerGroup(eventType);
        for (T listener : listeners) {
            if (listener == null) continue;
            if (this.shouldOverrideListeners(eventType, listener)) {
                group.clear();
                group.appendListener(listener);
                continue;
            }
            group.appendListener(listener);
        }
    }

    private <T> boolean shouldOverrideListeners(EventType<T> eventType, Object listener) {
        return listener instanceof DefaultSaveOrUpdateEventListener && eventType.equals((Object)EventType.SAVE_UPDATE);
    }

    protected <T> void appendListeners(EventListenerRegistry listenerRegistry, EventType<T> eventType, Map<String, Object> listeners) {
        Object listener = listeners.get(eventType.eventName());
        if (listener != null) {
            if (this.shouldOverrideListeners(eventType, listener)) {
                listenerRegistry.setListeners(eventType, new Object[]{listener});
            } else {
                listenerRegistry.appendListeners(eventType, new Object[]{listener});
            }
        }
    }

    public void integrate(MetadataImplementor metadata, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
    }

    public void disintegrate(SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
    }
}

