/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.support;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.orm.hibernate3.support.OpenSessionInViewFilter;

public class GrailsOpenSessionInViewFilter
extends OpenSessionInViewFilter {
    protected SessionFactory lookupSessionFactory() {
        ApplicationContext context = (ApplicationContext)this.getServletContext().getAttribute("org.codehaus.groovy.grails.APPLICATION_CONTEXT");
        if (context != null) {
            return (SessionFactory)context.getBean(this.getSessionFactoryBeanName(), SessionFactory.class);
        }
        return null;
    }

    protected Session getSession(SessionFactory sessionFactory) throws DataAccessResourceFailureException {
        Session session = SessionFactoryUtils.getSession((SessionFactory)sessionFactory, (boolean)true);
        session.setFlushMode(FlushMode.AUTO);
        return session;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        SessionFactory sf = this.lookupSessionFactory();
        if (sf != null) {
            super.doFilterInternal(request, response, filterChain);
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    protected void closeSession(Session session, SessionFactory sessionFactory) {
        if (!FlushMode.isManualFlushMode((FlushMode)session.getFlushMode())) {
            session.flush();
        }
        super.closeSession(session, sessionFactory);
    }
}

