/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.support;

import grails.validation.ValidationException;
import groovy.lang.Closure;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaMethod;
import groovy.lang.MetaProperty;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.orm.hibernate.cfg.GrailsDomainBinder;
import org.codehaus.groovy.grails.orm.hibernate.cfg.Mapping;
import org.codehaus.groovy.grails.orm.hibernate.metaclass.AbstractSavePersistentMethod;
import org.codehaus.groovy.grails.orm.hibernate.support.ClosureEventTriggeringInterceptor;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.grails.datastore.gorm.support.BeforeValidateHelper;
import org.grails.datastore.mapping.engine.event.ValidationEvent;
import org.hibernate.EntityMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.event.AbstractEvent;
import org.hibernate.event.EventSource;
import org.hibernate.event.PostDeleteEvent;
import org.hibernate.event.PostDeleteEventListener;
import org.hibernate.event.PostInsertEvent;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.event.PostLoadEvent;
import org.hibernate.event.PostLoadEventListener;
import org.hibernate.event.PostUpdateEvent;
import org.hibernate.event.PostUpdateEventListener;
import org.hibernate.event.PreDeleteEvent;
import org.hibernate.event.PreDeleteEventListener;
import org.hibernate.event.PreInsertEvent;
import org.hibernate.event.PreLoadEvent;
import org.hibernate.event.PreLoadEventListener;
import org.hibernate.event.PreUpdateEvent;
import org.hibernate.event.PreUpdateEventListener;
import org.hibernate.event.SaveOrUpdateEvent;
import org.hibernate.event.SaveOrUpdateEventListener;
import org.hibernate.persister.entity.EntityPersister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;
import org.springframework.validation.Errors;

public class ClosureEventListener
implements SaveOrUpdateEventListener,
PreLoadEventListener,
PostLoadEventListener,
PostInsertEventListener,
PostUpdateEventListener,
PostDeleteEventListener,
PreDeleteEventListener,
PreUpdateEventListener {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(ClosureEventListener.class);
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    EventTriggerCaller saveOrUpdateCaller;
    EventTriggerCaller beforeInsertCaller;
    EventTriggerCaller preLoadEventCaller;
    EventTriggerCaller postLoadEventListener;
    EventTriggerCaller postInsertEventListener;
    EventTriggerCaller postUpdateEventListener;
    EventTriggerCaller postDeleteEventListener;
    EventTriggerCaller preDeleteEventListener;
    EventTriggerCaller preUpdateEventListener;
    private BeforeValidateHelper beforeValidateHelper = new BeforeValidateHelper();
    boolean shouldTimestamp = false;
    MetaProperty dateCreatedProperty;
    MetaProperty lastUpdatedProperty;
    MetaClass domainMetaClass;
    boolean failOnErrorEnabled = false;
    MetaProperty errorsProperty;
    Map validateParams;
    MetaMethod validateMethod;

    public ClosureEventListener(Class<?> domainClazz, boolean failOnError, List failOnErrorPackages) {
        this.domainMetaClass = GroovySystem.getMetaClassRegistry().getMetaClass(domainClazz);
        this.dateCreatedProperty = this.domainMetaClass.getMetaProperty("dateCreated");
        this.lastUpdatedProperty = this.domainMetaClass.getMetaProperty("lastUpdated");
        if (this.dateCreatedProperty != null || this.lastUpdatedProperty != null) {
            Mapping m = new GrailsDomainBinder().getMapping(domainClazz);
            this.shouldTimestamp = m == null || m.isAutoTimestamp();
        }
        this.saveOrUpdateCaller = this.buildCaller(domainClazz, "onSave");
        this.beforeInsertCaller = this.buildCaller(domainClazz, "beforeInsert");
        this.preLoadEventCaller = this.buildCaller(domainClazz, "onLoad");
        if (this.preLoadEventCaller == null) {
            this.preLoadEventCaller = this.buildCaller(domainClazz, "beforeLoad");
        }
        this.postLoadEventListener = this.buildCaller(domainClazz, "afterLoad");
        this.postInsertEventListener = this.buildCaller(domainClazz, "afterInsert");
        this.postUpdateEventListener = this.buildCaller(domainClazz, "afterUpdate");
        this.postDeleteEventListener = this.buildCaller(domainClazz, "afterDelete");
        this.preDeleteEventListener = this.buildCaller(domainClazz, "beforeDelete");
        this.preUpdateEventListener = this.buildCaller(domainClazz, "beforeUpdate");
        this.failOnErrorEnabled = failOnErrorPackages.size() > 0 ? GrailsClassUtils.isClassBelowPackage(domainClazz, (List)failOnErrorPackages) : failOnError;
        this.validateParams = new HashMap();
        this.validateParams.put("deepValidate", Boolean.FALSE);
        this.errorsProperty = this.domainMetaClass.getMetaProperty("errors");
        this.validateMethod = this.domainMetaClass.getMetaMethod("validate", new Object[]{Map.class});
    }

    private EventTriggerCaller buildCaller(Class<?> domainClazz, String event) {
        Method method = ReflectionUtils.findMethod(domainClazz, (String)event);
        if (method != null) {
            ReflectionUtils.makeAccessible((Method)method);
            return new MethodCaller(method);
        }
        Field field = ReflectionUtils.findField(domainClazz, (String)event);
        if (field != null) {
            ReflectionUtils.makeAccessible((Field)field);
            return new FieldClosureCaller(field);
        }
        MetaMethod metaMethod = this.domainMetaClass.getMetaMethod(event, EMPTY_OBJECT_ARRAY);
        if (metaMethod != null) {
            return new MetaMethodCaller(metaMethod);
        }
        MetaProperty metaProperty = this.domainMetaClass.getMetaProperty(event);
        if (metaProperty != null) {
            return new MetaPropertyClosureCaller(metaProperty);
        }
        return null;
    }

    public void onSaveOrUpdate(SaveOrUpdateEvent event) throws HibernateException {
    }

    private void synchronizePersisterState(Object entity, EntityPersister persister, Object[] state) {
        String[] propertyNames = persister.getPropertyNames();
        for (int i = 0; i < propertyNames.length; ++i) {
            Object value;
            String p = propertyNames[i];
            MetaProperty metaProperty = this.domainMetaClass.getMetaProperty(p);
            if (ClosureEventTriggeringInterceptor.IGNORED.contains(p) || metaProperty == null) continue;
            state[i] = value = metaProperty.getProperty(entity);
            persister.setPropertyValue(entity, i, value, EntityMode.POJO);
        }
    }

    public void onPreLoad(final PreLoadEvent event) {
        if (this.preLoadEventCaller == null) {
            return;
        }
        this.doWithManualSession((AbstractEvent)event, new Closure(this){

            public Object call() {
                ClosureEventListener.this.preLoadEventCaller.call(event.getEntity());
                return null;
            }
        });
    }

    public void onPostLoad(final PostLoadEvent event) {
        if (this.postLoadEventListener == null) {
            return;
        }
        this.doWithManualSession((AbstractEvent)event, new Closure(this){

            public Object call() {
                ClosureEventListener.this.postLoadEventListener.call(event.getEntity());
                return null;
            }
        });
    }

    public void onPostInsert(PostInsertEvent event) {
        final Object entity = event.getEntity();
        AbstractSavePersistentMethod.clearDisabledValidations(entity);
        if (this.postInsertEventListener == null) {
            return;
        }
        this.doWithManualSession((AbstractEvent)event, new Closure(this){

            public Object call() {
                ClosureEventListener.this.postInsertEventListener.call(entity);
                return null;
            }
        });
    }

    public void onPostUpdate(PostUpdateEvent event) {
        final Object entity = event.getEntity();
        AbstractSavePersistentMethod.clearDisabledValidations(entity);
        if (this.postUpdateEventListener == null) {
            return;
        }
        this.doWithManualSession((AbstractEvent)event, new Closure(this){

            public Object call() {
                ClosureEventListener.this.postUpdateEventListener.call(entity);
                return null;
            }
        });
    }

    public void onPostDelete(PostDeleteEvent event) {
        final Object entity = event.getEntity();
        AbstractSavePersistentMethod.clearDisabledValidations(entity);
        if (this.postDeleteEventListener == null) {
            return;
        }
        this.doWithManualSession((AbstractEvent)event, new Closure(this){

            public Object call() {
                ClosureEventListener.this.postDeleteEventListener.call(entity);
                return null;
            }
        });
    }

    public boolean onPreDelete(final PreDeleteEvent event) {
        if (this.preDeleteEventListener == null) {
            return false;
        }
        return this.doWithManualSession((AbstractEvent)event, new Closure<Boolean>((Object)this){

            public Boolean call() {
                return ClosureEventListener.this.preDeleteEventListener.call(event.getEntity());
            }
        });
    }

    public boolean onPreUpdate(final PreUpdateEvent event) {
        return this.doWithManualSession((AbstractEvent)event, new Closure<Boolean>((Object)this){

            public Boolean call() {
                Object entity = event.getEntity();
                boolean evict = false;
                if (ClosureEventListener.this.preUpdateEventListener != null) {
                    evict = ClosureEventListener.this.preUpdateEventListener.call(entity);
                    ClosureEventListener.this.synchronizePersisterState(entity, event.getPersister(), event.getState());
                }
                if (ClosureEventListener.this.lastUpdatedProperty != null && ClosureEventListener.this.shouldTimestamp) {
                    Object now;
                    event.getState()[ArrayUtils.indexOf((Object[])event.getPersister().getPropertyNames(), (Object)"lastUpdated")] = now = DefaultGroovyMethods.newInstance((Class)ClosureEventListener.this.lastUpdatedProperty.getType(), (Object[])new Object[]{System.currentTimeMillis()});
                    ClosureEventListener.this.lastUpdatedProperty.setProperty(entity, now);
                }
                if (!AbstractSavePersistentMethod.isAutoValidationDisabled(entity) && !DefaultTypeTransformation.castToBoolean((Object)ClosureEventListener.this.validateMethod.invoke(entity, new Object[]{ClosureEventListener.this.validateParams}))) {
                    evict = true;
                    if (ClosureEventListener.this.failOnErrorEnabled) {
                        Errors errors = (Errors)ClosureEventListener.this.errorsProperty.getProperty(entity);
                        throw new ValidationException("Validation error whilst flushing entity [" + entity.getClass().getName() + "]", errors);
                    }
                }
                return evict;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T doWithManualSession(AbstractEvent event, Closure<T> callable) {
        EventSource session = event.getSession();
        FlushMode current = session.getFlushMode();
        try {
            session.setFlushMode(FlushMode.MANUAL);
            Object object = callable.call();
            return (T)object;
        }
        finally {
            session.setFlushMode(current);
        }
    }

    public boolean onPreInsert(final PreInsertEvent event) {
        return this.doWithManualSession((AbstractEvent)event, new Closure<Boolean>((Object)this){

            public Boolean call() {
                Object entity = event.getEntity();
                boolean synchronizeState = false;
                if (ClosureEventListener.this.beforeInsertCaller != null) {
                    if (ClosureEventListener.this.beforeInsertCaller.call(entity)) {
                        return true;
                    }
                    synchronizeState = true;
                }
                if (ClosureEventListener.this.shouldTimestamp) {
                    Object now;
                    long time = System.currentTimeMillis();
                    if (ClosureEventListener.this.dateCreatedProperty != null) {
                        now = DefaultGroovyMethods.newInstance((Class)ClosureEventListener.this.dateCreatedProperty.getType(), (Object[])new Object[]{time});
                        ClosureEventListener.this.dateCreatedProperty.setProperty(entity, now);
                        synchronizeState = true;
                    }
                    if (ClosureEventListener.this.lastUpdatedProperty != null) {
                        now = DefaultGroovyMethods.newInstance((Class)ClosureEventListener.this.lastUpdatedProperty.getType(), (Object[])new Object[]{time});
                        ClosureEventListener.this.lastUpdatedProperty.setProperty(entity, now);
                        synchronizeState = true;
                    }
                }
                if (synchronizeState) {
                    ClosureEventListener.this.synchronizePersisterState(entity, event.getPersister(), event.getState());
                }
                boolean evict = false;
                if (!AbstractSavePersistentMethod.isAutoValidationDisabled(entity) && !DefaultTypeTransformation.castToBoolean((Object)ClosureEventListener.this.validateMethod.invoke(entity, new Object[]{ClosureEventListener.this.validateParams}))) {
                    evict = true;
                    if (ClosureEventListener.this.failOnErrorEnabled) {
                        Errors errors = (Errors)ClosureEventListener.this.errorsProperty.getProperty(entity);
                        throw new ValidationException("Validation error whilst flushing entity [" + entity.getClass().getName() + "]", errors);
                    }
                }
                return evict;
            }
        });
    }

    public void onValidate(ValidationEvent event) {
        this.beforeValidateHelper.invokeBeforeValidate(event.getEntityObject(), event.getValidatedFields());
    }

    private static class MetaPropertyClosureCaller
    extends ClosureCaller {
        MetaProperty metaProperty;

        MetaPropertyClosureCaller(MetaProperty metaProperty) {
            this.metaProperty = metaProperty;
            if (Modifier.isStatic(metaProperty.getModifiers())) {
                this.cloneFirst = true;
            }
        }

        @Override
        public boolean call(Object entity) {
            Object fieldval = this.metaProperty.getProperty(entity);
            if (fieldval instanceof Closure) {
                return this.resolveReturnValue(this.callClosure(entity, (Closure)fieldval));
            }
            log.error("Field " + this.metaProperty + " is not Closure.");
            return false;
        }
    }

    private static class FieldClosureCaller
    extends ClosureCaller {
        Field field;

        FieldClosureCaller(Field field) {
            this.field = field;
            if (Modifier.isStatic(field.getModifiers())) {
                this.cloneFirst = true;
            }
        }

        @Override
        public boolean call(Object entity) {
            Object fieldval = ReflectionUtils.getField((Field)this.field, (Object)entity);
            if (fieldval instanceof Closure) {
                return this.resolveReturnValue(this.callClosure(entity, (Closure)fieldval));
            }
            log.error("Field " + this.field + " is not Closure or method.");
            return false;
        }
    }

    private static abstract class ClosureCaller
    extends EventTriggerCaller {
        boolean cloneFirst = false;

        private ClosureCaller() {
        }

        Object callClosure(Object entity, Closure callable) {
            if (this.cloneFirst) {
                callable = (Closure)callable.clone();
            }
            callable.setResolveStrategy(1);
            callable.setDelegate(entity);
            return callable.call();
        }
    }

    private static class MetaMethodCaller
    extends EventTriggerCaller {
        MetaMethod method;

        MetaMethodCaller(MetaMethod method) {
            this.method = method;
        }

        @Override
        public boolean call(Object entity) {
            Object retval = this.method.invoke(entity, EMPTY_OBJECT_ARRAY);
            return this.resolveReturnValue(retval);
        }
    }

    private static class MethodCaller
    extends EventTriggerCaller {
        Method method;

        MethodCaller(Method method) {
            this.method = method;
        }

        @Override
        public boolean call(Object entity) {
            Object retval = ReflectionUtils.invokeMethod((Method)this.method, (Object)entity);
            return this.resolveReturnValue(retval);
        }
    }

    private static abstract class EventTriggerCaller {
        private EventTriggerCaller() {
        }

        public abstract boolean call(Object var1);

        boolean resolveReturnValue(Object retval) {
            if (retval instanceof Boolean) {
                return (Boolean)retval == false;
            }
            return false;
        }
    }
}

