/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.cfg;

import groovy.lang.Closure;
import groovy.util.Eval;
import java.util.HashSet;
import java.util.Set;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClass;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.orm.hibernate.cfg.GrailsDomainBinder;
import org.codehaus.groovy.grails.orm.hibernate.cfg.GrailsDomainConfiguration;
import org.codehaus.groovy.grails.orm.hibernate.cfg.GrailsHibernateUtil;
import org.codehaus.groovy.grails.orm.hibernate.cfg.Mapping;
import org.hibernate.MappingException;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.Mappings;

public class DefaultGrailsDomainConfiguration
extends Configuration
implements GrailsDomainConfiguration {
    private static final long serialVersionUID = -7115087342689305517L;
    protected GrailsApplication grailsApplication;
    protected Set<GrailsDomainClass> domainClasses = new HashSet<GrailsDomainClass>();
    protected boolean configLocked;
    protected String sessionFactoryBeanName = "sessionFactory";
    protected String dataSourceName = "DEFAULT";
    protected static GrailsDomainBinder binder = new GrailsDomainBinder();

    public GrailsDomainConfiguration addDomainClass(GrailsDomainClass domainClass) {
        if (domainClass.getMappingStrategy().equalsIgnoreCase("GORM")) {
            this.domainClasses.add(domainClass);
        }
        return this;
    }

    public void setGrailsApplication(GrailsApplication application) {
        this.grailsApplication = application;
        if (this.grailsApplication == null) {
            return;
        }
        for (GrailsClass existingDomainClass : this.grailsApplication.getArtefacts("Domain")) {
            this.addDomainClass((GrailsDomainClass)existingDomainClass);
        }
    }

    public void setSessionFactoryBeanName(String name) {
        this.sessionFactoryBeanName = name;
    }

    public void setDataSourceName(String name) {
        this.dataSourceName = name;
    }

    protected void secondPassCompile() throws MappingException {
        if (this.configLocked) {
            return;
        }
        if (this.grailsApplication != null) {
            Thread.currentThread().setContextClassLoader(this.grailsApplication.getClassLoader());
        }
        DefaultGrailsDomainConfiguration.configureDomainBinder(this.grailsApplication, this.domainClasses);
        for (GrailsDomainClass domainClass : this.domainClasses) {
            if (!GrailsHibernateUtil.usesDatasource(domainClass, this.dataSourceName)) continue;
            Mappings mappings = super.createMappings();
            Mapping m = binder.getMapping(domainClass);
            mappings.setAutoImport(m == null || m.getAutoImport());
            binder.bindClass(domainClass, mappings, this.sessionFactoryBeanName);
        }
        super.secondPassCompile();
        this.configLocked = true;
    }

    public static void configureDomainBinder(GrailsApplication grailsApplication, Set<GrailsDomainClass> domainClasses) {
        Object defaultMapping = Eval.x((Object)grailsApplication, (String)"x.config?.grails?.gorm?.default?.mapping");
        for (GrailsDomainClass domainClass : domainClasses) {
            if (defaultMapping instanceof Closure) {
                binder.evaluateMapping(domainClass, (Closure)defaultMapping);
                continue;
            }
            binder.evaluateMapping(domainClass);
        }
    }
}

