/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.persistence.FlushModeType;
import org.codehaus.groovy.grails.domain.GrailsDomainClassMappingContext;
import org.codehaus.groovy.grails.orm.hibernate.AbstractHibernateDatastore;
import org.codehaus.groovy.grails.orm.hibernate.AbstractHibernateSession;
import org.codehaus.groovy.grails.orm.hibernate.GrailsHibernateTemplate;
import org.codehaus.groovy.grails.orm.hibernate.HibernateDatastore;
import org.codehaus.groovy.grails.orm.hibernate.proxy.HibernateProxyHandler;
import org.codehaus.groovy.grails.orm.hibernate.query.HibernateQuery;
import org.codehaus.groovy.grails.support.proxy.ProxyHandler;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.query.Query;
import org.grails.datastore.mapping.query.api.QueryableCriteria;
import org.grails.datastore.mapping.query.jpa.JpaQueryBuilder;
import org.grails.datastore.mapping.query.jpa.JpaQueryInfo;
import org.grails.datastore.mapping.reflect.ClassPropertyFetcher;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Restrictions;
import org.hibernate.proxy.HibernateProxy;
import org.springframework.orm.hibernate3.HibernateCallback;

public class HibernateSession
extends AbstractHibernateSession {
    ProxyHandler proxyHandler = new HibernateProxyHandler();

    public HibernateSession(HibernateDatastore hibernateDatastore, SessionFactory sessionFactory) {
        super((AbstractHibernateDatastore)hibernateDatastore, sessionFactory);
        this.hibernateTemplate = this.datastore.getMappingContext() instanceof GrailsDomainClassMappingContext ? new GrailsHibernateTemplate(sessionFactory, ((GrailsDomainClassMappingContext)this.datastore.getMappingContext()).getGrailsApplication()) : new GrailsHibernateTemplate(sessionFactory);
    }

    public Serializable getObjectIdentifier(Object instance) {
        if (instance == null) {
            return null;
        }
        if (this.proxyHandler.isProxy(instance)) {
            return ((HibernateProxy)instance).getHibernateLazyInitializer().getIdentifier();
        }
        Class<?> type = instance.getClass();
        ClassPropertyFetcher cpf = ClassPropertyFetcher.forClass(type);
        PersistentEntity persistentEntity = this.getMappingContext().getPersistentEntity(type.getName());
        if (persistentEntity != null) {
            return (Serializable)cpf.getPropertyValue(instance, persistentEntity.getIdentity().getName());
        }
        return null;
    }

    public int deleteAll(final QueryableCriteria criteria) {
        return (Integer)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Integer>(){

            public Integer doInHibernate(Session session) throws HibernateException, SQLException {
                JpaQueryBuilder builder = new JpaQueryBuilder(criteria);
                builder.setHibernateCompatible(true);
                JpaQueryInfo jpaQueryInfo = builder.buildDelete();
                org.hibernate.Query query = session.createQuery(jpaQueryInfo.getQuery());
                HibernateSession.this.getHibernateTemplate().applySettings(query);
                List parameters = jpaQueryInfo.getParameters();
                if (parameters != null) {
                    int count = parameters.size();
                    for (int i = 0; i < count; ++i) {
                        query.setParameter(i, parameters.get(i));
                    }
                }
                return query.executeUpdate();
            }
        });
    }

    public int updateAll(final QueryableCriteria criteria, final Map<String, Object> properties) {
        return (Integer)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Integer>(){

            public Integer doInHibernate(Session session) throws HibernateException, SQLException {
                JpaQueryBuilder builder = new JpaQueryBuilder(criteria);
                builder.setHibernateCompatible(true);
                JpaQueryInfo jpaQueryInfo = builder.buildUpdate(properties);
                org.hibernate.Query query = session.createQuery(jpaQueryInfo.getQuery());
                HibernateSession.this.getHibernateTemplate().applySettings(query);
                List parameters = jpaQueryInfo.getParameters();
                if (parameters != null) {
                    int count = parameters.size();
                    for (int i = 0; i < count; ++i) {
                        query.setParameter(i, parameters.get(i));
                    }
                }
                return query.executeUpdate();
            }
        });
    }

    public List retrieveAll(final Class type, final Iterable keys) {
        final PersistentEntity persistentEntity = this.getMappingContext().getPersistentEntity(type.getName());
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List>(){

            public List doInHibernate(Session session) throws HibernateException, SQLException {
                Criteria criteria = session.createCriteria(type);
                HibernateSession.this.getHibernateTemplate().applySettings(criteria);
                return criteria.add(Restrictions.in((String)persistentEntity.getIdentity().getName(), (Collection)HibernateSession.this.getIterableAsCollection(keys))).list();
            }
        });
    }

    public Query createQuery(Class type) {
        PersistentEntity persistentEntity = this.getMappingContext().getPersistentEntity(type.getName());
        Criteria criteria = this.getHibernateTemplate().getSessionFactory().getCurrentSession().createCriteria(type);
        this.getHibernateTemplate().applySettings(criteria);
        return new HibernateQuery(criteria, this, persistentEntity);
    }

    protected GrailsHibernateTemplate getHibernateTemplate() {
        return (GrailsHibernateTemplate)((Object)this.getNativeInterface());
    }

    public void setFlushMode(FlushModeType flushMode) {
        if (flushMode == FlushModeType.AUTO) {
            this.hibernateTemplate.setFlushMode(1);
        } else if (flushMode == FlushModeType.COMMIT) {
            this.hibernateTemplate.setFlushMode(3);
        }
    }

    public FlushModeType getFlushMode() {
        switch (this.hibernateTemplate.getFlushMode()) {
            case 1: {
                return FlushModeType.AUTO;
            }
            case 3: {
                return FlushModeType.COMMIT;
            }
            case 4: {
                return FlushModeType.AUTO;
            }
        }
        return FlushModeType.AUTO;
    }
}

