/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate;

import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.orm.hibernate.IHibernateTemplate;
import org.codehaus.groovy.grails.orm.hibernate.cfg.GrailsHibernateUtil;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class GrailsHibernateTemplate
extends HibernateTemplate
implements IHibernateTemplate {
    private boolean osivReadOnly;

    public GrailsHibernateTemplate() {
        this.initialize(null);
    }

    public GrailsHibernateTemplate(SessionFactory sessionFactory, boolean allowCreate) {
        super(sessionFactory, allowCreate);
        this.initialize(null);
    }

    public GrailsHibernateTemplate(SessionFactory sessionFactory) {
        super(sessionFactory);
        this.initialize(null);
    }

    public GrailsHibernateTemplate(SessionFactory sessionFactory, GrailsApplication application) {
        super(sessionFactory);
        this.initialize(application);
    }

    private void initialize(GrailsApplication application) {
        this.setExposeNativeSession(true);
        if (application != null) {
            this.setCacheQueries(GrailsHibernateUtil.isCacheQueriesByDefault(application));
            this.osivReadOnly = GrailsHibernateUtil.isOsivReadonly(application);
        }
    }

    protected void prepareQuery(Query queryObject) {
        super.prepareQuery(queryObject);
        if (this.isCurrentTransactionReadOnly()) {
            queryObject.setReadOnly(true);
        }
    }

    public void applySettings(Query queryObject) {
        if (this.isExposeNativeSession()) {
            this.prepareQuery(queryObject);
        }
    }

    protected void prepareCriteria(Criteria criteria) {
        super.prepareCriteria(criteria);
        if (this.isCurrentTransactionReadOnly()) {
            criteria.setReadOnly(true);
        }
    }

    protected boolean isCurrentTransactionReadOnly() {
        if (TransactionSynchronizationManager.hasResource((Object)this.getSessionFactory())) {
            if (TransactionSynchronizationManager.isActualTransactionActive()) {
                return TransactionSynchronizationManager.isCurrentTransactionReadOnly();
            }
            return this.osivReadOnly;
        }
        return false;
    }

    public void applySettings(Criteria criteria) {
        if (this.isExposeNativeSession()) {
            this.prepareCriteria(criteria);
        }
    }

    protected void enableFilters(Session session) {
        if (this.isCurrentTransactionReadOnly()) {
            session.setDefaultReadOnly(true);
        }
        super.enableFilters(session);
    }

    public boolean isOsivReadOnly() {
        return this.osivReadOnly;
    }

    public void setOsivReadOnly(boolean osivReadOnly) {
        this.osivReadOnly = osivReadOnly;
    }
}

