/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.cassandra.query;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.querybuilder.Ordering;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.grails.datastore.mapping.cassandra.CassandraSession;
import org.grails.datastore.mapping.cassandra.config.Table;
import org.grails.datastore.mapping.cassandra.engine.CassandraEntityPersister;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.keyvalue.mapping.config.Family;
import org.grails.datastore.mapping.model.ClassMapping;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.query.Query;
import org.grails.datastore.mapping.query.api.QueryArgumentsAware;
import org.springframework.cassandra.core.ResultSetExtractor;
import org.springframework.cassandra.core.RowMapper;
import org.springframework.core.convert.ConversionService;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.cassandra.core.CassandraTemplate;
import org.springframework.data.cassandra.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.mapping.CassandraPersistentProperty;

public class CassandraQuery
extends Query
implements QueryArgumentsAware {
    private static final Log LOG = LogFactory.getLog(CassandraQuery.class);
    public static final String ARGUMENT_ALLOW_FILTERING = "allowFiltering";
    public static final String ARGUMENT_FETCH_SIZE = "fetchSize";
    private CassandraSession cassandraSession;
    private CassandraEntityPersister cassandraEntityPersister;
    private CassandraTemplate cassandraTemplate;
    private CassandraPersistentEntity<?> cassandraPersistentEntity;
    private ConversionService conversionService;
    private static Map<Class, QueryHandler> queryHandlers = new HashMap<Class, QueryHandler>();
    private Map arguments = new HashMap();
    private boolean allowFiltering;
    private int fetchSize;

    public Query allowFiltering(boolean allowFiltering) {
        this.allowFiltering = allowFiltering;
        return this;
    }

    public Query fetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        return this;
    }

    public CassandraQuery(CassandraSession session, PersistentEntity entity) {
        super((Session)session, entity);
        this.cassandraSession = session;
        this.cassandraEntityPersister = (CassandraEntityPersister)this.cassandraSession.getPersister(entity);
        this.cassandraTemplate = this.cassandraSession.getCassandraTemplate();
        this.cassandraPersistentEntity = (CassandraPersistentEntity)this.cassandraTemplate.getMappingContext().getPersistentEntity(entity.getJavaClass());
        this.conversionService = this.cassandraTemplate.getConverter().getConversionService();
    }

    public void throwUnsupportedOperationException(String name) {
        throw new UnsupportedOperationException("Queries of type " + name + " are not supported by Cassandra");
    }

    public void setArguments(Map arguments) {
        this.arguments = arguments;
    }

    protected List executeQuery(final PersistentEntity entity, Query.Junction criteria) {
        List<Long> results = new ArrayList();
        if (criteria instanceof Query.Disjunction) {
            throw new UnsupportedOperationException("Queries of type Disjunction (OR) are not supported by this implementation");
        }
        if (criteria instanceof Query.Conjunction) {
            List orderBys;
            Select select;
            List projectionList = this.projections().getProjectionList();
            if (projectionList.isEmpty()) {
                select = QueryBuilder.select().all().from(this.getTableName(entity));
            } else {
                this.validateProjections(projectionList);
                select = this.buildQueryForProjections(entity, projectionList);
            }
            if (!criteria.getCriteria().isEmpty()) {
                this.buildCompositeClause(criteria, select.where());
            }
            if (!(orderBys = this.getOrderBy()).isEmpty()) {
                Ordering[] orderings = new Ordering[orderBys.size()];
                for (int i = 0; i < orderBys.size(); ++i) {
                    Query.Order orderBy = (Query.Order)orderBys.get(i);
                    orderings[i] = orderBy.getDirection() == Query.Order.Direction.ASC ? QueryBuilder.asc((String)orderBy.getProperty()) : QueryBuilder.desc((String)orderBy.getProperty());
                }
                select.orderBy(orderings);
            } else {
                Query.Order orderBy = ((Table)entity.getMapping().getMappedForm()).getSort();
                if (orderBy != null) {
                    if (orderBy.getDirection() == Query.Order.Direction.ASC) {
                        select.orderBy(new Ordering[]{QueryBuilder.asc((String)orderBy.getProperty())});
                    } else {
                        select.orderBy(new Ordering[]{QueryBuilder.desc((String)orderBy.getProperty())});
                    }
                }
            }
            if (this.max > 0) {
                select.limit(this.max);
            }
            if (this.offset > 0) {
                throw new UnsupportedOperationException("Cassandra does not support offset with pagination");
            }
            if (this.arguments.containsKey(ARGUMENT_FETCH_SIZE) || this.fetchSize > 0) {
                Integer fetch = (Integer)this.conversionService.convert(this.arguments.get(ARGUMENT_FETCH_SIZE), Integer.class);
                if (fetch != null) {
                    select.setFetchSize(fetch.intValue());
                } else if (this.fetchSize > 0) {
                    select.setFetchSize(this.fetchSize);
                }
            }
            if (this.arguments.containsKey(ARGUMENT_ALLOW_FILTERING) || this.allowFiltering) {
                select.allowFiltering();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Built Cassandra query to execute: " + select.toString()));
            }
            if (projectionList.isEmpty()) {
                results = this.cassandraTemplate.query(select, new RowMapper(){

                    public Object mapRow(Row row, int rowNum) throws DriverException {
                        Object object = CassandraQuery.this.cassandraTemplate.getConverter().read(entity.getJavaClass(), (Object)row);
                        return CassandraQuery.this.convertObject(object);
                    }
                });
            } else {
                for (Query.Projection projection : projectionList) {
                    if (projection instanceof Query.CountProjection) {
                        long count = this.getCountResult(select);
                        results.add(count);
                        continue;
                    }
                    if (projection instanceof Query.IdProjection) {
                        PersistentProperty persistentProperty = entity.getIdentity();
                        if (persistentProperty == null) continue;
                        Class type = persistentProperty.getType();
                        results = this.cassandraTemplate.queryForList(select, type);
                        continue;
                    }
                    if (projection instanceof Query.PropertyProjection) {
                        Query.PropertyProjection propertyProjection = (Query.PropertyProjection)projection;
                        CassandraPersistentProperty persistentProperty = CassandraEntityPersister.getPersistentProperty(this.cassandraPersistentEntity, propertyProjection.getPropertyName());
                        Class type = persistentProperty.getActualType();
                        results = this.cassandraTemplate.queryForList(select, type);
                        continue;
                    }
                    this.throwUnsupportedOperationException(projection.getClass().getSimpleName());
                }
            }
        } else {
            this.throwUnsupportedOperationException(criteria.getClass().getSimpleName());
        }
        return results;
    }

    private Object convertObject(Object object) {
        Serializable id = this.cassandraEntityPersister.getObjectIdentifier(object);
        Class type = this.entity.getJavaClass();
        Object instance = this.cassandraSession.getCachedInstance(type, id);
        if (instance == null) {
            instance = this.cassandraEntityPersister.convertObject(this.entity, id, object);
            this.cassandraSession.cacheInstance(type, id, instance);
        }
        return instance;
    }

    private String getTableName(PersistentEntity entity) {
        return this.cassandraTemplate.getTableName(entity.getJavaClass()).toString();
    }

    private void validateProjections(List<Query.Projection> projections) {
        boolean hasCountProjection = false;
        for (Query.Projection projection : projections) {
            if (!(Query.PropertyProjection.class.equals(projection.getClass()) || Query.CountProjection.class.equals(projection.getClass()) || Query.IdProjection.class.equals(projection.getClass()))) {
                this.throwUnsupportedOperationException(projection.getClass().getSimpleName());
            }
            if (!Query.CountProjection.class.equals(projection.getClass())) continue;
            hasCountProjection = true;
        }
        if (projections.size() > 1 && hasCountProjection) {
            throw new IllegalArgumentException("Can not mix count projection and other types of projections. You requested: " + projections);
        }
    }

    private Select buildQueryForProjections(PersistentEntity entity, List<Query.Projection> projectionList) {
        Select select = null;
        Select.Selection selection = QueryBuilder.select();
        for (Query.Projection projection : projectionList) {
            if (projection instanceof Query.CountProjection) {
                selection.countAll();
                continue;
            }
            if (projection instanceof Query.IdProjection) {
                PersistentProperty persistentProperty = entity.getIdentity();
                if (persistentProperty == null) continue;
                selection.column(persistentProperty.getName());
                continue;
            }
            if (!(projection instanceof Query.PropertyProjection)) continue;
            String name = CassandraEntityPersister.getPropertyName(this.cassandraPersistentEntity, ((Query.PropertyProjection)projection).getPropertyName());
            selection.column(name);
        }
        select = selection.from(this.getTableName(entity));
        return select;
    }

    private void buildCompositeClause(Query.Junction criteria, Select.Where where) {
        for (Query.Criterion criterion : criteria.getCriteria()) {
            if (criterion instanceof Query.PropertyNameCriterion) {
                QueryHandler queryHandler = queryHandlers.get(criterion.getClass());
                if (queryHandler != null) {
                    queryHandler.handle(this, criterion, where);
                    continue;
                }
                this.throwUnsupportedOperationException(criterion.getClass().getSimpleName());
                continue;
            }
            if (criterion instanceof Query.Conjunction) {
                this.buildCompositeClause((Query.Junction)criterion, where);
                continue;
            }
            this.throwUnsupportedOperationException(criterion.getClass().getSimpleName());
        }
    }

    private long getCountResult(Select select) {
        return (Long)this.cassandraTemplate.query(select, (ResultSetExtractor)new ResultSetExtractor<Long>(){

            public Long extractData(ResultSet rs) throws DriverException, DataAccessException {
                Row row = rs.one();
                if (row == null) {
                    throw new InvalidDataAccessApiUsageException(String.format("count query did not return any results", new Object[0]));
                }
                return row.getLong(0);
            }
        });
    }

    private String getKeyspace(ClassMapping<Family> cm, String defaultValue) {
        String keyspace = null;
        if (cm.getMappedForm() != null) {
            keyspace = ((Family)cm.getMappedForm()).getKeyspace();
        }
        if (keyspace == null) {
            keyspace = defaultValue;
        }
        return keyspace;
    }

    static {
        queryHandlers.put(Query.IdEquals.class, new QueryHandler<Query.IdEquals>(){

            @Override
            public void handle(CassandraQuery cassandraQuery, Query.IdEquals criterion, Select.Where where) {
                CassandraPersistentProperty idProperty = (CassandraPersistentProperty)cassandraQuery.cassandraPersistentEntity.getIdProperty();
                if (idProperty != null) {
                    where.and(QueryBuilder.eq((String)CassandraEntityPersister.getPropertyName(idProperty), (Object)CassandraEntityPersister.convertPrimitiveToNative(criterion.getValue(), idProperty, cassandraQuery.conversionService)));
                }
            }
        });
        queryHandlers.put(Query.Equals.class, new QueryHandler<Query.Equals>(){

            @Override
            public void handle(CassandraQuery cassandraQuery, Query.Equals criterion, Select.Where where) {
                CassandraPersistentProperty cassandraPersistentProperty = CassandraEntityPersister.getPersistentProperty(cassandraQuery.cassandraPersistentEntity, criterion.getProperty());
                where.and(QueryBuilder.eq((String)CassandraEntityPersister.getPropertyName(cassandraPersistentProperty), (Object)CassandraEntityPersister.convertPrimitiveToNative(criterion.getValue(), cassandraPersistentProperty, cassandraQuery.conversionService)));
            }
        });
        queryHandlers.put(Query.GreaterThan.class, new QueryHandler<Query.GreaterThan>(){

            @Override
            public void handle(CassandraQuery cassandraQuery, Query.GreaterThan criterion, Select.Where where) {
                CassandraPersistentProperty cassandraPersistentProperty = CassandraEntityPersister.getPersistentProperty(cassandraQuery.cassandraPersistentEntity, criterion.getProperty());
                where.and(QueryBuilder.gt((String)CassandraEntityPersister.getPropertyName(cassandraQuery.cassandraPersistentEntity, criterion.getProperty()), (Object)CassandraEntityPersister.convertPrimitiveToNative(criterion.getValue(), cassandraPersistentProperty, cassandraQuery.conversionService)));
            }
        });
        queryHandlers.put(Query.GreaterThanEquals.class, new QueryHandler<Query.GreaterThanEquals>(){

            @Override
            public void handle(CassandraQuery cassandraQuery, Query.GreaterThanEquals criterion, Select.Where where) {
                CassandraPersistentProperty cassandraPersistentProperty = CassandraEntityPersister.getPersistentProperty(cassandraQuery.cassandraPersistentEntity, criterion.getProperty());
                where.and(QueryBuilder.gte((String)CassandraEntityPersister.getPropertyName(cassandraQuery.cassandraPersistentEntity, criterion.getProperty()), (Object)CassandraEntityPersister.convertPrimitiveToNative(criterion.getValue(), cassandraPersistentProperty, cassandraQuery.conversionService)));
            }
        });
        queryHandlers.put(Query.LessThan.class, new QueryHandler<Query.LessThan>(){

            @Override
            public void handle(CassandraQuery cassandraQuery, Query.LessThan criterion, Select.Where where) {
                CassandraPersistentProperty cassandraPersistentProperty = CassandraEntityPersister.getPersistentProperty(cassandraQuery.cassandraPersistentEntity, criterion.getProperty());
                where.and(QueryBuilder.lt((String)CassandraEntityPersister.getPropertyName(cassandraQuery.cassandraPersistentEntity, criterion.getProperty()), (Object)CassandraEntityPersister.convertPrimitiveToNative(criterion.getValue(), cassandraPersistentProperty, cassandraQuery.conversionService)));
            }
        });
        queryHandlers.put(Query.LessThanEquals.class, new QueryHandler<Query.LessThanEquals>(){

            @Override
            public void handle(CassandraQuery cassandraQuery, Query.LessThanEquals criterion, Select.Where where) {
                CassandraPersistentProperty cassandraPersistentProperty = CassandraEntityPersister.getPersistentProperty(cassandraQuery.cassandraPersistentEntity, criterion.getProperty());
                where.and(QueryBuilder.lte((String)CassandraEntityPersister.getPropertyName(cassandraQuery.cassandraPersistentEntity, criterion.getProperty()), (Object)CassandraEntityPersister.convertPrimitiveToNative(criterion.getValue(), cassandraPersistentProperty, cassandraQuery.conversionService)));
            }
        });
        queryHandlers.put(Query.Between.class, new QueryHandler<Query.Between>(){

            @Override
            public void handle(CassandraQuery cassandraQuery, Query.Between criterion, Select.Where where) {
                CassandraPersistentProperty cassandraPersistentProperty = CassandraEntityPersister.getPersistentProperty(cassandraQuery.cassandraPersistentEntity, criterion.getProperty());
                where.and(QueryBuilder.gte((String)CassandraEntityPersister.getPropertyName(cassandraPersistentProperty), (Object)CassandraEntityPersister.convertPrimitiveToNative(criterion.getFrom(), cassandraPersistentProperty, cassandraQuery.conversionService)));
                where.and(QueryBuilder.lte((String)CassandraEntityPersister.getPropertyName(cassandraPersistentProperty), (Object)CassandraEntityPersister.convertPrimitiveToNative(criterion.getTo(), cassandraPersistentProperty, cassandraQuery.conversionService)));
            }
        });
        queryHandlers.put(Query.In.class, new QueryHandler<Query.In>(){

            @Override
            public void handle(CassandraQuery cassandraQuery, Query.In criterion, Select.Where where) {
                CassandraPersistentProperty cassandraPersistentProperty = CassandraEntityPersister.getPersistentProperty(cassandraQuery.cassandraPersistentEntity, criterion.getProperty());
                ArrayList values = new ArrayList(criterion.getValues().size());
                for (Object value : criterion.getValues()) {
                    value = CassandraEntityPersister.convertPrimitiveToNative(value, cassandraPersistentProperty, cassandraQuery.conversionService);
                    values.add(value);
                }
                where.and(QueryBuilder.in((String)CassandraEntityPersister.getPropertyName(cassandraPersistentProperty), (Object[])values.toArray()));
            }
        });
    }

    protected static interface QueryHandler<T> {
        public void handle(CassandraQuery var1, T var2, Select.Where var3);
    }
}

