/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.cassandra.config;

import groovy.lang.Closure;
import org.grails.datastore.gorm.cassandra.mapping.BasicCassandraMappingContext;
import org.grails.datastore.mapping.cassandra.config.CassandraPersistentEntity;
import org.grails.datastore.mapping.cassandra.config.Column;
import org.grails.datastore.mapping.cassandra.config.GormCassandraMappingFactory;
import org.grails.datastore.mapping.cassandra.config.Table;
import org.grails.datastore.mapping.model.AbstractMappingContext;
import org.grails.datastore.mapping.model.MappingConfigurationStrategy;
import org.grails.datastore.mapping.model.MappingFactory;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.config.GormMappingConfigurationStrategy;
import org.springframework.util.Assert;

public class CassandraMappingContext
extends AbstractMappingContext {
    public static final String DEFAULT_KEYSPACE = "CassandraKeySpace";
    protected String keyspace;
    protected MappingFactory<Table, Column> mappingFactory;
    protected MappingConfigurationStrategy syntaxStrategy;
    protected BasicCassandraMappingContext springCassandraMappingContext;
    private Closure defaultMapping;

    public CassandraMappingContext() {
        this(DEFAULT_KEYSPACE, null);
    }

    public CassandraMappingContext(String keyspace) {
        this(keyspace, null);
    }

    public CassandraMappingContext(String keyspace, Closure defaultMapping) {
        this(keyspace, defaultMapping, new Class[0]);
    }

    public CassandraMappingContext(String keyspace, Closure defaultMapping, Class ... entities) {
        Assert.hasText((String)keyspace, (String)"Property [keyspace] must be set!");
        this.keyspace = keyspace;
        this.defaultMapping = defaultMapping;
        this.mappingFactory = this.createMappingFactory();
        this.syntaxStrategy = new GormMappingConfigurationStrategy(this.mappingFactory);
        this.addPersistentEntities(entities);
    }

    public Closure getDefaultMapping() {
        return this.defaultMapping;
    }

    protected MappingFactory<Table, Column> createMappingFactory() {
        GormCassandraMappingFactory cassandraMappingFactory = new GormCassandraMappingFactory(this.keyspace);
        cassandraMappingFactory.setDefaultMapping(this.defaultMapping);
        return cassandraMappingFactory;
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public void setMappingFactory(MappingFactory<Table, Column> mappingFactory) {
        this.mappingFactory = mappingFactory;
    }

    public void setSyntaxStrategy(MappingConfigurationStrategy syntaxStrategy) {
        this.syntaxStrategy = syntaxStrategy;
    }

    public BasicCassandraMappingContext getSpringCassandraMappingContext() {
        return this.springCassandraMappingContext;
    }

    public void setSpringCassandraMappingContext(BasicCassandraMappingContext springCassandraMappingContext) {
        this.springCassandraMappingContext = springCassandraMappingContext;
    }

    public MappingConfigurationStrategy getMappingSyntaxStrategy() {
        return this.syntaxStrategy;
    }

    public MappingFactory<Table, Column> getMappingFactory() {
        return this.mappingFactory;
    }

    protected PersistentEntity createPersistentEntity(Class javaClass) {
        return new CassandraPersistentEntity(javaClass, this);
    }

    protected PersistentEntity createPersistentEntity(Class javaClass, boolean external) {
        return new CassandraPersistentEntity(javaClass, this);
    }
}

