/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.cassandra;

import java.io.Serializable;
import java.util.Map;
import org.grails.datastore.mapping.cassandra.CassandraDatastore;
import org.grails.datastore.mapping.cassandra.config.Table;
import org.grails.datastore.mapping.cassandra.engine.CassandraEntityPersister;
import org.grails.datastore.mapping.core.AbstractSession;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.engine.NonPersistentTypeException;
import org.grails.datastore.mapping.engine.Persister;
import org.grails.datastore.mapping.model.ClassMapping;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.transactions.SessionOnlyTransaction;
import org.grails.datastore.mapping.transactions.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.cassandra.core.CassandraTemplate;
import org.springframework.util.Assert;

public class CassandraSession
extends AbstractSession<com.datastax.driver.core.Session> {
    private Logger log = LoggerFactory.getLogger(CassandraSession.class);
    private com.datastax.driver.core.Session session;
    private ApplicationEventPublisher applicationEventPublisher;
    private CassandraTemplate cassandraTemplate;

    public CassandraSession(Datastore ds, MappingContext context, com.datastax.driver.core.Session session, ApplicationEventPublisher applicationEventPublisher, boolean stateless, CassandraTemplate cassandraTemplate) {
        super(ds, context, applicationEventPublisher, stateless);
        Assert.notNull((Object)session, (String)"Native session to Cassandra is null");
        this.applicationEventPublisher = applicationEventPublisher;
        this.session = session;
        this.cassandraTemplate = cassandraTemplate;
    }

    public boolean hasTransaction() {
        return true;
    }

    protected Persister createPersister(Class cls, MappingContext mappingContext) {
        PersistentEntity entity = mappingContext.getPersistentEntity(cls.getName());
        if (entity != null) {
            return new CassandraEntityPersister(mappingContext, entity, this, this.applicationEventPublisher);
        }
        return null;
    }

    public void disconnect() {
        super.disconnect();
    }

    protected Transaction beginTransactionInternal() {
        return new SessionOnlyTransaction((Object)this.getNativeInterface(), (Session)this);
    }

    public CassandraDatastore getCassandraDatastore() {
        return (CassandraDatastore)this.getDatastore();
    }

    public com.datastax.driver.core.Session getNativeInterface() {
        return this.session;
    }

    public CassandraTemplate getCassandraTemplate() {
        return this.cassandraTemplate;
    }

    public Serializable update(Object o) {
        Assert.notNull((Object)o, (String)"Cannot persist null object");
        Persister persister = this.getPersister(o);
        if (persister == null) {
            throw new NonPersistentTypeException("Object [" + o + "] cannot be persisted. It is not a known persistent type.");
        }
        CassandraEntityPersister cassandraEntityPersister = (CassandraEntityPersister)persister;
        Serializable key = (Serializable)cassandraEntityPersister.update(o);
        this.cacheObject(key, o);
        return key;
    }

    public void deleteAll(Class type) {
        this.cassandraTemplate.truncate(this.cassandraTemplate.getTableName(type));
    }

    protected Serializable convertIdentityIfNecessasry(PersistentProperty identity, Serializable key) {
        ClassMapping classMapping = identity.getOwner().getMapping();
        Table table = (Table)classMapping.getMappedForm();
        if (table.hasCompositePrimaryKeys() && key instanceof Map) {
            return key;
        }
        return super.convertIdentityIfNecessasry(identity, key);
    }
}

