/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.grails.datastore.gorm.cassandra.CassandraGormEnhancer;
import org.grails.datastore.gorm.cassandra.mapping.BasicCassandraMappingContext;
import org.grails.datastore.gorm.cassandra.mapping.MappingCassandraConverter;
import org.grails.datastore.gorm.cassandra.mapping.TimeZoneToStringConverter;
import org.grails.datastore.gorm.events.AutoTimestampEventListener;
import org.grails.datastore.gorm.events.ConfigurableApplicationContextEventPublisher;
import org.grails.datastore.gorm.events.ConfigurableApplicationEventPublisher;
import org.grails.datastore.gorm.events.DomainEventListener;
import org.grails.datastore.gorm.validation.listener.ValidationEventListener;
import org.grails.datastore.mapping.cassandra.CassandraSession;
import org.grails.datastore.mapping.cassandra.config.CassandraMappingContext;
import org.grails.datastore.mapping.cassandra.config.GormCassandraSessionFactoryBean;
import org.grails.datastore.mapping.cassandra.utils.EnumUtil;
import org.grails.datastore.mapping.core.AbstractDatastore;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.core.DatastoreException;
import org.grails.datastore.mapping.model.DatastoreConfigurationException;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.transactions.DatastoreTransactionManager;
import org.grails.datastore.mapping.transactions.TransactionCapableDatastore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cassandra.config.CassandraCqlClusterFactoryBean;
import org.springframework.cassandra.config.KeyspaceAction;
import org.springframework.cassandra.config.KeyspaceActionSpecificationFactoryBean;
import org.springframework.cassandra.core.keyspace.KeyspaceActionSpecification;
import org.springframework.cassandra.core.keyspace.KeyspaceOption;
import org.springframework.cassandra.support.CassandraExceptionTranslator;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.env.PropertyResolver;
import org.springframework.data.cassandra.config.SchemaAction;
import org.springframework.data.cassandra.convert.CassandraConverter;
import org.springframework.data.cassandra.core.CassandraAdminTemplate;
import org.springframework.data.cassandra.core.CassandraTemplate;
import org.springframework.data.cassandra.mapping.CassandraPersistentEntity;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.Assert;

public class CassandraDatastore
extends AbstractDatastore
implements InitializingBean,
DisposableBean,
Closeable,
MappingContext.Listener,
TransactionCapableDatastore {
    public static final String WRITE_OPTIONS = "writeOptions";
    private static Logger log = LoggerFactory.getLogger(CassandraDatastore.class);
    public static final String DEFAULT_KEYSPACE = "CassandraKeySpace";
    public static final SchemaAction DEFAULT_SCHEMA_ACTION = SchemaAction.NONE;
    public static final String CONTACT_POINTS = "grails.cassandra.contactPoints";
    public static final String PORT = "grails.cassandra.port";
    public static final String SCHEMA_ACTION = "grails.cassandra.dbCreate";
    public static final String KEYSPACE_CONFIG = "grails.cassandra.keyspace";
    public static final String KEYSPACE_NAME = "grails.cassandra.keyspace.name";
    public static final String DEFAULT_MAPPING = "grails.cassandra.default.mapping";
    public static final String KEYSPACE_ACTION = "grails.cassandra.keyspace.action";
    public static final String KEYSPACE_DURABLE_WRITES = "grails.cassandra.keyspace.durableWrites";
    public static final String KEYSPACE_REPLICATION_FACTOR = "grails.cassandra.keyspace.replicationFactor";
    public static final String KEYSPACE_REPLICATION_STRATEGY = "grails.cassandra.keyspace.replicationStrategy";
    public static final String KEYSPACE_NETWORK_TOPOLOGY = "grails.cassandra.keyspace.networkTopology";
    protected Cluster nativeCluster;
    protected Session nativeSession;
    protected BasicCassandraMappingContext springCassandraMappingContext;
    protected CassandraTemplate cassandraTemplate;
    protected CassandraAdminTemplate cassandraAdminTemplate;
    protected CassandraCqlClusterFactoryBean cassandraCqlClusterFactoryBean;
    protected KeyspaceActionSpecificationFactoryBean keyspaceActionSpecificationFactoryBean;
    protected GormCassandraSessionFactoryBean cassandraSessionFactoryBean;
    protected boolean stateless = false;
    protected String keyspace;
    protected boolean developmentMode = false;
    protected final CassandraGormEnhancer gormEnhancer;
    protected final PlatformTransactionManager transactionManager;

    public CassandraDatastore() {
        this(new CassandraMappingContext(), Collections.emptyMap(), null);
    }

    public CassandraDatastore(Map<String, Object> connectionDetails, ConfigurableApplicationContext ctx) {
        this(new CassandraMappingContext(), connectionDetails, ctx);
    }

    public CassandraDatastore(CassandraMappingContext mappingContext, PropertyResolver connectionDetails, ConfigurableApplicationContext ctx) {
        this(mappingContext, connectionDetails, null, ctx);
    }

    public CassandraDatastore(CassandraMappingContext mappingContext, Map<String, Object> connectionDetails, ConfigurableApplicationContext ctx) {
        this(mappingContext, CassandraDatastore.mapToPropertyResolver(connectionDetails), ctx);
    }

    public CassandraDatastore(CassandraMappingContext mappingContext, PropertyResolver connectionDetails, Cluster existingCluster, ConfigurableApplicationContext ctx) {
        super((MappingContext)mappingContext, connectionDetails, ctx);
        this.keyspace = mappingContext.getKeyspace();
        this.nativeCluster = existingCluster;
        Assert.hasText((String)this.keyspace, (String)"Keyspace must be set");
        this.springCassandraMappingContext = new BasicCassandraMappingContext(mappingContext);
        DatastoreTransactionManager datastoreTransactionManager = new DatastoreTransactionManager();
        datastoreTransactionManager.setDatastore((Datastore)this);
        this.transactionManager = datastoreTransactionManager;
        mappingContext.setSpringCassandraMappingContext(this.springCassandraMappingContext);
        mappingContext.addMappingContextListener(this);
        this.initializeConverters((MappingContext)mappingContext);
        if (ctx != null) {
            this.registerEventListeners((ConfigurableApplicationEventPublisher)new ConfigurableApplicationContextEventPublisher(ctx));
        }
        this.gormEnhancer = new CassandraGormEnhancer((Datastore)this, this.transactionManager);
        this.enhanceAll();
        if (log.isDebugEnabled()) {
            log.debug("Initializing Cassandra Datastore for keyspace: " + this.keyspace);
        }
    }

    @Deprecated
    public void enhanceAll() {
        for (PersistentEntity entity : this.mappingContext.getPersistentEntities()) {
            this.gormEnhancer.addCollectionMethods(entity);
        }
    }

    public void setDevelopmentMode(boolean developmentMode) {
        this.developmentMode = developmentMode;
    }

    protected void registerEventListeners(ConfigurableApplicationEventPublisher eventPublisher) {
        eventPublisher.addApplicationListener((ApplicationListener)new DomainEventListener((Datastore)this));
        eventPublisher.addApplicationListener((ApplicationListener)new AutoTimestampEventListener((Datastore)this));
        eventPublisher.addApplicationListener((ApplicationListener)new ValidationEventListener((Datastore)this));
    }

    protected void initializeConverters(MappingContext mappingContext) {
        super.initializeConverters(mappingContext);
        mappingContext.getConverterRegistry().addConverter((Converter)new TimeZoneToStringConverter());
    }

    public void setCassandraCqlClusterFactoryBean(CassandraCqlClusterFactoryBean cassandraCqlClusterFactoryBean) {
        this.cassandraCqlClusterFactoryBean = cassandraCqlClusterFactoryBean;
    }

    public void setKeyspaceActionSpecificationFactoryBean(KeyspaceActionSpecificationFactoryBean keyspaceActionSpecificationFactoryBean) {
        this.keyspaceActionSpecificationFactoryBean = keyspaceActionSpecificationFactoryBean;
    }

    public void setCassandraSessionFactoryBean(GormCassandraSessionFactoryBean cassandraSessionFactoryBean) {
        this.cassandraSessionFactoryBean = cassandraSessionFactoryBean;
    }

    public void afterPropertiesSet() throws Exception {
        this.createCluster();
        this.createNativeSession();
    }

    protected Cluster createCluster() throws Exception {
        if (this.nativeCluster == null) {
            if (this.cassandraCqlClusterFactoryBean == null) {
                this.cassandraCqlClusterFactoryBean = new CassandraCqlClusterFactoryBean();
            }
            String contactPoints = this.connectionDetails.getProperty(CONTACT_POINTS, "localhost");
            this.cassandraCqlClusterFactoryBean.setContactPoints(contactPoints);
            Integer defaultPort = (Integer)this.connectionDetails.getProperty(PORT, Integer.class, (Object)9042);
            this.cassandraCqlClusterFactoryBean.setPort(defaultPort.intValue());
            Set<KeyspaceActionSpecification<?>> keyspaceSpecifications = this.createKeyspaceSpecifications();
            this.cassandraCqlClusterFactoryBean.setKeyspaceSpecifications(keyspaceSpecifications);
            this.cassandraCqlClusterFactoryBean.afterPropertiesSet();
            this.nativeCluster = this.cassandraCqlClusterFactoryBean.getObject();
            if (this.nativeCluster == null) {
                throw new DatastoreConfigurationException("Cassandra driver cluster not created");
            }
        }
        return this.nativeCluster;
    }

    protected Set<KeyspaceActionSpecification<?>> createKeyspaceSpecifications() {
        Set specifications = Collections.emptySet();
        KeyspaceAction keyspaceAction = this.readKeyspaceAction();
        if (keyspaceAction != null) {
            Map networkTopology;
            log.info("Set keyspace generation strategy to '" + this.connectionDetails.getProperty(KEYSPACE_ACTION) + "'");
            if (this.keyspaceActionSpecificationFactoryBean == null) {
                this.keyspaceActionSpecificationFactoryBean = new KeyspaceActionSpecificationFactoryBean();
            }
            this.keyspaceActionSpecificationFactoryBean.setName(this.keyspace);
            this.keyspaceActionSpecificationFactoryBean.setAction(keyspaceAction);
            this.keyspaceActionSpecificationFactoryBean.setDurableWrites(((Boolean)this.connectionDetails.getProperty(KEYSPACE_DURABLE_WRITES, Boolean.class, (Object)true)).booleanValue());
            KeyspaceOption.ReplicationStrategy replicationStrategy = (KeyspaceOption.ReplicationStrategy)this.connectionDetails.getProperty(KEYSPACE_REPLICATION_STRATEGY, KeyspaceOption.ReplicationStrategy.class, (Object)KeyspaceOption.ReplicationStrategy.SIMPLE_STRATEGY);
            this.keyspaceActionSpecificationFactoryBean.setReplicationStrategy(replicationStrategy);
            if (replicationStrategy == KeyspaceOption.ReplicationStrategy.SIMPLE_STRATEGY) {
                this.keyspaceActionSpecificationFactoryBean.setReplicationFactor(((Long)this.connectionDetails.getProperty(KEYSPACE_REPLICATION_FACTOR, Long.class, (Object)1L)).longValue());
            } else if (replicationStrategy == KeyspaceOption.ReplicationStrategy.NETWORK_TOPOLOGY_STRATEGY && (networkTopology = (Map)this.connectionDetails.getProperty(KEYSPACE_NETWORK_TOPOLOGY, Map.class, null)) != null) {
                ArrayList<String> dataCenters = new ArrayList<String>();
                ArrayList<String> replicationFactors = new ArrayList<String>();
                Iterator i$ = networkTopology.entrySet().iterator();
                while (i$.hasNext()) {
                    Map.Entry o;
                    Map.Entry entry = o = i$.next();
                    dataCenters.add(String.valueOf(entry.getKey()));
                    replicationFactors.add(String.valueOf(entry.getValue()));
                }
                this.keyspaceActionSpecificationFactoryBean.setNetworkTopologyDataCenters(dataCenters);
                this.keyspaceActionSpecificationFactoryBean.setNetworkTopologyReplicationFactors(replicationFactors);
            }
            this.keyspaceActionSpecificationFactoryBean.setIfNotExists(true);
            try {
                this.keyspaceActionSpecificationFactoryBean.afterPropertiesSet();
                specifications = this.keyspaceActionSpecificationFactoryBean.getObject();
            }
            catch (Exception e) {
                throw new DatastoreConfigurationException(String.format("Failed to create keyspace [%s] ", this.keyspace), (Throwable)e);
            }
        }
        return specifications;
    }

    protected Session createNativeSession() throws ClassNotFoundException, Exception {
        if (this.nativeSession == null) {
            SchemaAction schemaAction = this.readSchemaAction();
            Assert.notNull((Object)this.nativeCluster, (String)"Cassandra driver cluster not created");
            if (this.cassandraSessionFactoryBean == null) {
                this.cassandraSessionFactoryBean = new GormCassandraSessionFactoryBean();
            }
            this.cassandraSessionFactoryBean.setCluster(this.nativeCluster);
            this.cassandraSessionFactoryBean.setKeyspaceName(this.keyspace);
            MappingCassandraConverter mappingCassandraConverter = new MappingCassandraConverter(this.cassandraMapping());
            this.cassandraSessionFactoryBean.setConverter((CassandraConverter)mappingCassandraConverter);
            this.cassandraSessionFactoryBean.setSchemaAction(schemaAction);
            if (log.isInfoEnabled()) {
                log.info("Set Cassandra db generation strategy to '" + schemaAction + "'");
            }
            this.buildIndex();
            this.nativeSession = this.cassandraSessionFactoryBean.getObject();
            this.cassandraTemplate = new CassandraTemplate(this.nativeSession, (CassandraConverter)mappingCassandraConverter);
            this.cassandraTemplate.setExceptionTranslator(new CassandraExceptionTranslator());
            this.cassandraAdminTemplate = new CassandraAdminTemplate(this.nativeSession, (CassandraConverter)mappingCassandraConverter);
        }
        return this.nativeSession;
    }

    protected void buildIndex() throws Exception {
        if (this.cassandraSessionFactoryBean != null) {
            this.cassandraSessionFactoryBean.afterPropertiesSet();
        }
    }

    protected org.springframework.data.cassandra.mapping.CassandraMappingContext cassandraMapping() throws ClassNotFoundException {
        Collection persistentEntities = this.mappingContext.getPersistentEntities();
        HashSet<Class> entitySet = new HashSet<Class>();
        for (PersistentEntity persistentEntity : persistentEntities) {
            entitySet.add(persistentEntity.getJavaClass());
        }
        this.springCassandraMappingContext.setInitialEntitySet(entitySet);
        this.springCassandraMappingContext.afterPropertiesSet();
        return this.springCassandraMappingContext;
    }

    protected org.grails.datastore.mapping.core.Session createSession(PropertyResolver connectionDetails) {
        if (this.stateless) {
            return this.createStatelessSession(connectionDetails);
        }
        return new CassandraSession((Datastore)this, this.getMappingContext(), this.nativeSession, this.getApplicationEventPublisher(), false, this.cassandraTemplate);
    }

    protected org.grails.datastore.mapping.core.Session createStatelessSession(PropertyResolver connectionDetails) {
        return new CassandraSession((Datastore)this, this.getMappingContext(), this.nativeSession, this.getApplicationEventPublisher(), true, this.cassandraTemplate);
    }

    public void persistentEntityAdded(PersistentEntity entity) {
        this.gormEnhancer.registerEntity(entity);
        this.gormEnhancer.addCollectionMethods(entity);
        try {
            CassandraPersistentEntity springEntity = (CassandraPersistentEntity)this.springCassandraMappingContext.getPersistentEntity(entity.getJavaClass());
            if (this.cassandraSessionFactoryBean != null) {
                this.cassandraSessionFactoryBean.createTableIfNecessary(springEntity);
            }
        }
        catch (Exception e) {
            throw new DatastoreConfigurationException("Could not add entity [" + entity.getName() + "] as Cassandra entity: " + e.getMessage(), (Throwable)e);
        }
    }

    public Cluster getNativeCluster() {
        return this.nativeCluster;
    }

    public Session getNativeSession() {
        return this.nativeSession;
    }

    public CassandraTemplate getCassandraTemplate() {
        return this.cassandraTemplate;
    }

    public void destroy() throws Exception {
        super.destroy();
        this.gormEnhancer.close();
        if (this.cassandraSessionFactoryBean != null) {
            this.cassandraSessionFactoryBean.destroy();
        }
        if (this.cassandraCqlClusterFactoryBean != null) {
            this.cassandraCqlClusterFactoryBean.destroy();
        }
    }

    private KeyspaceAction readKeyspaceAction() {
        HashMap<String, KeyspaceAction> keyspaceActionMap = new HashMap<String, KeyspaceAction>();
        keyspaceActionMap.put("create", KeyspaceAction.CREATE);
        keyspaceActionMap.put("create-drop", KeyspaceAction.CREATE_DROP);
        return EnumUtil.findMatchingEnum(KEYSPACE_ACTION, this.connectionDetails.getProperty(KEYSPACE_ACTION, (String)null), keyspaceActionMap, this.developmentMode ? KeyspaceAction.CREATE_DROP : null);
    }

    private SchemaAction readSchemaAction() {
        HashMap<String, SchemaAction> schemaActionMap = new HashMap<String, SchemaAction>();
        schemaActionMap.put("none", SchemaAction.NONE);
        schemaActionMap.put("create", SchemaAction.CREATE);
        schemaActionMap.put("recreate", SchemaAction.RECREATE);
        schemaActionMap.put("recreate-drop-unused", SchemaAction.RECREATE_DROP_UNUSED);
        return EnumUtil.findMatchingEnum(SCHEMA_ACTION, this.connectionDetails.getProperty(SCHEMA_ACTION, this.developmentMode ? "recreate-drop-unused" : "none"), schemaActionMap, this.developmentMode ? SchemaAction.RECREATE_DROP_UNUSED : SchemaAction.NONE);
    }

    @Override
    public void close() throws IOException {
        try {
            this.destroy();
        }
        catch (Exception e) {
            throw new DatastoreException("Error shutting down Cassandra datastore: " + e.getMessage(), (Throwable)e);
        }
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }
}

