/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.cassandra.mapping;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.querybuilder.Insert;
import org.grails.datastore.gorm.cassandra.mapping.TimeZoneToStringConverter;
import org.grails.datastore.mapping.model.types.BasicTypeConverterRegistrar;
import org.grails.datastore.mapping.model.types.conversion.StringToCurrencyConverter;
import org.grails.datastore.mapping.model.types.conversion.StringToLocaleConverter;
import org.grails.datastore.mapping.model.types.conversion.StringToTimeZoneConverter;
import org.grails.datastore.mapping.model.types.conversion.StringToURLConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.cassandra.convert.CassandraPersistentEntityParameterValueProvider;
import org.springframework.data.cassandra.convert.CassandraRowValueProvider;
import org.springframework.data.cassandra.convert.ColumnReader;
import org.springframework.data.cassandra.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.mapping.CassandraPersistentProperty;
import org.springframework.data.convert.EntityInstantiator;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.mapping.model.DefaultSpELExpressionEvaluator;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.PropertyValueProvider;
import org.springframework.data.mapping.model.SpELExpressionEvaluator;

public class MappingCassandraConverter
extends org.springframework.data.cassandra.convert.MappingCassandraConverter {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public MappingCassandraConverter(CassandraMappingContext cassandraMapping) {
        super(cassandraMapping);
        DefaultConversionService conversionService = (DefaultConversionService)this.getConversionService();
        conversionService.addConverter((Converter)new StringToCurrencyConverter());
        conversionService.addConverter((Converter)new StringToLocaleConverter());
        conversionService.addConverter((Converter)new StringToTimeZoneConverter());
        conversionService.addConverter((Converter)new TimeZoneToStringConverter());
        conversionService.addConverter((Converter)new StringToURLConverter());
        BasicTypeConverterRegistrar registrar = new BasicTypeConverterRegistrar();
        registrar.register((ConverterRegistry)conversionService);
    }

    protected <S> S readEntityFromRow(CassandraPersistentEntity<S> entity, Row row) {
        DefaultSpELExpressionEvaluator evaluator = new DefaultSpELExpressionEvaluator((Object)row, this.spELContext);
        BasicCassandraRowValueProvider rowValueProvider = new BasicCassandraRowValueProvider(row, evaluator);
        CassandraPersistentEntityParameterValueProvider parameterProvider = new CassandraPersistentEntityParameterValueProvider(entity, (PropertyValueProvider)rowValueProvider, null);
        EntityInstantiator instantiator = this.instantiators.getInstantiatorFor(entity);
        Object instance = instantiator.createInstance(entity, (ParameterValueProvider)parameterProvider);
        PersistentPropertyAccessor accessor = instance instanceof PersistentPropertyAccessor ? (PersistentPropertyAccessor)instance : entity.getPropertyAccessor(instance);
        this.readPropertiesFromRow(entity, (CassandraRowValueProvider)rowValueProvider, (PersistentPropertyAccessor)new ConvertingPropertyAccessor(accessor, this.conversionService){

            public void setProperty(PersistentProperty<?> property, Object value) {
                Class actualType = property.getTypeInformation().getType();
                if (actualType.isEnum() && value instanceof CharSequence) {
                    super.setProperty(property, MappingCassandraConverter.this.conversionService.convert(value, actualType));
                } else {
                    super.setProperty(property, value);
                }
            }
        });
        return (S)accessor.getBean();
    }

    protected void writeInsertFromWrapper(final ConvertingPropertyAccessor accessor, final Insert insert, CassandraPersistentEntity<?> entity) {
        entity.doWithProperties((PropertyHandler)new PropertyHandler<CassandraPersistentProperty>(){

            public void doWithPersistentProperty(CassandraPersistentProperty prop) {
                Object value = accessor.getProperty((PersistentProperty)prop, prop.getType());
                if (MappingCassandraConverter.this.log.isDebugEnabled()) {
                    MappingCassandraConverter.this.log.debug("prop.type -> " + prop.getType().getName());
                    MappingCassandraConverter.this.log.debug("prop.value -> " + value);
                }
                if (prop.getDataType().equals(DataType.text()) && !CharSequence.class.isAssignableFrom(prop.getType())) {
                    value = MappingCassandraConverter.this.conversionService.convert(value, String.class);
                }
                if (prop.isCompositePrimaryKey()) {
                    if (MappingCassandraConverter.this.log.isDebugEnabled()) {
                        MappingCassandraConverter.this.log.debug("prop is a compositeKey");
                    }
                    PersistentPropertyAccessor accessor2 = value instanceof PersistentPropertyAccessor ? (PersistentPropertyAccessor)value : prop.getCompositePrimaryKeyEntity().getPropertyAccessor(value);
                    accessor2 = new ConvertingPropertyAccessor(accessor2, MappingCassandraConverter.this.conversionService);
                    MappingCassandraConverter.this.writeInsertFromWrapper((ConvertingPropertyAccessor)accessor2, insert, prop.getCompositePrimaryKeyEntity());
                    return;
                }
                if (value != null) {
                    if (MappingCassandraConverter.this.log.isDebugEnabled()) {
                        MappingCassandraConverter.this.log.debug(String.format("Adding insert.value [%s] - [%s]", prop.getColumnName().toCql(), value));
                    }
                    insert.value(prop.getColumnName().toCql(), value);
                }
            }
        });
    }

    private static class BasicCassandraRowValueProvider
    extends org.springframework.data.cassandra.convert.BasicCassandraRowValueProvider {
        private final ColumnReader reader;
        private final SpELExpressionEvaluator evaluator;

        public BasicCassandraRowValueProvider(Row source, DefaultSpELExpressionEvaluator evaluator) {
            super(source, evaluator);
            this.reader = new ColumnReader(source){

                public Object get(int i) {
                    DataType type = this.columns.getType(i);
                    if (type.equals(DataType.varint())) {
                        return this.row.getVarint(i);
                    }
                    return super.get(i);
                }
            };
            this.evaluator = evaluator;
        }

        public Object getPropertyValue(CassandraPersistentProperty property) {
            String expression = property.getSpelExpression();
            if (expression != null) {
                return this.evaluator.evaluate(expression);
            }
            return this.reader.get(property.getColumnName());
        }

        public Row getRow() {
            return this.reader.getRow();
        }
    }
}

