/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.cassandra.mapping;

import com.datastax.driver.core.DataType;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Calendar;
import java.util.Currency;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.grails.datastore.mapping.cassandra.config.CassandraMappingContext;
import org.grails.datastore.mapping.cassandra.config.Table;
import org.grails.datastore.mapping.model.IllegalMappingException;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.springframework.cassandra.core.keyspace.CreateTableSpecification;
import org.springframework.cassandra.core.keyspace.TableOption;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.cassandra.mapping.BasicCassandraPersistentProperty;
import org.springframework.data.cassandra.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.mapping.CassandraSimpleTypeHolder;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.TypeInformation;
import org.springframework.validation.Errors;

public class BasicCassandraMappingContext
extends org.springframework.data.cassandra.mapping.BasicCassandraMappingContext {
    private static final Map<String, Class<? extends Enum>> KEY_TO_OPTION = new LinkedHashMap<String, Class<? extends Enum>>(){
        {
            this.put("CACHING", TableOption.CachingOption.class);
            this.put("COMPACTION", TableOption.CompactionOption.class);
            this.put("COMPRESSION", TableOption.CompressionOption.class);
        }
    };
    public static final String INTERNAL_MARKER = "$";
    public static final String INTERNAL_GRAILS_FIELD_MARKER = "org_grails";
    CassandraMappingContext gormCassandraMappingContext;

    public BasicCassandraMappingContext(CassandraMappingContext gormCassandraMappingContext) {
        this.gormCassandraMappingContext = gormCassandraMappingContext;
    }

    protected CassandraPersistentEntity<?> addPersistentEntity(TypeInformation<?> typeInformation) {
        if (!typeInformation.getType().isInterface()) {
            return super.addPersistentEntity(typeInformation);
        }
        return null;
    }

    public CreateTableSpecification getCreateTableSpecificationFor(CassandraPersistentEntity<?> entity) {
        CreateTableSpecification tableSpecification = super.getCreateTableSpecificationFor(entity);
        PersistentEntity gormEntity = this.gormCassandraMappingContext.getPersistentEntity(entity.getName());
        Table table = (Table)gormEntity.getMapping().getMappedForm();
        Map<String, Object> tableProperties = table.getTableProperties();
        if (tableProperties != null && !tableProperties.isEmpty()) {
            for (Map.Entry<String, Object> option : tableProperties.entrySet()) {
                String k = option.getKey();
                String optionName = this.resolveOptionName(k);
                Object value = option.getValue();
                try {
                    TableOption to = TableOption.valueOf((String)optionName);
                    if (value instanceof Boolean) {
                        if (!((Boolean)value).booleanValue()) continue;
                        tableSpecification.with(to);
                        continue;
                    }
                    if (value instanceof Map) {
                        Map mapValue = (Map)value;
                        if (KEY_TO_OPTION.containsKey(optionName)) {
                            Class<? extends Enum> enumClass = KEY_TO_OPTION.get(optionName);
                            for (Object key : new HashSet(mapValue.keySet())) {
                                String subOption = this.resolveOptionName(key.toString());
                                try {
                                    Enum subopt = Enum.valueOf(enumClass, subOption);
                                    Object v = mapValue.get(key);
                                    mapValue.remove(key);
                                    mapValue.put(subopt, v);
                                }
                                catch (Exception e) {
                                    throw new IllegalMappingException("Invalid [" + optionName + "] option [" + key + "] for parent option [" + key + "] for entity [" + entity.getName() + "]: " + e.getMessage());
                                }
                            }
                        }
                        tableSpecification.with(to, (Object)mapValue);
                        continue;
                    }
                    tableSpecification.with(to, value);
                }
                catch (Throwable e) {
                    throw new IllegalMappingException("Invalid table option [" + k + "] for entity [" + entity.getName() + "]: " + e.getMessage());
                }
            }
        }
        return tableSpecification;
    }

    private String resolveOptionName(String k) {
        return k.toUpperCase().replace(' ', '_');
    }

    public CassandraPersistentProperty createPersistentProperty(Field field, PropertyDescriptor descriptor, CassandraPersistentEntity<?> owner, SimpleTypeHolder simpleTypeHolder) {
        Class<?> rawType;
        PersistentEntity gormEntity = this.gormCassandraMappingContext.getPersistentEntity(owner.getName());
        CassandraPersistentProperty property = super.createPersistentProperty(field, descriptor, owner, simpleTypeHolder);
        BasicCassandraPersistentProperty transientProperty = new BasicCassandraPersistentProperty(field, descriptor, owner, (CassandraSimpleTypeHolder)simpleTypeHolder){

            public boolean isTransient() {
                return true;
            }
        };
        if (field == null && !property.usePropertyAccess()) {
            return transientProperty;
        }
        if (field != null && Modifier.isTransient(field.getModifiers())) {
            return transientProperty;
        }
        if (field != null && "errors".equals(field.getName())) {
            return transientProperty;
        }
        if (field != null && field.getType().equals(Errors.class)) {
            return transientProperty;
        }
        if (field != null && (field.getName().contains(INTERNAL_MARKER) || field.getName().startsWith(INTERNAL_GRAILS_FIELD_MARKER))) {
            return transientProperty;
        }
        if (descriptor != null && descriptor.getWriteMethod() == null && descriptor.getReadMethod() == null) {
            return transientProperty;
        }
        Class<Object> clazz = field != null ? field.getType() : (rawType = descriptor != null ? descriptor.getPropertyType() : null);
        if (rawType == null) {
            return transientProperty;
        }
        if (rawType.isEnum()) {
            return new BasicCassandraPersistentProperty(field, descriptor, owner, (CassandraSimpleTypeHolder)simpleTypeHolder){

                public DataType getDataType() {
                    return CassandraSimpleTypeHolder.getDataTypeFor(String.class);
                }

                public boolean usePropertyAccess() {
                    return true;
                }
            };
        }
        if (URL.class.isAssignableFrom(rawType) || TimeZone.class.isAssignableFrom(rawType) || Locale.class.isAssignableFrom(rawType) || Currency.class.isAssignableFrom(rawType) || Calendar.class.isAssignableFrom(rawType)) {
            return new BasicCassandraPersistentProperty(field, descriptor, owner, (CassandraSimpleTypeHolder)simpleTypeHolder){

                public DataType getDataType() {
                    return CassandraSimpleTypeHolder.getDataTypeFor(String.class);
                }

                public boolean isEntity() {
                    return false;
                }

                public boolean usePropertyAccess() {
                    return true;
                }
            };
        }
        if (field != null && gormEntity != null && "version".equals(field.getName()) && !gormEntity.isVersioned()) {
            return transientProperty;
        }
        if (!property.isTransient() && (property.isMap() || property.isCollectionLike())) {
            try {
                property.getDataType();
            }
            catch (InvalidDataAccessApiUsageException e) {
                return transientProperty;
            }
        }
        return property;
    }
}

