/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.cassandra.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.EnumUtils;
import org.springframework.cassandra.core.keyspace.Option;

public class EnumUtil {
    public static <E extends Enum<E>> E findEnum(Class<E> enumClass, String value) {
        if (value == null) {
            return null;
        }
        List enumTypes = EnumUtils.getEnumList(enumClass);
        Enum enumValue = null;
        for (Enum e : enumTypes) {
            if (Option.class.isInstance(e)) {
                if (!((Option)e).getName().equals(value)) continue;
                enumValue = e;
                break;
            }
            if (!e.toString().equals(value)) continue;
            enumValue = e;
            break;
        }
        return (E)enumValue;
    }

    public static <E extends Enum<E>> E findEnum(Class<E> enumClass, String key, Map<String, Object> map, E defaultValue) {
        if (map == null) {
            return defaultValue;
        }
        Object value = map.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (!(value instanceof String)) {
            throw new IllegalArgumentException(String.format("Invalid type for property [%s], expected java.lang.String", key));
        }
        E enumValue = EnumUtil.getRequiredEnum(enumClass, key, (String)value);
        return enumValue;
    }

    public static <E extends Enum<E>> E getRequiredEnum(Class<E> enumClass, String property, String value) {
        E enumValue = EnumUtil.findEnum(enumClass, value);
        if (enumValue == null) {
            throw new IllegalArgumentException(String.format("Invalid option [%s] for property [%s], allowable values are %s", value, property, EnumUtil.getValidEnumList(enumClass)));
        }
        return enumValue;
    }

    public static <E extends Enum<E>> List<String> getValidEnumList(Class<E> enumClass) {
        ArrayList<String> allowable = new ArrayList<String>();
        List enumList = EnumUtils.getEnumList(enumClass);
        for (Enum e : enumList) {
            if (Option.class.isInstance(e)) {
                allowable.add(((Option)e).getName());
                continue;
            }
            allowable.add(e.toString());
        }
        return allowable;
    }

    public static <E extends Enum<E>> E findMatchingEnum(String property, Object key, Map<String, E> map, E defaultValue) {
        if (key == null || map == null) {
            return defaultValue;
        }
        if (!(key instanceof String)) {
            throw new IllegalArgumentException(String.format("Invalid type for property [%s], expected java.lang.String", key));
        }
        Enum enumValue = (Enum)map.get(key);
        if (enumValue == null) {
            throw new IllegalArgumentException(String.format("Invalid option [%s] for property [%s], allowable values are %s", key, property, map.keySet()));
        }
        return (E)enumValue;
    }
}

