/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.cassandra.engine;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Update;
import groovy.lang.MissingPropertyException;
import java.io.Serializable;
import java.net.URL;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import org.grails.datastore.mapping.cassandra.CassandraSession;
import org.grails.datastore.mapping.cassandra.config.Column;
import org.grails.datastore.mapping.cassandra.config.Table;
import org.grails.datastore.mapping.cassandra.engine.CassandraPendingUpdateAdapter;
import org.grails.datastore.mapping.cassandra.query.CassandraQuery;
import org.grails.datastore.mapping.cassandra.utils.UUIDUtil;
import org.grails.datastore.mapping.core.OptimisticLockingException;
import org.grails.datastore.mapping.core.SessionImplementor;
import org.grails.datastore.mapping.core.impl.PendingUpdate;
import org.grails.datastore.mapping.core.impl.PendingUpdateAdapter;
import org.grails.datastore.mapping.engine.AssociationIndexer;
import org.grails.datastore.mapping.engine.EntityAccess;
import org.grails.datastore.mapping.engine.NativeEntryEntityPersister;
import org.grails.datastore.mapping.engine.PropertyValueIndexer;
import org.grails.datastore.mapping.model.ClassMapping;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.types.Association;
import org.grails.datastore.mapping.proxy.ProxyFactory;
import org.grails.datastore.mapping.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cassandra.core.CqlTemplate;
import org.springframework.cassandra.core.SessionCallback;
import org.springframework.cassandra.core.WriteOptions;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.dao.DataAccessException;
import org.springframework.data.cassandra.core.CassandraTemplate;
import org.springframework.data.cassandra.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.repository.MapId;
import org.springframework.data.cassandra.repository.support.BasicMapId;
import org.springframework.data.mapping.PropertyHandler;

public class CassandraEntityPersister
extends NativeEntryEntityPersister<EntityAccess, Object> {
    private static Logger LOG = LoggerFactory.getLogger(CassandraEntityPersister.class);
    private CassandraPersistentEntity<?> springCassandraPersistentEntity;
    private CassandraTemplate cassandraTemplate = this.getCassandraTemplate();
    private ConversionService conversionService;

    public CassandraEntityPersister(MappingContext context, PersistentEntity entity, CassandraSession cassandraSession, ApplicationEventPublisher applicationEventPublisher) {
        super(context, entity, (org.grails.datastore.mapping.core.Session)cassandraSession, applicationEventPublisher);
        this.springCassandraPersistentEntity = this.cassandraTemplate.getCassandraMappingContext().getExistingPersistentEntity(entity.getJavaClass());
        this.conversionService = context.getConversionService();
    }

    protected CassandraTemplate getCassandraTemplate() {
        return this.getCassandraSession().getCassandraTemplate();
    }

    protected CassandraSession getCassandraSession() {
        return (CassandraSession)this.getSession();
    }

    public String getEntityFamily() {
        String table = this.getPersistentEntity().getDecapitalizedName();
        if (table == null) {
            table = this.getPersistentEntity().getJavaClass().getSimpleName();
        }
        return table;
    }

    protected boolean doesRequirePropertyIndexing() {
        return false;
    }

    protected EntityAccess createEntityAccess(PersistentEntity persistentEntity, Object obj) {
        return new CassandraEntityAccess(persistentEntity, obj);
    }

    protected EntityAccess createEntityAccess(PersistentEntity persistentEntity, Object obj, EntityAccess nativeEntry) {
        CassandraEntityAccess ea = new CassandraEntityAccess(persistentEntity, obj);
        ea.setNativeEntry(nativeEntry);
        return ea;
    }

    protected EntityAccess createNewEntry(String family) {
        return new CassandraEntityAccess(this.getPersistentEntity(), this.getPersistentEntity().newInstance());
    }

    protected EntityAccess createNewEntry(String family, Object instance) {
        return this.createEntityAccess(this.getPersistentEntity(), instance);
    }

    protected Object readObjectIdentifier(EntityAccess entityAccess, ClassMapping cm) {
        Table table = (Table)cm.getMappedForm();
        if (table.hasCompositePrimaryKeys()) {
            HashMap<String, Object> identifier = new HashMap<String, Object>();
            for (Column column : table.getPrimaryKeys()) {
                String name = column.getName();
                identifier.put(name, entityAccess.getProperty(name));
            }
            return identifier;
        }
        return entityAccess.getIdentifier();
    }

    protected Object readIdentifierFromObject(Object object) {
        EntityAccess entityAccess = this.createEntityAccess(this.getPersistentEntity(), object);
        return this.readObjectIdentifier(entityAccess, this.getPersistentEntity().getMapping());
    }

    public Serializable getObjectIdentifier(Object object) {
        if (object == null) {
            return null;
        }
        ProxyFactory pf = this.getProxyFactory();
        if (pf.isProxy(object)) {
            return pf.getIdentifier(object);
        }
        return (Serializable)this.readIdentifierFromObject(object);
    }

    public Object convertObject(PersistentEntity persistentEntity, Serializable nativeKey, Object object) {
        return this.createObjectFromNativeEntry(persistentEntity, nativeKey, this.createEntityAccess(persistentEntity, object));
    }

    public Object createObjectFromNativeEntry(PersistentEntity persistentEntity, Serializable nativeKey, EntityAccess nativeEntry) {
        persistentEntity = this.discriminatePersistentEntity(persistentEntity, nativeEntry);
        this.cacheNativeEntry(persistentEntity, nativeKey, nativeEntry);
        Object obj = nativeEntry.getEntity();
        this.refreshObjectStateFromNativeEntry(persistentEntity, obj, nativeKey, nativeEntry, false);
        return obj;
    }

    protected Object getEntryValue(EntityAccess nativeEntry, String property) {
        return nativeEntry.getProperty(property);
    }

    protected void setEntryValue(EntityAccess nativeEntry, String key, Object value) {
        nativeEntry.setProperty(key, value);
    }

    protected EntityAccess retrieveEntry(PersistentEntity persistentEntity, String family, Serializable nativeKey) {
        Map<String, Serializable> idMap = this.createIdMap(nativeKey, false);
        Object entity = this.cassandraTemplate.selectOneById(persistentEntity.getJavaClass(), idMap);
        return entity == null ? null : new CassandraEntityAccess(persistentEntity, entity);
    }

    protected Object storeEntry(PersistentEntity persistentEntity, EntityAccess entityAccess, Object storeId, EntityAccess entry) {
        Object entity = entityAccess.getEntity();
        WriteOptions writeOptions = this.getWriteOptions(entity);
        this.cassandraTemplate.insert(entity, writeOptions);
        return storeId;
    }

    protected void updateEntry(PersistentEntity persistentEntity, EntityAccess entityAccess, Object key, EntityAccess entry) {
        this.updateEntry(persistentEntity, entityAccess, key, entry, false);
    }

    protected void updateEntry(final PersistentEntity persistentEntity, final EntityAccess entityAccess, final Object key, EntityAccess entry, final boolean simpleTypesOnly) {
        Object entity = entityAccess.getEntity();
        WriteOptions writeOptions = this.getWriteOptions(entity);
        final Update update = this.createUpdate();
        final boolean versioned = this.isVersioned(entityAccess);
        if (versioned) {
            Object currentVersion = this.getCurrentVersion(entityAccess);
            this.incrementVersion(entityAccess);
            if (currentVersion != null) {
                update.onlyIf(QueryBuilder.eq((String)"version", (Object)currentVersion));
            }
        }
        this.springCassandraPersistentEntity.doWithProperties((PropertyHandler)new PropertyHandler<CassandraPersistentProperty>(){

            public void doWithPersistentProperty(CassandraPersistentProperty prop) {
                Object value = entityAccess.getProperty(prop.getName());
                if ((value = CassandraEntityPersister.convertPrimitiveToNative(value, prop, CassandraEntityPersister.this.conversionService)) != null) {
                    if (prop.isIdProperty() || prop.isPrimaryKeyColumn()) {
                        update.where(QueryBuilder.eq((String)prop.getColumnName().toCql(), (Object)value));
                    } else if (!simpleTypesOnly || !prop.isCollectionLike() && !prop.isMap()) {
                        update.with(QueryBuilder.set((String)prop.getColumnName().toCql(), (Object)value));
                    }
                }
            }
        });
        CqlTemplate.addWriteOptions((Update)update, (WriteOptions)writeOptions);
        this.cassandraTemplate.execute((SessionCallback)new SessionCallback<Object>(){

            public Object doInSession(Session s) throws DataAccessException {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("executing [{}]", (Object)update.toString());
                }
                ResultSet resultSet = s.execute((Statement)update);
                if (versioned) {
                    Row row = resultSet.one();
                    if (row != null && row.getBool("[applied]")) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Successfully modified entry [{}] to version [{}] ", key, CassandraEntityPersister.this.getCurrentVersion(entityAccess));
                        }
                    } else {
                        throw new OptimisticLockingException(persistentEntity, key);
                    }
                }
                return null;
            }
        });
    }

    protected Object getCurrentVersion(EntityAccess ea) {
        Object currentVersion = ea.getProperty("version");
        if (Number.class.isAssignableFrom(ea.getPropertyType("version"))) {
            currentVersion = currentVersion != null ? Long.valueOf(((Number)currentVersion).longValue()) : currentVersion;
        }
        return currentVersion;
    }

    protected void deleteEntries(String family, List<Object> keys) {
        for (Object key : keys) {
            if (!(key instanceof Map)) {
                key = BasicMapId.id((String)this.getPersistentEntity().getIdentity().getName(), (Serializable)((Serializable)key));
            }
            this.cassandraTemplate.deleteById(this.getPersistentEntity().getJavaClass(), key);
        }
    }

    protected void deleteEntry(String family, Object key, Object entry) {
        this.cassandraTemplate.delete(entry);
    }

    protected Object generateIdentifier(PersistentEntity persistentEntity, EntityAccess entityAccess) {
        Object identifier = entityAccess.getIdentifier();
        if (identifier != null) {
            return identifier;
        }
        UUID id = null;
        Column idColumn = (Column)persistentEntity.getIdentity().getMapping().getMappedForm();
        id = idColumn != null && "timeuuid".equals(idColumn.getType()) ? UUIDUtil.getRandomTimeUUID() : UUIDUtil.getRandomUUID();
        if (UUID.class.isAssignableFrom(persistentEntity.getIdentity().getType())) {
            entityAccess.setIdentifier((Object)id);
            return id;
        }
        String stringId = id.toString();
        entityAccess.setIdentifier((Object)stringId);
        return stringId;
    }

    protected Map<String, Serializable> createIdMap(Serializable nativeKey, boolean withColumnName) {
        MapId idMap = new HashMap();
        if (!(nativeKey instanceof Map)) {
            String name = this.getPersistentEntity().getIdentity().getName();
            CassandraPersistentProperty cassandraPersistentProperty = (CassandraPersistentProperty)this.springCassandraPersistentEntity.getPersistentProperty(name);
            if (cassandraPersistentProperty == null) {
                CassandraEntityPersister.throwUnknownPrimaryKeyException(name, this.springCassandraPersistentEntity.getName());
            }
            idMap = BasicMapId.id((String)(withColumnName ? cassandraPersistentProperty.getColumnName().toCql() : name), (Serializable)((Serializable)CassandraEntityPersister.convertPrimitiveToNative(nativeKey, cassandraPersistentProperty, this.conversionService)));
        } else {
            for (Map.Entry entry : ((Map)((Object)nativeKey)).entrySet()) {
                String name = (String)entry.getKey();
                CassandraPersistentProperty cassandraPersistentProperty = (CassandraPersistentProperty)this.springCassandraPersistentEntity.getPersistentProperty(name);
                if (cassandraPersistentProperty == null || !cassandraPersistentProperty.isPrimaryKeyColumn()) {
                    CassandraEntityPersister.throwUnknownPrimaryKeyException(name, this.springCassandraPersistentEntity.getName());
                }
                idMap.put(withColumnName ? cassandraPersistentProperty.getColumnName().toCql() : name, (Serializable)CassandraEntityPersister.convertPrimitiveToNative(entry.getValue(), cassandraPersistentProperty, this.conversionService));
            }
        }
        return idMap;
    }

    protected WriteOptions getWriteOptions(Object entity) {
        return this.getCassandraSession().getCassandraDatastore().getWriteOptions(entity);
    }

    protected String getTableName() {
        return this.cassandraTemplate.getTableName(this.getPersistentEntity().getJavaClass()).toCql();
    }

    protected Update createUpdate() {
        return QueryBuilder.update((String)this.getTableName());
    }

    protected Update prepareUpdate(Serializable id, Update update, WriteOptions writeOptions) {
        Map<String, Serializable> idMap = this.createIdMap(id, true);
        for (Map.Entry<String, Serializable> entry : idMap.entrySet()) {
            update.where(QueryBuilder.eq((String)entry.getKey(), (Object)entry.getValue()));
        }
        CqlTemplate.addWriteOptions((Update)update, (WriteOptions)writeOptions);
        return update;
    }

    protected void addPendingUpdate(Serializable id, Statement statement) {
        if (id != null && statement != null) {
            CassandraPendingUpdateAdapter pendingUpdate = new CassandraPendingUpdateAdapter(this.getPersistentEntity(), id, statement, this.cassandraTemplate);
            ((SessionImplementor)this.session).addPendingUpdate(pendingUpdate);
        }
    }

    protected Delete prepareDelete(Serializable id, Delete delete) {
        Map<String, Serializable> idMap = this.createIdMap(id, true);
        for (Map.Entry<String, Serializable> entry : idMap.entrySet()) {
            delete.where(QueryBuilder.eq((String)entry.getKey(), (Object)entry.getValue()));
        }
        return delete;
    }

    public void setObjectIdentifier(Object obj, Serializable id) {
        new CassandraEntityAccess(this.getPersistentEntity(), obj).setIdentifier(id);
    }

    public Query createQuery() {
        return new CassandraQuery(this.getCassandraSession(), this.getPersistentEntity());
    }

    public PropertyValueIndexer getPropertyIndexer(PersistentProperty property) {
        return null;
    }

    public AssociationIndexer getAssociationIndexer(EntityAccess nativeEntry, Association association) {
        return null;
    }

    public Object update(Object obj) {
        return this.update(obj, false);
    }

    public Object updateSingleTypes(Object obj) {
        return this.update(obj, true);
    }

    public Object update(Object obj, final boolean simpleTypesOnly) {
        final PersistentEntity persistentEntity = this.getPersistentEntity();
        final EntityAccess entityAccess = this.createEntityAccess(persistentEntity, obj);
        Object key = this.readIdentifierFromObject(obj);
        PendingUpdateAdapter<EntityAccess, Object> pendingUpdate = new PendingUpdateAdapter<EntityAccess, Object>(persistentEntity, key, entityAccess, entityAccess){

            public void run() {
                CassandraEntityPersister.this.updateEntry(this.entity, this.getEntityAccess(), this.getNativeKey(), (EntityAccess)this.getNativeEntry(), simpleTypesOnly);
                CassandraEntityPersister.this.firePostUpdateEvent(persistentEntity, entityAccess);
            }
        };
        ((SessionImplementor)this.session).addPendingUpdate((PendingUpdate)pendingUpdate);
        return key;
    }

    public void updateProperty(Serializable id, String propertyName, Object item, WriteOptions writeOptions) {
        Statement statement = this.prepareUpdateProperty(id, propertyName, item, writeOptions);
        this.addPendingUpdate(id, statement);
    }

    public Statement prepareUpdateProperty(Serializable id, String propertyName, Object item, WriteOptions writeOptions) {
        Update update = this.createUpdate();
        CassandraPersistentProperty persistentProperty = CassandraEntityPersister.getPersistentProperty(this.springCassandraPersistentEntity, propertyName);
        String columnName = CassandraEntityPersister.getPropertyName(persistentProperty);
        item = CassandraEntityPersister.convertPrimitiveToNative(item, persistentProperty, this.conversionService);
        update.with(QueryBuilder.set((String)columnName, (Object)item));
        return this.prepareUpdate(id, update, writeOptions);
    }

    public void updateProperties(Serializable id, Map<String, Object> properties, WriteOptions writeOptions) {
        Statement statement = this.prepareUpdateProperties(id, properties, writeOptions);
        this.addPendingUpdate(id, statement);
    }

    public Statement prepareUpdateProperties(Serializable id, Map<String, Object> properties, WriteOptions writeOptions) {
        Update update = this.createUpdate();
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            CassandraPersistentProperty persistentProperty = CassandraEntityPersister.getPersistentProperty(this.springCassandraPersistentEntity, property.getKey());
            String columnName = CassandraEntityPersister.getPropertyName(persistentProperty);
            Object item = CassandraEntityPersister.convertPrimitiveToNative(property.getValue(), persistentProperty, this.conversionService);
            update.with(QueryBuilder.set((String)columnName, (Object)item));
        }
        return this.prepareUpdate(id, update, writeOptions);
    }

    public void append(Object obj, String propertyName, Object element, WriteOptions writeOptions) {
        Serializable id = (Serializable)this.readIdentifierFromObject(obj);
        this.append(id, propertyName, element, writeOptions);
    }

    public void append(Serializable id, String propertyName, Object element, WriteOptions writeOptions) {
        Statement statement = this.prepareAppend(id, propertyName, element, writeOptions);
        this.addPendingUpdate(id, statement);
    }

    public Statement prepareAppend(Serializable id, String propertyName, Object element, WriteOptions writeOptions) {
        Map map;
        Update update = this.createUpdate();
        CassandraPersistentProperty persistentProperty = CassandraEntityPersister.getPersistentProperty(this.springCassandraPersistentEntity, propertyName);
        String columnName = CassandraEntityPersister.getPropertyName(persistentProperty);
        Class type = persistentProperty.getType();
        if (Set.class.isAssignableFrom(type)) {
            if (element instanceof Set) {
                Set set = (Set)element;
                if (set.size() > 0) {
                    update.with(QueryBuilder.addAll((String)columnName, (Set)set));
                }
            } else {
                update.with(QueryBuilder.add((String)columnName, (Object)element));
            }
        } else if (List.class.isAssignableFrom(type)) {
            if (element instanceof List) {
                List list = (List)element;
                if (list.size() > 0) {
                    update.with(QueryBuilder.appendAll((String)columnName, (List)list));
                }
            } else {
                update.with(QueryBuilder.append((String)columnName, (Object)element));
            }
        } else if (Map.class.isAssignableFrom(type) && element instanceof Map && (map = (Map)element).size() > 0) {
            update.with(QueryBuilder.putAll((String)columnName, (Map)map));
        }
        return this.prepareUpdate(id, update, writeOptions);
    }

    public void prepend(Object obj, String propertyName, Object element, WriteOptions writeOptions) {
        Serializable id = (Serializable)this.readIdentifierFromObject(obj);
        this.prepend(id, propertyName, element, writeOptions);
    }

    public void prepend(Serializable id, String propertyName, Object element, WriteOptions writeOptions) {
        Statement statement = this.preparePrepend(id, propertyName, element, writeOptions);
        this.addPendingUpdate(id, statement);
    }

    public Statement preparePrepend(Serializable id, String propertyName, Object element, WriteOptions writeOptions) {
        Update update = this.createUpdate();
        CassandraPersistentProperty persistentProperty = CassandraEntityPersister.getPersistentProperty(this.springCassandraPersistentEntity, propertyName);
        String columnName = CassandraEntityPersister.getPropertyName(persistentProperty);
        if (List.class.isAssignableFrom(persistentProperty.getType())) {
            if (element instanceof List) {
                List list = (List)element;
                if (list.size() > 0) {
                    update.with(QueryBuilder.prependAll((String)columnName, (List)list));
                }
            } else {
                update.with(QueryBuilder.prepend((String)columnName, (Object)element));
            }
        }
        return this.prepareUpdate(id, update, writeOptions);
    }

    public void replaceAt(Object obj, String propertyName, int index, Object element, WriteOptions writeOptions) {
        Serializable id = (Serializable)this.readIdentifierFromObject(obj);
        this.replaceAt(id, propertyName, index, element, writeOptions);
    }

    public void replaceAt(Serializable id, String propertyName, int index, Object element, WriteOptions writeOptions) {
        Statement statement = this.prepareReplaceAt(id, propertyName, index, element, writeOptions);
        this.addPendingUpdate(id, statement);
    }

    public Statement prepareReplaceAt(Serializable id, String propertyName, int index, Object element, WriteOptions writeOptions) {
        Update update = this.createUpdate();
        CassandraPersistentProperty persistentProperty = CassandraEntityPersister.getPersistentProperty(this.springCassandraPersistentEntity, propertyName);
        String columnName = CassandraEntityPersister.getPropertyName(persistentProperty);
        if (List.class.isAssignableFrom(persistentProperty.getType())) {
            update.with(QueryBuilder.setIdx((String)columnName, (int)index, (Object)element));
        }
        return this.prepareUpdate(id, update, writeOptions);
    }

    public void deleteFrom(Object obj, String propertyName, Object item, boolean isIndex, WriteOptions writeOptions) {
        Serializable id = (Serializable)this.readIdentifierFromObject(obj);
        this.deleteFrom(id, propertyName, item, isIndex, writeOptions);
    }

    public void deleteFrom(Serializable id, String propertyName, Object item, boolean isIndex, WriteOptions writeOptions) {
        Statement statement = this.prepareDeleteFrom(id, propertyName, item, isIndex, writeOptions);
        this.addPendingUpdate(id, statement);
    }

    public Statement prepareDeleteFrom(Serializable id, String propertyName, Object item, boolean isIndex, WriteOptions writeOptions) {
        Update update = null;
        Delete delete = null;
        CassandraPersistentProperty persistentProperty = CassandraEntityPersister.getPersistentProperty(this.springCassandraPersistentEntity, propertyName);
        String columnName = CassandraEntityPersister.getPropertyName(persistentProperty);
        Class type = persistentProperty.getType();
        if (isIndex) {
            if (List.class.isAssignableFrom(type)) {
                delete = QueryBuilder.delete().listElt(columnName, ((Integer)item).intValue()).from(this.getTableName());
            }
        } else if (Set.class.isAssignableFrom(type)) {
            update = this.createUpdate();
            if (item instanceof Set) {
                Set set = (Set)item;
                if (set.size() > 0) {
                    update.with(QueryBuilder.removeAll((String)columnName, (Set)set));
                }
            } else {
                update.with(QueryBuilder.remove((String)columnName, (Object)item));
            }
        } else if (List.class.isAssignableFrom(type)) {
            update = this.createUpdate();
            if (item instanceof List) {
                List list = (List)item;
                if (list.size() > 0) {
                    update.with(QueryBuilder.discardAll((String)columnName, (List)list));
                }
            } else {
                update.with(QueryBuilder.discard((String)columnName, (Object)item));
            }
        } else if (Map.class.isAssignableFrom(type)) {
            delete = QueryBuilder.delete().mapElt(columnName, item).from(this.getTableName());
        }
        if (update != null) {
            return this.prepareUpdate(id, update, writeOptions);
        }
        if (delete != null) {
            return this.prepareDelete(id, delete);
        }
        return null;
    }

    public static Object convertPrimitiveToNative(Object item, CassandraPersistentProperty cassandraPersistentProperty, ConversionService conversionService) {
        Object nativeValue = item;
        if (item != null) {
            TypeDescriptor targetTypeDescriptor;
            TypeDescriptor itemTypeDescriptor = TypeDescriptor.forObject((Object)item);
            Class itemTypeClass = itemTypeDescriptor.getObjectType();
            if (Enum.class.isAssignableFrom(itemTypeClass) && conversionService.canConvert(itemTypeDescriptor, TypeDescriptor.valueOf(String.class))) {
                nativeValue = conversionService.convert(item, String.class);
            } else if (Currency.class.isAssignableFrom(itemTypeClass) || Locale.class.isAssignableFrom(itemTypeClass) || TimeZone.class.isAssignableFrom(itemTypeClass) || URL.class.isAssignableFrom(itemTypeClass)) {
                nativeValue = conversionService.convert(item, String.class);
            } else if (cassandraPersistentProperty != null && !cassandraPersistentProperty.getType().isAssignableFrom(itemTypeClass) && conversionService.canConvert(itemTypeDescriptor, targetTypeDescriptor = TypeDescriptor.valueOf((Class)cassandraPersistentProperty.getType()))) {
                try {
                    nativeValue = conversionService.convert(item, itemTypeDescriptor, targetTypeDescriptor);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(String.format("Failed to convert property [%s] on entity class [%s]: [%s]", cassandraPersistentProperty.getName(), cassandraPersistentProperty.getOwner().getName(), e.getMessage()), e);
                }
            }
        }
        return nativeValue;
    }

    public static String getPropertyName(CassandraPersistentEntity<?> cassandraPersistentEntity, String propertyName) {
        CassandraPersistentProperty property = CassandraEntityPersister.getPersistentProperty(cassandraPersistentEntity, propertyName);
        return CassandraEntityPersister.getPropertyName(property);
    }

    public static String getPropertyName(CassandraPersistentProperty property) {
        return property.getColumnName().toCql();
    }

    public static CassandraPersistentProperty getPersistentProperty(CassandraPersistentEntity<?> cassandraPersistentEntity, String propertyName) {
        CassandraPersistentProperty property = (CassandraPersistentProperty)cassandraPersistentEntity.getPersistentProperty(propertyName);
        if (property == null) {
            throw new MissingPropertyException(propertyName, cassandraPersistentEntity.getType());
        }
        return property;
    }

    private static void throwUnknownPrimaryKeyException(String name, String entity) {
        throw new MissingPropertyException(String.format("No such primary key property: %s for entity class: %s", name, entity));
    }

    protected class CassandraEntityAccess
    extends NativeEntryEntityPersister.NativeEntryModifyingEntityAccess {
        public CassandraEntityAccess(PersistentEntity persistentEntity, Object entity) {
            super((NativeEntryEntityPersister)CassandraEntityPersister.this, persistentEntity, entity);
        }

        public void setIdentifier(Object id) {
            Table table = (Table)CassandraEntityPersister.this.classMapping.getMappedForm();
            if (table.hasCompositePrimaryKeys() && id instanceof Map) {
                Map idMap = (Map)id;
                for (String primaryKeyName : table.getPrimaryKeyNames()) {
                    Object value = idMap.get(primaryKeyName);
                    if (value == null) continue;
                    this.setProperty(primaryKeyName, value);
                }
            } else {
                super.setIdentifier(id);
            }
        }

        public void setProperty(String name, Object value) {
            Class type;
            Table table = (Table)CassandraEntityPersister.this.classMapping.getMappedForm();
            if (table.isPrimaryKey(name) && value instanceof Map) {
                value = ((Map)value).get(name);
            }
            if ((type = this.getPropertyType(name)).isEnum() || "version".equals(name)) {
                super.setProperty(name, value);
            } else {
                super.setPropertyNoConversion(name, value);
            }
        }
    }
}

