/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.cassandra.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.grails.datastore.mapping.cassandra.config.Column;
import org.grails.datastore.mapping.config.Entity;
import org.grails.datastore.mapping.query.Query;

public class Table
extends Entity {
    private String keyspace;
    private List<Column> columns = new ArrayList<Column>();
    private List<Column> primaryKeys = new ArrayList<Column>();
    private List<String> primaryKeyNames = new ArrayList<String>();
    private Query.Order sort;
    private Map<String, Object> tableProperties;

    public Table() {
    }

    public Table(String keyspace) {
        this.keyspace = keyspace;
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public void setKeyspace(String keyspace) {
        this.keyspace = keyspace;
    }

    public void addColumn(Column column) {
        this.columns.add(column);
        if (column.isPrimaryKey()) {
            this.primaryKeys.add(column);
            this.primaryKeyNames.add(column.getName());
        }
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public List<Column> getPrimaryKeys() {
        return this.primaryKeys;
    }

    public String[] getPrimaryKeyNames() {
        return this.primaryKeyNames.toArray(new String[0]);
    }

    public boolean hasCompositePrimaryKeys() {
        return this.primaryKeys.size() > 1;
    }

    public boolean isPrimaryKey(String name) {
        return this.primaryKeyNames.contains(name);
    }

    public Query.Order getSort() {
        return this.sort;
    }

    public void setSort(Object sort) {
        if (sort instanceof Query.Order) {
            this.sort = (Query.Order)sort;
        }
        if (sort instanceof Map) {
            Map m = (Map)sort;
            if (!m.isEmpty()) {
                Map.Entry entry = m.entrySet().iterator().next();
                Object key = entry.getKey();
                this.sort = "desc".equalsIgnoreCase(entry.getValue().toString()) ? Query.Order.desc((String)key.toString()) : Query.Order.asc((String)key.toString());
            }
        } else {
            this.sort = Query.Order.asc((String)sort.toString());
        }
    }

    public Map<String, Object> getTableProperties() {
        return this.tableProperties;
    }

    public void setTableProperties(Map<String, Object> tableProperties) {
        this.tableProperties = tableProperties;
    }
}

