/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.cassandra.config;

import groovy.lang.Closure;
import java.beans.PropertyDescriptor;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.grails.datastore.mapping.cassandra.config.CassandraPersistentEntity;
import org.grails.datastore.mapping.cassandra.config.Column;
import org.grails.datastore.mapping.cassandra.config.MapConfigurationBuilder;
import org.grails.datastore.mapping.cassandra.config.Table;
import org.grails.datastore.mapping.config.AbstractGormMappingFactory;
import org.grails.datastore.mapping.config.Property;
import org.grails.datastore.mapping.model.ClassMapping;
import org.grails.datastore.mapping.model.IdentityMapping;
import org.grails.datastore.mapping.model.IllegalMappingException;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.PropertyMapping;
import org.grails.datastore.mapping.model.types.Identity;
import org.grails.datastore.mapping.reflect.ClassPropertyFetcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GormCassandraMappingFactory
extends AbstractGormMappingFactory<Table, Column> {
    private static final String TABLE_PROPERTIES = "tableProperties";
    private static Logger log = LoggerFactory.getLogger(GormCassandraMappingFactory.class);
    private String keyspace;

    public GormCassandraMappingFactory(String keyspace) {
        this.keyspace = keyspace;
    }

    public Table createMappedForm(PersistentEntity entity) {
        Map properties;
        Object version;
        Table table = (Table)super.createMappedForm(entity);
        CassandraPersistentEntity cassandraPersistentEntity = (CassandraPersistentEntity)entity;
        ClassPropertyFetcher cpf = ClassPropertyFetcher.forClass((Class)entity.getJavaClass());
        Closure value = (Closure)cpf.getStaticPropertyValue(TABLE_PROPERTIES, Closure.class);
        if (value != null) {
            MapConfigurationBuilder builder = new MapConfigurationBuilder();
            try {
                builder.evaluate(value);
            }
            catch (Exception e) {
                throw new IllegalMappingException(String.format("Error reading %s : %s", TABLE_PROPERTIES, e.toString()));
            }
            table.setTableProperties(builder.getProperties());
        }
        if (table.getKeyspace() == null) {
            table.setKeyspace(this.keyspace);
        }
        if ((version = (properties = (Map)this.entityToPropertyMap.get(entity)).get("VERSION_KEY")) instanceof Boolean) {
            cassandraPersistentEntity.setVersion((Boolean)version);
        }
        Column idProperty = (Column)((Object)properties.get("id"));
        Iterator propertyIterator = properties.entrySet().iterator();
        while (propertyIterator.hasNext()) {
            Map.Entry entry = propertyIterator.next();
            if (!(entry.getValue() instanceof Column)) continue;
            String name = (String)entry.getKey();
            Column column = (Column)((Object)entry.getValue());
            if (idProperty != null && idProperty.getName() != null && idProperty.getName().equals(name)) {
                propertyIterator.remove();
                continue;
            }
            if (column.getName() == null) {
                column.setName(name);
            }
            table.addColumn(column);
        }
        return table;
    }

    protected Class<Table> getEntityMappedFormType() {
        return Table.class;
    }

    protected Class<Column> getPropertyMappedFormType() {
        return Column.class;
    }

    protected IdentityMapping getIdentityMappedForm(final ClassMapping classMapping, final Column property) {
        String name;
        if (property != null && (name = property.getName()) != null) {
            return new IdentityMapping(){

                public String[] getIdentifierName() {
                    return new String[]{name};
                }

                public ClassMapping getClassMapping() {
                    return classMapping;
                }

                public Property getMappedForm() {
                    return property;
                }
            };
        }
        return super.getIdentityMappedForm(classMapping, (Property)property);
    }

    public Identity<Column> createIdentity(PersistentEntity owner, MappingContext context, PropertyDescriptor pd) {
        Table table = (Table)owner.getMapping().getMappedForm();
        if (table.hasCompositePrimaryKeys()) {
            return new Identity<Column>(owner, context, table.getPrimaryKeyNames()[0], Map.class){
                PropertyMapping<Column> propertyMapping;
                {
                    this.propertyMapping = GormCassandraMappingFactory.this.createPropertyMapping((PersistentProperty)this, this.owner);
                }

                public PropertyMapping<Column> getMapping() {
                    return this.propertyMapping;
                }
            };
        }
        return super.createIdentity(owner, context, pd);
    }

    public boolean isSimpleType(Class propType) {
        return GormCassandraMappingFactory.isCassandraNativeType(propType) || super.isSimpleType(propType);
    }

    public static boolean isCassandraNativeType(Class clazz) {
        return UUID.class.getName().equals(clazz.getName());
    }
}

