/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.cassandra;

import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TableMetadata;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.grails.datastore.mapping.cassandra.config.Column;
import org.grails.datastore.mapping.cassandra.config.Table;
import org.grails.datastore.mapping.cassandra.utils.EnumUtil;
import org.grails.datastore.mapping.core.EntityCreationException;
import org.grails.datastore.mapping.model.IllegalMappingException;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cassandra.core.SessionCallback;
import org.springframework.cassandra.core.cql.CqlIdentifier;
import org.springframework.cassandra.core.cql.generator.CreateIndexCqlGenerator;
import org.springframework.cassandra.core.cql.generator.CreateTableCqlGenerator;
import org.springframework.cassandra.core.keyspace.ColumnSpecification;
import org.springframework.cassandra.core.keyspace.CreateIndexSpecification;
import org.springframework.cassandra.core.keyspace.CreateTableSpecification;
import org.springframework.cassandra.core.keyspace.TableOption;
import org.springframework.dao.DataAccessException;
import org.springframework.data.cassandra.config.CassandraSessionFactoryBean;
import org.springframework.data.cassandra.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.mapping.CassandraPersistentProperty;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.util.Assert;

public class GormCassandraSessionFactoryBean
extends CassandraSessionFactoryBean {
    private static Logger log = LoggerFactory.getLogger(GormCassandraSessionFactoryBean.class);
    private static final String COMPACT_STORAGE = "compact_storage";
    protected MappingContext gormMappingContext;
    protected CassandraMappingContext springCassandraMappingContext;
    private static List<String> allowableTableOptions;

    public GormCassandraSessionFactoryBean(MappingContext mappingContext, CassandraMappingContext springCassandraMappingContext) {
        this.gormMappingContext = mappingContext;
        this.springCassandraMappingContext = springCassandraMappingContext;
        allowableTableOptions = EnumUtil.getValidEnumList(TableOption.class);
        allowableTableOptions.add(COMPACT_STORAGE);
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        this.performIndexAction();
    }

    public void createTable(Class<?> cls) {
        Assert.notNull(cls);
        CassandraPersistentEntity cassandraPersistentEntity = (CassandraPersistentEntity)this.springCassandraMappingContext.getPersistentEntity(cls);
        if (cassandraPersistentEntity == null) {
            throw new EntityCreationException(String.format("Class [%s] not found in mapping context", cls.getName()));
        }
        this.createTable(cassandraPersistentEntity);
        this.createIndex(cassandraPersistentEntity);
    }

    protected void createTables(boolean dropTables, boolean dropUnused) {
        Metadata md = this.session.getCluster().getMetadata();
        KeyspaceMetadata kmd = md.getKeyspace(this.keyspaceName);
        if (kmd == null) {
            kmd = md.getKeyspace(this.keyspaceName.toLowerCase());
        }
        if (kmd == null) {
            throw new IllegalStateException(String.format("keyspace [%s] does not exist", this.keyspaceName));
        }
        for (TableMetadata table : kmd.getTables()) {
            if (!dropTables || !dropUnused && !this.mappingContext.usesTable(table)) continue;
            this.admin.dropTable(CqlIdentifier.cqlId((CharSequence)table.getName()));
        }
        Collection entities = this.converter.getMappingContext().getNonPrimaryKeyEntities();
        for (CreateTableSpecification createTableSpecification : this.createTableSpecifications(entities)) {
            this.createTable(createTableSpecification);
        }
    }

    protected void createTable(CassandraPersistentEntity<?> cassandraPersistentEntity) {
        this.createTable(this.createTableSpecification(cassandraPersistentEntity));
    }

    protected void createTable(final CreateTableSpecification createTableSpecification) {
        this.admin.execute((SessionCallback)new SessionCallback<Object>(){

            public Object doInSession(Session s) throws DataAccessException {
                String cql = new CreateTableCqlGenerator(createTableSpecification).toCql();
                log.debug(String.format("executing [%s]", cql));
                try {
                    s.execute(cql);
                }
                catch (Exception e) {
                    throw new EntityCreationException(String.format("Failed to create table [%s]", createTableSpecification.getName()), (Throwable)e);
                }
                return null;
            }
        });
    }

    protected List<CreateTableSpecification> createTableSpecifications(Collection<? extends CassandraPersistentEntity<?>> entities) {
        ArrayList<CreateTableSpecification> createTableSpecifications = new ArrayList<CreateTableSpecification>();
        for (CassandraPersistentEntity<?> entity : entities) {
            CreateTableSpecification createTableSpecification = this.createTableSpecification(entity);
            createTableSpecifications.add(createTableSpecification);
        }
        return createTableSpecifications;
    }

    protected CreateTableSpecification createTableSpecification(CassandraPersistentEntity<?> entity) {
        PersistentEntity gormEntity = this.gormMappingContext.getPersistentEntity(entity.getName());
        Table table = (Table)gormEntity.getMapping().getMappedForm();
        CreateTableSpecification createTableSpecification = this.springCassandraMappingContext.getCreateTableSpecificationFor(entity);
        block0: for (Column column : table.getColumns()) {
            if (column.getOrder() == null) continue;
            CassandraPersistentProperty persistentProperty = (CassandraPersistentProperty)entity.getPersistentProperty(column.getName());
            if (persistentProperty == null || !column.isClusterKey()) {
                throw new IllegalMappingException(String.format("Invalid mapping for property [%s]. [order] attribute can only be set for a clustered primary key", column.getName()));
            }
            CqlIdentifier clusteringKeyName = persistentProperty.getColumnName();
            for (ColumnSpecification clusterKeyColumn : createTableSpecification.getClusteredKeyColumns()) {
                if (!clusterKeyColumn.getName().equals((Object)clusteringKeyName)) continue;
                clusterKeyColumn.clustered(column.getOrder());
                continue block0;
            }
        }
        Map<String, Object> gormTableProperties = table.getTableProperties();
        if (gormTableProperties != null) {
            if (gormTableProperties.remove(COMPACT_STORAGE) != null) {
                createTableSpecification.with(TableOption.COMPACT_STORAGE);
            }
            Map<TableOption, Object> tableOptions = this.convertToCassandraOptionEnumObjectMap(TableOption.class, gormTableProperties, "tableOptions");
            for (Map.Entry<TableOption, Object> tableOptionEntry : tableOptions.entrySet()) {
                Map tableOptionMap;
                Object value = tableOptionEntry.getValue();
                Map map = tableOptionMap = value instanceof Map ? (Map)value : null;
                if (TableOption.COMPACTION == tableOptionEntry.getKey()) {
                    Map<TableOption.CompactionOption, Object> compactionOptions = this.convertToCassandraOptionEnumObjectMap(TableOption.CompactionOption.class, tableOptionMap, "compaction options");
                    createTableSpecification.with(TableOption.COMPACTION, compactionOptions);
                    continue;
                }
                if (TableOption.COMPRESSION == tableOptionEntry.getKey()) {
                    Map<TableOption.CompressionOption, Object> compressionOptions = this.convertToCassandraOptionEnumObjectMap(TableOption.CompressionOption.class, tableOptionMap, "compression options");
                    createTableSpecification.with(TableOption.COMPRESSION, compressionOptions);
                    continue;
                }
                if (TableOption.CACHING == tableOptionEntry.getKey()) {
                    TableOption.CachingOption cachingOption = EnumUtil.getRequiredEnum(TableOption.CachingOption.class, "caching", String.valueOf(value));
                    createTableSpecification.with(TableOption.CACHING, (Object)cachingOption);
                    continue;
                }
                if (TableOption.COMPACT_STORAGE == tableOptionEntry.getKey()) {
                    createTableSpecification.with(TableOption.COMPACT_STORAGE);
                    continue;
                }
                createTableSpecification.with(tableOptionEntry.getKey(), value);
            }
        }
        return createTableSpecification;
    }

    protected <E extends Enum<E>> Map<E, Object> convertToCassandraOptionEnumObjectMap(Class<E> enumClass, Map<String, Object> stringObjectMap, String optionEnumTypeName) {
        if (stringObjectMap == null) {
            return null;
        }
        LinkedHashMap<E, Object> result = new LinkedHashMap<E, Object>();
        for (Map.Entry<String, Object> optionEntry : stringObjectMap.entrySet()) {
            E e = EnumUtil.findEnum(enumClass, optionEntry.getKey());
            if (e != null) {
                result.put(e, optionEntry.getValue());
                continue;
            }
            List<String> allowable = null;
            allowable = enumClass == TableOption.class ? allowableTableOptions : EnumUtil.getValidEnumList(enumClass);
            throw new IllegalMappingException(String.format("Invalid option [%s] for [%s], allowable values are %s", optionEntry.getKey(), optionEnumTypeName, allowable));
        }
        return result;
    }

    protected void performIndexAction() {
        switch (this.schemaAction) {
            case NONE: {
                return;
            }
            case RECREATE_DROP_UNUSED: 
            case RECREATE: 
            case CREATE: {
                this.createIndex();
            }
        }
    }

    protected void createIndex() {
        Collection entities = this.mappingContext.getNonPrimaryKeyEntities();
        for (CassandraPersistentEntity entity : entities) {
            this.createIndex(entity);
        }
    }

    protected void createIndex(final CassandraPersistentEntity<?> entity) {
        entity.doWithProperties((PropertyHandler)new PropertyHandler<CassandraPersistentProperty>(){

            public void doWithPersistentProperty(final CassandraPersistentProperty persistentProperty) {
                if (persistentProperty.isIndexed()) {
                    final CreateIndexSpecification createIndexSpecification = new CreateIndexSpecification();
                    createIndexSpecification.tableName(entity.getTableName()).columnName(persistentProperty.getColumnName()).ifNotExists();
                    GormCassandraSessionFactoryBean.this.admin.execute((SessionCallback)new SessionCallback<ResultSet>(){

                        public ResultSet doInSession(Session s) throws DataAccessException {
                            String cql = CreateIndexCqlGenerator.toCql((CreateIndexSpecification)createIndexSpecification);
                            log.debug(String.format("executing [%s]", cql));
                            try {
                                return s.execute(cql);
                            }
                            catch (Exception e) {
                                throw new EntityCreationException(String.format("Failed to create index for property [%s] in entity [%s]", persistentProperty.getName(), entity.getName()), (Throwable)e);
                            }
                        }
                    });
                }
            }
        });
    }

    public void destroy() throws Exception {
        this.executeScripts(this.shutdownScripts);
        if (this.session != null) {
            this.session.close();
        }
    }
}

