/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import groovy.util.ConfigObject;
import groovy.util.ConfigSlurper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.grails.datastore.gorm.cassandra.mapping.BasicCassandraMappingContext;
import org.grails.datastore.gorm.cassandra.mapping.MappingCassandraConverter;
import org.grails.datastore.gorm.cassandra.mapping.TimeZoneToStringConverter;
import org.grails.datastore.mapping.cassandra.CassandraSession;
import org.grails.datastore.mapping.cassandra.GormCassandraSessionFactoryBean;
import org.grails.datastore.mapping.cassandra.config.CassandraMappingContext;
import org.grails.datastore.mapping.cassandra.utils.EnumUtil;
import org.grails.datastore.mapping.core.AbstractDatastore;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.core.SoftThreadLocalMap;
import org.grails.datastore.mapping.model.DatastoreConfigurationException;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cassandra.config.CassandraCqlClusterFactoryBean;
import org.springframework.cassandra.config.KeyspaceAction;
import org.springframework.cassandra.config.KeyspaceActionSpecificationFactoryBean;
import org.springframework.cassandra.config.KeyspaceAttributes;
import org.springframework.cassandra.core.WriteOptions;
import org.springframework.cassandra.core.keyspace.KeyspaceActionSpecification;
import org.springframework.cassandra.core.keyspace.KeyspaceOption;
import org.springframework.cassandra.support.CassandraExceptionTranslator;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.cassandra.config.SchemaAction;
import org.springframework.data.cassandra.convert.CassandraConverter;
import org.springframework.data.cassandra.core.CassandraAdminTemplate;
import org.springframework.data.cassandra.core.CassandraTemplate;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;

public class CassandraDatastore
extends AbstractDatastore
implements InitializingBean,
DisposableBean,
MappingContext.Listener {
    private static Logger log = LoggerFactory.getLogger(CassandraDatastore.class);
    public static final String DEFAULT_KEYSPACE = "CassandraKeySpace";
    public static final SchemaAction DEFAULT_SCHEMA_ACTION = SchemaAction.NONE;
    public static final String CONTACT_POINTS = "contactPoints";
    public static final String PORT = "port";
    public static final String SCHEMA_ACTION = "dbCreate";
    public static final String KEYSPACE_CONFIG = "keyspace";
    public static final String KEYSPACE_NAME = "name";
    public static final String KEYSPACE_ACTION = "action";
    public static final String KEYSPACE_DURABLE_WRITES = "durableWrites";
    public static final String KEYSPACE_REPLICATION_FACTOR = "replicationFactor";
    public static final String KEYSPACE_REPLICATION_STRATEGY = "replicationStrategy";
    public static final String KEYSPACE_NETWORK_TOPOLOGY = "networkTopology";
    protected ConfigObject configuration = new ConfigObject();
    protected Cluster nativeCluster;
    protected Session nativeSession;
    protected BasicCassandraMappingContext springCassandraMappingContext;
    protected CassandraTemplate cassandraTemplate;
    protected CassandraAdminTemplate cassandraAdminTemplate;
    protected CassandraCqlClusterFactoryBean cassandraCqlClusterFactoryBean;
    protected KeyspaceActionSpecificationFactoryBean keyspaceActionSpecificationFactoryBean;
    protected GormCassandraSessionFactoryBean cassandraSessionFactoryBean;
    protected boolean stateless = false;
    protected String keyspace;
    private static final SoftThreadLocalMap PERSISTENCE_OPTIONS_MAP = new SoftThreadLocalMap();

    public CassandraDatastore() {
        this(new CassandraMappingContext(), Collections.emptyMap(), null);
    }

    public CassandraDatastore(Map<String, String> connectionDetails, ConfigurableApplicationContext ctx) {
        this(new CassandraMappingContext(), connectionDetails, ctx);
    }

    public CassandraDatastore(CassandraMappingContext mappingContext, Map<String, String> connectionDetails, ConfigurableApplicationContext ctx) {
        super((MappingContext)mappingContext, connectionDetails, ctx);
        if (connectionDetails instanceof ConfigObject) {
            this.configuration = (ConfigObject)connectionDetails;
        } else if (connectionDetails instanceof Properties) {
            this.configuration = new ConfigSlurper().parse((Properties)connectionDetails);
        } else if (connectionDetails != null) {
            for (Map.Entry<String, String> entry : connectionDetails.entrySet()) {
                this.configuration.put((Object)entry.getKey(), (Object)entry.getValue());
            }
        }
        this.keyspace = mappingContext.getKeyspace();
        Assert.hasText((String)this.keyspace, (String)"Keyspace must be set");
        this.springCassandraMappingContext = new BasicCassandraMappingContext(mappingContext);
        mappingContext.setSpringCassandraMappingContext(this.springCassandraMappingContext);
        if (mappingContext != null) {
            mappingContext.addMappingContextListener(this);
        }
        this.initializeConverters((MappingContext)mappingContext);
        log.debug("Initializing Cassandra Datastore for keyspace: " + this.keyspace);
    }

    protected void initializeConverters(MappingContext mappingContext) {
        super.initializeConverters(mappingContext);
        mappingContext.getConverterRegistry().addConverter((Converter)new TimeZoneToStringConverter());
    }

    public void setCassandraCqlClusterFactoryBean(CassandraCqlClusterFactoryBean cassandraCqlClusterFactoryBean) {
        this.cassandraCqlClusterFactoryBean = cassandraCqlClusterFactoryBean;
    }

    public void setKeyspaceActionSpecificationFactoryBean(KeyspaceActionSpecificationFactoryBean keyspaceActionSpecificationFactoryBean) {
        this.keyspaceActionSpecificationFactoryBean = keyspaceActionSpecificationFactoryBean;
    }

    public void setCassandraSessionFactoryBean(GormCassandraSessionFactoryBean cassandraSessionFactoryBean) {
        this.cassandraSessionFactoryBean = cassandraSessionFactoryBean;
    }

    public void afterPropertiesSet() throws Exception {
        this.createCluster();
        this.createNativeSession();
    }

    protected Cluster createCluster() throws Exception {
        if (this.nativeCluster == null) {
            if (this.cassandraCqlClusterFactoryBean == null) {
                this.cassandraCqlClusterFactoryBean = new CassandraCqlClusterFactoryBean();
            }
            this.cassandraCqlClusterFactoryBean.setContactPoints(this.read((Class)String.class, CONTACT_POINTS, (Map<?, ?>)this.configuration, (Object)"localhost"));
            this.cassandraCqlClusterFactoryBean.setPort(this.read((Class)Integer.class, PORT, (Map<?, ?>)this.configuration, 9042).intValue());
            Set<KeyspaceActionSpecification<?>> keyspaceSpecifications = this.createKeyspaceSpecifications();
            this.cassandraCqlClusterFactoryBean.setKeyspaceSpecifications(keyspaceSpecifications);
            this.cassandraCqlClusterFactoryBean.afterPropertiesSet();
            this.nativeCluster = this.cassandraCqlClusterFactoryBean.getObject();
            if (this.nativeCluster == null) {
                throw new DatastoreConfigurationException("Cassandra driver cluster not created");
            }
        }
        return this.nativeCluster;
    }

    protected Set<KeyspaceActionSpecification<?>> createKeyspaceSpecifications() {
        Map keyspaceConfiguration;
        KeyspaceAction keyspaceAction;
        Set specifications = Collections.emptySet();
        Object object = this.configuration.get((Object)KEYSPACE_CONFIG);
        if (object instanceof Map && (keyspaceAction = this.readKeyspaceAction(keyspaceConfiguration = (Map)object)) != null) {
            Map networkTopology;
            log.info("Set keyspace generation strategy to '" + keyspaceConfiguration.get(KEYSPACE_ACTION) + "'");
            if (this.keyspaceActionSpecificationFactoryBean == null) {
                this.keyspaceActionSpecificationFactoryBean = new KeyspaceActionSpecificationFactoryBean();
            }
            this.keyspaceActionSpecificationFactoryBean.setName(this.keyspace);
            this.keyspaceActionSpecificationFactoryBean.setAction(keyspaceAction);
            this.keyspaceActionSpecificationFactoryBean.setDurableWrites(this.read(Boolean.class, KEYSPACE_DURABLE_WRITES, keyspaceConfiguration, true).booleanValue());
            KeyspaceOption.ReplicationStrategy replicationStrategy = EnumUtil.findEnum(KeyspaceOption.ReplicationStrategy.class, KEYSPACE_REPLICATION_STRATEGY, keyspaceConfiguration, KeyspaceAttributes.DEFAULT_REPLICATION_STRATEGY);
            this.keyspaceActionSpecificationFactoryBean.setReplicationStrategy(replicationStrategy);
            if (replicationStrategy == KeyspaceOption.ReplicationStrategy.SIMPLE_STRATEGY) {
                this.keyspaceActionSpecificationFactoryBean.setReplicationFactor(this.read(Long.class, KEYSPACE_REPLICATION_FACTOR, keyspaceConfiguration, 1L).longValue());
            } else if (replicationStrategy == KeyspaceOption.ReplicationStrategy.NETWORK_TOPOLOGY_STRATEGY && (networkTopology = (Map)this.read(Map.class, KEYSPACE_NETWORK_TOPOLOGY, keyspaceConfiguration, null)) != null) {
                ArrayList<String> dataCenters = new ArrayList<String>();
                ArrayList<String> replicationFactors = new ArrayList<String>();
                Iterator i$ = networkTopology.entrySet().iterator();
                while (i$.hasNext()) {
                    Map.Entry o;
                    Map.Entry entry = o = i$.next();
                    dataCenters.add(String.valueOf(entry.getKey()));
                    replicationFactors.add(String.valueOf(entry.getValue()));
                }
                this.keyspaceActionSpecificationFactoryBean.setNetworkTopologyDataCenters(dataCenters);
                this.keyspaceActionSpecificationFactoryBean.setNetworkTopologyReplicationFactors(replicationFactors);
            }
            this.keyspaceActionSpecificationFactoryBean.setIfNotExists(true);
            try {
                this.keyspaceActionSpecificationFactoryBean.afterPropertiesSet();
                specifications = this.keyspaceActionSpecificationFactoryBean.getObject();
            }
            catch (Exception e) {
                throw new DatastoreConfigurationException(String.format("Failed to create keyspace [%s] ", this.keyspace), (Throwable)e);
            }
        }
        return specifications;
    }

    protected Session createNativeSession() throws ClassNotFoundException, Exception {
        if (this.nativeSession == null) {
            Assert.notNull((Object)this.nativeCluster, (String)"Cassandra driver cluster not created");
            if (this.cassandraSessionFactoryBean == null) {
                this.cassandraSessionFactoryBean = new GormCassandraSessionFactoryBean(this.mappingContext, (org.springframework.data.cassandra.mapping.CassandraMappingContext)this.springCassandraMappingContext);
            }
            this.cassandraSessionFactoryBean.setCluster(this.nativeCluster);
            this.cassandraSessionFactoryBean.setKeyspaceName(this.keyspace);
            MappingCassandraConverter mappingCassandraConverter = new MappingCassandraConverter(this.cassandraMapping());
            this.cassandraSessionFactoryBean.setConverter((CassandraConverter)mappingCassandraConverter);
            this.cassandraSessionFactoryBean.setSchemaAction(this.readSchemaAction());
            log.info("Set Cassandra db generation strategy to '" + (this.configuration.get((Object)SCHEMA_ACTION) != null ? this.configuration.get((Object)SCHEMA_ACTION) : "none") + "'");
            this.cassandraSessionFactoryBean.afterPropertiesSet();
            this.nativeSession = this.cassandraSessionFactoryBean.getObject();
            this.cassandraTemplate = new CassandraTemplate(this.nativeSession, (CassandraConverter)mappingCassandraConverter);
            this.cassandraTemplate.setExceptionTranslator(new CassandraExceptionTranslator());
            this.cassandraAdminTemplate = new CassandraAdminTemplate(this.nativeSession, (CassandraConverter)mappingCassandraConverter);
        }
        return this.nativeSession;
    }

    protected org.springframework.data.cassandra.mapping.CassandraMappingContext cassandraMapping() throws ClassNotFoundException {
        Collection persistentEntities = this.mappingContext.getPersistentEntities();
        HashSet<Class> entitySet = new HashSet<Class>();
        for (PersistentEntity persistentEntity : persistentEntities) {
            entitySet.add(persistentEntity.getJavaClass());
        }
        this.springCassandraMappingContext.setInitialEntitySet(entitySet);
        this.springCassandraMappingContext.afterPropertiesSet();
        return this.springCassandraMappingContext;
    }

    protected org.grails.datastore.mapping.core.Session createSession(Map<String, String> connectionDetails) {
        if (this.stateless) {
            return this.createStatelessSession(connectionDetails);
        }
        return new CassandraSession((Datastore)this, this.getMappingContext(), this.nativeSession, this.getApplicationEventPublisher(), false, this.cassandraTemplate);
    }

    protected org.grails.datastore.mapping.core.Session createStatelessSession(Map<String, String> connectionDetails) {
        return new CassandraSession((Datastore)this, this.getMappingContext(), this.nativeSession, this.getApplicationEventPublisher(), true, this.cassandraTemplate);
    }

    public void persistentEntityAdded(PersistentEntity entity) {
        this.springCassandraMappingContext.getPersistentEntity(entity.getJavaClass());
    }

    public Cluster getNativeCluster() {
        return this.nativeCluster;
    }

    public Session getNativeSession() {
        return this.nativeSession;
    }

    public CassandraTemplate getCassandraTemplate() {
        return this.cassandraTemplate;
    }

    public void createTableDefinition(Class<?> cls) {
        this.cassandraSessionFactoryBean.createTable(cls);
    }

    public void setWriteOptions(Object o, WriteOptions writeOptions) {
        if (o != null && writeOptions != null) {
            this.getPersistenceOptionsMap(o).put("writeOptions", writeOptions);
        }
    }

    public WriteOptions getWriteOptions(Object o) {
        return (WriteOptions)this.getPersistenceOptionsMap(o).get("writeOptions");
    }

    public void destroy() throws Exception {
        super.destroy();
        PERSISTENCE_OPTIONS_MAP.remove();
        if (this.cassandraSessionFactoryBean != null) {
            this.cassandraSessionFactoryBean.destroy();
        }
        if (this.cassandraCqlClusterFactoryBean != null) {
            this.cassandraCqlClusterFactoryBean.destroy();
        }
    }

    private <T> T read(Class<T> type, String key, Map<?, ?> config, T defaultValue) {
        Object value = config.get(key);
        return (T)(value == null ? defaultValue : this.mappingContext.getConversionService().convert(value, type));
    }

    private Map<String, Object> getPersistenceOptionsMap(Object o) {
        HashMap persistenceOptionsMap = (HashMap)((ConcurrentReferenceHashMap)PERSISTENCE_OPTIONS_MAP.get()).get((Object)System.identityHashCode(o));
        if (persistenceOptionsMap == null) {
            persistenceOptionsMap = new HashMap();
            ((ConcurrentReferenceHashMap)PERSISTENCE_OPTIONS_MAP.get()).put((Object)System.identityHashCode(o), persistenceOptionsMap);
        }
        return persistenceOptionsMap;
    }

    private KeyspaceAction readKeyspaceAction(Map keyspaceConfiguration) {
        HashMap<String, KeyspaceAction> keyspaceActionMap = new HashMap<String, KeyspaceAction>();
        keyspaceActionMap.put("create", KeyspaceAction.CREATE);
        keyspaceActionMap.put("create-drop", KeyspaceAction.CREATE_DROP);
        return EnumUtil.findMatchingEnum(KEYSPACE_ACTION, keyspaceConfiguration.get(KEYSPACE_ACTION), keyspaceActionMap, null);
    }

    private SchemaAction readSchemaAction() {
        HashMap<String, SchemaAction> schemaActionMap = new HashMap<String, SchemaAction>();
        schemaActionMap.put("none", SchemaAction.NONE);
        schemaActionMap.put("create", SchemaAction.CREATE);
        schemaActionMap.put("recreate", SchemaAction.RECREATE);
        schemaActionMap.put("recreate-drop-unused", SchemaAction.RECREATE_DROP_UNUSED);
        return EnumUtil.findMatchingEnum(SCHEMA_ACTION, this.configuration.get((Object)SCHEMA_ACTION), schemaActionMap, SchemaAction.NONE);
    }
}

