/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.cassandra.mapping;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Row;
import org.grails.datastore.gorm.cassandra.mapping.TimeZoneToStringConverter;
import org.grails.datastore.mapping.model.types.BasicTypeConverterRegistrar;
import org.grails.datastore.mapping.model.types.conversion.StringToCurrencyConverter;
import org.grails.datastore.mapping.model.types.conversion.StringToLocaleConverter;
import org.grails.datastore.mapping.model.types.conversion.StringToTimeZoneConverter;
import org.grails.datastore.mapping.model.types.conversion.StringToURLConverter;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.cassandra.convert.CassandraPersistentEntityParameterValueProvider;
import org.springframework.data.cassandra.convert.ColumnReader;
import org.springframework.data.cassandra.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.mapping.CassandraPersistentProperty;
import org.springframework.data.convert.EntityInstantiator;
import org.springframework.data.mapping.model.BeanWrapper;
import org.springframework.data.mapping.model.DefaultSpELExpressionEvaluator;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.PropertyValueProvider;
import org.springframework.data.mapping.model.SpELExpressionEvaluator;

public class MappingCassandraConverter
extends org.springframework.data.cassandra.convert.MappingCassandraConverter {
    public MappingCassandraConverter(CassandraMappingContext cassandraMapping) {
        super(cassandraMapping);
        DefaultConversionService conversionService = (DefaultConversionService)this.getConversionService();
        conversionService.addConverter((Converter)new StringToCurrencyConverter());
        conversionService.addConverter((Converter)new StringToLocaleConverter());
        conversionService.addConverter((Converter)new StringToTimeZoneConverter());
        conversionService.addConverter((Converter)new TimeZoneToStringConverter());
        conversionService.addConverter((Converter)new StringToURLConverter());
        BasicTypeConverterRegistrar registrar = new BasicTypeConverterRegistrar();
        registrar.register((ConverterRegistry)conversionService);
    }

    protected <S> S readEntityFromRow(CassandraPersistentEntity<S> entity, Row row) {
        DefaultSpELExpressionEvaluator evaluator = new DefaultSpELExpressionEvaluator((Object)row, this.spELContext);
        BasicCassandraRowValueProvider rowValueProvider = new BasicCassandraRowValueProvider(row, evaluator);
        CassandraPersistentEntityParameterValueProvider parameterProvider = new CassandraPersistentEntityParameterValueProvider(entity, (PropertyValueProvider)rowValueProvider, null);
        EntityInstantiator instantiator = this.instantiators.getInstantiatorFor(entity);
        Object instance = instantiator.createInstance(entity, (ParameterValueProvider)parameterProvider);
        BeanWrapper wrapper = BeanWrapper.create((Object)instance, (ConversionService)this.conversionService);
        this.readPropertiesFromRow(entity, rowValueProvider, wrapper);
        return (S)wrapper.getBean();
    }

    private static class BasicCassandraRowValueProvider
    extends org.springframework.data.cassandra.convert.BasicCassandraRowValueProvider {
        private final ColumnReader reader;
        private final SpELExpressionEvaluator evaluator;

        public BasicCassandraRowValueProvider(Row source, DefaultSpELExpressionEvaluator evaluator) {
            super(source, evaluator);
            this.reader = new ColumnReader(source){

                public Object get(int i) {
                    DataType type = this.columns.getType(i);
                    if (type.equals((Object)DataType.varint())) {
                        return this.row.getVarint(i);
                    }
                    return super.get(i);
                }
            };
            this.evaluator = evaluator;
        }

        public Object getPropertyValue(CassandraPersistentProperty property) {
            String expression = property.getSpelExpression();
            if (expression != null) {
                return this.evaluator.evaluate(expression);
            }
            return this.reader.get(property.getColumnName());
        }

        public Row getRow() {
            return this.reader.getRow();
        }
    }
}

